/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.builder.escpos;

import com.digiwin.mobile.mobileuibot.printer.enums.PrinterCommandTypeEnum;
import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.model.CommandRequired;
import com.digiwin.mobile.mobileuibot.printer.model.ReportData;
import com.digiwin.mobile.mobileuibot.printer.model.ReportDetail;
import com.google.common.collect.Lists;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Scope(value="prototype")
public class ESCPOSPrinterCommandBuilder
implements PrinterCommandBuilder {
    public String getPrinterType() {
        return PrinterCommandTypeEnum.ESC.name();
    }

    public ReportDetail getReportFilePaths(ReportDetail report, String pdfUrl) {
        report.setBmpFilesPath((List)Lists.newArrayList((Object[])new String[]{pdfUrl}));
        report.setCopy(1);
        return report;
    }

    public List<String> buildPrintCommand(List<String> imagePaths) throws Exception {
        if (CollectionUtils.isEmpty(imagePaths)) {
            return Lists.newArrayList();
        }
        ReportData reportData = new ReportData();
        reportData.setPdfUrls(imagePaths);
        return this.printerCommandString(reportData);
    }

    private List<CommandRequired> getCommandBytes(ReportDetail report, String pdfUrl) throws IOException {
        ArrayList<CommandRequired> reportBytesCopy = new ArrayList<CommandRequired>();
        report = this.getReportFilePaths(report, pdfUrl);
        for (String path : report.getBmpFilesPath()) {
            BufferedImage originalBitmap = ImageIO.read(new File(path));
            reportBytesCopy.add(new CommandRequired(this.copyBitmap(originalBitmap), report.getCopy(), path));
        }
        return reportBytesCopy;
    }

    private List<String> printerCommandString(ReportData reportData) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        List reportBytesCopy = this.getCommandBytes(reportData);
        if (!reportBytesCopy.isEmpty()) {
            for (List reportBytesData : reportBytesCopy) {
                for (CommandRequired reportInfo : reportBytesData) {
                    byte[] commandByte = this.draw2PxPoint(reportInfo.getBitmap());
                    for (int i = 0; i < reportInfo.getCopy(); ++i) {
                        result.add(Base64.getEncoder().encodeToString(commandByte));
                    }
                }
            }
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u5341\u516d\u8fdb\u5236\u6307\u4ee4\uff0c\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f");
        }
        return result;
    }

    private List<byte[]> printerCommandByte(ReportData reportData) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        List reportBytesCopy = this.getCommandBytes(reportData);
        if (!reportBytesCopy.isEmpty()) {
            for (List reportBytesData : reportBytesCopy) {
                for (CommandRequired reportInfo : reportBytesData) {
                    byte[] commandByte = this.draw2PxPoint(reportInfo.getBitmap());
                    for (int i = 0; i < reportInfo.getCopy(); ++i) {
                        result.add(commandByte);
                    }
                }
            }
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u751f\u6210\u5341\u516d\u8fdb\u5236\u6307\u4ee4\uff0c\u6ca1\u6709\u6807\u7b7e\u4fe1\u606f");
        }
        return result;
    }

    private List<List<CommandRequired>> getCommandBytes(ReportData reportData) throws IOException {
        ArrayList<List<CommandRequired>> reportBytesCopy = new ArrayList<List<CommandRequired>>();
        if (!reportData.getPdfUrls().isEmpty()) {
            for (String pdfUrl : reportData.getPdfUrls()) {
                reportBytesCopy.add(this.getCommandBytes(new ReportDetail(), pdfUrl));
            }
        } else {
            for (ReportDetail report : reportData.getData()) {
                reportBytesCopy.add(this.getCommandBytes(report, ""));
            }
        }
        return reportBytesCopy;
    }

    private byte[] draw2PxPoint(BufferedImage bmp) {
        int i;
        ArrayList<Byte> data = new ArrayList<Byte>();
        int n1 = bmp.getWidth() % 256;
        int n2 = bmp.getWidth() / 256;
        data.add((byte)27);
        data.add((byte)64);
        data.add((byte)27);
        data.add((byte)97);
        data.add((byte)1);
        data.add((byte)27);
        data.add((byte)51);
        data.add((byte)0);
        int j = 0;
        while ((float)j < (float)bmp.getHeight() / 24.0f) {
            data.add((byte)27);
            data.add((byte)42);
            data.add((byte)33);
            data.add((byte)n1);
            data.add((byte)n2);
            for (i = 0; i < bmp.getWidth(); ++i) {
                for (int m = 0; m < 3; ++m) {
                    byte byteData = 0;
                    for (int n = 0; n < 8; ++n) {
                        byte b = this.px2Byte(i, j * 24 + m * 8 + n, bmp);
                        byteData = (byte)(byteData + (byte)(byteData + b));
                    }
                    data.add(byteData);
                }
            }
            data.add((byte)10);
            ++j;
        }
        data.add((byte)12);
        byte[] byteArray = new byte[data.size()];
        for (i = 0; i < data.size(); ++i) {
            byteArray[i] = (Byte)data.get(i);
        }
        return byteArray;
    }

    private byte px2Byte(int x, int y, BufferedImage bit) {
        if (x < bit.getWidth() && y < bit.getHeight()) {
            int pixel = bit.getRGB(x, y);
            int red = pixel >> 16 & 0xFF;
            int green = pixel >> 8 & 0xFF;
            int blue = pixel & 0xFF;
            return red == 255 && green == 255 && blue == 255 ? (byte)0 : 1;
        }
        return 0;
    }

    private BufferedImage copyBitmap(BufferedImage original) {
        BufferedImage copy = new BufferedImage(original.getWidth(), original.getHeight(), original.getType());
        Graphics2D g = copy.createGraphics();
        g.drawImage((Image)original, 0, 0, null);
        g.dispose();
        return copy;
    }

    private byte[] mergeByteArrays(List<byte[]> arrays) {
        int totalLength = arrays.stream().mapToInt(arr -> ((byte[])arr).length).sum();
        byte[] merged = new byte[totalLength];
        int currentPos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, merged, currentPos, array.length);
            currentPos += array.length;
        }
        return merged;
    }

    public static void main(String[] args) throws Exception {
        ReportData reportData = new ReportData();
        reportData.setPdfUrls((List)Lists.newArrayList((Object[])new String[]{"C:\\Users\\wjw\\Downloads\\UserBasis001.bmp"}));
        List strings = new ESCPOSPrinterCommandBuilder().printerCommandString(reportData);
        System.out.println(strings);
    }
}

