/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.utils;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.UrlResource;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PdfToImageUtils {
    private static final Logger log = LoggerFactory.getLogger(PdfToImageUtils.class);
    private static final String PDF_TO_IMAGE_TEMP_DIR = System.getProperty("user.dir") + File.separator + "temp" + File.separator + "pdf_to_bmp" + File.separator;

    public static List<String> convertPdfUrlToBmp(String pdfUrl) {
        if (StringUtils.isEmpty((CharSequence)pdfUrl)) {
            return new ArrayList<String>();
        }
        String prefix = UUIDUtil.getUuid() + "_";
        String tempPdfPath = PDF_TO_IMAGE_TEMP_DIR + prefix + ".pdf";
        PdfToImageUtils.downloadFile((String)pdfUrl, (String)tempPdfPath);
        List images = PdfToImageUtils.pdfPathToBmp((String)tempPdfPath, (String)(PDF_TO_IMAGE_TEMP_DIR + prefix));
        PdfToImageUtils.deleteFile((String)tempPdfPath);
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> pdfUrlToBmp(String pdfInputUrl, String imageOutputPath) {
        ArrayList<String> images = new ArrayList<String>();
        BufferedInputStream inputStream = null;
        PDDocument document = null;
        try {
            inputStream = new BufferedInputStream(new UrlResource(pdfInputUrl).getInputStream());
            document = PDDocument.load((InputStream)inputStream);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            int pageCount = document.getNumberOfPages();
            for (int page = 0; page < pageCount; ++page) {
                BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 256.0f, ImageType.GRAY);
                String imagePath = imageOutputPath + (page + 1) + ".bmp";
                ImageIO.write((RenderedImage)bim, "bmp", new File(imagePath));
                images.add(imagePath);
            }
        }
        catch (IOException e) {
            log.error("pdfurl\u8f6cbmp\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("inputStream\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    log.error("document\u5173\u95ed\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return images;
    }

    private static List<String> pdfPathToBmp(String pdfInputPath, String imageOutputPath) {
        ArrayList<String> images = new ArrayList<String>();
        try (PDDocument document = PDDocument.load((File)new File(pdfInputPath));){
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            int pageCount = document.getNumberOfPages();
            for (int page = 0; page < pageCount; ++page) {
                BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 256.0f, ImageType.GRAY);
                String imagePath = imageOutputPath + (page + 1) + ".bmp";
                ImageIO.write((RenderedImage)bim, "bmp", new File(imagePath));
                images.add(imagePath);
            }
        }
        catch (IOException e) {
            log.error("pdfpath\u8f6cbmp\u5931\u8d25", (Throwable)e);
        }
        return images;
    }

    public static void deleteFile(String path) {
        PdfToImageUtils.deleteFiles((List)Lists.newArrayList((Object[])new String[]{path}));
    }

    public static void deleteFiles(List<String> imagePaths) {
        if (CollectionUtils.isEmpty(imagePaths)) {
            return;
        }
        for (String imagePath : imagePaths) {
            try {
                Files.deleteIfExists(Paths.get(imagePath, new String[0]));
            }
            catch (IOException e) {
                log.error("\u5220\u9664\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void createDirectoryIfNotExists(String dirPath) {
        if (dirPath == null || dirPath.isEmpty()) {
            throw new IllegalArgumentException("\u76ee\u5f55\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        File directory = new File(dirPath);
        try {
            if (directory.mkdirs()) {
                log.debug("\u76ee\u5f55\u521b\u5efa\u6210\u529f: " + dirPath);
            } else {
                log.debug("\u76ee\u5f55\u5df2\u5b58\u5728\u6216\u65e0\u6cd5\u521b\u5efa: " + dirPath);
            }
        }
        catch (SecurityException e) {
            log.error("\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55", (Throwable)e);
        }
    }

    public static void downloadFile(String fileUrl, String tempPath) {
        File file = new File(tempPath);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             FileOutputStream fos = new FileOutputStream(file);){
            HttpGet httpGet = new HttpGet(new URIBuilder(fileUrl).build().toString());
            httpClient.execute((HttpUriRequest)httpGet, httpResponse -> {
                int read;
                InputStream inputStream = httpResponse.getEntity().getContent();
                file.createNewFile();
                byte[] bytes = new byte[1024];
                while ((read = inputStream.read(bytes)) != -1) {
                    fos.write(bytes, 0, read);
                }
                fos.flush();
                return null;
            });
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String pdfUrl = "http://digiwinabi-test.apps.digiwincloud.com.cn/abi/eanalysemgr/httpdownload.do?cacheid=5095c0df93f94f49868cf0ba554aa6b3&resid=EANA$2$17$1$93943b570dfc46c78fea79c96fa16d01$4bfbb8fce75447a9b700721c0f107c08";
        String prefix = UUIDUtil.getUuid() + "_";
        String tempPdfPath = PDF_TO_IMAGE_TEMP_DIR + prefix + ".pdf";
        PdfToImageUtils.downloadFile((String)pdfUrl, (String)tempPdfPath);
        List strings = PdfToImageUtils.pdfPathToBmp((String)tempPdfPath, (String)(PDF_TO_IMAGE_TEMP_DIR + prefix));
        PdfToImageUtils.deleteFiles((List)strings);
        PdfToImageUtils.deleteFile((String)tempPdfPath);
        System.out.println(strings);
    }

    static {
        PdfToImageUtils.createDirectoryIfNotExists((String)PDF_TO_IMAGE_TEMP_DIR);
    }
}

