/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.common;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelTask;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ProjectStringUtil {
    private static Pattern PROJECT_NO_PATTERN = Pattern.compile("(\\[).*?(])");
    public static final String PCC_OLD_PROJECT_TYPE = "task_Project_Center_Console";
    public static final String PCC_OLD_PROJECT_TYPE_PROGRESS_TRACK_ACTIVITY = "progressTrack";
    public static final String PCC_NEW_PROJECT_TYPE = "projectCenterConsole_userProject";
    public static final String KSC_PROJECT_TYPE = "systemCloudHouseKeeper_userProject";
    public static final String PCC_NEW_PROJECT_TYPE_PROGRESS_TRACK_ACTIVITY = "progressTrack_DTD";
    public static final String KSC_PROJECT_TYPE_PROGRESS_TRACK_ACTIVITY = "sch_progressTrack";
    public static final String KSC_PROJECT_TYPE_PROGRESS_MAINTENANC_ACTIVITY = "sch_maintenanceProject";

    public static String getProjectNameOnCard(String locale, String startTime, String endTime, String projectName, boolean isPccTask) {
        String[] projectNameSpilt = ProjectStringUtil.projectNameSpilt((String)projectName);
        if (isPccTask && projectNameSpilt.length == 2) {
            return projectNameSpilt[0] + " " + projectNameSpilt[1];
        }
        String contentTemplate = "%s: %s %s";
        return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee"), DateTimeUtil.getTimeDistanceFromStartToEnd((String)startTime, (String)endTime), projectName).trim();
    }

    private static String[] projectNameSpilt(String projectName) {
        String[] stringArray;
        if (!StringUtils.hasLength((String)projectName)) {
            return new String[0];
        }
        Matcher matcher = PROJECT_NO_PATTERN.matcher(projectName);
        String projectNo = "";
        while (matcher.find()) {
            projectNo = matcher.group();
        }
        if (StringUtils.hasLength((String)projectNo)) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = projectName.substring(0, projectName.indexOf(projectNo));
            stringArray = stringArray2;
            stringArray2[1] = projectNo;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static String getProjectCCProjectDateDistanceString(String locale, PccProjectInfo projectInfo) {
        String contentTemplate = "%s: %s";
        return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u65f6\u8ddd"), DateTimeUtil.getDateDistanceFromStartToEnd((String)projectInfo.getPlanStartDate(), (String)projectInfo.getPlanFinishDate())).trim();
    }

    public static String getProjectDateDistanceString(String locale, DigiwinAtmcPanelTask panelTask) {
        String contentTemplate = "%s: %s";
        return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u65f6\u8ddd"), DateTimeUtil.getTimeDistanceFromStartToEnd((String)panelTask.getStartTime(), (String)panelTask.getEndTime())).trim();
    }

    public static String getProjectBuildTypeByDetailPatternCategory(String tmTaskId, String tmActivityId) {
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null");
        return tmTaskId + "_" + tmActivityId;
    }

    public static String getProjectCCStatusString(String locale, String statusValue) {
        Assert.notNull((Object)statusValue, (String)"statusValue must not null");
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        if ("10".equalsIgnoreCase(statusValue)) {
            return localeService.getLanguageValue(locale, "\u672a\u5f00\u59cb");
        }
        if ("20".equalsIgnoreCase(statusValue)) {
            return localeService.getLanguageValue(locale, "\u7b7e\u6838\u4e2d");
        }
        if ("30".equalsIgnoreCase(statusValue)) {
            return localeService.getLanguageValue(locale, "\u8fdb\u884c\u4e2d");
        }
        if ("40".equalsIgnoreCase(statusValue)) {
            return localeService.getLanguageValue(locale, "\u5df2\u7ed3\u6848");
        }
        if ("50".equalsIgnoreCase(statusValue)) {
            return localeService.getLanguageValue(locale, "\u6682\u505c");
        }
        if ("60".equalsIgnoreCase(statusValue)) {
            return localeService.getLanguageValue(locale, "\u6307\u5b9a\u7ed3\u6848");
        }
        return localeService.getLanguageValue(locale, "\u672a\u53d1\u8d77");
    }

    public static String getProjectCCPropertyString(String locale, String propertyValue) {
        Assert.notNull((Object)propertyValue, (String)"propertyValue must not null");
        if ("10".equalsIgnoreCase(propertyValue)) {
            return LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6f5c\u5728");
        }
        return LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5f0f");
    }

    public static String getProjectSourceInfoString(String locale, DigiwinAtmcPanel atmcPanel) {
        String contentTemplate = "%s: %s";
        if (Locale.US.toString().equals(locale)) {
            return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u6e90"), String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u6765\u6e90\u8bf4\u660e"), Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getSourceCount).orElse(0), Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getSourceName).orElse(""), Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getSourceIds).orElse(""))).trim();
        }
        return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6765\u6e90"), String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9879\u76ee\u6765\u6e90\u8bf4\u660e"), Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getSourceIds).orElse(""), Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getSourceCount).orElse(0), Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask).map(DigiwinAtmcPanelTask::getSourceName).orElse(""))).trim();
    }

    public static String getProjectSourceInfoString(String locale, DigiwinAtmcPanelTask panelTask) {
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        return localeService.getLanguageValue(locale, "\u6765\u6e90\uff1a") + panelTask.getSourceIds() + localeService.getLanguageValue(locale, ",\u5171\u5305\u62ec1\u4e2a\u5206\u516c\u53f8\u5171") + panelTask.getSourceCount() + localeService.getLanguageValue(locale, "\u5f20") + panelTask.getSourceName() + localeService.getLanguageValue(locale, "\u7ec4\u6210");
    }

    public static String getProjectInitiatorInfoString(String locale, DigiwinAtmcPanel atmcPanel) {
        String contentTemplate = "%s: %s %s";
        LocalDate initiateDate = DateTimeUtil.parseUseDefaultPattern((String)atmcPanel.getTask().getCreateTime()).toLocalDate();
        return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1\u8d77\u65b9"), String.format("%s.%s.%s", initiateDate.getYear(), DateTimeUtil.getFullMonth((Integer)initiateDate.getMonthValue()), DateTimeUtil.getFullDate((Integer)initiateDate.getDayOfMonth())), LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7531Athena\u53d1\u8d77\u5f53\u524d\u9879\u76ee"));
    }

    public static String getProjectInitiatorInfoString(String locale, DigiwinAtmcPanelTask panelTask) {
        String contentTemplate = "%s: %s %s";
        LocalDate initiateDate = DateTimeUtil.parseUseDefaultPattern((String)panelTask.getCreateTime()).toLocalDate();
        return String.format(contentTemplate, LocaleUtil.getMobileTextByKey((String)locale, (String)"\u53d1\u8d77\u65b9"), String.format("%s.%s.%s", initiateDate.getYear(), DateTimeUtil.getFullMonth((Integer)initiateDate.getMonthValue()), DateTimeUtil.getFullDate((Integer)initiateDate.getDayOfMonth())), LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7531Athena\u53d1\u8d77\u5f53\u524d\u9879\u76ee"));
    }
}

