/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum;
import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterContent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="projectFilter")
public class ProjectFilter
implements Serializable {
    private static final long serialVersionUID = -7574870147042138041L;
    @Id
    private String id;
    private String companyId;
    private String systemId;
    private String tenantId;
    private String appCode;
    private ProjectFilterContent content;
    private Boolean valid;
    private List<EnvScope> envScopes;
    private String createTime;
    private String updateTime;

    public Boolean validWithAppEnvType(String appEnvType) {
        if (this.getEnvScopes() == null || this.getEnvScopes().isEmpty()) {
            return false;
        }
        Boolean result = false;
        for (EnvScope envScope : this.getEnvScopes()) {
            String type = envScope.getType();
            Boolean valid = envScope.getValid();
            if (!appEnvType.equals(type)) continue;
            result = valid;
            break;
        }
        return result;
    }

    public void setDefault() {
        if (this.getValid() == null) {
            this.setValid(Boolean.valueOf(true));
        }
        if (this.getCompanyId() == null) {
            this.setCompanyId("1000");
        }
        if (this.getSystemId() == null) {
            this.setSystemId("athena");
        }
        if (this.getEnvScopes() == null) {
            ArrayList<EnvScope> envScopeList = new ArrayList<EnvScope>();
            EnvScope developScope = new EnvScope();
            developScope.setType(AppEnvTypeEnum.DEVELOP.getEnvType());
            developScope.setValid(Boolean.valueOf(true));
            envScopeList.add(developScope);
            EnvScope prodScope = new EnvScope();
            prodScope.setType(AppEnvTypeEnum.PRODUCTION.getEnvType());
            prodScope.setValid(Boolean.valueOf(true));
            envScopeList.add(prodScope);
            EnvScope testScope = new EnvScope();
            testScope.setType(AppEnvTypeEnum.TEST.getEnvType());
            testScope.setValid(Boolean.valueOf(true));
            envScopeList.add(testScope);
            this.setEnvScopes(envScopeList);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public ProjectFilterContent getContent() {
        return this.content;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public List<EnvScope> getEnvScopes() {
        return this.envScopes;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setContent(ProjectFilterContent content) {
        this.content = content;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public void setEnvScopes(List<EnvScope> envScopes) {
        this.envScopes = envScopes;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFilter)) {
            return false;
        }
        ProjectFilter other = (ProjectFilter)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$companyId = this.getCompanyId();
        String other$companyId = other.getCompanyId();
        if (this$companyId == null ? other$companyId != null : !this$companyId.equals(other$companyId)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        ProjectFilterContent this$content = this.getContent();
        ProjectFilterContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List this$envScopes = this.getEnvScopes();
        List other$envScopes = other.getEnvScopes();
        if (this$envScopes == null ? other$envScopes != null : !((Object)this$envScopes).equals(other$envScopes)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $companyId = this.getCompanyId();
        result = result * 59 + ($companyId == null ? 43 : $companyId.hashCode());
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        ProjectFilterContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List $envScopes = this.getEnvScopes();
        result = result * 59 + ($envScopes == null ? 43 : ((Object)$envScopes).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectFilter(id=" + this.getId() + ", companyId=" + this.getCompanyId() + ", systemId=" + this.getSystemId() + ", tenantId=" + this.getTenantId() + ", appCode=" + this.getAppCode() + ", content=" + this.getContent() + ", valid=" + this.getValid() + ", envScopes=" + this.getEnvScopes() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

