/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilter;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/openapi"})
public class ProjectFilterController {
    @Autowired
    private ProjectFilterRepository projectFilterRepository;
    @Resource(name="systemCacheManager")
    private CaffeineCacheManager systemCacheManager;

    @PostMapping(value={"/apps/{appCode}/project/addfilters"})
    public ApiResponse addOrUpdateProjectFilterList(@PathVariable(value="appCode") String appCode, @RequestBody Map<String, List<ProjectFilter>> map) {
        if (map == null || map.get("filters") == null) {
            return ApiResponse.buildError((String)"filters can not be empty!");
        }
        List<ProjectFilter> projectFilterList = map.get("filters");
        if (CollectionUtils.isEmpty(projectFilterList)) {
            return ApiResponse.buildError((String)"filters can not be empty!");
        }
        for (ProjectFilter projectFilter : projectFilterList) {
            projectFilter.setAppCode(appCode);
            projectFilter.setDefault();
        }
        List filterList = this.projectFilterRepository.upsertAll(projectFilterList);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("filters", filterList);
        this.invalidateCache();
        return ApiResponse.buildOK().setData(result);
    }

    @GetMapping(value={"/apps/{appCode}/project/getfilters"})
    public ApiResponse getProjectFilterList(@PathVariable(value="appCode") String appCode, @RequestParam(required=false) String tenantId) {
        List filterList = this.projectFilterRepository.listProjectFilter(appCode, tenantId);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("filters", filterList);
        return ApiResponse.buildOK().setData(result);
    }

    @PostMapping(value={"/apps/{appCode}/project/deletefilters"})
    public ApiResponse deleteProjectFilter(@PathVariable(value="appCode") String appCode, @RequestBody(required=false) ProjectFilter projectFilter) {
        String tmTaskId = null;
        String tenantId = null;
        if (projectFilter != null) {
            tenantId = projectFilter.getTenantId();
            if (projectFilter.getContent() != null) {
                tmTaskId = projectFilter.getContent().getTmTaskId();
            }
        }
        List filterList = this.projectFilterRepository.deleteProjectFilter(appCode, tenantId, tmTaskId);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("filters", filterList);
        this.invalidateCache();
        return ApiResponse.buildOK().setData((Object)filterList);
    }

    private void invalidateCache() {
        Cache cache = this.systemCacheManager.getCache("projectFilterList");
        if (cache != null) {
            cache.invalidate();
        }
    }
}

