/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.model.projectcc;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRateTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBar;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.NextCrumbs;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItemDescription;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItemPreTitle;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectCCTaskItem
implements Serializable {
    private static final long serialVersionUID = 4132892584440067404L;
    public static Logger logger = LoggerFactory.getLogger(ProjectCCTaskItem.class);
    private String title;
    private ProjectCCTaskItemPreTitle preTitle;
    private ProgressRate progressRate;
    private List<ProjectCCTaskItemDescription> descList = new ArrayList();
    private Integer type;
    private Button detail;
    private NextCrumbs nextCrumbs;

    public static ProjectCCTaskItem create(String locale, PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo) {
        return ProjectCCTaskItem.create((String)locale, (PccProjectTaskInfo)currentProjectTaskInfo, allProjectTaskInfoList, (boolean)isCrumbs, (String)iamUserToken, (String)projectNo, (boolean)true);
    }

    public static ProjectCCTaskItem createKsc(String locale, PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo) {
        return ProjectCCTaskItem.createKscItem((String)locale, (PccProjectTaskInfo)currentProjectTaskInfo, allProjectTaskInfoList, (boolean)isCrumbs, (String)iamUserToken, (String)projectNo, (boolean)true);
    }

    public static ProjectCCTaskItem createKscItem(String locale, PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo, boolean isCreateInfo) {
        List nextLevelProjectTaskInfoList = currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();
        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(TaskStringUtil.getTaskDateDistanceText((String)currentProjectTaskInfo.getPlanStartDate(), (String)currentProjectTaskInfo.getPlanFinishDate()));
        long workPeriod = currentProjectTaskInfo.getWorkPeriodInDay();
        String workPeriodUnit = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5929");
        String rightText = LocaleUtil.getMobileTextWithUnit((String)locale, (String)"", (String)String.valueOf(workPeriod), (String)workPeriodUnit, (boolean)false, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5de5\u671f"));
        preTitle.setRight(rightText);
        projectCCTaskItem.setPreTitle(preTitle);
        projectCCTaskItem.setTitle(currentProjectTaskInfo.getTaskName());
        projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(currentProjectTaskInfo, nextLevelProjectTaskInfoList));
        int type = nextLevelProjectTaskInfoList.isEmpty() ? (currentProjectTaskInfo.isOverdue() ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType()).intValue() : (nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType()).intValue();
        projectCCTaskItem.setType(Integer.valueOf(type));
        ProjectCCTaskItemDescription description = new ProjectCCTaskItemDescription();
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            description.setIconData(Integer.valueOf(59021));
            description.setText(currentProjectTaskInfo.getLiablePersonName());
            List taskMemberInfo = currentProjectTaskInfo.getTaskMemberInfo();
            List<Object> eocPersonInfoList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)taskMemberInfo)) {
                eocPersonInfoList = taskMemberInfo.stream().map(item -> {
                    EocPersonInfo eocPersonInfo = new EocPersonInfo();
                    eocPersonInfo.setEocId(MapUtils.getString((Map)item, (Object)"executor_no"));
                    eocPersonInfo.setName(MapUtils.getString((Map)item, (Object)"executor_name"));
                    return eocPersonInfo;
                }).collect(Collectors.toList());
            }
            description.setPersonInfoList(eocPersonInfoList);
            LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
            description.setPersonLabel(localeService.getLanguageValue(locale, "\u6267\u884c\u4eba"));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                long overduePeriod = StringUtils.hasLength((String)currentProjectTaskInfo.getActualFinishDate()) ? DateTimeUtil.getDatePeriod((String)currentProjectTaskInfo.getPlanFinishDate(), (String)currentProjectTaskInfo.getActualFinishDate()) : currentProjectTaskInfo.getOverduePeriodInDay() - 1L;
                String text = LocaleUtil.getMobileTextWithUnit((String)locale, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f"), (String)String.valueOf(overduePeriod), (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5929"), (boolean)false, (String)"");
                description.addLabel(Label.create((String)text, (String)LabelTypeEnum.OVERDUE.getType()));
            }
            if (isCreateInfo) {
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("taskInfo", (Object)currentProjectTaskInfo);
                projectCCTaskItem.setDetail(new Button("", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8be6\u60c5") + ">", new Action(currentProjectTaskInfo.getTaskNo(), PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_TAIL_TASK_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), (Object)apiRawData)));
            }
        } else {
            description.setIconData(Integer.valueOf(59022));
            long nextLevelProjectTaskInfoCompleteCount = nextLevelProjectTaskInfoList.stream().filter(PccProjectTaskInfo::isDone).count();
            int nextLevelProjectTaskInfoCount = nextLevelProjectTaskInfoList.size();
            description.setText(String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoCount));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                description.addLabel(Label.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5b58\u5728\u903e\u671f\u4efb\u52a1"), (String)LabelTypeEnum.OVERDUE.getType()));
            }
            if (isCrumbs) {
                List itemList = nextLevelProjectTaskInfoList.stream().map(digiwinAtdmProjectTaskInfo -> ProjectCCTaskItem.createKsc((String)locale, (PccProjectTaskInfo)digiwinAtdmProjectTaskInfo, (List)allProjectTaskInfoList, (boolean)true, (String)iamUserToken, (String)projectNo)).collect(Collectors.toList());
                NextCrumbs nextCrumbs = new NextCrumbs();
                nextCrumbs.setButtonName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8be6\u60c5") + ">");
                nextCrumbs.setChildren(itemList);
                projectCCTaskItem.setNextCrumbs(nextCrumbs);
            } else {
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("data", allProjectTaskInfoList);
                apiRawData.put("projectNo", (Object)projectNo);
                projectCCTaskItem.setDetail(new Button("", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8be6\u60c5") + ">", new Action(currentProjectTaskInfo.getTaskNo(), PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_NEXT_LEVEL_TASK_LIST.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(), (Object)apiRawData)));
            }
        }
        projectCCTaskItem.addProjectCCPhaseItemDescription(description);
        return projectCCTaskItem;
    }

    public static ProjectCCTaskItem create(String locale, PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo, boolean isCreateInfo) {
        List nextLevelProjectTaskInfoList = currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();
        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(TaskStringUtil.getTaskDateDistanceText((String)currentProjectTaskInfo.getPlanStartDate(), (String)currentProjectTaskInfo.getPlanFinishDate()));
        String workloadQty = Objects.isNull(currentProjectTaskInfo.getWorkloadQty()) ? "0" : new BigDecimal(String.valueOf(currentProjectTaskInfo.getWorkloadQty())).stripTrailingZeros().toPlainString();
        String workPeriodUnit = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5929");
        String rightText = LocaleUtil.getMobileTextWithUnit((String)locale, (String)"", (String)String.valueOf(workloadQty), (String)workPeriodUnit, (boolean)false, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5de5\u671f"));
        preTitle.setRight(rightText);
        projectCCTaskItem.setPreTitle(preTitle);
        projectCCTaskItem.setTitle(currentProjectTaskInfo.getTaskName());
        projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(currentProjectTaskInfo, nextLevelProjectTaskInfoList));
        int type = nextLevelProjectTaskInfoList.isEmpty() ? (currentProjectTaskInfo.isOverdue() ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType()).intValue() : (nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType()).intValue();
        projectCCTaskItem.setType(Integer.valueOf(type));
        ProjectCCTaskItemDescription description = new ProjectCCTaskItemDescription();
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            description.setIconData(Integer.valueOf(59021));
            description.setText(currentProjectTaskInfo.getLiablePersonName());
            EocPersonInfo eocPersonInfo = new EocPersonInfo();
            eocPersonInfo.setEocId(currentProjectTaskInfo.getLiablePersonCode());
            eocPersonInfo.setName(currentProjectTaskInfo.getLiablePersonName());
            description.setPersonInfo(eocPersonInfo);
            LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
            description.setPersonLabel(localeService.getLanguageValue(locale, "\u8d23\u4efb\u4eba"));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                long overduePeriod = currentProjectTaskInfo.getOverduePeriodInDay();
                long overdueDay = overduePeriod - 1L;
                String text = LocaleUtil.getMobileTextWithUnit((String)locale, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f"), (String)String.valueOf(overdueDay), (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5929"), (boolean)false, (String)"");
                description.addLabel(Label.create((String)text, (String)LabelTypeEnum.OVERDUE.getType()));
            }
            if (isCreateInfo) {
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("taskInfo", (Object)currentProjectTaskInfo);
                projectCCTaskItem.setDetail(new Button("", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8be6\u60c5") + ">", new Action(currentProjectTaskInfo.getTaskNo(), PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_TAIL_TASK_DETAIL.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), (Object)apiRawData)));
            }
        } else {
            description.setIconData(Integer.valueOf(59022));
            long nextLevelProjectTaskInfoCompleteCount = nextLevelProjectTaskInfoList.stream().filter(PccProjectTaskInfo::isDone).count();
            int nextLevelProjectTaskInfoCount = nextLevelProjectTaskInfoList.size();
            description.setText(String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoCount));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                description.addLabel(Label.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5b58\u5728\u903e\u671f\u4efb\u52a1"), (String)LabelTypeEnum.OVERDUE.getType()));
            }
            if (isCrumbs) {
                List itemList = nextLevelProjectTaskInfoList.stream().map(digiwinAtdmProjectTaskInfo -> ProjectCCTaskItem.create((String)locale, (PccProjectTaskInfo)digiwinAtdmProjectTaskInfo, (List)allProjectTaskInfoList, (boolean)true, (String)iamUserToken, (String)projectNo)).collect(Collectors.toList());
                NextCrumbs nextCrumbs = new NextCrumbs();
                nextCrumbs.setButtonName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8be6\u60c5") + ">");
                nextCrumbs.setChildren(itemList);
                projectCCTaskItem.setNextCrumbs(nextCrumbs);
            } else {
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("data", allProjectTaskInfoList);
                apiRawData.put("projectNo", (Object)projectNo);
                projectCCTaskItem.setDetail(new Button("", LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8be6\u60c5") + ">", new Action(currentProjectTaskInfo.getTaskNo(), PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_NEXT_LEVEL_TASK_LIST.toString(), "", ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(), (Object)apiRawData)));
            }
        }
        projectCCTaskItem.addProjectCCPhaseItemDescription(description);
        return projectCCTaskItem;
    }

    public static ProjectCCTaskItem createPccPlan(String locale, PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> allProjectTaskInfoList) {
        List nextLevelProjectTaskInfoList = currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();
        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(TaskStringUtil.getTaskDateDistanceText((String)currentProjectTaskInfo.getPlanStartDate(), (String)currentProjectTaskInfo.getPlanFinishDate()));
        int workloadQty = DateTimeUtil.getWorkingDaysBetweenDates((String)currentProjectTaskInfo.getPlanStartDate(), (String)currentProjectTaskInfo.getPlanFinishDate());
        String workPeriodUnit = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5929");
        String rightText = LocaleUtil.getMobileTextWithUnit((String)locale, (String)"", (String)String.valueOf(workloadQty), (String)workPeriodUnit, (boolean)false, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5de5\u671f"));
        preTitle.setRight(rightText);
        projectCCTaskItem.setPreTitle(preTitle);
        projectCCTaskItem.setTitle(currentProjectTaskInfo.getTaskName());
        int type = nextLevelProjectTaskInfoList.isEmpty() ? (currentProjectTaskInfo.isOverdue() ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType()).intValue() : (nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType()).intValue();
        projectCCTaskItem.setType(Integer.valueOf(type));
        ProjectCCTaskItemDescription description = new ProjectCCTaskItemDescription();
        if (CollectionUtils.isEmpty((Collection)nextLevelProjectTaskInfoList)) {
            description.setIconData(Integer.valueOf(59021));
            description.setText(currentProjectTaskInfo.getLiablePersonName());
            EocPersonInfo eocPersonInfo = new EocPersonInfo();
            eocPersonInfo.setEocId(currentProjectTaskInfo.getLiablePersonCode());
            eocPersonInfo.setName(currentProjectTaskInfo.getLiablePersonName());
            description.setPersonInfo(eocPersonInfo);
            LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
            description.setPersonLabel(localeService.getLanguageValue(locale, "\u8d23\u4efb\u4eba"));
            projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(currentProjectTaskInfo, nextLevelProjectTaskInfoList));
        } else {
            projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(currentProjectTaskInfo, nextLevelProjectTaskInfoList));
            description.setIconData(Integer.valueOf(59022));
            long nextLevelProjectTaskInfoCompleteCount = nextLevelProjectTaskInfoList.stream().filter(PccProjectTaskInfo::isDone).count();
            int nextLevelProjectTaskInfoCount = nextLevelProjectTaskInfoList.size();
            description.setText(String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoCount));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                description.addLabel(Label.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5b58\u5728\u903e\u671f\u4efb\u52a1"), (String)LabelTypeEnum.OVERDUE.getType()));
            }
        }
        projectCCTaskItem.addProjectCCPhaseItemDescription(description);
        return projectCCTaskItem;
    }

    public static Card createProjectCard(ApiRequest apiRequest, PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> allProjectTaskInfoList, String projectNo, String mainPageId, boolean isPcc, boolean isPccPlan, boolean isCriticalPath, Boolean isPccTask) {
        String workloadQty;
        String locale = apiRequest.getLocale();
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        List nextLevelProjectTaskInfoList = currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();
        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(TaskStringUtil.getTaskDateDistanceText((String)currentProjectTaskInfo.getPlanStartDate(), (String)currentProjectTaskInfo.getPlanFinishDate()));
        Card card = new Card();
        card.setTitle(currentProjectTaskInfo.getTaskName());
        card.setStyle(Integer.valueOf(3));
        boolean isOverdue = false;
        if (CollectionUtils.isEmpty((Collection)nextLevelProjectTaskInfoList)) {
            card.setSubTitle(localeService.getLanguageValue(locale, "\u8be6\u60c5"));
            if (isCriticalPath) {
                card.setTitleBgColor("#605CE5");
                card.setTitleColor("#FFFFFF");
                card.setSubTitleColor("#FFFFFF");
            } else {
                card.setTitleBgColor("#F0E8FD");
            }
            if (currentProjectTaskInfo.isOverdue()) {
                isOverdue = true;
                long overduePeriod = currentProjectTaskInfo.getOverduePeriodInDay() - 1L;
                String tagContent = String.format(localeService.getLanguageValue(locale, "\u903e\u671f%s\u5929"), overduePeriod);
                card.setTags(Collections.singletonList(Tag.createWarningTag((String)tagContent)));
            }
            ApiRawData apiRawData = new ApiRawData();
            apiRawData.put("taskInfo", (Object)currentProjectTaskInfo);
            apiRawData.put("isPccPlan", (Object)isPccPlan);
            card.setSubTitleAction(new Action(currentProjectTaskInfo.getTaskNo(), isPcc ? PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_TAIL_TASK_DETAIL.name() : PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_TAIL_TASK_DETAIL.name(), "", ActionTypeEnum.OPEN_NEW_PAGE.getValue(), (Object)apiRawData));
        } else {
            card.setSubTitle(localeService.getLanguageValue(locale, "\u67e5\u770b\u66f4\u591a>"));
            boolean isFirstOrder = Objects.equals(currentProjectTaskInfo.getTaskNo(), currentProjectTaskInfo.getUpperLevelTaskNo());
            card.setTitleBgColor(isFirstOrder ? "#DAE1FF" : "#E3F2FF");
            if (isCriticalPath) {
                card.setTitleBgColor("#605CE5");
                card.setTitleColor("#FFFFFF");
                card.setSubTitleColor("#FFFFFF");
            }
            if (!isPccPlan && nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue)) {
                isOverdue = true;
                String tagContent = localeService.getLanguageValue(locale, "\u5b58\u5728\u903e\u671f\u4efb\u52a1");
                card.setTags(Collections.singletonList(Tag.createWarningTag((String)tagContent)));
            }
            ApiRawData apiRawData = new ApiRawData();
            apiRawData.put("data", allProjectTaskInfoList);
            apiRawData.put("projectNo", (Object)projectNo);
            apiRawData.put("isPcc", (Object)isPcc);
            apiRawData.put("mainPageId", (Object)mainPageId);
            apiRawData.put("isPccPlan", (Object)isPccPlan);
            apiRawData.put("currentProjectTaskInfo", (Object)currentProjectTaskInfo);
            if (Objects.isNull(apiRequest.getRawData())) {
                apiRawData.put("bread_crumb_chain", Collections.singletonList(currentProjectTaskInfo));
            } else {
                List breadCrubChain = (List)MapUtil.getOrDefault((Map)apiRequest.getRawData(), (String)"bread_crumb_chain", new LinkedList());
                breadCrubChain.add(currentProjectTaskInfo);
                apiRawData.put("bread_crumb_chain", (Object)breadCrubChain);
            }
            Action action = new Action();
            if (isFirstOrder || isCriticalPath || isPccTask.booleanValue()) {
                action.setRawData((Object)apiRawData);
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_NEXT_LEVEL_PROJECT_LIST.toString());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            } else {
                BreadCrumbNode breadCrumbNode = new BreadCrumbNode();
                breadCrumbNode.setTitle(currentProjectTaskInfo.getTaskName());
                breadCrumbNode.setRequestUrl("/mobile/v1/proxy/get/project/breadCrumb/data");
                breadCrumbNode.setRawData((Map)apiRawData);
                action.setCrumbItem(breadCrumbNode);
                action.setType(ActionTypeEnum.REFRESH_LOCAL.getValue());
            }
            card.setSubTitleAction(action);
        }
        LinkedList<CardContent> contentList = new LinkedList<CardContent>();
        String string = workloadQty = Objects.isNull(currentProjectTaskInfo.getWorkloadQty()) ? "0" : new BigDecimal(String.valueOf(currentProjectTaskInfo.getWorkloadQty())).stripTrailingZeros().toPlainString();
        if (isPccPlan) {
            ArrayList<CardContent> multiValueContentList = new ArrayList<CardContent>(2);
            multiValueContentList.add(new CardContent(localeService.getLanguageValue(locale, "\u8d1f\u8d23\u4eba"), currentProjectTaskInfo.getLiablePersonName()));
            multiValueContentList.add(new CardContent(localeService.getLanguageValue(locale, "\u4efb\u52a1\u5de5\u671f"), workloadQty + localeService.getLanguageValue(locale, "\u5929")));
            contentList.add(CardContent.createMultiValue(multiValueContentList, (String)"  "));
        } else {
            List taskMemberInfo = currentProjectTaskInfo.getTaskMemberInfo();
            String executorName = "";
            if (!CollectionUtils.isEmpty((Collection)taskMemberInfo)) {
                executorName = taskMemberInfo.stream().map(item -> MapUtils.getString((Map)item, (Object)"executor_name")).collect(Collectors.joining("; "));
            }
            contentList.add(new CardContent(localeService.getLanguageValue(locale, "\u6267\u884c\u4eba"), executorName));
            contentList.add(new CardContent(localeService.getLanguageValue(locale, "\u4efb\u52a1\u5de5\u671f"), workloadQty + localeService.getLanguageValue(locale, "\u5929")));
        }
        contentList.add(new CardContent(localeService.getLanguageValue(locale, "\u65f6\u95f4\u8303\u56f4"), String.format("%s-%s", currentProjectTaskInfo.getPlanStartDate().replaceAll("-", "."), currentProjectTaskInfo.getPlanFinishDate().replaceAll("-", "."))));
        if (!Objects.equals(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString(), mainPageId) || isCriticalPath || isPccTask.booleanValue()) {
            ProgressRate progressRate = projectCCTaskItem.calculateProgressRate(currentProjectTaskInfo, nextLevelProjectTaskInfoList);
            ProgressBar progressBar = new ProgressBar();
            progressBar.setTitle(localeService.getLanguageValue(locale, "\u6574\u4f53\u8fdb\u5ea6"));
            progressBar.setMinValue(new BigDecimal(0));
            progressBar.setMaxValue(new BigDecimal(100));
            progressBar.setDefaultValue(new BigDecimal(String.valueOf(progressRate.getRate())).multiply(new BigDecimal(100)));
            if (isOverdue) {
                progressBar.setActiveColor1("FFC084");
                progressBar.setActiveColor2("FF8160");
            } else {
                progressBar.setActiveColor1("91BAFF");
                progressBar.setActiveColor2("5465FF");
            }
            CardContent progressBarCardContent = new CardContent();
            progressBarCardContent.setProgressBar(progressBar);
            contentList.add(progressBarCardContent);
            if (!CollectionUtils.isEmpty((Collection)nextLevelProjectTaskInfoList)) {
                long nextLevelProjectTaskInfoCompleteCount = nextLevelProjectTaskInfoList.stream().filter(PccProjectTaskInfo::isDone).count();
                String taskProcess = String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoList.size());
                contentList.add(new CardContent(localeService.getLanguageValue(locale, "\u4efb\u52a1\u8fdb\u7a0b"), taskProcess));
            }
        }
        card.setContent(contentList);
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString().equalsIgnoreCase(mainPageId)) {
            Action editAction = new Action();
            editAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_TASK.toString());
            editAction.setJumpPageTitle(localeService.getLanguageValue(locale, "\u7f16\u8f91\u4efb\u52a1"));
            editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            HashMap<String, Object> rawData = new HashMap<String, Object>();
            rawData.put("currentProjectTaskInfo", currentProjectTaskInfo);
            rawData.put("fromPageId", apiRequest.getPageId());
            editAction.setRawData(rawData);
            card.setCardAction(editAction);
        }
        return card;
    }

    private ProgressRate calculateProgressRate(PccProjectTaskInfo currentProjectTaskInfo, List<PccProjectTaskInfo> nextLevelProjectTaskInfoList) {
        int type;
        double rate;
        ProgressRate progressRate = new ProgressRate();
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            rate = MathUtil.getDecimalPoint((double)currentProjectTaskInfo.getCompleteRate(), (int)2);
            type = currentProjectTaskInfo.isOverdue() ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        } else {
            rate = MathUtil.getDecimalPoint((double)nextLevelProjectTaskInfoList.stream().mapToDouble(PccProjectTaskInfo::getCompleteRate).average().orElse(0.0), (int)2);
            type = nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ? ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        }
        progressRate.setRate(Double.valueOf(rate));
        progressRate.setName(String.format("%.0f", rate * 100.0) + "%");
        progressRate.setType(Integer.valueOf(type));
        return progressRate;
    }

    public void addProjectCCPhaseItemDescription(ProjectCCTaskItemDescription description) {
        if (null != description) {
            this.descList.add(description);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProjectCCTaskItemPreTitle getPreTitle() {
        return this.preTitle;
    }

    public void setPreTitle(ProjectCCTaskItemPreTitle preTitle) {
        this.preTitle = preTitle;
    }

    public ProgressRate getProgressRate() {
        return this.progressRate;
    }

    public void setProgressRate(ProgressRate progressRate) {
        this.progressRate = progressRate;
    }

    public List<ProjectCCTaskItemDescription> getDescList() {
        return this.descList;
    }

    public void setDescList(List<ProjectCCTaskItemDescription> descList) {
        this.descList = descList;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Button getDetail() {
        return this.detail;
    }

    public void setDetail(Button detail) {
        this.detail = detail;
    }

    public NextCrumbs getNextCrumbs() {
        return this.nextCrumbs;
    }

    public void setNextCrumbs(NextCrumbs nextCrumbs) {
        this.nextCrumbs = nextCrumbs;
    }
}

