/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectCreateDetailBuildBizDataEntryDrivenStrategy {
    private static final Logger log = LoggerFactory.getLogger(ProjectCreateDetailBuildBizDataEntryDrivenStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PageSettingService pageSettingService;

    public UiBotModel buildUibotModel(ApiRequest apiRequest) {
        PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE_DATA_ENTRY_DRIVEN_DETAIL.name());
        UiBotModel pageModel = pageSetting.getPageModel();
        UiBotPageData pageData = pageModel.getPageData();
        for (UiBotLayout layout : pageModel.getLayout()) {
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), CustomGroup.class);
                    CustomGroupContent content = customGroup.getContent();
                    UiBotPageData customPageData = new UiBotPageData();
                    for (UiBotLayout childLayout : content.getLayout()) {
                        if (!"INPUT_MULTI".equalsIgnoreCase(childLayout.getType())) continue;
                        customPageData.put((Object)childLayout.getSchema(), (Object)InputMultiText.create((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u9879\u76ee\u4ecb\u7ecd"), (String)apiRequest.getRawData().getString(childLayout.getSchema()), (Boolean)false, (Boolean)false, (String)apiRequest.getLocale()));
                    }
                    content.setPageData(customPageData);
                    break;
                }
                case "EMPTY": {
                    pageData.put((Object)layout.getSchema(), (Object)Empty.create((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u79fb\u52a8\u7aef\u672a\u652f\u6301\uff0c\u8bf7\u81f3PC\u7aef\u64cd\u4f5c"), (boolean)true));
                    break;
                }
            }
        }
        return pageModel;
    }
}

