/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ProjectPageService;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class UiBotModelBuildProjectMilestonePageStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildProjectMilestonePageStrategy.class);
    @Autowired
    private ProjectPageService projectPageService;
    @Autowired
    private ActivityFilterService activityFilterService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String tmActivityId = apiRequest.getRawData().getString("tmActivityId");
        String tmTaskId = apiRequest.getRawData().getString("tmTaskId");
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        Set tmActivityIds = this.activityFilterService.findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.PROJECT.getValue(), apiRequest.getTenantId(), tenantVersion).stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toSet());
        if (!tmActivityIds.contains(tmActivityId)) {
            return this.buildNotSupportModel(apiRequest.getLocale());
        }
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create((String)apiRequest.getLocale(), (String)apiRequest.getTenantId(), (String)apiRequest.getDataId());
        executeContext.appendPageInfo("project-detail-mobile", tmTaskId, tmActivityId, "charge", Boolean.valueOf(false));
        executeContext.setSourceType(apiRequest.getSourceType());
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        UiBotModel uiBotModel = this.projectPageService.createPage(executeContext, apiRequest.getDataId(), apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private UiBotModel buildNotSupportModel(String locale) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)Empty.create((String)this.localeService.getLanguageValue(locale, "\u79fb\u52a8\u7aef\u672a\u652f\u6301\uff0c\u8bf7\u81f3PC\u7aef\u64cd\u4f5c"), (boolean)true), "DW_EMPTY"));
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

