/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumb;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="projectDetailBuildProjectNextLevelListStrategy")
public class ProjectDetailBuildProjectNextLevelListStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildProjectNextLevelListStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Project Cc Next Level List");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        ApiRawData rawData = apiRequest.getRawData();
        String mainPageId = MapUtils.getString((Map)rawData, (Object)"mainPageId");
        Boolean isPcc = MapUtils.getBooleanValue((Map)rawData, (Object)"isPcc");
        Boolean isPccPlan = MapUtils.getBooleanValue((Map)rawData, (Object)"isPccPlan");
        PccProjectTaskInfo currentProjectTaskInfo = (PccProjectTaskInfo)JsonUtil.objectToJavaObject(rawData.get("currentProjectTaskInfo"), PccProjectTaskInfo.class);
        String currentTaskNo = currentProjectTaskInfo.getTaskNo();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "BREAD_CRUMB": {
                    BreadCrumb breadCrumb = new BreadCrumb();
                    List breadCrubChain = (List)JsonUtil.objectToJavaObject(rawData.get("bread_crumb_chain"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    if (!CollectionUtils.isEmpty((Collection)breadCrubChain)) {
                        AtomicInteger index = new AtomicInteger(1);
                        List breadCrumbNodeList = breadCrubChain.stream().map(arg_0 -> ProjectDetailBuildProjectNextLevelListStrategy.lambda$doActually$0((Map)rawData, breadCrubChain, index, arg_0)).collect(Collectors.toList());
                        breadCrumb.setData(breadCrumbNodeList);
                    }
                    pageData.put((Object)schema, (Object)breadCrumb);
                    break;
                }
                case "ZTB_VIEW_LIST": {
                    List allProjectTaskInfoList = (List)JsonUtil.objectToJavaObject(rawData.get("data"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    List processedTaskList = allProjectTaskInfoList.stream().filter(projectTaskInfo -> !projectTaskInfo.getTaskNo().equalsIgnoreCase(currentTaskNo)).filter(projectTaskInfo -> projectTaskInfo.getUpperLevelTaskNo().equalsIgnoreCase(currentTaskNo)).sorted(Comparator.comparingInt(PccProjectTaskInfo::getSequence)).collect(Collectors.toList());
                    ZtbViewList ztbViewList = new ZtbViewList();
                    ztbViewList.setData(processedTaskList.stream().map(arg_0 -> ProjectDetailBuildProjectNextLevelListStrategy.lambda$doActually$3(apiRequest, allProjectTaskInfoList, (Map)rawData, mainPageId, isPcc, isPccPlan, arg_0)).collect(Collectors.toList()));
                    pageData.put((Object)schema, (Object)ztbViewList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = (List)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    buttonList.forEach(item -> item.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), item.getName())));
                    pageData.put((Object)schema, (Object)buttonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    private static /* synthetic */ Card lambda$doActually$3(ApiRequest apiRequest, List allProjectTaskInfoList, Map rawData, String mainPageId, Boolean isPcc, Boolean isPccPlan, PccProjectTaskInfo projectTaskInfo) {
        return ProjectCCTaskItem.createProjectCard((ApiRequest)apiRequest, (PccProjectTaskInfo)projectTaskInfo, (List)allProjectTaskInfoList, (String)MapUtils.getString((Map)rawData, (Object)"projectNo"), (String)mainPageId, (boolean)isPcc, (boolean)isPccPlan, (boolean)false, (Boolean)false);
    }

    private static /* synthetic */ BreadCrumbNode lambda$doActually$0(Map rawData, List breadCrubChain, AtomicInteger index, PccProjectTaskInfo item) {
        Map breadCrumbRawData = (Map)JsonUtil.objectToJavaObject((Object)rawData, Map.class);
        breadCrumbRawData.put("currentProjectTaskInfo", item);
        List currentBreadCrubChain = breadCrubChain.stream().limit(index.getAndIncrement()).collect(Collectors.toList());
        breadCrumbRawData.put("bread_crumb_chain", currentBreadCrubChain);
        return new BreadCrumbNode(item.getTaskName(), breadCrumbRawData, "", "/mobile/v1/proxy/get/project/breadCrumb/data");
    }
}

