/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="projectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy")
public class ProjectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("SystemCloudHouseKeeper Choose Template Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map projectInfoMap = (Map)MapUtil.getOrDefault((Map)rawData, (String)"project_info", Collections.emptyMap());
        List projectInfoList = (List)MapUtil.getOrDefault((Map)projectInfoMap, (String)"projectInfoList", Collections.emptyList());
        Map projectInfo = CollectionUtils.isNotEmpty((Collection)projectInfoList) ? (Map)projectInfoList.get(0) : Collections.emptyMap();
        stopWatch.start("Build SystemCloudHouseKeeper Choose Template Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "MESSAGE_BAR": {
                    MessageBar messageBar = (MessageBar)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), MessageBar.class);
                    messageBar.setContent(this.localeService.getLanguageValue(locale, messageBar.getContent()));
                    uiBotModel.getPageData().put((Object)schema, (Object)messageBar);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                    this.handleCustomGroup(customGroup, projectInfo, locale);
                    uiBotModel.getPageData().put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = (List)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    buttonList.forEach(bottomButton -> {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getIsCheckButton().booleanValue()) {
                            Action action = bottomButton.getAction();
                            action.setRefreshPageId(apiRequest.getRefreshPageId());
                            rawData.put("actionId", "bm.pisc.project.template.copy.process");
                            rawData.put("project_no", projectInfo.get("projectNo"));
                            action.setRawData((Object)rawData);
                        }
                    });
                    uiBotModel.getPageData().put((Object)schema, (Object)buttonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private void handleCustomGroup(CustomGroup customGroup, Map<String, Object> projectInfo, String locale) {
        CustomGroupContent customGroupContent = customGroup.getContent();
        List customGroupUiBotLayouts = customGroupContent.getLayout();
        for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayouts) {
            String customGroupSchema = customGroupUiBotLayout.getSchema();
            switch (customGroupUiBotLayout.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = this.buildInputWindowSingleSelect(customGroupUiBotLayout, projectInfo, customGroupSchema, locale);
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputWindowSingleSelect);
                    break;
                }
                case "INPUT_CALENDAR": {
                    InputCalendar inputCalendar = this.buildInputCalendar(customGroupUiBotLayout, projectInfo, locale);
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputCalendar);
                }
            }
        }
    }

    private InputWindowSingleSelect buildInputWindowSingleSelect(UiBotLayout uiBotLayout, Map<String, Object> projectInfo, String schema, String locale) {
        InputWindowSingleSelect inputWindowSingleSelect = new InputWindowSingleSelect();
        inputWindowSingleSelect.setSchema(uiBotLayout.getSchema());
        inputWindowSingleSelect.setTitle(this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        inputWindowSingleSelect.setRawData(this.buildInputWindowMultiSelectRawData(projectInfo));
        inputWindowSingleSelect.setType("WINDOW_SINGLE_SELECT");
        inputWindowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowSingleSelect.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9"));
        inputWindowSingleSelect.setRequired(Boolean.valueOf(true));
        return inputWindowSingleSelect;
    }

    private InputCalendar buildInputCalendar(UiBotLayout uiBotLayout, Map<String, Object> projectInfo, String locale) {
        uiBotLayout.setHeaderName(this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        InputCalendar inputCalendar = InputCalendar.create((UiBotLayout)uiBotLayout, null, (String)locale);
        String planStartDate = MapUtils.getString(projectInfo, (Object)"planStartDate");
        if (StringUtils.isNotEmpty((CharSequence)planStartDate)) {
            LocalDate localDate = DateTimeUtil.parseLocalDateUseDefaultPattern((String)planStartDate);
            InputCalendarDate inputCalendarDate = InputCalendarDate.create((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth());
            inputCalendar.setMinDateSelectable(inputCalendarDate);
            inputCalendar.setDateValueList(Collections.singletonList(inputCalendarDate));
        }
        inputCalendar.setRequired(Boolean.valueOf(true));
        inputCalendar.setHidden(Boolean.valueOf(true));
        return inputCalendar;
    }

    private Map<String, Object> buildInputWindowMultiSelectRawData(Map<String, Object> projectInfo) {
        ArrayList searchInfoList = new ArrayList(3);
        HashMap<String, Object> searchItemOrConditionMap = new HashMap<String, Object>(6);
        searchItemOrConditionMap.put("bracket", "(");
        searchItemOrConditionMap.put("logic", "OR");
        searchItemOrConditionMap.put("order", 1);
        searchItemOrConditionMap.put("search_field", "project_type_no");
        searchItemOrConditionMap.put("search_operator", "equal");
        searchItemOrConditionMap.put("search_value", Collections.singletonList(MapUtils.getString(projectInfo, (Object)"projectTypeNo")));
        searchInfoList.add(searchItemOrConditionMap);
        HashMap<String, Object> searchItemAndConditionMap = new HashMap<String, Object>(6);
        searchItemAndConditionMap.put("bracket", ")");
        searchItemAndConditionMap.put("logic", "AND");
        searchItemAndConditionMap.put("order", 2);
        searchItemAndConditionMap.put("search_field", "project_type_no");
        searchItemAndConditionMap.put("search_operator", "equal");
        searchItemAndConditionMap.put("search_value", Collections.singletonList(""));
        searchInfoList.add(searchItemAndConditionMap);
        HashMap<String, Object> searchItemNullConditionMap = new HashMap<String, Object>(6);
        searchItemNullConditionMap.put("order", 3);
        searchItemNullConditionMap.put("search_field", "is_default");
        searchItemNullConditionMap.put("search_operator", "equal");
        searchItemNullConditionMap.put("search_value", Collections.singletonList(false));
        searchInfoList.add(searchItemNullConditionMap);
        HashMap<String, Object> parasMap = new HashMap<String, Object>(2);
        parasMap.put("query_condition", "M1");
        parasMap.put("search_info", searchInfoList);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.project.template.get");
        requestMap.put("parameter", parasMap);
        HashMap<String, Object> rawDataMap = new HashMap<String, Object>(2);
        rawDataMap.put("requestParam", requestMap);
        rawDataMap.put("type", "isSCHEditPlanTemplateInfo");
        return rawDataMap;
    }

    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        HashMap projectInfoMap = new HashMap(3);
        projectInfoMap.put("project_no", rawData.get("project_no"));
        for (ActionSubmitParam actionSubmitParam : apiRequestSubmit.getSubmitParams()) {
            switch (actionSubmitParam.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputWindowSingleSelect.class);
                    String projectTemplateNo = Optional.ofNullable(inputWindowSingleSelect.getDetail()).map(e -> MapUtils.getString((Map)e, (Object)"project_template_no")).orElse("");
                    projectInfoMap.put("project_template_no", projectTemplateNo);
                    break;
                }
                case "INPUT_CALENDAR": {
                    InputCalendar inputCalendar = (InputCalendar)actionSubmitParam.getParams();
                    if (!StringUtils.isNotEmpty((CharSequence)inputCalendar.getInputText())) break;
                    projectInfoMap.put("plan_rearrange_base_date", inputCalendar.getInputText().replaceAll("\\.", "-"));
                }
            }
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("is_clear_person_info", true);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        HashMap requestMap = new HashMap(2);
        requestMap.put("actionId", rawData.get("actionId"));
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() != 200 || StringUtils.isNotEmpty((CharSequence)resp.getErrorMessage())) {
            throw new ServiceException(resp.getErrorMessage());
        }
        List projectInfoList = Optional.ofNullable(resp.getResponse()).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"project_info", Collections.emptyList())).orElse(Collections.emptyList());
        String errorMsg = projectInfoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)MapUtils.getString((Map)e, (Object)"error_msg"))).findFirst().map(e -> MapUtils.getString((Map)e, (Object)"error_msg")).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            throw new ServiceException(errorMsg);
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.name());
        action.setSuccessMsg(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4\u6210\u529f"));
        return ActionSubmitResult.create((boolean)true, (Action)action);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

