/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroupAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRateTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDescProjectCCBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.strategy.ProjectDetailBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.service.DigiwinTaskEngineProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="projectDetailBuildSystemCloudHouseKeeperEditPlanStrategy")
public class ProjectDetailBuildSystemCloudHouseKeeperEditPlanStrategy
implements ProjectDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildSystemCloudHouseKeeperEditPlanStrategy.class);
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DigiwinTaskEngineProxyService digiwinTaskEngineProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private TitleDescProjectCCBuilder titleDescProjectCCBuilder;
    @Autowired
    private CustomTabsBuilder customTabsBuilder;
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private LocaleService localeService;

    public String getProjectDetailType() {
        return "systemCloudHouseKeeper_userProject_sch_maintenanceProject";
    }

    public Map<String, Object> build(ApiRequest apiRequest, String iamUserToken, PageSetting pageSetting, UiBotModel pcUiBotModel, DigiwinAtmcPanel digiwinAtmcPanel, Object ... args) {
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        StopWatch stopWatch = new StopWatch("Build Project-Detail Page Data");
        stopWatch.start("Get ProjectCC Detail Data From Athena ATDM");
        ArrayList<Future> futureList = new ArrayList<Future>();
        Future futureAtdmProjectInfo = this.threadPoolTaskExecutor.submit(this.buildGetProjectInfoCallable(locale, iamUserToken, pcUiBotModel, this.digiwinAtdmProxyService, tenantId));
        futureList.add(futureAtdmProjectInfo);
        Future futureAtdmProjectTaskInfo = this.threadPoolTaskExecutor.submit(this.buildGetProjectTaskInfoCallable(locale, iamUserToken, pcUiBotModel, this.digiwinAtdmProxyService, tenantId));
        futureList.add(futureAtdmProjectTaskInfo);
        PccApiDataWrapper projectInfo = null;
        PccApiDataWrapper projectTaskInfo = null;
        try {
            block24: for (Future future : futureList) {
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        PccApiDataWrapper container;
                        Object obj = future.get();
                        if (!(obj instanceof PccApiDataWrapper) || null == (container = (PccApiDataWrapper)obj).getProjectInfoList() || container.getProjectInfoList().isEmpty()) continue block24;
                        Object firstEle = container.getProjectInfoList().get(0);
                        if (firstEle instanceof PccProjectInfo) {
                            projectInfo = container;
                            continue block24;
                        }
                        if (!(firstEle instanceof PccProjectTaskInfo)) continue block24;
                        projectTaskInfo = container;
                        continue block24;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        stopWatch.stop();
        if (null == projectInfo || CollectionUtils.isEmpty((Collection)projectInfo.getProjectInfoList())) {
            return Collections.emptyMap();
        }
        stopWatch.start("Build SystemCloudHouseKeeper Edit Plan Page Page");
        HashMap<String, Object> result = new HashMap<String, Object>();
        PccProjectInfo pccProjectInfo = (PccProjectInfo)projectInfo.getProjectInfoList().get(0);
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map projectDetailDataState = (Map)MapUtil.getOrDefault((Map)rawData, (String)"projectDetailDataState", Collections.emptyMap());
        UiBotModel pageModel = pageSetting.getPageModel();
        Iterator layoutIterator = pageModel.getLayout().iterator();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = (UiBotLayout)layoutIterator.next();
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_DESC": {
                    result.put(schema, this.titleDescProjectCCBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleDesc.class, new Object[]{pccProjectInfo, digiwinAtmcPanel}));
                    break;
                }
                case "TITLE_BODY": {
                    result.put(schema, TitleBody.create((ApiRequest)apiRequest, (PageSetting)pageSetting, (UiBotModel)pcUiBotModel, (PccProjectInfo)pccProjectInfo, (DigiwinAtmcPanel)digiwinAtmcPanel, (PageDescBuilderFactory)this.pageDescBuilderFactory));
                    break;
                }
                case "PROGRESS_RATE": {
                    if ("progressRateFinished".equalsIgnoreCase(schema)) {
                        double rate = MathUtil.getDecimalPoint((double)Optional.ofNullable(pccProjectInfo.getProjectCompleteRate()).orElse(0.0), (int)2);
                        result.put(schema, new ProgressRate(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5b8c\u6210\u7387") + String.format("%.0f", rate * 100.0) + "%", ProgressRateTypeEnum.NORMAL.getType(), Double.valueOf(rate)));
                        break;
                    }
                    if ("progressRateOverdue".equalsIgnoreCase(schema)) {
                        double rate = MathUtil.getDecimalPoint((double)Optional.ofNullable(pccProjectInfo.getProjectOverdueRate()).orElse(0.0), (int)2);
                        if (rate != 0.0) {
                            result.put(schema, new ProgressRate(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u7387") + String.format("%.0f", rate * 100.0) + "%", ProgressRateTypeEnum.EXCEPTION.getType(), Double.valueOf(rate)));
                            break;
                        }
                        layoutIterator.remove();
                        break;
                    }
                    result.put(schema, new ProgressRate(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u672a\u5b9a\u4e49"), ProgressRateTypeEnum.NORMAL.getType(), Double.valueOf(0.0)));
                    break;
                }
                case "DIVIDER": {
                    Divider divider = Divider.create((DividerTypeEnum)DividerTypeEnum.BLOCK_DIVIDER);
                    String newSchema = schema + "_" + divider.getCmptUuid();
                    layout.setSchema(newSchema);
                    result.put(newSchema, divider);
                    break;
                }
                case "AUTO_FILL": {
                    HashMap<String, Object> basicDetailRawData;
                    Action basicDetailAction;
                    ArrayList<AutoFillData> autoFillDataList = new ArrayList<AutoFillData>();
                    List bmdPiscProMemoList = this.getBmdPiscProMemo(apiRequest, pccProjectInfo.getProjectNo());
                    if (!CollectionUtils.isEmpty((Collection)bmdPiscProMemoList)) {
                        AutoFillData processRemarkAutoFillData = new AutoFillData();
                        processRemarkAutoFillData.setName(this.localeService.getLanguageValue(locale, "\u8fc7\u7a0b\u5907\u5fd8\u5f55"));
                        processRemarkAutoFillData.setNameColor("5037DB");
                        processRemarkAutoFillData.setNameSize("28");
                        basicDetailAction = new Action();
                        basicDetailAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROCESS_REMARK.toString());
                        basicDetailAction.setJumpPageTitle(processRemarkAutoFillData.getName());
                        basicDetailAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                        basicDetailRawData = new HashMap<String, Object>();
                        basicDetailRawData.put("project_info", pccProjectInfo);
                        basicDetailRawData.put("isEdit", true);
                        basicDetailAction.setRawData(basicDetailRawData);
                        processRemarkAutoFillData.setAction(basicDetailAction);
                        autoFillDataList.add(processRemarkAutoFillData);
                    }
                    AutoFillData chooseTemplateAutoFillData = new AutoFillData();
                    chooseTemplateAutoFillData.setName(this.localeService.getLanguageValue(locale, "\u9009\u62e9\u6a21\u677f"));
                    chooseTemplateAutoFillData.setNameColor("5037DB");
                    chooseTemplateAutoFillData.setNameSize("28");
                    basicDetailAction = new Action();
                    basicDetailAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_CHOOSE_TEMPLATE.toString());
                    basicDetailAction.setJumpPageTitle(chooseTemplateAutoFillData.getName());
                    basicDetailAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    basicDetailRawData = new HashMap();
                    basicDetailRawData.put("project_info", projectInfo);
                    basicDetailAction.setRawData(basicDetailRawData);
                    chooseTemplateAutoFillData.setAction(basicDetailAction);
                    autoFillDataList.add(chooseTemplateAutoFillData);
                    AutoFill autoFill = new AutoFill();
                    autoFill.setData(autoFillDataList);
                    autoFill.setAlign(ButtonGroupAlignEnum.CENTER.getValue());
                    result.put(schema, autoFill);
                    break;
                }
                case "CUSTOM_TABS": {
                    if (Objects.nonNull(projectTaskInfo)) {
                        List pccProjectTaskInfo = projectTaskInfo.getProjectInfoList();
                        CustomTabs customTabs = this.customTabsBuilder.build(apiRequest, pageSetting, pcUiBotModel, CustomTabs.class, new Object[]{layout, pccProjectTaskInfo, pccProjectInfo.getProjectNo(), apiRequest.getTenantId()});
                        result.put(schema, customTabs);
                        break;
                    }
                    Empty empty = Empty.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9\u6a21\u677f\uff0c\u6dfb\u52a0\u4efb\u52a1"));
                    layout.setType("EMPTY");
                    result.put(schema, empty);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = (List)JsonUtil.objectToJavaObject((Object)pageModel.getPageData().get((Object)schema), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    PccApiDataWrapper finalProjectTaskInfo = projectTaskInfo;
                    buttonList.forEach(bottomButton -> {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getIsCheckButton().booleanValue()) {
                            Action action = bottomButton.getAction();
                            action.setRefreshPageId(apiRequest.getRefreshPageId());
                            rawData.put("projectDetailDataState", projectDetailDataState);
                            rawData.put("project_info", pccProjectInfo);
                            rawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString());
                            action.setRawData((Object)rawData);
                            ConfirmPop confirmPop = ConfirmPop.create((String)this.localeService.getLanguageValue(locale, "\u662f\u5426\u542f\u52a8\u9879\u76ee?"), (String)this.localeService.getLanguageValue(locale, "\u8bf7\u6838\u5bf9\u6267\u884c\u4eba/\u8d1f\u8d23\u4eba/\u4efb\u52a1\u540d\u79f0\u7b49\u4fe1\u606f"), (boolean)true);
                            action.setConfirmPop(confirmPop);
                        }
                        if (Objects.isNull(finalProjectTaskInfo) || CollectionUtils.isEmpty((Collection)finalProjectTaskInfo.getProjectInfoList())) {
                            bottomButton.setEnable(Boolean.valueOf(false));
                        }
                    });
                    result.put(schema, buttonList);
                }
            }
        }
        stopWatch.stop();
        result.put("project_info", pccProjectInfo);
        logger.debug(stopWatch.prettyPrint());
        return result;
    }

    private Callable<PccApiDataWrapper<PccProjectInfo>> buildGetProjectInfoCallable(String locale, String iamUserToken, UiBotModel pcUiBotModel, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {
        return () -> {
            HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
            String actionId = "project.info.get";
            bodyPayloadMap.put("actionId", actionId);
            bodyPayloadMap.put("businessUnit", pcUiBotModel.getExecuteContext().get((Object)"businessUnit"));
            Map taskWithBacklogData = (Map)pcUiBotModel.getExecuteContext().get((Object)"taskWithBacklogData");
            Map bpmData = (Map)taskWithBacklogData.get("bpmData");
            List projectDataList = (List)bpmData.get("project_data");
            HashMap<String, List> parameter = new HashMap<String, List>(1);
            parameter.put("project_info", projectDataList);
            bodyPayloadMap.put("parameter", parameter);
            return digiwinAtdmProxyService.dataQueryByActionProjectInfo(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
        };
    }

    private Callable<PccApiDataWrapper<PccProjectTaskInfo>> buildGetProjectTaskInfoCallable(String locale, String iamUserToken, UiBotModel pcUiBotModel, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {
        return () -> {
            HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
            String actionId = "task.info.get";
            bodyPayloadMap.put("actionId", actionId);
            bodyPayloadMap.put("businessUnit", pcUiBotModel.getExecuteContext().get((Object)"businessUnit"));
            Map taskWithBacklogData = (Map)pcUiBotModel.getExecuteContext().get((Object)"taskWithBacklogData");
            Map bpmData = (Map)taskWithBacklogData.get("bpmData");
            List projectDataList = (List)bpmData.get("project_data");
            if (null != projectDataList && !projectDataList.isEmpty()) {
                ((Map)projectDataList.get(0)).put("control_mode", "1");
                ((Map)projectDataList.get(0)).put("task_property", "1");
            }
            HashMap<String, List> parameter = new HashMap<String, List>(1);
            parameter.put("project_info", projectDataList);
            bodyPayloadMap.put("parameter", parameter);
            return digiwinAtdmProxyService.dataQueryByActionProjectTaskInfo(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
        };
    }

    private List<Map<String, Object>> getBmdPiscProMemo(ApiRequest apiRequest, String projectNo) {
        HashMap<String, Object> projectProcessMemorandumInfoMap = new HashMap<String, Object>(2);
        projectProcessMemorandumInfoMap.put("project_no", projectNo);
        projectProcessMemorandumInfoMap.put("memorandum_property", 1);
        HashMap parameterMap = new HashMap(2);
        parameterMap.put("project_process_memorandum_info", Collections.singletonList(projectProcessMemorandumInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bmd.pisc.pro.memo.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"project_process_memorandum_info")).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> getBmPiscAttachmentJoinRelation(ApiRequest apiRequest, String projectNo) {
        HashMap<String, String> taskInfoMap = new HashMap<String, String>(3);
        taskInfoMap.put("project_no", projectNo);
        taskInfoMap.put("task_property", "1");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("query_condition", "ALL");
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.attachment.join.relation.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"task_info")).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) throws ServiceException {
        String locale = apiRequestSubmit.getLocale();
        this.validProcessRemarkRequired(apiRequestSubmit);
        this.validateAssistSchedule(apiRequestSubmit);
        this.validateProjectInfo(apiRequestSubmit);
        boolean isNeedApprove = this.getProjectIsApproveByProjectType(apiRequestSubmit);
        this.updateProjectStatus(apiRequestSubmit, isNeedApprove);
        if (isNeedApprove) {
            this.executionEngine(apiRequestSubmit);
        } else {
            this.submitData(apiRequestSubmit);
            this.dispatch(apiRequestSubmit);
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.name());
        action.setSuccessMsg(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4\u6210\u529f"));
        return ActionSubmitResult.create((boolean)true, (Action)action);
    }

    private void validProcessRemarkRequired(ApiRequestSubmit apiRequestSubmit) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setLocale(apiRequestSubmit.getLocale());
        apiRequest.setTenantId(apiRequestSubmit.getTenantId());
        apiRequest.setIamUserToken(apiRequestSubmit.getIamUserToken());
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        String projectNo = MapUtils.getString((Map)projectInfo, (Object)"projectNo");
        List bmdPiscProMemoList = this.getBmdPiscProMemo(apiRequest, projectNo);
        List bmPiscAttachmentJoinRelationList = this.getBmPiscAttachmentJoinRelation(apiRequest, projectNo);
        Map<String, Map> bmPiscAttachmentJoinRelationListMapByTaskNo = bmPiscAttachmentJoinRelationList.stream().collect(Collectors.toMap(item -> MapUtils.getString((Map)item, (Object)"task_no"), item -> item, (v1, v2) -> v1));
        ArrayList<String> validFailedTaskNameList = new ArrayList<String>();
        for (Map bmdPiscProMemo : bmdPiscProMemoList) {
            String belongTaskNo = MapUtils.getString((Map)bmdPiscProMemo, (Object)"belong_task_no");
            String processPlan = MapUtils.getString((Map)bmdPiscProMemo, (Object)"process_plan");
            Map bmPiscAttachmentJoinRelationMapByTaskNo = bmPiscAttachmentJoinRelationListMapByTaskNo.get(belongTaskNo);
            boolean isRequired = CollectionUtils.isEmpty((Map)bmPiscAttachmentJoinRelationMapByTaskNo) ? false : !MapUtils.getBooleanValue((Map)bmPiscAttachmentJoinRelationMapByTaskNo, (Object)"need_issue_task_card", (boolean)true);
            if (!isRequired || !StringUtils.isEmpty((CharSequence)processPlan)) continue;
            validFailedTaskNameList.add(MapUtils.getString((Map)bmPiscAttachmentJoinRelationMapByTaskNo, (Object)"task_name"));
        }
        if (!CollectionUtils.isEmpty(validFailedTaskNameList)) {
            String errorMessage = StringUtils.join(validFailedTaskNameList, (String)"\uff0c") + this.localeService.getLanguageValue(apiRequestSubmit.getLocale(), "\u4efb\u52a1\u4e0d\u9700\u6267\u884c\uff0c\u8fc7\u7a0b\u5907\u5fd8\u5f55\u5fc5\u586b");
            throw new ServiceException(errorMessage);
        }
    }

    private void validateAssistSchedule(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        HashMap assistScheduleInfoMap = new HashMap(2);
        assistScheduleInfoMap.put("project_no", projectInfo.get("projectNo"));
        assistScheduleInfoMap.put("schedule_status", "1");
        HashMap parameterMap = new HashMap(2);
        parameterMap.put("assist_schedule_info", Collections.singletonList(assistScheduleInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.assist.schedule.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            List assistScheduleInfoResp = Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"assist_schedule_info")).orElse(Collections.emptyList());
            if (!CollectionUtils.isEmpty(assistScheduleInfoResp)) {
                throw new ServiceException(this.localeService.getLanguageValue(locale, "\u5f53\u524d\u6709\u534f\u540c\u6392\u5b9a\u8ba1\u5212\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u8bf7\u50ac\u529e\uff01"));
            }
        } else {
            throw new ServiceException(resp.getErrorMessage());
        }
    }

    private void validateProjectInfo(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        HashMap projectInfoMap = new HashMap(1);
        projectInfoMap.put("project_no", projectInfo.get("projectNo"));
        HashMap parameterMap = new HashMap(1);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.project.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            Map projectInfoResp = Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"project_info")).filter(e -> !CollectionUtils.isEmpty((Collection)e)).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
            String projectStatus = MapUtils.getString(projectInfoResp, (Object)"project_status");
            String approveAction = MapUtils.getString(projectInfoResp, (Object)"approve_action");
            if (Objects.equals(projectStatus, "10") && Objects.equals(approveAction, "30")) {
                throw new ServiceException(this.localeService.getLanguageValue(locale, "\u5f53\u524d\u9879\u2f6c\u6b63\u5728\u542f\u52a8\u7b7e\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u7b7e\u6838\u5b8c\u6210\uff01"));
            }
            if (Objects.equals(projectStatus, "30")) {
                throw new ServiceException(this.localeService.getLanguageValue(locale, "\u5f53\u524d\u9879\u2f6c\u5df2\u7ecf\u7b7e\u6838\u5b8c\u6210\uff0c\u8bf7\u5237\u65b0\u2eda\u2faf\uff01"));
            }
        } else {
            throw new ServiceException(resp.getErrorMessage());
        }
    }

    private boolean getProjectIsApproveByProjectType(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        HashMap projectInfoMap = new HashMap(1);
        projectInfoMap.put("project_type_no", projectInfo.get("projectTypeNo"));
        HashMap parameterMap = new HashMap(1);
        parameterMap.put("project_type_info", Collections.singletonList(projectInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.project.type.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            Map projectTypeInfoResp = Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"project_type_info")).filter(e -> !CollectionUtils.isEmpty((Collection)e)).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
            return MapUtils.getBooleanValue(projectTypeInfoResp, (Object)"project_is_approve");
        }
        throw new ServiceException(resp.getErrorMessage());
    }

    private void updateProjectStatus(ApiRequestSubmit apiRequestSubmit, boolean isApprove) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        HashMap projectInfoMap = new HashMap(1);
        projectInfoMap.put("project_no", projectInfo.get("projectNo"));
        projectInfoMap.put("is_approve", isApprove);
        projectInfoMap.put("approve_status", isApprove ? "N" : "V");
        projectInfoMap.put("project_status", "30");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(1);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        parameterMap.put("sync_steady_state", "N");
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.project.status.update");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() != 200 && StringUtils.isNotEmpty((CharSequence)resp.getErrorMessage())) {
            throw new ServiceException(resp.getErrorMessage());
        }
    }

    private void submitData(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        Map projectDetailDataState = (Map)rawData.get("projectDetailDataState");
        Map workItemInfo = Optional.ofNullable(projectDetailDataState).map(e -> (Map)MapUtil.getOrDefault((Map)e, (String)"executeContext", Collections.emptyMap())).map(e -> (Map)MapUtil.getOrDefault((Map)e, (String)"taskWithBacklogData", Collections.emptyMap())).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"backlog", Collections.emptyList())).map(e -> (Map)e.get(0)).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"workitemList", Collections.emptyList())).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
        HashMap dispatchDataMap = new HashMap(1);
        dispatchDataMap.put("project_no", projectInfo.get("projectNo"));
        HashMap processVariablesMap = new HashMap(1);
        processVariablesMap.put("project_no", projectInfo.get("projectNo"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(1);
        parameterMap.put("dispatchData", Collections.singletonList(dispatchDataMap));
        parameterMap.put("processVariables", processVariablesMap);
        parameterMap.put("performerId", apiRequestSubmit.getUserId());
        parameterMap.put("workitemId", workItemInfo.get("workitemId"));
        parameterMap.put("locale", locale);
        Map resp = this.digiwinTaskEngineProxyService.submitData(apiRequestSubmit.getTenantId(), apiRequestSubmit.getIamUserToken(), parameterMap);
        if (!MapUtils.getBooleanValue((Map)resp, (Object)"success")) {
            throw new ServiceException(MapUtils.getString((Map)resp, (Object)"message"));
        }
    }

    private void dispatch(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectDetailDataState = (Map)rawData.get("projectDetailDataState");
        Map workItemInfo = Optional.ofNullable(projectDetailDataState).map(e -> (Map)MapUtil.getOrDefault((Map)e, (String)"executeContext", Collections.emptyMap())).map(e -> (Map)MapUtil.getOrDefault((Map)e, (String)"taskWithBacklogData", Collections.emptyMap())).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"backlog", Collections.emptyList())).map(e -> (Map)e.get(0)).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"workitemList", Collections.emptyList())).map(e -> (Map)e.get(0)).orElse(Collections.emptyMap());
        HashMap<String, String> parameterMap = new HashMap<String, String>(1);
        parameterMap.put("comment", "");
        parameterMap.put("performerId", (String)workItemInfo.get("performerId"));
        parameterMap.put("workitemId", (String)workItemInfo.get("workitemId"));
        parameterMap.put("locale", locale);
        Map resp = this.digiwinTaskEngineProxyService.manualDispatch(apiRequestSubmit.getTenantId(), apiRequestSubmit.getIamUserToken(), parameterMap);
        if (!MapUtils.getBooleanValue((Map)resp, (Object)"success")) {
            throw new ServiceException(MapUtils.getString((Map)resp, (Object)"message"));
        }
    }

    private void executionEngine(ApiRequestSubmit apiRequestSubmit) {
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map projectInfo = (Map)rawData.get("project_info");
        HashMap projectInfoMap = new HashMap(5);
        projectInfoMap.put("project_no", projectInfo.get("projectNo"));
        projectInfoMap.put("project_leader_code", projectInfo.get("projectLeaderCode"));
        projectInfoMap.put("project_leader_id", apiRequestSubmit.getUserId());
        projectInfoMap.put("project_status", "30");
        projectInfoMap.put("action", "start");
        HashMap parameterMap = new HashMap(1);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        Map resp = this.digiwinKnowledgeMapsProxyService.executionEngine(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "startServiceComposer_sch_startProjectCard", Collections.singletonList(parameterMap));
        Map output = Optional.ofNullable(resp).map(e -> (Map)MapUtil.getOrDefault((Map)e, (String)"output", Collections.emptyMap())).orElse(Collections.emptyMap());
        if (!MapUtils.getBooleanValue(output, (Object)"success")) {
            throw new ServiceException(MapUtils.getString(output, (Object)"errorMessage"));
        }
    }
}

