/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="projectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy")
public class ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("SystemCloudHouseKeeper Process Remark Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        stopWatch.start("Build SystemCloudHouseKeeper Process Remark Page Model...");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map projectInfoMap = (Map)MapUtil.getOrDefault((Map)rawData, (String)"project_info", Collections.emptyMap());
        String projectNo = MapUtils.getString((Map)projectInfoMap, (Object)"projectNo");
        List bmdPiscProMemoList = this.getBmdPiscProMemo(apiRequest, projectNo);
        List bmPiscAttachmentJoinRelationList = this.getBmPiscAttachmentJoinRelation(apiRequest, projectNo);
        Map<String, Map> bmPiscAttachmentJoinRelationListMapByTaskNo = bmPiscAttachmentJoinRelationList.stream().collect(Collectors.toMap(item -> MapUtils.getString((Map)item, (Object)"task_no"), item -> item, (v1, v2) -> v1));
        boolean isEdit = MapUtils.getBooleanValue((Map)rawData, (Object)"isEdit", (boolean)false);
        List uiBotLayouts = uiBotModel.getLayout();
        ArrayList<UiBotLayout> newUiBotLayouts = new ArrayList<UiBotLayout>();
        UiBotPageData newPageData = new UiBotPageData();
        block16: for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    for (Map bmdPiscProMemo : bmdPiscProMemoList) {
                        String memorandumId = MapUtils.getString((Map)bmdPiscProMemo, (Object)"memorandum_id");
                        String belongTaskNo = MapUtils.getString((Map)bmdPiscProMemo, (Object)"belong_task_no");
                        boolean isRequired = false;
                        Map bmPiscAttachmentJoinRelationMapByTaskNo = bmPiscAttachmentJoinRelationListMapByTaskNo.get(belongTaskNo);
                        if (!CollectionUtils.isEmpty((Map)bmPiscAttachmentJoinRelationMapByTaskNo) && isEdit) {
                            isRequired = !MapUtils.getBooleanValue((Map)bmPiscAttachmentJoinRelationMapByTaskNo, (Object)"need_issue_task_card", (boolean)true);
                        }
                        UiBotLayout copyCustomGroupLayout = (UiBotLayout)JsonUtil.objectToJavaObject((Object)layout, UiBotLayout.class);
                        copyCustomGroupLayout.setSchema(UUIDUtil.getUuid());
                        newUiBotLayouts.add(copyCustomGroupLayout);
                        CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                        CustomGroupContent customGroupContent = customGroup.getContent();
                        UiBotPageData customGroupUiBotPageData = customGroupContent.getPageData();
                        List customGroupUiBotLayoutList = customGroupContent.getLayout();
                        for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayoutList) {
                            String customGroupSchema = customGroupUiBotLayout.getSchema();
                            String label = this.localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel());
                            switch (customGroupUiBotLayout.getType()) {
                                case "FIELD": {
                                    this.buildDyncamicComponent(bmdPiscProMemo, customGroupUiBotLayout, customGroupUiBotPageData, customGroupSchema, label, locale, isRequired, isEdit);
                                    break;
                                }
                                case "INPUT_SINGLE": {
                                    String value = MapUtils.getString((Map)bmdPiscProMemo, (Object)customGroupSchema);
                                    customGroupUiBotLayout.setSchema(memorandumId + "_concat_" + customGroupSchema);
                                    if (BooleanUtils.isFalse((Boolean)isEdit) && StringUtils.isEmpty((CharSequence)value)) {
                                        Field field = Field.createLabelLeftValueRightField((String)label, (String)"-");
                                        customGroupUiBotLayout.setType("FIELD");
                                        customGroupUiBotPageData.put((Object)customGroupUiBotLayout.getSchema(), (Object)field);
                                        break;
                                    }
                                    InputSingleText inputSingleText = InputSingleText.create((String)customGroupSchema, (String)label, (Boolean)false, (Boolean)isEdit, (String)locale, (String)value, (Boolean)false);
                                    inputSingleText.setMaxLength(Integer.valueOf(100));
                                    customGroupUiBotPageData.put((Object)customGroupUiBotLayout.getSchema(), (Object)inputSingleText);
                                }
                            }
                        }
                        newPageData.put((Object)copyCustomGroupLayout.getSchema(), (Object)customGroup);
                    }
                    continue block16;
                }
                case "BOTTOM_BUTTON": {
                    newUiBotLayouts.add(layout);
                    ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>();
                    buttonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
                    if (BooleanUtils.isTrue((Boolean)isEdit)) {
                        Action buttonAction = new Action();
                        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
                        HashMap<String, List> actionRawData = new HashMap<String, List>();
                        actionRawData.put("bmdPiscProMemoList", bmdPiscProMemoList);
                        buttonAction.setRawData(actionRawData);
                        BottomButtonDigiwinAthena saveButton = new BottomButtonDigiwinAthena();
                        saveButton.setName(this.localeService.getLanguageValue(locale, "\u786e\u5b9a"));
                        saveButton.setAction(buttonAction);
                        buttonList.add(saveButton);
                    }
                    newPageData.put((Object)schema, buttonList);
                    break;
                }
            }
        }
        uiBotModel.setLayout(newUiBotLayouts);
        uiBotModel.setPageData(newPageData);
        stopWatch.stop();
        return uiBotModel;
    }

    private void buildDyncamicComponent(Map<String, Object> bmdPiscProMemo, UiBotLayout customGroupUiBotLayout, UiBotPageData customGroupUiBotPageData, String customGroupSchema, String label, String locale, boolean isRequired, boolean isEdit) {
        String memorandumId = MapUtils.getString(bmdPiscProMemo, (Object)"memorandum_id");
        String processPlan = MapUtils.getString(bmdPiscProMemo, (Object)"process_plan");
        String inputMode = MapUtils.getString(bmdPiscProMemo, (Object)"input_mode");
        if (Objects.equals("process_plan", customGroupSchema) && (BooleanUtils.isTrue((Boolean)isEdit) || Objects.equals(inputMode, "7"))) {
            customGroupSchema = memorandumId + "_concat_" + customGroupSchema;
            customGroupUiBotLayout.setSchema(customGroupSchema);
            switch (inputMode) {
                case "7": {
                    if (isEdit || StringUtils.isNotEmpty((CharSequence)processPlan)) {
                        Attachment attachment = new Attachment();
                        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
                        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
                        attachment.setTitle(label);
                        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
                        attachment.setType(isEdit ? AttachmentTypeEnum.READ_AND_WRITE.getValue() : AttachmentTypeEnum.READ_ONLY.getValue());
                        Long maxSize = 0x3200000L;
                        attachment.setFileMaxSize(new FileMaxSize(maxSize, maxSize, maxSize, maxSize));
                        attachment.setLimit(Integer.valueOf(1));
                        List fileInfoList = this.digiwinDmcProxyService.getFileInfoByIds("SCH", Collections.singletonList(processPlan));
                        if (!CollectionUtils.isEmpty((Collection)fileInfoList)) {
                            String finalProcessPlan = processPlan;
                            List attachmentFileList = fileInfoList.stream().map(item -> {
                                AttachmentFile attachmentFile = new AttachmentFile();
                                attachmentFile.setFileName(item.getFileName());
                                attachmentFile.setFileId(finalProcessPlan);
                                attachmentFile.setFileExtension(item.getExtension());
                                return attachmentFile;
                            }).collect(Collectors.toList());
                            attachment.setFileList(attachmentFileList);
                        }
                        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
                        attachmentRawDataDigiwinAthena.setBuckets("SCH");
                        attachment.setRawData((AttachmentRawData)attachmentRawDataDigiwinAthena);
                        attachment.setRequired(Boolean.valueOf(isRequired));
                        customGroupUiBotLayout.setType("ATTACHMENT");
                        customGroupUiBotPageData.put((Object)customGroupSchema, (Object)attachment);
                        break;
                    }
                    processPlan = StringUtils.isNotEmpty((CharSequence)processPlan) ? processPlan : "-";
                    Field field = Field.createLabelLeftValueRightField((String)label, (String)processPlan);
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)field);
                    break;
                }
                case "6": {
                    InputDateTimePicker inputDatePicker = InputDateTimePicker.create((String)customGroupSchema, (String)label, (String)processPlan, (String)locale, (Integer)InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
                    inputDatePicker.setRequired(Boolean.valueOf(isRequired));
                    customGroupUiBotLayout.setType("INPUT_DATETIME_PICKER");
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)inputDatePicker);
                    break;
                }
                case "5": {
                    InputDateTimePicker inputDateTimePicker = InputDateTimePicker.create((String)customGroupSchema, (String)label, (String)processPlan, (String)locale, (Integer)InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType());
                    inputDateTimePicker.setRequired(Boolean.valueOf(isRequired));
                    customGroupUiBotLayout.setType("INPUT_DATETIME_PICKER");
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)inputDateTimePicker);
                    break;
                }
                case "4": {
                    String singleOptionalValue = MapUtils.getString(bmdPiscProMemo, (Object)"optional_value");
                    List<Object> singleOptionList = new ArrayList();
                    if (StringUtils.isNotEmpty((CharSequence)singleOptionalValue)) {
                        String finalProcessPlan1 = processPlan;
                        singleOptionList = Arrays.asList(StringUtils.splitByWholeSeparator((String)singleOptionalValue, (String)",")).stream().map(item -> {
                            SingleSelectListOption singleSelectListOption = SingleSelectListOption.create((String)item, (String)item, (Boolean)true);
                            singleSelectListOption.setSelected(Boolean.valueOf(Objects.equals(item, finalProcessPlan1)));
                            return singleSelectListOption;
                        }).collect(Collectors.toList());
                    }
                    SingleSelectList singleSelectList = SingleSelectList.createSingleSelectList(singleOptionList, (String)label, (String)processPlan, (String)processPlan, (String)locale, (boolean)isRequired, (boolean)true);
                    customGroupUiBotLayout.setType("SINGLE_SELECT_LIST");
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)singleSelectList);
                    break;
                }
                case "3": {
                    String multiOptionalValue = MapUtils.getString(bmdPiscProMemo, (Object)"optional_value");
                    List<Object> valueList = StringUtils.isNotEmpty((CharSequence)processPlan) ? Arrays.asList(StringUtils.splitByWholeSeparator((String)processPlan, (String)",")) : new ArrayList();
                    List<Object> multiOptionList = new ArrayList();
                    if (StringUtils.isNotEmpty((CharSequence)multiOptionalValue)) {
                        multiOptionList = Arrays.asList(StringUtils.splitByWholeSeparator((String)multiOptionalValue, (String)",")).stream().map(item -> {
                            SingleSelectListOption singleSelectListOption = SingleSelectListOption.create((String)item, (String)item, (Boolean)true);
                            singleSelectListOption.setSelected(Boolean.valueOf(valueList.contains(item)));
                            return singleSelectListOption;
                        }).collect(Collectors.toList());
                    }
                    SingleSelectList multiSingleSelectList = SingleSelectList.createMultiSelectList(multiOptionList, (String)label, valueList, valueList, (String)locale, (boolean)isRequired, (boolean)true);
                    customGroupUiBotLayout.setType("SINGLE_SELECT_LIST");
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)multiSingleSelectList);
                    break;
                }
                case "2": {
                    InputNumeric inputNumeric = InputNumeric.create((Integer)99999999, (Integer)0, (String)processPlan, (String)label, (Integer)InputNumericTypeEnum.INTEGER_ALLOW_NEGATIVE.getValue(), (Boolean)isRequired, (String)"");
                    inputNumeric.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165"));
                    customGroupUiBotLayout.setType("INPUT_NUMERIC");
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)inputNumeric);
                    break;
                }
                case "1": {
                    InputSingleText inputSingleText = InputSingleText.create((String)customGroupSchema, (String)label, (Boolean)isRequired, (Boolean)true, (String)locale, (String)processPlan, (Boolean)false);
                    inputSingleText.setMaxLength(Integer.valueOf(100));
                    customGroupUiBotLayout.setType("INPUT_SINGLE");
                    customGroupUiBotPageData.put((Object)customGroupSchema, (Object)inputSingleText);
                    break;
                }
            }
        } else {
            String value = MapUtils.getString(bmdPiscProMemo, (Object)customGroupSchema);
            value = StringUtils.isNotEmpty((CharSequence)value) ? value : "-";
            Field field = Field.createLabelLeftValueRightField((String)label, (String)value);
            if (Objects.equals(customGroupSchema, "belong_task_name")) {
                field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_BLACK.getValue());
            }
            customGroupUiBotLayout.setSchema(memorandumId + "_concat_" + customGroupSchema);
            customGroupUiBotPageData.put((Object)customGroupUiBotLayout.getSchema(), (Object)field);
        }
    }

    private List<Map<String, Object>> getBmPiscAttachmentJoinRelation(ApiRequest apiRequest, String projectNo) {
        HashMap<String, String> taskInfoMap = new HashMap<String, String>(3);
        taskInfoMap.put("project_no", projectNo);
        taskInfoMap.put("task_property", "1");
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("query_condition", "ALL");
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bm.pisc.attachment.join.relation.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"task_info")).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> getBmdPiscProMemo(ApiRequest apiRequest, String projectNo) {
        HashMap<String, Object> projectProcessMemorandumInfoMap = new HashMap<String, Object>(2);
        projectProcessMemorandumInfoMap.put("project_no", projectNo);
        projectProcessMemorandumInfoMap.put("memorandum_property", 1);
        HashMap parameterMap = new HashMap(2);
        parameterMap.put("project_process_memorandum_info", Collections.singletonList(projectProcessMemorandumInfoMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bmd.pisc.pro.memo.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty((CharSequence)resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List)e.get((Object)"project_process_memorandum_info")).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        List bmdPiscProMemoList = (List)MapUtil.getOrDefault((Map)rawData, (String)"bmdPiscProMemoList", Collections.emptyList());
        if (CollectionUtils.isEmpty((Collection)apiRequestSubmit.getSubmitParams())) {
            throw new ServiceException(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Map<String, List<ActionSubmitParam>> actionSubmitParamListMapByMemorandumId = apiRequestSubmit.getSubmitParams().stream().collect(Collectors.groupingBy(e -> StringUtils.splitByWholeSeparator((String)e.getSchema(), (String)"_concat_")[0]));
        for (Map bmdPiscProMemo : bmdPiscProMemoList) {
            String memorandumId = MapUtils.getString((Map)bmdPiscProMemo, (Object)"memorandum_id");
            List<ActionSubmitParam> actionSubmitParamListByMemorandumId = actionSubmitParamListMapByMemorandumId.get(memorandumId);
            if (CollectionUtils.isEmpty(actionSubmitParamListByMemorandumId)) continue;
            for (ActionSubmitParam actionSubmitParam : actionSubmitParamListByMemorandumId) {
                String schema = StringUtils.splitByWholeSeparator((String)actionSubmitParam.getSchema(), (String)"_concat_")[1];
                switch (actionSubmitParam.getType()) {
                    case "ATTACHMENT": {
                        Attachment attachment = (Attachment)actionSubmitParam.getParams();
                        List fileList = attachment.getFileList();
                        boolean isDelete = fileList.stream().allMatch(e -> Objects.equals("DELETE", e.getStatus()));
                        if (isDelete) {
                            bmdPiscProMemo.put(schema, "");
                            break;
                        }
                        String fileId = fileList.stream().filter(e -> Objects.equals("NEW", e.getStatus())).findFirst().orElse(new AttachmentFile()).getFileId();
                        bmdPiscProMemo.put(schema, fileId);
                        break;
                    }
                    case "INPUT_DATETIME_PICKER": {
                        InputDateTimePicker picker = (InputDateTimePicker)actionSubmitParam.getParams();
                        if (picker.getDatetimeValue() == null) break;
                        String value = InputDateTime.getDateTypeDateStringByType((InputDateTime)picker.getDatetimeValue(), (Integer)picker.getType());
                        bmdPiscProMemo.put(schema, value);
                        break;
                    }
                    case "INPUT_SINGLE": {
                        InputSingleText inputSingleText = (InputSingleText)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputSingleText.class);
                        bmdPiscProMemo.put(schema, inputSingleText.getText());
                        break;
                    }
                    case "INPUT_NUMERIC": {
                        InputNumeric inputNumeric = (InputNumeric)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputNumeric.class);
                        bmdPiscProMemo.put(schema, inputNumeric.getText());
                        break;
                    }
                    case "SINGLE_SELECT_LIST": {
                        SingleSelectList singleSelectList = (SingleSelectList)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), SingleSelectList.class);
                        if (singleSelectList.getType() == 2) {
                            String value = CollectionUtils.isEmpty((Collection)singleSelectList.getSelectIdList()) ? "" : StringUtils.join((Iterable)singleSelectList.getSelectIdList(), (String)",");
                            bmdPiscProMemo.put(schema, value);
                            break;
                        }
                        bmdPiscProMemo.put(schema, singleSelectList.getSelectId());
                        break;
                    }
                }
            }
        }
        HashMap<String, List> parameterMap = new HashMap<String, List>(1);
        parameterMap.put("project_process_memorandum_info", bmdPiscProMemoList);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(2);
        requestMap.put("actionId", "bmd.pisc.pro.memo.update");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);
        if (resp.getStatus() != 200 || StringUtils.isNotEmpty((CharSequence)resp.getErrorMessage())) {
            throw new ServiceException(resp.getErrorMessage());
        }
        List projectInfoList = Optional.ofNullable(resp.getResponse()).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"error_info", Collections.emptyList())).orElse(Collections.emptyList());
        String errorMsg = projectInfoList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)MapUtils.getString((Map)e, (Object)"error_msg"))).findFirst().map(e -> MapUtils.getString((Map)e, (Object)"error_msg")).orElse("");
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            throw new ServiceException(errorMsg);
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.name());
        action.setSuccessMsg(this.localeService.getLanguageValue(locale, "\u6dfb\u52a0\u6210\u529f"));
        return ActionSubmitResult.create((boolean)true, (Action)action);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

