/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.projectplan.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildPccProjectPlanBasicDetailStrategy")
public class UiBotModelBuildPccProjectPlanBasicDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(UiBotModelBuildPccProjectPlanBasicDetailStrategy.class);
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildPccProjectPlanBasicDetailStrategy.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Pcc Project Plan Basic Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map projectInfoMap = (Map)MapUtil.getOrDefault((Map)rawData, (String)"project_info", Collections.emptyMap());
        if (CollectionUtils.isEmpty((Map)projectInfoMap)) {
            return UiBotModel.emptyUiBotModel();
        }
        List shippingInfoList = this.getShippingInfoList(apiRequest, MapUtils.getString((Map)projectInfoMap, (Object)"project_no"));
        if (!CollectionUtils.isEmpty((Collection)shippingInfoList)) {
            projectInfoMap.putAll((Map)shippingInfoList.get(0));
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "RETRACYABLE": {
                    Retractable retractable = (Retractable)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Retractable.class);
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)((BaseMobileComponentWrapper)retractable.getContent().get(0)).getData(), CustomGroup.class);
                    List customGroupLayoutList = customGroup.getContent().getLayout();
                    UiBotPageData customGroupPageData = customGroup.getContent().getPageData();
                    for (UiBotLayout customGroupLayout : customGroupLayoutList) {
                        String customGroupSchema = customGroupLayout.getSchema();
                        switch (customGroupLayout.getType()) {
                            case "FIELD": {
                                String fieldValue;
                                String fieldName = this.localeService.getLanguageValue(locale, customGroupLayout.getLabel());
                                if ("project_type_name".equalsIgnoreCase(customGroupSchema)) {
                                    String projectTypeName = MapUtils.getString((Map)projectInfoMap, (Object)"project_type_name");
                                    String projectTypeNo = MapUtils.getString((Map)projectInfoMap, (Object)"project_type_no");
                                    fieldValue = (Objects.isNull(projectTypeName) ? "" : projectTypeName) + (Objects.isNull(projectTypeNo) ? "" : projectTypeNo);
                                } else if ("wbs_first_budget".equalsIgnoreCase(customGroupSchema) || "budget_planning".equalsIgnoreCase(customGroupSchema)) {
                                    boolean isTrue = MapUtils.getBooleanValue((Map)projectInfoMap, (Object)customGroupSchema);
                                    fieldValue = this.localeService.getLanguageValue(locale, isTrue ? "\u662f" : "\u5426");
                                } else {
                                    fieldValue = MapUtils.getString((Map)projectInfoMap, (Object)customGroupSchema);
                                    if ("project_property".equalsIgnoreCase(customGroupSchema)) {
                                        fieldValue = this.localeService.getLanguageValue(locale, "20".equals(fieldValue) ? "\u6b63\u5f0f" : ("10".equals(fieldValue) ? "\u6f5c\u5728" : ""));
                                    }
                                    if ("control_type".equalsIgnoreCase(customGroupSchema)) {
                                        fieldValue = "20".equals(fieldValue) ? "WARNING" : ("10".equals(fieldValue) ? "ERROR" : "");
                                    }
                                }
                                Field field = Field.createLabelLeftValueRightField((String)fieldName, (String)fieldValue);
                                customGroupPageData.put((Object)customGroupSchema, (Object)field);
                                break;
                            }
                            case "INPUT_MULTI": {
                                String inputMultiTextName = this.localeService.getLanguageValue(locale, customGroupLayout.getLabel());
                                String inputMultiTextValue = MapUtils.getString((Map)projectInfoMap, (Object)customGroupSchema);
                                InputMultiText inputMultiText = InputMultiText.create((String)inputMultiTextName, (String)inputMultiTextValue, (Boolean)false, (Boolean)true, (String)locale);
                                customGroupPageData.put((Object)customGroupSchema, (Object)inputMultiText);
                                break;
                            }
                            case "ATTACHMENT": {
                                List dataList;
                                Attachment attachment = new Attachment();
                                attachment.setTitle(this.localeService.getLanguageValue(locale, customGroupLayout.getLabel()));
                                attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                                attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                                attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
                                Map attachmentMap = (Map)MapUtil.getOrDefault((Map)projectInfoMap, (String)"attachment", Collections.emptyMap());
                                if (!CollectionUtils.isEmpty((Map)attachmentMap) && !CollectionUtils.isEmpty((Collection)(dataList = (List)MapUtil.getOrDefault((Map)attachmentMap, (String)"data", Collections.emptyList())))) {
                                    List fileList = dataList.stream().map(data -> {
                                        String createDate;
                                        AttachmentFile file = new AttachmentFile();
                                        file.setFileId(MapUtils.getString((Map)data, (Object)"id"));
                                        file.setFileSize(Long.valueOf((long)MapUtils.getDoubleValue((Map)data, (Object)"size", (double)0.0)));
                                        file.setUploader(MapUtils.getString((Map)data, (Object)"upload_user_name"));
                                        file.setFileName(MapUtils.getString((Map)data, (Object)"name"));
                                        String string = createDate = Objects.isNull(data.get("create_date")) ? "" : String.valueOf(data.get("create_date"));
                                        if (StringUtils.hasLength((String)createDate)) {
                                            createDate = createDate.replaceAll("/", "-");
                                        }
                                        file.setUploadTime(createDate);
                                        file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String)((String)data.get("name"))));
                                        file.setShareUrl(AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/Athena/preview/" + file.getFileId());
                                        return file;
                                    }).collect(Collectors.toList());
                                    attachment.setFileList(fileList);
                                }
                                customGroupPageData.put((Object)customGroupSchema, (Object)attachment);
                            }
                        }
                    }
                    retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper((BaseMobileComponent)customGroup, "CUSTOM_GROUP")));
                    pageData.put((Object)schema, (Object)retractable);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    buttons.forEach(item -> item.setName(this.localeService.getLanguageValue(locale, item.getName())));
                    pageData.put((Object)schema, (Object)buttons);
                }
            }
        }
        return uiBotModel;
    }

    private PccApiDataWrapper<PccProjectTaskInfo> buildGetProjectTaskInfoCallable(String locale, String iamUserToken, PccProjectInfo pccProjectInfo, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {
        HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
        String actionId = "task.info.get";
        bodyPayloadMap.put("actionId", actionId);
        HashMap<String, String> projectInfoMap = new HashMap<String, String>();
        projectInfoMap.put("project_no", pccProjectInfo.getProjectNo());
        projectInfoMap.put("task_property", "1");
        projectInfoMap.put("control_mode", "1");
        projectInfoMap.put("get_key_info", "3");
        HashMap parameter = new HashMap(1);
        parameter.put("project_info", Collections.singletonList(projectInfoMap));
        bodyPayloadMap.put("parameter", parameter);
        return digiwinAtdmProxyService.dataQueryByActionProjectTaskInfo(locale, iamUserToken, JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
    }

    private List<Map<String, Object>> getShippingInfoList(ApiRequest apiRequest, String projectNo) {
        HashMap<String, String> projectInfoMap = new HashMap<String, String>(1);
        projectInfoMap.put("project_no", projectNo);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        parameterMap.put("query_mode", "1");
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("actionId", "project.batch.shipment.info.get");
        requestParamMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse employeeInfo = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestParamMap);
        List<Map<String, Object>> shippingInfoList = Optional.ofNullable(employeeInfo).map(DigiwinAthenaApiResponse::getResponse).map(e -> (Map)MapUtil.getOrDefault((Map)e, (String)"project_info", Collections.emptyMap())).map(e -> (List)MapUtil.getOrDefault((Map)e, (String)"shipping_info", Collections.emptyList())).orElse(Collections.emptyList());
        return shippingInfoList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

