/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCard;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardContent;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabsComponent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.TableUiBotParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/proxy"})
public class StandardProjectController {
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @PostMapping(value={"/project/standard/progress/detail"})
    public ApiResponse<Map> getProgressDetail(@RequestParam String projectId, @RequestParam String tmTaskId, HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String tenantId = (String)params.get("tenantId");
        String locale = (String)params.get("locale");
        String progressId = (String)params.get("progressId");
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow) {
            String data = FileUtil.readText((String)("static/appstore-use/project-standard-progress-show-" + progressId + ".json"));
            Map map = (Map)JsonUtil.jsonStringToObject((String)data, Map.class);
            ArrayList<Map> content = new ArrayList<Map>();
            content.add(map);
            return ApiResponse.buildOK().setData(content);
        }
        List sortList = this.digiwinPcUiBotProxyService.getProjectDetailByProjectId(locale, iamUserToken, tenantId, projectId, tmTaskId, progressId);
        TabsComponent tabsComponent = new TabsComponent();
        ArrayList content = new ArrayList();
        HashMap<String, String> tabsMap = new HashMap<String, String>();
        tabsMap.put("area", "body");
        tabsMap.put("componentType", "TABS");
        tabsMap.put("data", (String)tabsComponent);
        content.add(tabsMap);
        if (sortList == null || sortList.size() == 0) {
            return ApiResponse.buildOK().setData(content);
        }
        for (Map map : sortList) {
            List fieldDataListList;
            TabItem tabItem = new TabItem();
            tabsComponent.add((Object)tabItem);
            String tabName = (String)map.get("queryTitle");
            if (!StringUtils.hasLength((String)tabName)) {
                tabName = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5168\u90e8");
            }
            tabItem.setName(tabName);
            ArrayList<TabItemCard> cardList = new ArrayList<TabItemCard>();
            tabItem.setContent(cardList);
            UiBotModel uiBotModel = this.digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString((Object)map));
            List layoutList = uiBotModel.getLayout();
            if (layoutList == null || layoutList.size() == 0) continue;
            List orderLayoutList = layoutList.stream().filter(UiBotLayout::isTypeOfGroupOrder).collect(Collectors.toList());
            List tableLayoutList = layoutList.stream().filter(UiBotLayout::isTypeOfTable).collect(Collectors.toList());
            if (orderLayoutList.size() > 0) {
                HashMap<String, Integer> overdueMap = new HashMap<String, Integer>();
                overdueMap.put("overdueNum", 0);
                overdueMap.put("overdueDays", 0);
                List fieldDataListList2 = TableUiBotParser.parseTableUiBotData((UiBotLayout)((UiBotLayout)orderLayoutList.get(0)), (UiBotPageData)uiBotModel.getPageData());
                if (fieldDataListList2 != null) {
                    List dataList = (List)uiBotModel.getPageData().get((Object)((UiBotLayout)orderLayoutList.get(0)).getSchema());
                    for (int i = 0; i < fieldDataListList2.size(); ++i) {
                        List fieldDataList = (List)fieldDataListList2.get(i);
                        TabItemCard itemCard = this.orderMap2TabItemCard(fieldDataList, overdueMap, locale, projectId);
                        if (((Map)dataList.get(i)).get("logistics_detail") != null) {
                            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
                            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ZTB_PROJECT_LOGISTICS.toString());
                            HashMap rawData = new HashMap();
                            rawData.put("data", ((Map)dataList.get(i)).get("logistics_detail"));
                            detailPage.setRawData(rawData);
                            itemCard.setDetailPage(detailPage);
                        }
                        cardList.add(itemCard);
                    }
                }
                int overdueDays = (Integer)overdueMap.get("overdueDays");
                int overdueNum = (Integer)overdueMap.get("overdueNum");
                if (overdueNum <= 0) continue;
                tabItem.setDesc(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u8be6\u60c5"), overdueNum, overdueDays));
                continue;
            }
            if (tableLayoutList.size() <= 0 || (fieldDataListList = TableUiBotParser.parseTableUiBotData((UiBotLayout)((UiBotLayout)tableLayoutList.get(0)), (UiBotPageData)uiBotModel.getPageData())) == null) continue;
            for (List fieldDataList : fieldDataListList) {
                TabItemCard itemCard = this.tableMap2TabItemCard(fieldDataList, locale, projectId);
                cardList.add(itemCard);
            }
        }
        return ApiResponse.buildOK().setData(content);
    }

    private TabItemCard tableMap2TabItemCard(List<ParseFieldData> fieldDataList, String locale, String projectId) {
        TabItemCard card = new TabItemCard();
        ArrayList<TabItemCardContent> cardContentList = new ArrayList<TabItemCardContent>();
        card.setContent(cardContentList);
        for (ParseFieldData fieldData : fieldDataList) {
            if (cardContentList.size() == 3) break;
            TabItemCardContent cardContent = this.convertTabItemCardContent(fieldData, locale, projectId);
            if (cardContent == null) continue;
            cardContentList.add(cardContent);
        }
        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
        detailPage.setDataId("");
        HashMap<String, List<ParseFieldData>> rawData = new HashMap<String, List<ParseFieldData>>();
        rawData.put("data", fieldDataList);
        detailPage.setRawData(rawData);
        card.setDetailPage(detailPage);
        return card;
    }

    private TabItemCardContent convertTabItemCardContent(ParseFieldData fieldData, String locale, String projectId) {
        if (fieldData == null || fieldData.getData() == null) {
            return null;
        }
        TabItemCardContent tabItemCardContent = new TabItemCardContent();
        tabItemCardContent.setLabel(fieldData.getLabel());
        tabItemCardContent.setLabelStyleType(Integer.valueOf(2));
        tabItemCardContent.setValueStyleType(Integer.valueOf(1));
        AtomicReference<Object> value = new AtomicReference<Object>(fieldData.getData());
        if (fieldData.getOptions() != null) {
            fieldData.getOptions().forEach(uiBotTableColumnEditorOption -> {
                if (value.get().equals(uiBotTableColumnEditorOption.getValue())) {
                    value.set(uiBotTableColumnEditorOption.getTitle());
                }
            });
        }
        if ("SIGN_OFF_PROGRESS".equalsIgnoreCase(fieldData.getType())) {
            String approve;
            Map valueMap = (Map)value.get();
            switch (approve = valueMap.get("approve").toString()) {
                case "3": {
                    tabItemCardContent.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u7b7e\u6838"));
                    break;
                }
                default: {
                    tabItemCardContent.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7b7e\u6838\u4e2d"));
                }
            }
            Action action = new Action();
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            action.setJumpPageTitle(fieldData.getLabel());
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString());
            action.setDataId(projectId);
            action.setRawData((Object)valueMap);
            tabItemCardContent.setAction(action);
        } else {
            String valueStr = value.get().toString();
            if (!StringUtils.hasLength((String)valueStr)) {
                valueStr = "-";
            }
            tabItemCardContent.setValue(valueStr);
        }
        return tabItemCardContent;
    }

    private TabItemCard orderMap2TabItemCard(List<ParseFieldData> fieldDataList, Map<String, Integer> overdueMap, String locale, String projectId) {
        TabItemCardContent approvalStateCardContent;
        TabItemCardContent activityPlanEndTimeCardContent;
        Map dataMap = this.fieldData2Map(fieldDataList);
        TabItemCard card = new TabItemCard();
        if (dataMap.get("activity__performerName") != null) {
            BaseMobileComponentPerson person = new BaseMobileComponentPerson();
            String name = (String)((ParseFieldData)dataMap.get("activity__performerName")).getData();
            person.setName(StringUtils.hasLength((String)name) ? name : "-");
            card.setPerson(person);
        }
        ArrayList<TabItemCardContent> cardContentList = new ArrayList<TabItemCardContent>();
        card.setContent(cardContentList);
        if (dataMap.get("activity__backLog__data") != null) {
            TabItemCardContent statusCardContent = this.calculateTaskStatus((ParseFieldData)dataMap.get("activity__backLog__data"), overdueMap, locale);
            cardContentList.add(statusCardContent);
        }
        if (dataMap.get("activity__planEndTime") != null && (activityPlanEndTimeCardContent = this.convertTabItemCardContent((ParseFieldData)dataMap.get("activity__planEndTime"), locale, projectId)) != null) {
            cardContentList.add(activityPlanEndTimeCardContent);
        }
        if (dataMap.get("activity__approval__state") != null && (approvalStateCardContent = this.convertTabItemCardContent((ParseFieldData)dataMap.get("activity__approval__state"), locale, projectId)) != null) {
            cardContentList.add(approvalStateCardContent);
        }
        for (ParseFieldData fieldData : fieldDataList) {
            TabItemCardContent tabItemCardContent;
            if (cardContentList.size() == 4) break;
            if ("activity__performerName".equalsIgnoreCase(fieldData.getSchema()) || "activity__backLog__data".equalsIgnoreCase(fieldData.getSchema()) || "activity__planEndTime".equalsIgnoreCase(fieldData.getSchema()) || "activity__approval__state".equalsIgnoreCase(fieldData.getSchema()) || (tabItemCardContent = this.convertTabItemCardContent(fieldData, locale, projectId)) == null) continue;
            cardContentList.add(tabItemCardContent);
        }
        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
        detailPage.setDataId(projectId);
        HashMap<String, List<ParseFieldData>> rawData = new HashMap<String, List<ParseFieldData>>();
        rawData.put("data", fieldDataList);
        detailPage.setRawData(rawData);
        card.setDetailPage(detailPage);
        return card;
    }

    private Map<String, ParseFieldData> fieldData2Map(List<ParseFieldData> fieldDataList) {
        HashMap<String, ParseFieldData> map = new HashMap<String, ParseFieldData>();
        if (fieldDataList == null) {
            return map;
        }
        fieldDataList.stream().forEach(fieldData -> map.put(fieldData.getSchema(), (ParseFieldData)fieldData));
        return map;
    }

    public TabItemCardContent calculateTaskStatus(ParseFieldData fieldData, Map<String, Integer> overdueMap, String locale) {
        Map dataMap = (Map)fieldData.getData();
        if (dataMap == null) {
            TabItemCardContent statusCardContent = new TabItemCardContent();
            statusCardContent.setLabel(fieldData.getLabel());
            statusCardContent.setLabelStyleType(Integer.valueOf(2));
            statusCardContent.setValue("-");
            return statusCardContent;
        }
        String planEndTime = (String)dataMap.get("planEndTime");
        Boolean close = (Boolean)dataMap.get("closed");
        String endTime = (String)dataMap.get("endTime");
        TabItemCardContent statusCardContent = new TabItemCardContent();
        statusCardContent.setLabel(fieldData.getLabel());
        statusCardContent.setLabelStyleType(Integer.valueOf(2));
        if (close.booleanValue()) {
            if (DateTimeUtil.compareTime((String)endTime, (String)planEndTime).booleanValue()) {
                statusCardContent.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u5b8c\u6210"));
                statusCardContent.setType("DONE");
            } else {
                int days = DateTimeUtil.getDateTimePeriod((String)planEndTime, (String)endTime);
                statusCardContent.setValue(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u540e\u5b8c\u6210"), days));
                statusCardContent.setType("OVERDUE_DONE");
            }
        } else if (!DateTimeUtil.isBeforeNowDateTime((String)planEndTime).booleanValue()) {
            statusCardContent.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5728\u8fdb\u884c"));
            statusCardContent.setType("LOADING");
        } else {
            int overdueNum = overdueMap.get("overdueNum");
            int overdueDays = overdueMap.get("overdueDays");
            overdueMap.put("overdueNum", ++overdueNum);
            int days = DateTimeUtil.getDateTimePeriod((String)planEndTime, (String)DateTimeUtil.getTodayTimeUseDefaultPattern());
            if (days > overdueDays) {
                overdueDays = days;
                overdueMap.put("overdueDays", overdueDays);
            }
            statusCardContent.setValue(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), days));
            statusCardContent.setType("OVERDUE");
        }
        return statusCardContent;
    }
}

