/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.ai.service.impl;

import com.digiwin.athena.ai.RequestHDL;
import com.digiwin.athena.ai.enums.CacData;
import com.digiwin.athena.ai.enums.OCR_CarData;
import com.digiwin.athena.ai.enums.RHResult;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.constant.TimeOutEnum;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ai.model.DigiwinAiOcrCarNumberResult;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.DigiwinAiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.impl.DigiwinAiProxyServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DigiwinAiProxyServiceImpl
implements DigiwinAiProxyService {
    private static final Logger log = LoggerFactory.getLogger(DigiwinAiProxyServiceImpl.class);
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private HttpService httpService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public List<String> getRecommendedReport(List<String> reportCodeList, String userId, String iamUserToken, String tenantId) {
        List mapList;
        ArrayList<String> recommendedReportCodeList = new ArrayList<String>();
        if (reportCodeList == null || reportCodeList.isEmpty()) {
            return recommendedReportCodeList;
        }
        String url = this.sysEnvConfig.getAiUrl() + "/rs/recommended-report-list";
        boolean overdue = this.digiwinEspProxyService.checkProjectAmountOverdue(iamUserToken, tenantId, "zh_CN");
        boolean projectBehind = this.digiwinEspProxyService.checkProjectBackward(iamUserToken, tenantId, "zh_CN");
        HashMap<String, Integer> reportInformation = new HashMap<String, Integer>();
        reportInformation.put("task_behind", projectBehind ? 1 : 0);
        reportInformation.put("task_overdue", overdue ? 1 : 0);
        HashMap body = new HashMap();
        List dataList = reportCodeList.stream().map(reportCode -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tenant_id", tenantId);
            data.put("user_id", userId);
            data.put("report_id", reportCode);
            data.put("report_code", reportCode);
            data.put("report_information", reportInformation);
            data.put("timestamp", System.currentTimeMillis());
            return data;
        }).collect(Collectors.toList());
        body.put("data_list", dataList);
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        List<String> resultList = new ArrayList<String>();
        if (statusCode.is2xxSuccessful() && (mapList = (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()) != null && !mapList.isEmpty()) {
            resultList = mapList.stream().map(map -> (String)map.get("report_code")).collect(Collectors.toList());
        }
        return resultList;
    }

    public List<String> getRecommendedMenu(List<String> menuCodeList, String userId, String iamUserToken, String tenantId) {
        List mapList;
        ArrayList<String> recommendedMenuCodeList = new ArrayList<String>();
        if (menuCodeList == null || menuCodeList.isEmpty()) {
            return recommendedMenuCodeList;
        }
        String url = this.sysEnvConfig.getAiUrl() + "/rs/recommended-menu-list";
        HashMap body = new HashMap();
        List dataList = menuCodeList.stream().map(menuCode -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tenant_id", tenantId);
            data.put("user_id", userId);
            data.put("menu_id", menuCode);
            data.put("menu_code", menuCode);
            data.put("timestamp", System.currentTimeMillis());
            return data;
        }).collect(Collectors.toList());
        body.put("data_list", dataList);
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        List<String> resultList = new ArrayList<String>();
        if (statusCode.is2xxSuccessful() && (mapList = (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse()) != null && !mapList.isEmpty()) {
            resultList = mapList.stream().map(map -> (String)map.get("menu_code")).collect(Collectors.toList());
        }
        return resultList;
    }

    public DigiwinAiApiResponse<DigiwinAiOcrCarNumberResult> getOcrCarNumber(String locale, String iamUserToken, String userId, String tenantId, String image) {
        DigiwinAiApiResponse digiwinAiApiResponse = new DigiwinAiApiResponse();
        try {
            AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
            athenaBasicHttpRequestHead.setLocale(locale);
            athenaBasicHttpRequestHead.setUserToken(iamUserToken);
            athenaBasicHttpRequestHead.setTenantId(tenantId);
            ResponseEntity responseEntity = this.httpService.doGet(this.sysEnvConfig.getAiGetTopicQtyUrl(), athenaBasicHttpRequestHead, Collections.emptyMap(), Map.class);
            Object topicQtyObj = ((Map)responseEntity.getBody()).get("data");
            Integer topicQty = topicQtyObj != null ? (Integer)topicQtyObj : 10;
            OCR_CarData imgdata = new OCR_CarData();
            imgdata.setImage(image);
            imgdata.setMulti_detect("true");
            CacData cacData = new CacData();
            cacData.setUserID(userId);
            cacData.setUserToken(iamUserToken);
            RequestHDL requestHdl = new RequestHDL();
            RHResult resultJson = requestHdl.requestOCR_CAR(this.sysEnvConfig.getAikafkaUrl(), "AI", "1", iamUserToken, imgdata, cacData, TimeOutEnum.getSecondByEnvType().intValue(), topicQty.intValue());
            log.error("DigiwinAiProxyServiceImpl get Ai requestOCR_CAR info: {}", (Object)resultJson);
            digiwinAiApiResponse.setCode(resultJson.getCode());
            digiwinAiApiResponse.setMsg(resultJson.getMsg());
            if (resultJson.getData() != null) {
                digiwinAiApiResponse.setData(JsonUtil.jsonStringToObject((String)resultJson.getData(), DigiwinAiOcrCarNumberResult.class));
            }
        }
        catch (Throwable e) {
            log.error("DigiwinAiProxyServiceImpl getOcrCarNumber error: ", e);
            digiwinAiApiResponse = DigiwinAiApiResponse.buildError();
        }
        return digiwinAiApiResponse;
    }
}

