/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspExecution;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Objects;
import java.util.Optional;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class DigiwinEspResponse {
    public static final String RESP_CODE_OK = "0";
    public static final String RESP_CODE_ERROR = "-1";
    public static final String RESP_EMPTY = "EMPTY in API!!!";
    private DigiwinEspStdData stdData;

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public String getStdDataExecutionCode() {
        return Optional.ofNullable(this.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getCode).orElse(RESP_CODE_ERROR);
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public String getStdDataExecutionDescription() {
        return Optional.ofNullable(this.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getDescription).orElse(RESP_EMPTY);
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public String getStdDataExecutionMessage() {
        return Optional.ofNullable(this.getStdData()).map(DigiwinEspStdData::getExecution).map(DigiwinEspExecution::getMessage).orElse(RESP_EMPTY);
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public String getResponseFullDescriptionMsgWhenNotOK(String serviceProd, String serviceName, String parameterBodyJson) {
        return "Service [" + serviceName + "] NOT OK. Here is summary: \r\nServiceProd is: " + serviceProd + ", \r\nRequestBody is: " + parameterBodyJson + ", \r\nExecution code: " + this.getStdDataExecutionCode() + ", \r\nExecution description: " + this.getStdDataExecutionDescription() + ", \r\nExecution message: " + this.getStdDataExecutionMessage();
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public Boolean isRespOk(String respDataKey) {
        return Objects.equals(RESP_CODE_OK, this.getStdDataExecutionCode()) && this.getStdData() != null && this.getStdData().getExecution() != null && this.getStdData().getParameter() != null && this.getStdData().getParameter().get(respDataKey) != null;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize=false)
    public Boolean isRespOk() {
        return Objects.equals(RESP_CODE_OK, this.getStdDataExecutionCode()) && this.getStdData() != null && this.getStdData().getExecution() != null && this.getStdData().getParameter() != null;
    }

    public DigiwinEspStdData getStdData() {
        return this.stdData;
    }

    public void setStdData(DigiwinEspStdData stdData) {
        this.stdData = stdData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DigiwinEspResponse)) {
            return false;
        }
        DigiwinEspResponse other = (DigiwinEspResponse)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DigiwinEspStdData this$stdData = this.getStdData();
        DigiwinEspStdData other$stdData = other.getStdData();
        return !(this$stdData == null ? other$stdData != null : !this$stdData.equals(other$stdData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DigiwinEspResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DigiwinEspStdData $stdData = this.getStdData();
        result = result * 59 + ($stdData == null ? 43 : $stdData.hashCode());
        return result;
    }

    public String toString() {
        return "DigiwinEspResponse(stdData=" + this.getStdData() + ")";
    }
}

