/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.iam.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.crypto.digest.SecureAESUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.password.RandomPasswordUtil;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.IamAuth;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.PasswordChange;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTokenRefreshTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAddJoinTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfoResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserRoleInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.impl.DigiwinIamProxyServiceImpl;
import com.digiwin.mobile.mobileuibot.sso.dto.ThirdPartyLoginFreeQueryDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="digiwinIamProxyService")
public class DigiwinIamProxyServiceImpl
implements DigiwinIamProxyService {
    private static final String LOGIN_TYPE_FIRM_ACCOUNT = "firmAccount";
    private static final Logger logger = LoggerFactory.getLogger(DigiwinIamProxyServiceImpl.class);
    private final HttpService httpService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private SysEnvConfig sysEnvConfig;

    public DigiwinIamProxyServiceImpl(HttpService httpService) {
        this.httpService = httpService;
    }

    public List<DigiwinIamTenant> listUserTenantsInAthena(String userToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/tenant?appId={appId}";
        HashMap<String, String> uriVariables = new HashMap<String, String>(1);
        uriVariables.put("appId", "Athena");
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), uriVariables, (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)responseEntity.getBody() : Collections.emptyList();
    }

    public DigiwinIamTokenRefreshTenant tokenRefreshTenant(String tenantId, String tenantSid, String userToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/token/refresh/tenant";
        HashMap<String, Object> bodyPayload = new HashMap<String, Object>(1);
        if (StringUtils.hasLength((String)tenantSid)) {
            bodyPayload.put("tenantSid", NumberUtils.parseNumber((String)tenantSid, Long.class));
        }
        if (StringUtils.hasLength((String)tenantId)) {
            bodyPayload.put("tenantId", tenantId);
        }
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(bodyPayload), DigiwinIamTokenRefreshTenant.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return (DigiwinIamTokenRefreshTenant)responseEntity.getBody();
    }

    public DigiwinIamAnalyzedToken tokenAnalyze(String userToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/token/analyze";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), Map.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            return (DigiwinIamAnalyzedToken)JsonUtil.objectToJavaObject((Object)responseEntity.getBody(), DigiwinIamAnalyzedToken.class);
        }
        return DigiwinIamAnalyzedToken.createEmpty();
    }

    public int tokenAnalyzeByCheck(String userToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/token/analyze";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), DigiwinIamAnalyzedToken.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.value();
    }

    public Integer logout(String userToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/logout";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), Collections.emptyMap(), Object.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.value();
    }

    public List<DigiwinIamUserInfo> userList(List<String> userIds, String userToken, String locale) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/list";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(userIds), DigiwinIamUserInfoResponse.class);
        return responseEntity.getStatusCode().is2xxSuccessful() ? ((DigiwinIamUserInfoResponse)responseEntity.getBody()).getData() : null;
    }

    public DigiwinIamUserInfo userInfoById(String userId, String userToken, String locale) {
        if (StringUtils.isEmpty((Object)userId)) {
            return null;
        }
        ArrayList<String> userIds = new ArrayList<String>(1);
        userIds.add(userId);
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/list";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(userIds), DigiwinIamUserInfoResponse.class);
        if (responseEntity.getStatusCode().is2xxSuccessful() && ((DigiwinIamUserInfoResponse)responseEntity.getBody()).getData().size() != 0) {
            return (DigiwinIamUserInfo)((DigiwinIamUserInfoResponse)responseEntity.getBody()).getData().get(0);
        }
        return null;
    }

    public Boolean mobileIsRegister(String telephone, String locale) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/mobilephone/without/inner/exist";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("telephone", telephone);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (Boolean)((Map)responseEntity.getBody()).get("isRegister");
        }
        return false;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userRegisterByMobileOrEmail(String telephone, String verificationCode, String locale, String clientAgent) {
        String password;
        String userId;
        String cellphonePrefix;
        String phoneNumSuffix;
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/register";
        int PASSWORD_MAX_LENGTH = 16;
        String emailHash = "";
        if (Objects.equals(locale.trim(), Locale.SIMPLIFIED_CHINESE.toString())) {
            phoneNumSuffix = telephone.substring(7, 11);
            cellphonePrefix = "+86";
            userId = UUIDUtil.getUuid().substring(0, 2) + phoneNumSuffix;
            password = RandomPasswordUtil.getRandomPwd((int)16);
        } else if (Objects.equals(locale.trim(), Locale.TRADITIONAL_CHINESE.toString())) {
            phoneNumSuffix = telephone.substring(6, 10);
            cellphonePrefix = "+886";
            userId = "user" + telephone;
            password = "Digiwin666";
        } else {
            phoneNumSuffix = telephone;
            cellphonePrefix = "";
            userId = "user" + telephone;
            password = "Digiwin666";
        }
        String passwordHash = SecureAESUtil.aesEncryptInIamRegister((String)password);
        String telephoneHash = SecureAESUtil.aesEncryptInIamRegister((String)telephone);
        emailHash = SecureAESUtil.aesEncryptInIamRegister((String)emailHash);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("Id", userId);
        params.put("name", phoneNumSuffix + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7528\u6237"));
        params.put("emailHash", emailHash);
        params.put("telephoneHash", telephoneHash);
        params.put("cellphonePrefix", cellphonePrefix);
        params.put("verificationCode", verificationCode);
        params.put("passwordHash", passwordHash);
        params.put("agreeAgreement", true);
        params.put("verificationCodeType", 1);
        params.put("inviteSid", "");
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setClientAgent(clientAgent);
        ResponseEntity responseEntity = this.httpService.doPost(url, athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            String errorMessage = this.localeService.getLanguageValue(locale, "\u6ce8\u518c\u5931\u8d25:") + (responseEntity.getBody() != null ? this.localeService.getLanguageValue(locale, ((DigiwhaleLoginResponse)responseEntity.getBody()).getErrorMessage()) : this.localeService.getLanguageValue(locale, "IAM\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            return this.buildError(responseEntity, errorMessage);
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userLoginByVerificationCode(String username, String password, String locale, String iamDeviceId, String clientAgent) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login";
        AthenaBasicHttpRequestHead header = new AthenaBasicHttpRequestHead();
        header.setLocale(locale);
        header.setClientAgent(clientAgent);
        header.setIamDeviceId(iamDeviceId);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("userId", username);
        params.put("verificationCode", password);
        params.put("identityType", "verificationCode");
        ResponseEntity responseEntity = this.httpService.doPost(url, header, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            return this.buildError(responseEntity, ((DigiwhaleLoginResponse)responseEntity.getBody()).getMessage());
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userLoginByEncodePassword(String publicKey, String username, String password, String locale, String tenantId, String clientAgent, HttpServletRequest request, String iamDeviceId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login";
        return this.handleLoginAndpublicKey(publicKey, username, password, locale, tenantId, clientAgent, url, request, iamDeviceId);
    }

    public ResponseEntity<DigiwhaleLoginResponse> firmAccountLogin(String publicKey, String username, String password, String locale, String tenantId, String clientAgent, HttpServletRequest request, String iamDeviceId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/internal/login";
        return this.handleLoginAndpublicKey(publicKey, username, password, locale, tenantId, clientAgent, url, request, iamDeviceId);
    }

    @NotNull
    private ResponseEntity handleLoginAndpublicKey(String publicKey, String username, String password, String locale, String tenantId, String clientEncryptPublicKey, String url, HttpServletRequest request, String iamDeviceId) {
        AthenaBasicHttpRequestHead header = new AthenaBasicHttpRequestHead();
        header.setClientAgent(clientEncryptPublicKey);
        header.setLocale(locale);
        header.setIamDeviceId(iamDeviceId);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("identityType", "token");
        if (!ObjectUtils.isEmpty((Object)request)) {
            if (StringUtils.hasText((String)request.getParameter("userToken"))) {
                header.setUserToken(request.getParameter("userToken"));
            }
            if (StringUtils.hasText((String)request.getParameter("code")) && StringUtils.hasText((String)request.getParameter("value"))) {
                params.put("code", Long.valueOf(request.getParameter("code")));
                params.put("value", String.valueOf(request.getParameter("value")));
            }
            if (StringUtils.hasText((String)request.getParameter("identityType")) && StringUtils.hasText((String)request.getParameter("verificationCode"))) {
                params.put("identityType", String.valueOf(request.getParameter("identityType")));
                params.put("verificationCode", String.valueOf(request.getParameter("verificationCode")));
                if (LOGIN_TYPE_FIRM_ACCOUNT.equals(request.getParameter("loginType"))) {
                    username = tenantId + "$" + username;
                }
            }
        }
        params.put("userId", username);
        params.put("passwordHash", password);
        params.put("tenantId", tenantId);
        params.put("clientEncryptPublicKey", publicKey);
        ResponseEntity responseEntity = this.httpService.doPost(url, header, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            return this.buildError(responseEntity, ((DigiwhaleLoginResponse)Objects.requireNonNull(responseEntity.getBody())).getMessage());
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userLoginByAD(String username, String clientEncryptPublicKey, String password, String locale, String tenantId, String clientAgent, HttpServletRequest request, String iamDeviceId) {
        ResponseEntity responseEntity;
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login";
        AthenaBasicHttpRequestHead header = new AthenaBasicHttpRequestHead();
        header.setClientAgent(clientAgent);
        header.setLocale(locale);
        header.setIamDeviceId(iamDeviceId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", username);
        params.put("passwordHash", password);
        params.put("identityType", "service");
        params.put("tenantId", tenantId);
        params.put("clientEncryptPublicKey", clientEncryptPublicKey);
        params.put("serviceName", "digiwin");
        if (!ObjectUtils.isEmpty((Object)request)) {
            if (StringUtils.hasText((String)request.getParameter("code")) && StringUtils.hasText((String)request.getParameter("value"))) {
                params.put("code", Long.valueOf(request.getParameter("code")));
                params.put("value", String.valueOf(request.getParameter("value")));
            }
            if (StringUtils.hasText((String)request.getParameter("identityType")) && StringUtils.hasText((String)request.getParameter("verificationCode"))) {
                params.put("identityType", String.valueOf(request.getParameter("identityType")));
                params.put("verificationCode", String.valueOf(request.getParameter("verificationCode")));
            }
        }
        if (!(responseEntity = this.httpService.doPost(url, header, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class)).getStatusCode().is2xxSuccessful()) {
            return this.buildError(responseEntity, ((DigiwhaleLoginResponse)responseEntity.getBody()).getMessage());
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userLoginGetProxyUsers(String username, String clientEncryptPublicKey, String password, String locale, String agentAuthorizationCode, String clientAgent) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login/proxy/users";
        AthenaBasicHttpRequestHead header = new AthenaBasicHttpRequestHead();
        header.setClientAgent(clientAgent);
        header.setLocale(locale);
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("agentAuthorizationCode", agentAuthorizationCode);
        params.put("clientEncryptPublicKey", clientEncryptPublicKey);
        params.put("passwordHash", password);
        params.put("identityType", "agent");
        params.put("userId", username);
        ResponseEntity responseEntity = this.httpService.doPost(url, header, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            return this.buildError(responseEntity, ((DigiwhaleLoginResponse)responseEntity.getBody()).getMessage());
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userLoginByProxy(String username, String agentToken, String locale, String clientAgent, String iamDeviceId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login/proxy";
        AthenaBasicHttpRequestHead header = new AthenaBasicHttpRequestHead();
        header.setClientAgent(clientAgent);
        header.setIamDeviceId(iamDeviceId);
        header.setLocale(locale);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("agentToken", agentToken);
        params.put("userId", username);
        ResponseEntity responseEntity = this.httpService.doPost(url, header, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            return this.buildError(responseEntity, ((DigiwhaleLoginResponse)responseEntity.getBody()).getMessage());
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> userLoginByCard(String username, String clientEncryptPublicKey, String locale, String tenantId, String clientAgent, String loginType, String iamDeviceId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login";
        AthenaBasicHttpRequestHead header = new AthenaBasicHttpRequestHead();
        header.setClientAgent(clientAgent);
        header.setLocale(locale);
        header.setIamDeviceId(iamDeviceId);
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("secretKey", username);
        params.put("identityType", "cardKey");
        params.put("tenantId", tenantId);
        params.put("clientEncryptPublicKey", clientEncryptPublicKey);
        params.put("serviceName", loginType);
        ResponseEntity responseEntity = this.httpService.doPost(url, header, JsonUtil.javaObjectToJsonString(params), DigiwhaleLoginResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            return this.buildError(responseEntity, ((DigiwhaleLoginResponse)responseEntity.getBody()).getMessage());
        }
        this.buildResponse((DigiwhaleLoginResponse)responseEntity.getBody());
        return responseEntity;
    }

    public String doGetPublicKey() {
        2 responseType;
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/publickey";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(), new HashMap(), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (String)((Map)responseEntity.getBody()).get("publicKey");
        }
        return "";
    }

    public String doGetAesKey(String clientEncryptPublicKey) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/aeskey";
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("clientEncryptPublicKey", clientEncryptPublicKey);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (String)((Map)responseEntity.getBody()).get("encryptAesKey");
        }
        return "";
    }

    private DigiwhaleLoginResponse buildResponse(DigiwhaleLoginResponse digiwhaleLoginResponse) {
        IamAuth iamAuth = new IamAuth();
        BeanUtils.copyProperties((Object)digiwhaleLoginResponse, (Object)iamAuth);
        digiwhaleLoginResponse.setIamAuth(iamAuth);
        digiwhaleLoginResponse.setAccessToken(digiwhaleLoginResponse.getToken());
        return digiwhaleLoginResponse;
    }

    private ResponseEntity buildError(ResponseEntity<DigiwhaleLoginResponse> responseEntity, String errorMessage) {
        ((DigiwhaleLoginResponse)responseEntity.getBody()).setError(HttpStatus.INTERNAL_SERVER_ERROR.value() + "");
        ((DigiwhaleLoginResponse)responseEntity.getBody()).setErrorDescription(errorMessage);
        return responseEntity;
    }

    public String getAuthorizeCode(String userToken, String appId, String callbackUrl) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/oauth2/authorize";
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("appId", appId);
        params.put("callbackUrl", callbackUrl);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(params), Map.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            Map map = (Map)((Map)responseEntity.getBody()).get("data");
            return String.valueOf(map.get("code"));
        }
        return "";
    }

    public PasswordChange checkUserPasswordChange(String locale, String userToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/password/change/check";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(locale, userToken), Collections.emptyMap(), PasswordChange.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (PasswordChange)responseEntity.getBody();
        }
        return new PasswordChange(Boolean.valueOf(false));
    }

    public Boolean updatePassword(String iamUserToken, Map<String, Object> parameters) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/update/password";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(parameters), Map.class);
        System.out.println("1: " + JsonUtil.javaObjectToJsonString((Object)responseEntity));
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return true;
        }
        return false;
    }

    public Boolean renewalPassword(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/password/renewal";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), Collections.emptyMap(), Map.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return true;
        }
        return false;
    }

    public Boolean isSuperAdmin(String userToken, String userId) {
        DigiwinIamUserRoleInfo digiwinIamUserRoleInfo = this.userRole(userToken, userId);
        if (null == digiwinIamUserRoleInfo) {
            return Boolean.FALSE;
        }
        List roles = digiwinIamUserRoleInfo.getRoles();
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return Boolean.FALSE;
        }
        return roles.stream().anyMatch(role -> "superadmin".equalsIgnoreCase(role.getId()));
    }

    public DigiwinIamUserRoleInfo userRole(String userToken, String userId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/role";
        HashMap<String, String> bodyPayLoad = new HashMap<String, String>(1);
        bodyPayLoad.put("id", userId);
        3 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(bodyPayLoad), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (DigiwinIamUserRoleInfo)responseEntity.getBody();
        }
        return null;
    }

    public DigiwinIamUserAuthInfo getUserPermissionFunctional(String userToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/permission/user/functional";
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(params), DigiwinIamUserAuthInfo.class);
        return responseEntity.getStatusCode().is2xxSuccessful() ? (DigiwinIamUserAuthInfo)responseEntity.getBody() : null;
    }

    public JSONObject deleteBundle(String userId, String userToken, String unionId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/mapping/delete";
        JSONObject param = new JSONObject();
        param.put("userId", (Object)userId);
        param.put("identityId", (Object)"Athena");
        param.put("verifyUserId", (Object)unionId);
        param.put("account", (Object)"line");
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), param.toJSONString(), JSONObject.class);
        return responseEntity.getStatusCode().is2xxSuccessful() ? (JSONObject)responseEntity.getBody() : null;
    }

    public JSONObject importThirdplatform(String comeFrom, String unionId, String iamId, String userToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/integrate/import/thirdplatform";
        JSONObject param = new JSONObject();
        param.put("tenantId", (Object)tenantId);
        param.put("comeFrom", (Object)comeFrom);
        param.put("enterprise", (Object)false);
        param.put("action", (Object)1);
        JSONObject users = new JSONObject().fluentPut("unionId", (Object)unionId).fluentPut("id", (Object)iamId);
        param.put("users", Collections.singletonList(users));
        JSONObject auth = new JSONObject().fluentPut("appId", (Object)"Athena");
        param.put("auth", (Object)auth);
        param.put("remark", (Object)"mock");
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), param.toJSONString(), JSONObject.class);
        return responseEntity.getStatusCode().is2xxSuccessful() ? (JSONObject)responseEntity.getBody() : null;
    }

    public DigiwhaleLoginResponse identityOauthTokenGrantAccess(ThirdPartyLoginFreeQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/oauth/token/grant/access";
        try {
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString((Object)queryDTO), DigiwhaleLoginResponse.class);
            return (DigiwhaleLoginResponse)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("identityOauthTokenGrantAccess \u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public String identityTokenTempAccess(String tempToken, String tenantId, String userId, String appId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/token/temp/access";
        try {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("tempToken", tempToken);
            map.put("tenantId", tenantId);
            map.put("userId", userId);
            map.put("appId", appId);
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(map), Object.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject jsonObject = (JSONObject)JsonUtil.objectToJavaObject((Object)responseEntity.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                return jsonObject.getJSONObject("data").getString("token");
            }
        }
        catch (Exception e) {
            logger.error("identityTokenTempAccess \u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return null;
    }

    public DigiwhaleLoginResponse identityOauthTokenAccess(String code, String tenantId, String type, String appId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/oauth/token/access";
        try {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("code", code);
            map.put("tenantId", tenantId);
            map.put("oauthType", type);
            map.put("appId", appId);
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(map), DigiwhaleLoginResponse.class);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return (DigiwhaleLoginResponse)responseEntity.getBody();
            }
        }
        catch (Exception e) {
            logger.error("identityTokenTempAccess \u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return null;
    }

    public List<String> queryUserAppCodes(String iamUserToken) {
        try {
            List body;
            String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/tenant/application";
            ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), Collections.emptyMap(), List.class);
            List list = body = responseEntity.getStatusCode().is2xxSuccessful() ? (List)responseEntity.getBody() : null;
            if (body == null) {
                return null;
            }
            ArrayList<String> appCodes = new ArrayList<String>();
            body.forEach(apps -> {
                JSONObject apps_json;
                if (apps != null && (apps_json = (JSONObject)JsonUtil.objectToJavaObject((Object)apps, JSONObject.class)).get((Object)"id") != null && apps_json.get((Object)"expired") != null && "false".equals(apps_json.getString("expired"))) {
                    appCodes.add(apps_json.getString("id"));
                }
            });
            return appCodes;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void userMetadataUserLanguage(String userToken, String userSid, String locale) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/usermetadata/user/language";
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("catalogId", "basic");
        map.put("key", "dapAcceptLanguage");
        map.put("tenantSid", 0);
        map.put("userSid", userSid);
        map.put("value", locale);
        this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(map), Object.class);
    }

    public ResponseEntity<Object> getUserMetadataUserLanguage(String userToken, String userSid, String userID) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/usermetadata/user/get";
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("catalogId", "basic");
        map.put("key", "dapAcceptLanguage");
        map.put("tenantSid", 0);
        map.put("userSid", userSid);
        map.put("userID", userID);
        ResponseEntity ResponseEntity2 = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken), JsonUtil.javaObjectToJsonString(map), Object.class);
        return ResponseEntity2;
    }

    public Boolean associationRoleAddUsers(String iamUserToken, String roleId, List<String> userIds) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/association/role/addusers";
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("roleId", roleId);
            map.put("userIds", userIds);
            5 responseType = new /* Unavailable Anonymous Inner Class!! */;
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(map), (ParameterizedTypeReference)responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("associationRoleAddusers \u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return false;
    }

    public DigiwinIamUserAddJoinTenant userAddJoinTenant(String iamUserToken, String tenantId, String tenantSid, String appId, String tenantVisible) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/add/join/tenant";
        HashMap<String, Object> bodyPayload = new HashMap<String, Object>(1);
        if (StringUtils.hasLength((String)tenantSid)) {
            bodyPayload.put("tenantSid", NumberUtils.parseNumber((String)tenantSid, Long.class));
        }
        if (StringUtils.hasLength((String)tenantId)) {
            bodyPayload.put("tenantId", tenantId);
        }
        if (StringUtils.hasLength((String)appId)) {
            bodyPayload.put("appId", appId);
        }
        if (StringUtils.hasLength((String)tenantVisible)) {
            bodyPayload.put("tenantVisible", tenantVisible);
        }
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayload), DigiwinIamUserAddJoinTenant.class);
        return (DigiwinIamUserAddJoinTenant)responseEntity.getBody();
    }

    public Boolean checkUserInTenant(String user, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/tenant/check/userintenant";
        HashMap<String, String> bodyPayload = new HashMap<String, String>(1);
        bodyPayload.put("user", user);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayload), String.class);
        return responseEntity.getStatusCode().is2xxSuccessful() && Boolean.parseBoolean((String)responseEntity.getBody());
    }

    public DigiwinIamAuthoredUser authCodeSubstitutionAccessToken(String authCode, String sourceAppId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/sso/accesstoken";
        HashMap<String, String> bodyPayload = new HashMap<String, String>(2);
        bodyPayload.put("authCode", authCode);
        bodyPayload.put("sourceAppId", sourceAppId);
        6 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(bodyPayload), (ParameterizedTypeReference)responseType);
        return responseEntity.getStatusCode().is2xxSuccessful() ? (DigiwinIamAuthoredUser)((DigiwinIamResult)Objects.requireNonNull(responseEntity.getBody())).getData() : null;
    }

    public String getAuthCode(String iamUserToken, String sourceAppId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/sso/auth/code";
        HashMap<String, String> bodyPayload = new HashMap<String, String>(1);
        bodyPayload.put("targetAppId", sourceAppId);
        7 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayload), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            Map data = (Map)((DigiwinIamResult)responseEntity.getBody()).getData();
            return String.valueOf(data.get("authCode"));
        }
        return null;
    }

    public JSONObject loginFailure(String userId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/login/failure";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("userId", userId);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setProxyToken(this.sysEnvConfig.getAppToken()), JsonUtil.javaObjectToJsonString(body), JSONObject.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            JSONObject data = ((JSONObject)responseEntity.getBody()).getJSONObject("data");
            return data;
        }
        return new JSONObject();
    }

    public JSONObject getImage(String userId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/captcha/image";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("userId", userId);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setProxyToken(this.sysEnvConfig.getAppToken()), JsonUtil.javaObjectToJsonString(body), JSONObject.class);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            JSONObject response = (JSONObject)responseEntity.getBody();
            JSONObject data = response.getJSONObject("data");
            return data;
        }
        return new JSONObject();
    }

    public String getIamDeviceId(String deviceId, String deviceType) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/device/id";
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = new AthenaBasicHttpRequestHead();
        athenaBasicHttpRequestHead.setDeviceId(deviceId);
        athenaBasicHttpRequestHead.setDeviceType(deviceType);
        athenaBasicHttpRequestHead.setSourceFrom("app");
        8 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, athenaBasicHttpRequestHead, (Map)CollectionUtils.newHashMap((int)2), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return String.valueOf(((DigiwinIamResult)responseEntity.getBody()).getData());
        }
        return null;
    }

    public JSONObject getUserInfo(String iamUserToken, String userId) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user";
        9 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> userInfo = new HashMap<String, String>();
        userInfo.put("id", userId);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(userInfo), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (JSONObject)responseEntity.getBody();
        }
        return null;
    }

    public DigiwinIamResult deleteUserMapping(String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/mapping/delete";
        10 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (DigiwinIamResult)responseEntity.getBody();
        }
        return null;
    }

    public DigiwinIamResult getUserInfoByEmail(String iamUserToken, Map<String, String> params) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/email";
        11 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (DigiwinIamResult)responseEntity.getBody();
        }
        return null;
    }

    public DigiwinIamResult userAddJoinTenantCustom(String iamUserToken, Map<String, String> params) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/add/join/tenant/custom";
        12 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (DigiwinIamResult)responseEntity.getBody();
        }
        return null;
    }

    public ResponseEntity<JSONObject> registerIamUser(String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/register/without/captcha";
        13 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        return responseEntity;
    }

    public ResponseEntity<DigiwhaleLoginResponse> loginInternal(String tenantId) {
        return this.loginInternal(tenantId, "integration", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
    }

    private ResponseEntity<DigiwhaleLoginResponse> loginInternal(String tenantId, String userId, String password) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/identity/login/internal";
        14 responseType = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("userId", userId);
        params.put("passwordHash", password);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity;
        }
        return null;
    }

    public JSONObject queryGlobalLine(String iamUserToken, Map<String, String> params) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/mapping/query/global/single";
        15 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (JSONObject)responseEntity.getBody();
        }
        return null;
    }

    public Boolean setUserDefaultTenant(String iamUserToken, String tenantId, String tenantSid) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/user/setting/default/tenant";
        HashMap<String, Object> bodyPayload = new HashMap<String, Object>(1);
        if (StringUtils.hasLength((String)tenantSid)) {
            bodyPayload.put("sid", NumberUtils.parseNumber((String)tenantSid, Long.class));
        }
        if (StringUtils.hasLength((String)tenantId)) {
            bodyPayload.put("id", tenantId);
        }
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayload), String.class);
        return responseEntity.getStatusCode().is2xxSuccessful();
    }

    public Boolean setUserDefaultAcceptLanguage(String iamUserToken, Long tenantSid, Long userSid, String locale) {
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/usermetadata/user/language";
        HashMap<String, Object> bodyPayload = new HashMap<String, Object>(1);
        if (null != tenantSid) {
            bodyPayload.put("tenantSid", tenantSid);
        } else {
            bodyPayload.put("tenantId", 0L);
        }
        bodyPayload.put("catalogId", "basic");
        bodyPayload.put("key", "dapAcceptLanguage");
        bodyPayload.put("userSid", userSid);
        bodyPayload.put("value", locale);
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(bodyPayload), String.class);
        return responseEntity.getStatusCode().is2xxSuccessful();
    }

    public DigiwinIamTenant currentTenant(String iamUserToken) {
        16 responseType;
        String url = AppContext.getApiUrlSetting().getIamUrl() + "/api/iam/v2" + "/tenant/current/simple";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap(), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (DigiwinIamTenant)((DigiwinIamResult)responseEntity.getBody()).getData();
        }
        return null;
    }
}

