/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.im.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;
import com.digiwin.mobile.mobileuibot.proxy.im.service.DigiwinImProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.service.impl.DigiwinImProxyServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DigiwinImProxyServiceImpl
implements DigiwinImProxyService {
    @Autowired
    private HttpService httpService;

    public IMUser userLoginAndCreate(String iamUserToken, String tenantId) {
        try {
            String url = AppContext.getApiUrlSetting().getImUrl() + "/user/loginAndCreate";
            1 responseType = new /* Unavailable Anonymous Inner Class!! */;
            ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), new HashMap(), (ParameterizedTypeReference)responseType);
            HttpStatus statusCode = responseEntity.getStatusCode();
            return statusCode.is2xxSuccessful() && Optional.ofNullable(responseEntity).map(HttpEntity::getBody).map(DigiwinAthenaApiResponse::getStatus).orElse(-1).intValue() == HttpStatus.OK.value() ? (IMUser)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : IMUser.createEmpty();
        }
        catch (Exception e) {
            return new IMUser();
        }
    }

    public IMUser userGetAndCreate(String iamUserToken, String tenantId, String eocId) {
        String url = AppContext.getApiUrlSetting().getImUrl() + "/user/getAndCreate";
        HashMap<String, String> bodyPayLoad = new HashMap<String, String>(4);
        if (StringUtils.hasLength((String)eocId)) {
            bodyPayLoad.put("eocId", eocId);
        }
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(bodyPayLoad), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && Optional.ofNullable(responseEntity).map(HttpEntity::getBody).map(DigiwinAthenaApiResponse::getStatus).orElse(-1).intValue() == HttpStatus.OK.value() ? (IMUser)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : IMUser.createEmpty();
    }

    public DigiwinAthenaApiResponse<String> teamCreate(String iamUserToken, IMTeam imTeam, String tenantId) {
        String url = AppContext.getApiUrlSetting().getImUrl() + "/team/create";
        3 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), JsonUtil.javaObjectToJsonString((Object)imTeam), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAthenaApiResponse)responseEntity.getBody() : null;
    }

    public List<TeamMember> getTeamMembers(String iamUserToken, String teamId, String tenantId) {
        4 responseType;
        String url = AppContext.getApiUrlSetting().getImUrl() + "/team/getTeamMembers/" + teamId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), new HashMap(1), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && Optional.ofNullable(responseEntity).map(HttpEntity::getBody).map(DigiwinAthenaApiResponse::getStatus).orElse(-1).intValue() == HttpStatus.OK.value() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public DigiwinAthenaApiResponse<String> teamAddMembers(String iamUserToken, String teamId, List<String> memberIds, String bizId, Integer type, String tenantId) {
        HashMap<String, Object> bodyPayLoad = new HashMap<String, Object>(4);
        bodyPayLoad.put("tId", teamId);
        bodyPayLoad.put("type", type);
        bodyPayLoad.put("memberIds", memberIds);
        bodyPayLoad.put("bizId", bizId);
        String url = AppContext.getApiUrlSetting().getImUrl() + "/team/addMembers";
        5 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(bodyPayLoad), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (DigiwinAthenaApiResponse)responseEntity.getBody() : null;
    }

    public List<TeamMember> getAllMembers(String iamUserToken, String tenantId) {
        6 responseType;
        String url = AppContext.getApiUrlSetting().getImUrl() + "/user/getUsers";
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), new HashMap(1), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() && Optional.ofNullable(responseEntity).map(HttpEntity::getBody).map(DigiwinAthenaApiResponse::getStatus).orElse(-1).intValue() == HttpStatus.OK.value() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public String getAccIdByEocId(String eocId, String iamUserToken) {
        String accId = "";
        String imUrl = AppContext.getApiUrlSetting().getImUrl() + "/user/getUserInfo/" + eocId;
        ResponseEntity imResponseEntity = this.httpService.doGet(imUrl, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap(), Map.class);
        Map imResponseMap = (Map)imResponseEntity.getBody();
        if (imResponseMap.get("response") != null) {
            Map imInfo = (Map)imResponseMap.get("response");
            accId = (String)imInfo.get("accid");
        }
        return accId;
    }
}

