/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgileDataChartFieldDisplayFormat
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AgileDataChartFieldDisplayFormat.class);
    public static final Integer DEFAULT_DECIMAL = 2;
    public static final String FORMAT_PERCENT = "percent";
    public static final String FORMAT_THOUSAND = "thousand";
    private String percent;
    private Integer decimal;
    private UiBotTableDecimalRule decimalRule;
    private UiBotTableUnit unit;

    public String getFormattedString(Double d) {
        double newValue;
        if (null == d) {
            log.debug("value is null, set to ZERO...");
            newValue = 0.0;
        } else {
            newValue = d;
        }
        String percent = Optional.ofNullable(this.percent).map(String::toLowerCase).map(String::trim).orElse("");
        double epsilon = 1.0E-9;
        double absNewValue = Math.abs(newValue);
        if (absNewValue < epsilon) {
            newValue = 0.0;
        }
        if (FORMAT_PERCENT.equals(percent)) {
            if (null == this.decimal) {
                return String.format("%." + DEFAULT_DECIMAL + "f%%", newValue * 100.0);
            }
            return String.format("%." + this.decimal + "f%%", newValue * 100.0);
        }
        if (FORMAT_THOUSAND.equals(percent)) {
            if (null == this.decimal) {
                return String.format("%,." + DEFAULT_DECIMAL + "f", newValue);
            }
            return String.format("%,." + this.decimal + "f", newValue);
        }
        if (null == this.decimal) {
            return String.format("%." + DEFAULT_DECIMAL + "f", newValue);
        }
        return String.format("%." + this.decimal + "f", newValue);
    }

    public String getPercent() {
        return this.percent;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public UiBotTableDecimalRule getDecimalRule() {
        return this.decimalRule;
    }

    public UiBotTableUnit getUnit() {
        return this.unit;
    }

    public AgileDataChartFieldDisplayFormat setPercent(String percent) {
        this.percent = percent;
        return this;
    }

    public AgileDataChartFieldDisplayFormat setDecimal(Integer decimal) {
        this.decimal = decimal;
        return this;
    }

    public AgileDataChartFieldDisplayFormat setDecimalRule(UiBotTableDecimalRule decimalRule) {
        this.decimalRule = decimalRule;
        return this;
    }

    public AgileDataChartFieldDisplayFormat setUnit(UiBotTableUnit unit) {
        this.unit = unit;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataChartFieldDisplayFormat)) {
            return false;
        }
        AgileDataChartFieldDisplayFormat other = (AgileDataChartFieldDisplayFormat)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$decimal = this.getDecimal();
        Integer other$decimal = other.getDecimal();
        if (this$decimal == null ? other$decimal != null : !((Object)this$decimal).equals(other$decimal)) {
            return false;
        }
        String this$percent = this.getPercent();
        String other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !this$percent.equals(other$percent)) {
            return false;
        }
        UiBotTableDecimalRule this$decimalRule = this.getDecimalRule();
        UiBotTableDecimalRule other$decimalRule = other.getDecimalRule();
        if (this$decimalRule == null ? other$decimalRule != null : !this$decimalRule.equals(other$decimalRule)) {
            return false;
        }
        UiBotTableUnit this$unit = this.getUnit();
        UiBotTableUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataChartFieldDisplayFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $decimal = this.getDecimal();
        result = result * 59 + ($decimal == null ? 43 : ((Object)$decimal).hashCode());
        String $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : $percent.hashCode());
        UiBotTableDecimalRule $decimalRule = this.getDecimalRule();
        result = result * 59 + ($decimalRule == null ? 43 : $decimalRule.hashCode());
        UiBotTableUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataChartFieldDisplayFormat(percent=" + this.getPercent() + ", decimal=" + this.getDecimal() + ", decimalRule=" + this.getDecimalRule() + ", unit=" + this.getUnit() + ")";
    }
}

