/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRuleAnalyzer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="uiBotMaxLengthRuleAnalyzer")
public class UiBotMaxLengthRuleAnalyzer
implements UiBotRuleAnalyzer<Integer> {
    private static final Integer MAX_LENGTH = 999999999;
    private static final Map<String, Integer> DEFAULT_COLUMN_TO_ANALYZE = new HashMap();

    public String getRuleKey() {
        return "maxLength";
    }

    public Integer analyzeByDefault(UiBotRule rule) {
        if (DEFAULT_COLUMN_TO_ANALYZE.containsKey(rule.getSchema())) {
            return (Integer)DEFAULT_COLUMN_TO_ANALYZE.get(rule.getSchema());
        }
        return MAX_LENGTH;
    }

    public Integer analyze(UiBotRule rule) {
        Assert.notNull((Object)rule, (String)"rule cannot be null.");
        if (!rule.getKey().equalsIgnoreCase(this.getRuleKey())) {
            return MAX_LENGTH;
        }
        if (rule.getParameter().contains("(") || rule.getParameter().contains(")")) {
            return MAX_LENGTH;
        }
        return Integer.parseInt(rule.getParameter());
    }

    static {
        DEFAULT_COLUMN_TO_ANALYZE.put("work_hours", 6);
        DEFAULT_COLUMN_TO_ANALYZE.put("complete_rate", 3);
    }
}

