/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageFieldMetaData;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredField;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.ScoredFieldsSummary;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivityStates;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DesignerDslLayoutService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryInfoSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskDataSourceAnalysisService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskEngineActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskSubmitActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractPageDefineAnalyzer<T extends PcUiBotPageDefine> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPageDefineAnalyzer.class);
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Autowired
    protected TaskDataSourceAnalysisService taskDataSourceAnalysisService;
    @Autowired
    private TaskSubmitActionCreateService taskSubmitActionCreateService;
    @Autowired
    private TaskEngineActionCreateService taskEngineActionCreateService;
    @Autowired
    private DesignerDslLayoutService designerDslLayoutService;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private QueryInfoSetService queryInfoSetService;

    protected T createPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotTmPage tmPage = tmActivity.getPages();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
            return null;
        }
        this.addDefaultConfigInfo(executeContext, tmActivity);
        PcUiBotTmDataState dataState = (PcUiBotTmDataState)tmPage.getDataStates().get(0);
        PcUiBotPageDefine pageDefine = this.createPageDefine(executeContext, tmActivity, tmPage, dataState);
        if (StringUtils.hasLength((String)tmPage.getTitle())) {
            pageDefine.setTitle(tmPage.getTitle());
            pageDefine.setSubTitle(tmActivity.getActivityNameByLocale());
        } else {
            pageDefine.setTitle(tmActivity.getActivityNameByLocale());
            pageDefine.setSubTitle(tmActivity.getActivityNameByLocale());
        }
        return (T)pageDefine;
    }

    protected void appendInternalPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, List<PcUiBotTaskPageDefine> taskPageDefineList) {
        PcUiBotTaskPageDefine shelvedPageDefine;
        if (org.springframework.util.CollectionUtils.isEmpty(taskPageDefineList)) {
            return;
        }
        PcUiBotTaskPageDefine completedTaskPageDefine = null;
        PcUiBotTaskPageDefine waitingTaskPageDefine = null;
        for (PcUiBotTaskPageDefine taskPageDefine : taskPageDefineList) {
            switch (taskPageDefine.getDataStateCode()) {
                case "completed": {
                    completedTaskPageDefine = taskPageDefine;
                    break;
                }
                case "waiting": {
                    waitingTaskPageDefine = taskPageDefine;
                }
            }
        }
        log.warn(executeContext.getTmActivityId() + "\u914d\u7f6e\u6709\u95ee\u9898\uff0c\u6ca1\u6709\u6309\u7167\u6807\u51c6\u914d\u7f6e\uff0c\u5bfc\u81f4\u627e\u4e0d\u5230\u5f85\u5904\u7406\u3001\u5df2\u5b8c\u6210\u7684\u9875\u7b7e");
        if (completedTaskPageDefine == null) {
            completedTaskPageDefine = taskPageDefineList.get(taskPageDefineList.size() - 1);
        }
        if (waitingTaskPageDefine == null) {
            waitingTaskPageDefine = taskPageDefineList.get(0);
        }
        if (completedTaskPageDefine != null && BooleanUtils.isTrue((Boolean)completedTaskPageDefine.getAutoAppendShelvedDataState()) && BooleanUtils.isTrue((Boolean)tmActivity.getPages().getAutoAppendTerminateDataState()) && BooleanUtils.isTrue((Boolean)tmActivity.getPages().getAutoAppendShelvedDataState()) && null != (shelvedPageDefine = this.appendShelvedDataPageDefine(executeContext, completedTaskPageDefine))) {
            taskPageDefineList.add(shelvedPageDefine);
        }
        if (waitingTaskPageDefine != null) {
            PcUiBotTaskPageDefine abnormalDataPageDefine;
            if (executeContext.getTaskType() != null && executeContext.getTaskType() == 89) {
                this.editWaitingTaskPageDefine(executeContext, waitingTaskPageDefine);
                taskPageDefineList.clear();
                taskPageDefineList.add(waitingTaskPageDefine);
            } else if (!org.springframework.util.CollectionUtils.isEmpty((Collection)executeContext.getAbnormalData()) && null != (abnormalDataPageDefine = this.createAbnormalDataPageDefine(executeContext, waitingTaskPageDefine))) {
                taskPageDefineList.add(1, abnormalDataPageDefine);
            }
        }
    }

    protected PcUiBotTaskPageDefine appendShelvedDataPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine taskPageDefine) {
        if (null == taskPageDefine || null == taskPageDefine.getDataSourceSet() || org.springframework.util.CollectionUtils.isEmpty((Collection)taskPageDefine.getDataSourceSet().getDataSourceList())) {
            return null;
        }
        List taskWithBacklogDataList = executeContext.getTaskWithBacklogDataList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)taskWithBacklogDataList)) {
            return null;
        }
        String actionId = null;
        if (taskPageDefine.getDataSourceSet().getDataSourceList().size() > 0) {
            actionId = taskPageDefine.getDataSourceSet().getFirstActionId();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(actionId)) {
            return null;
        }
        ArrayList workItemIdList = new ArrayList();
        for (DigiwinAtmcTaskWithBacklogData taskWithBacklogData : taskWithBacklogDataList) {
            Optional.ofNullable(taskWithBacklogData).map(DigiwinAtmcTaskWithBacklogData::getBacklog).map(backloglist -> backloglist.isEmpty() ? new DigiwinAtmcBacklogData() : (DigiwinAtmcBacklogData)backloglist.get(0)).map(DigiwinAtmcBacklogData::getBacklogId).ifPresent(workItemId -> workItemIdList.add(String.valueOf(workItemId)));
        }
        if (org.springframework.util.CollectionUtils.isEmpty(workItemIdList)) {
            return null;
        }
        Integer retrievedDataSize = 0;
        if (null == retrievedDataSize || 0 >= retrievedDataSize) {
            return null;
        }
        PcUiBotTaskPageDefine pageDefine = (PcUiBotTaskPageDefine)JsonUtil.objectToJavaObject((Object)taskPageDefine, PcUiBotTaskPageDefine.class);
        pageDefine.setExecuteContext((PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)taskPageDefine.getExecuteContext(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        pageDefine.setSubmitActions(Collections.emptyList());
        pageDefine.setShowSubmitActions(Boolean.valueOf(false));
        pageDefine.setRowSizeType("");
        pageDefine.setQueryTitle("\u5df2\u6401\u7f6e");
        PcUiBotDataSourceDTO oldDataSource = (PcUiBotDataSourceDTO)pageDefine.getDataSourceSet().getDataSourceList().get(0);
        PcUiBotDataSourceDTO newDataSource = this.createShelvedDataSource(actionId);
        newDataSource.setAction(oldDataSource.getAction());
        newDataSource.setName(oldDataSource.getName());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)oldDataSource.getDataSourceProcessors())) {
            newDataSource.setDataSourceProcessors(oldDataSource.getDataSourceProcessors());
        } else if (!org.springframework.util.CollectionUtils.isEmpty((Collection)oldDataSource.getUnionItems())) {
            oldDataSource.getUnionItems().stream().map(PcUiBotDataSourceDTO::getDataSourceProcessors).filter(tmDataProcesses -> !org.springframework.util.CollectionUtils.isEmpty((Collection)tmDataProcesses)).findFirst().ifPresent(arg_0 -> ((PcUiBotDataSourceDTO)newDataSource).setDataSourceProcessors(arg_0));
        }
        this.taskDataSourceAnalysisService.addExtendedData(executeContext.getTaskWithBacklogData(), newDataSource);
        pageDefine.getDataSourceSet().setDataSourceList(Collections.singletonList(newDataSource));
        this.addExtraInfoToDataSourceParas(executeContext.getAuthoredUser().getUserId(), (PcUiBotDataSourceDTO)pageDefine.getDataSourceSet().getDataSourceList().get(0), workItemIdList);
        pageDefine.setDataStateCode("shelved");
        this.appendShelvedPageMergeField(pageDefine);
        return pageDefine;
    }

    protected void appendShelvedPageMergeField(PcUiBotTaskPageDefine pageDefine) {
        String dataSourceName = ((PcUiBotDataSourceDTO)pageDefine.getDataSourceSet().getDataSourceList().get(0)).getName();
        JSONObject settings = pageDefine.getSettings();
        if (null == settings || !settings.containsKey((Object)dataSourceName) || null == settings.getJSONObject(dataSourceName) || !settings.getJSONObject(dataSourceName).containsKey((Object)"merge")) {
            return;
        }
        JSONObject merge = settings.getJSONObject(dataSourceName).getJSONObject("merge");
        if (null == merge || !merge.containsKey((Object)"options") || null == merge.getJSONArray("options") || merge.getJSONArray("options").isEmpty()) {
            return;
        }
        JSONArray options = merge.getJSONArray("options");
        JSONObject activityName = new JSONObject();
        activityName.put("schema", (Object)"uibot__initiateActivityName");
        options.add(0, (Object)activityName);
        JSONObject dateTime = new JSONObject();
        dateTime.put("schema", (Object)"uibot__dateTime");
        options.add(0, (Object)dateTime);
        JSONObject userName = new JSONObject();
        userName.put("schema", (Object)"uibot__userName");
        options.add(0, (Object)userName);
        JSONObject operationType = new JSONObject();
        operationType.put("schema", (Object)"uibot__operationType");
        options.add(0, (Object)operationType);
    }

    private void editWaitingTaskPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine waitingTaskPageDefine) {
        List dataSourceDTOList = waitingTaskPageDefine.getDataSourceSet().getDataSourceList();
        PcUiBotDataSourceDTO dataSourceDTO = (PcUiBotDataSourceDTO)dataSourceDTOList.get(0);
        if (dataSourceDTO.getDataSourceProcessors() == null) {
            dataSourceDTO.setDataSourceProcessors(new ArrayList());
        }
        PcUiBotTmDataProcess tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setType("service");
        tmDataProcess.setParas((Object)executeContext.getAbnormalData());
        tmDataProcess.setServiceName("retainAbnormalAndAddColumnService");
        dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        submitAction.setTitle("\u63d0\u4ea4");
        submitAction.setCategory("UIBOT");
        submitAction.setActionId("atmc_data_uniformity_submit");
        submitAction.executeExtendParas(new HashMap(), executeContext);
        submitAction.getExtendParas().put("AbnormalData", executeContext.getAbnormalData());
        submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)executeContext, (DigiwinAtmcTaskWithBacklogData)waitingTaskPageDefine.getExecuteContext().getTaskWithBacklogData()));
        String schema = "";
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)waitingTaskPageDefine.getSubmitActions())) {
            waitingTaskPageDefine.setSubmitActions(new ArrayList());
        } else {
            PcUiBotSubmitType submitTypeOri = ((PcUiBotSubmitAction)waitingTaskPageDefine.getSubmitActions().get(0)).getSubmitType();
            PcUiBotSubmitType submitType = (PcUiBotSubmitType)JsonUtil.objectToJavaObject((Object)submitTypeOri, PcUiBotSubmitType.class);
            submitType.setIsBatch(Boolean.valueOf(false));
            submitType.setSubmitAll(Boolean.valueOf(true));
            submitAction.setSubmitType(submitType);
            waitingTaskPageDefine.getSubmitActions().clear();
            schema = null != submitAction.getSubmitType() ? submitAction.getSubmitType().getSchema() : "";
        }
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setName("atmc_data_uniformity_submit");
        actionServiceId.setHostAcct("athena");
        actionServiceId.setTenant_id(executeContext.getAuthoredUser().getTenantId());
        submitAction.setServiceId(actionServiceId);
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("submitVariableName", schema);
        String processVariableName = "";
        List actionParams = dataSourceDTO.getAction().getActionParams();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)actionParams)) {
            for (PcUiBotActionParameterMapping actionParam : actionParams) {
                if (!"PROCESS_VARIABLE".equals(actionParam.getType())) continue;
                processVariableName = actionParam.getValue();
                break;
            }
        }
        extendParams.put("processVariableName", processVariableName);
        extendParams.put("dataKeys", "");
        submitAction.executeExtendParas(extendParams, executeContext);
        PcUiBotDataSourceDTO checkCompleteAction = new PcUiBotDataSourceDTO();
        checkCompleteAction.setType("DATA_UNIFORMITY_SUBMIT");
        checkCompleteAction.setName(dataSourceDTO.getName());
        checkCompleteAction.setActionId(dataSourceDTO.getActionId());
        submitAction.setCheckCompleteAction(checkCompleteAction);
        ArrayList<PcUiBotSubmitAction> attachActionList = new ArrayList<PcUiBotSubmitAction>();
        DigiwinAtmcTaskWithBacklogData taskWithBacklogData = executeContext.getTaskWithBacklogData();
        if (!Objects.equals(executeContext.getDataFrom(), "PTM")) {
            DigiwinAtmcBacklogData backlogData = (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0);
            PcUiBotSubmitAction attachAction = this.taskSubmitActionCreateService.createTerminateProcessAction(taskWithBacklogData, backlogData);
            attachActionList.add(attachAction);
        } else {
            PcUiBotSubmitAction attachAction = this.taskEngineActionCreateService.createTerminateTaskAction(taskWithBacklogData);
            attachActionList.add(attachAction);
        }
        submitAction.setAttachActions(attachActionList);
        waitingTaskPageDefine.setOperations(new ArrayList());
        waitingTaskPageDefine.getSubmitActions().add(submitAction);
    }

    private PcUiBotTaskPageDefine createAbnormalDataPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine taskPageDefine) {
        if (null == taskPageDefine || null == taskPageDefine.getDataSourceSet() || org.springframework.util.CollectionUtils.isEmpty((Collection)taskPageDefine.getDataSourceSet().getDataSourceList())) {
            return null;
        }
        if (taskPageDefine.getFinished().booleanValue()) {
            return null;
        }
        List taskWithBacklogDataList = executeContext.getTaskWithBacklogDataList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)taskWithBacklogDataList)) {
            return null;
        }
        String actionId = null;
        if (taskPageDefine.getDataSourceSet().getDataSourceList().size() > 0) {
            actionId = taskPageDefine.getDataSourceSet().getFirstActionId();
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(actionId)) {
            return null;
        }
        PcUiBotTaskPageDefine pageDefine = (PcUiBotTaskPageDefine)JsonUtil.objectToJavaObject((Object)taskPageDefine, PcUiBotTaskPageDefine.class);
        PcUiBotDataSourceDTO dataSourceDTO = (PcUiBotDataSourceDTO)taskPageDefine.getDataSourceSet().getDataSourceList().get(0);
        if (dataSourceDTO.getDataSourceProcessors() == null) {
            dataSourceDTO.setDataSourceProcessors(new ArrayList());
        }
        PcUiBotTmDataProcess tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setType("service");
        tmDataProcess.setParas((Object)executeContext.getAbnormalData());
        tmDataProcess.setServiceName("removeAbnormalDataService");
        dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);
        pageDefine.setOperations(null);
        pageDefine.setSubmitActions(null);
        pageDefine.setRowSize(null);
        pageDefine.setType("async");
        pageDefine.setQueryTitle("\u5c01\u5b58\u4e2d");
        dataSourceDTO = (PcUiBotDataSourceDTO)pageDefine.getDataSourceSet().getDataSourceList().get(0);
        if (dataSourceDTO.getDataSourceProcessors() == null) {
            dataSourceDTO.setDataSourceProcessors(new ArrayList());
        }
        tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setType("service");
        tmDataProcess.setParas((Object)executeContext.getAbnormalData());
        tmDataProcess.setServiceName("retainAbnormalDataService");
        dataSourceDTO.getDataSourceProcessors().add(tmDataProcess);
        pageDefine.setDataStateCode("sealing");
        executeContext.setClientAgent("webplatform");
        executeContext.setPattern("business");
        executeContext.setCategory("sealing");
        pageDefine.setVersion("2.0");
        return pageDefine;
    }

    private void addExtraInfoToDataSourceParas(String userId, PcUiBotDataSourceDTO dataSource, List<String> workItemIdList) {
        HashMap<String, List<String>> extendedData;
        if (null != dataSource.getAction()) {
            HashMap<String, List<String>> paras = dataSource.getAction().getParas();
            if (null == paras) {
                paras = new HashMap<String, List<String>>();
                dataSource.getAction().setParas(paras);
            }
            paras.put("allWorkItemId", workItemIdList);
            paras.put("uibot_login_userId", (List<String>)((Object)userId));
        }
        if (null == (extendedData = dataSource.getExtendedData())) {
            extendedData = new HashMap<String, List<String>>();
            dataSource.setExtendedData(extendedData);
        }
        extendedData.put("allWorkItemId", workItemIdList);
        extendedData.put("uibot_login_userId", (List<String>)((Object)userId));
    }

    private PcUiBotDataSourceDTO createShelvedDataSource(String actionId) {
        PcUiBotDataSourceDTO dataSource = new PcUiBotDataSourceDTO();
        dataSource.setType("SHELVED_DATA");
        dataSource.setActionId(actionId);
        dataSource.setOverride(Boolean.valueOf(false));
        return dataSource;
    }

    public List<T> createPageDefines(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        ArrayList<PcUiBotPageDefine> pageDefines = new ArrayList<PcUiBotPageDefine>();
        if (tmActivity.getPages() == null) {
            return pageDefines;
        }
        PcUiBotTmPage tmPage = tmActivity.getPages();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
            return pageDefines;
        }
        this.addDefaultConfigInfo(executeContext, tmActivity);
        for (PcUiBotTmDataState dataState : tmPage.getDataStates()) {
            PcUiBotPageDefine pageDefine = this.createPageDefine(executeContext, tmActivity, tmPage, dataState);
            if (pageDefine != null && Boolean.TRUE.equals(dataState.getEnablePaging())) {
                pageDefine.setUseHasNext(Boolean.valueOf(true));
                PcUiBotPageInfo pageInfo = Optional.ofNullable(pageDefine.getPageInfo()).orElse(new PcUiBotPageInfo());
                if (Objects.isNull(pageInfo.getPageNo())) {
                    pageInfo.setPageNo(Integer.valueOf(1));
                }
                if (Objects.isNull(pageInfo.getPageSize())) {
                    pageInfo.setPageSize(Integer.valueOf(50));
                }
                pageDefine.setPageInfo(pageInfo);
            }
            pageDefines.add(pageDefine);
        }
        if (tmPage.getDataStates().size() == 1 && pageDefines.size() == 1) {
            ((PcUiBotPageDefine)pageDefines.get(0)).setDefaultShow(true);
        }
        this.appendUserOrderConditions(executeContext, pageDefines);
        return pageDefines;
    }

    protected void appendUserOrderConditions(PcUiBotExecuteContext executeContext, List<T> pageDefines) {
        try {
            if (executeContext.getOpenWindow() != null && (executeContext.getOpenWindow() == null || executeContext.getOpenWindow().booleanValue())) {
                return;
            }
            if (org.springframework.util.CollectionUtils.isEmpty(pageDefines) || pageDefines.get(0) == null || ((PcUiBotPageDefine)pageDefines.get(0)).getDataSourceSet() == null) {
                return;
            }
            String schema = ((PcUiBotPageDefine)pageDefines.get(0)).getDataSourceSet().getMainDatasource();
            if (schema == null) {
                return;
            }
            if (StringUtils.isEmpty((Object)executeContext.getTmActivityId())) {
                return;
            }
            String tmProjectId = "";
            tmProjectId = StringUtils.hasText((String)executeContext.getTmProjectId()) ? executeContext.getTmProjectId() : "__uibot__";
            JSONObject userSetting = this.digiwinAudcProxyService.getOrderConditionsByUser(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getPageCode(), tmProjectId, executeContext.getTmActivityId());
            if (userSetting == null || userSetting.isEmpty()) {
                return;
            }
            if (userSetting.containsKey((Object)"order") && !userSetting.containsKey((Object)schema)) {
                JSONObject setting = new JSONObject();
                setting.put(schema, (Object)userSetting);
                userSetting = setting;
            }
            for (PcUiBotPageDefine pageDefine : pageDefines) {
                JSONObject orderSetting;
                if (userSetting != null && !userSetting.isEmpty() && (orderSetting = userSetting.getJSONObject(schema)).containsKey((Object)"order")) {
                    pageDefine.setSortInfo(orderSetting.getJSONObject("order").getJSONArray("options"));
                }
                pageDefine.setUserSetting(userSetting);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected T createPageDefine(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {
        PcUiBotPageDefine pageDefine = this.createNewPageDefine();
        PcUiBotExecuteContext newExecuteContext = this.createNewContext(executeContext);
        pageDefine.setExecuteContext(newExecuteContext);
        newExecuteContext.setDataStateCode(dataState.getCode());
        pageDefine.setDataStateCode(dataState.getCode());
        pageDefine.setShowSubmitActions(tmPage.getShowSubmitActions());
        this.analysisBaseInfo(newExecuteContext, pageDefine, tmActivity, tmPage);
        pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        PcUiBotTmDataFilter tmDataFilter = null;
        if (dataState.getDataFilter() != null) {
            tmDataFilter = dataState.getDataFilter();
        } else if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tmActivity.getDataFilters())) {
            tmDataFilter = tmActivity.getDataFilters().stream().filter(filter -> Objects.equals(filter.getCode(), dataState.getDataFilterCode())).findFirst().orElse(null);
        }
        if (tmDataFilter != null && tmDataFilter.getDefaultFilter() != null) {
            pageDefine.setDefaultShow(tmDataFilter.getDefaultFilter().booleanValue());
            if (BooleanUtils.isTrue((Boolean)tmDataFilter.isApiFilter())) {
                pageDefine.setDataFilter(tmDataFilter);
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Map)tmActivity.getDataSources())) {
            Map dataSources = this.getDataSources(tmDataFilter, tmActivity);
            this.analysisSubmitType(dataState);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
            Map copyDataSources = (Map)JsonUtil.objectToJavaObject((Object)dataSources, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.analysisDataSource(newExecuteContext, pageDefine, tmActivity, dataState, copyDataSources, tmDataFilter);
            this.analysisAllDataSource(newExecuteContext, pageDefine, tmActivity, dataState, tmDataFilter);
            this.postAnalysisDataSource(newExecuteContext, pageDefine, dataState);
            executeContext.setMainDataSourceName((String)Optional.ofNullable(pageDefine.getDataSourceSet()).map(PcUiBotDataSourceSetDTO::getMainDatasource).orElse(null));
            newExecuteContext.setMainDataSourceName((String)Optional.ofNullable(pageDefine.getDataSourceSet()).map(PcUiBotDataSourceSetDTO::getMainDatasource).orElse(null));
        }
        pageDefine.setMasterFromDataSourceName(dataState.getMasterFromDataSourceName());
        this.analysisDataViewQuerys(executeContext, pageDefine, dataState);
        this.analysisDataSourceViewCode(pageDefine, tmActivity, dataState);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getOperations())) {
            this.analysisOperators(newExecuteContext, pageDefine, tmActivity, dataState.getOperations());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getSubmitActions())) {
            this.analysisSubmitActions(newExecuteContext, pageDefine, tmActivity, dataState, dataState.getSubmitActions());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getTaskStates())) {
            this.analysisTaskStates(pageDefine, dataState.getTaskStates());
        }
        if (dataState.getSettings() != null) {
            this.analysisSettings(pageDefine, dataState.getSettings());
        }
        if (tmActivity.getApprove() != null || !org.springframework.util.CollectionUtils.isEmpty((Collection)tmActivity.getApproves())) {
            this.analysisApprove(newExecuteContext, pageDefine, tmActivity, tmPage, dataState);
        }
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions())) {
            pageDefine.setSubmitType(null);
        }
        pageDefine.setExtendedFields(tmPage.getExtendedFields());
        pageDefine.setEnableSelectAll(dataState.getEnableSelectAll());
        pageDefine.setEnableVirtualScrolling(dataState.getEnableVirtualScrolling());
        pageDefine.setEnableBackEndPaging(dataState.getEnableBackEndPaging());
        pageDefine.setEnableBackEndPagingLimit(dataState.getEnableBackEndPagingLimit());
        pageDefine.setEnableFilter(dataState.getEnableFilter());
        pageDefine.setEnablePaging(dataState.getEnablePaging());
        if (PcUiBotPatternUtil.isModelDriven((PcUiBotExecuteContext)executeContext)) {
            executeContext.setIsDesigner(Boolean.valueOf(true));
            newExecuteContext.setIsDesigner(Boolean.valueOf(true));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getPageLayout())) {
            this.analysisLayout(executeContext, newExecuteContext, pageDefine, dataState);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tmPage.getRules())) {
            pageDefine.setRules(tmPage.getRules());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getHooks())) {
            pageDefine.setHooks(dataState.getHooks());
        }
        if (null != dataState.getShowMetadatas()) {
            this.analysisShowMetadatas(pageDefine, dataState.getShowMetadatas());
        }
        pageDefine.setAutoAppendShelvedDataState(dataState.getAutoAppendShelvedDataState());
        this.appendMechnismConfig(tmActivity, pageDefine);
        pageDefine.setShowTitle(dataState.getShowTitle());
        pageDefine.setDefaultTabMobileCode(dataState.getDefaultTabMobileCode());
        pageDefine.setShowSingleHeadFrom(dataState.getShowSingleHeadFrom());
        pageDefine.setPageLayout(dataState.getPageLayout());
        pageDefine.setTipSetting(dataState.getTipSetting());
        boolean notDcp = Objects.isNull(Optional.ofNullable(executeContext.getBpmData()).map(r -> r.get("UIBOT_ACTION_METADATA")).orElse(null));
        pageDefine.setIsDesignerDsl(Boolean.valueOf(tmActivity.getIsDesignerDsl() && notDcp || tmActivity.isbindFormCode()));
        return (T)pageDefine;
    }

    protected void analysisDataViewQuerys(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmDataState dataState) {
    }

    private void postAnalysisDataSource(PcUiBotExecuteContext newExecuteContext, T pageDefine, PcUiBotTmDataState dataState) {
        List dataSourceList;
        Map bpmData = newExecuteContext.getBpmData();
        if (bpmData == null) {
            return;
        }
        Object metadata = bpmData.get("UIBOT_ACTION_METADATA");
        if (metadata == null) {
            return;
        }
        PcUiBotDataSourceSetDTO dataSourceSet = pageDefine.getDataSourceSet();
        if (dataSourceSet != null && !org.springframework.util.CollectionUtils.isEmpty((Collection)(dataSourceList = dataSourceSet.getDataSourceList()))) {
            for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceList) {
                List metadataFields;
                String type = dataSourceDTO.getType();
                if (!"RAWDATA".equals(type) || !org.springframework.util.CollectionUtils.isEmpty((Collection)(metadataFields = dataSourceDTO.getMetadataFields())) || StringUtils.hasLength((String)dataSourceDTO.getActionId())) continue;
                MobileRenderDataUtil.multilingualProcessing((Map)((Map)metadata), (String)AppRequestContext.getContextEntity().getLocale());
                PcUiBotMetadataField sdMetadata = (PcUiBotMetadataField)JsonUtil.objectToJavaObject(metadata, PcUiBotMetadataField.class);
                Object o = bpmData.get("UIBOT_HIDDEN_FIELDS");
                List hiddenFields = null;
                if (o instanceof List) {
                    hiddenFields = (List)o;
                }
                List finalHiddenFields = hiddenFields;
                PcUiBotDefaultTagUtils.addDefaultTag((List)sdMetadata.getSubFields(), metadataField -> {
                    List tagDefinitions;
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)finalHiddenFields) && finalHiddenFields.contains(metadataField.getName())) {
                        metadataField.setTagDefinitions(null);
                        return;
                    }
                    if (!metadataField.isCanEdit() && !org.springframework.util.CollectionUtils.isEmpty((Collection)(tagDefinitions = metadataField.getTagDefinitions()))) {
                        metadataField.getTagDefinitions().add(PcUiBotDefaultTagUtils.createUneditableTagDef());
                    }
                });
                sdMetadata.setName(dataSourceDTO.getName());
                dataSourceDTO.setMetadataFields((List)Lists.newArrayList((Object[])new PcUiBotMetadataField[]{sdMetadata}));
                dataState.setShowMetadatas(null);
            }
        }
    }

    protected void analysisLayout(PcUiBotExecuteContext executeContext, PcUiBotExecuteContext newExecuteContext, T pageDefine, PcUiBotTmDataState dataState) {
        executeContext.setIsDesigner(Boolean.valueOf(true));
        newExecuteContext.setIsDesigner(Boolean.valueOf(true));
        this.queryInfoSetService.analysisLayoutDsl(newExecuteContext, pageDefine, dataState);
    }

    private void appendMechnismConfig(PcUiBotTmActivity tmActivity, PcUiBotPageDefine pageDefine) {
        Map mechnismConfig = tmActivity.getMechnismConfig();
        if (mechnismConfig == null) {
            return;
        }
        pageDefine.setMechnismConfig(mechnismConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Map<String, PcUiBotTmQueryAction> getDataSources(PcUiBotTmDataFilter tmDataFilter, PcUiBotTmActivity tmActivity) {
        HashMap<String, PcUiBotTmQueryAction> dataSources;
        block9: {
            Object dataSourceName;
            block12: {
                block10: {
                    block11: {
                        block8: {
                            dataSources = new HashMap();
                            if (tmActivity.getPages() == null || !StringUtils.hasText((String)tmActivity.getPages().getDataSourceName())) break block8;
                            dataSourceName = tmActivity.getPages().getDataSourceName();
                            if (!tmActivity.getDataSources().containsKey(dataSourceName)) {
                                String message = String.format("\u6570\u636e\u8fc7\u6ee4:\u5b9a\u4e49\u7684\u6570\u636e\u6e90:%s\u4e0d\u5b58\u5728", dataSourceName);
                                throw new ServiceException(message);
                            }
                            dataSources.put((String)dataSourceName, (PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceName));
                            break block9;
                        }
                        if (tmDataFilter == null) break block10;
                        if (!CollectionUtils.isEmpty((Collection)tmDataFilter.getDataSourceNames())) break block11;
                        dataSources = tmActivity.getDataSources();
                        break block9;
                    }
                    dataSourceName = tmDataFilter.getDataSourceNames().iterator();
                    break block12;
                }
                dataSources = tmActivity.getDataSources();
                break block9;
            }
            while (dataSourceName.hasNext()) {
                String dataSourceName2 = (String)dataSourceName.next();
                if (!tmActivity.getDataSources().containsKey(dataSourceName2)) {
                    String message = String.format("\u6570\u636e\u8fc7\u6ee4:%s\u5b9a\u4e49\u7684\u6570\u636e\u6e90:%s\u4e0d\u5b58\u5728", tmDataFilter.getCode(), dataSourceName2);
                    throw new ServiceException(message);
                }
                String viewCode = PcUiBotRuntimes.getContext().get("VIEWCODE", String.class).orElse("");
                if (StringUtils.isEmpty((Object)viewCode)) {
                    dataSources.put(dataSourceName2, (PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceName2));
                    continue;
                }
                PcUiBotTmQueryAction queryAction = (PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceName2);
                if (queryAction.getType().equals("VIEWCODE")) {
                    if (!queryAction.getDataViewQuery().getCode().equals(viewCode)) continue;
                    dataSources.put(dataSourceName2, (PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceName2));
                    continue;
                }
                if (StringUtils.isEmpty((Object)queryAction.getViewCode())) {
                    String message = String.format("\u83b7\u53d6\u6570\u636e\u6e90:%s\u5b9a\u4e49\u7684ESP\u6570\u636e\u6e90:%s\u7ed3\u6784\u4e2d\u7f3a\u5c11viewCode", tmDataFilter.getCode(), dataSourceName2);
                    throw new ServiceException(message);
                }
                if (!queryAction.getViewCode().equals(viewCode)) continue;
                dataSources.put(dataSourceName2, (PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceName2));
            }
        }
        if (tmActivity.getPages().getTaskStates() != null) {
            List dataSourceNames = tmActivity.getPages().getTaskStates().stream().map(PcUiBotTmActivityStates::getDataSourceName).collect(Collectors.toList());
            for (String sourceName : dataSourceNames) {
                if (dataSources.containsKey(sourceName)) continue;
                dataSources.put(sourceName, (PcUiBotTmQueryAction)tmActivity.getDataSources().get(sourceName));
            }
        }
        return dataSources;
    }

    protected abstract T createNewPageDefine();

    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return oldExecuteContext;
    }

    protected void addDefaultConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotAttachmentUtil.addDefaultAttachmentDataSourceProcess((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity);
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity);
    }

    protected void analysisApprove(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {
    }

    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        pageDefine.setTitle(tmPage.getTitle());
        pageDefine.setSubTitle(tmPage.getSubTitle());
        pageDefine.setDescription(tmPage.getDescription());
        pageDefine.setSubDescription(tmPage.getSubDescription());
        pageDefine.setExplanation(tmPage.getExplanation());
    }

    private void analysisSettings(PcUiBotPageDefine pageDefine, JSONObject settings) {
        pageDefine.setSettings(settings);
    }

    private void analysisTaskStates(T pageDefine, List<PcUiBotTmActivityStates> taskStates) {
        pageDefine.setTaskStates(taskStates);
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, T pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
    }

    protected List<PcUiBotOperationDTO> filterActiveOperationsWhenBacklogFinished(List<PcUiBotOperationDTO> operationList) {
        if (org.springframework.util.CollectionUtils.isEmpty(operationList)) {
            return operationList;
        }
        return operationList.stream().filter(operation -> BooleanUtils.isTrue((Boolean)operation.getApplyAlthoughFinished())).collect(Collectors.toList());
    }

    protected abstract void analysisDataSource(PcUiBotExecuteContext var1, T var2, PcUiBotTmActivity var3, PcUiBotTmDataState var4, Map<String, PcUiBotTmQueryAction> var5, PcUiBotTmDataFilter var6);

    protected abstract void analysisAllDataSource(PcUiBotExecuteContext var1, T var2, PcUiBotTmActivity var3, PcUiBotTmDataState var4, PcUiBotTmDataFilter var5);

    protected void convertToUnion(PcUiBotDataSourceSetDTO dataSourceSetDTO) {
        if (dataSourceSetDTO.getDataSourceList() != null && dataSourceSetDTO.getDataSourceList().size() > 1) {
            Map<String, List<PcUiBotDataSourceDTO>> groupDs = dataSourceSetDTO.getDataSourceList().stream().collect(Collectors.groupingBy(PcUiBotDataSourceDTO::getName));
            dataSourceSetDTO.getDataSourceList().clear();
            for (List<PcUiBotDataSourceDTO> dataSourceDTOS : groupDs.values()) {
                if (dataSourceDTOS.size() > 1) {
                    PcUiBotDataSourceDTO allDs = new PcUiBotDataSourceDTO();
                    allDs.setType("MIX_UNION");
                    allDs.setUnionItems(dataSourceDTOS);
                    allDs.setName(dataSourceDTOS.get(0).getName());
                    allDs.setDataKeys(dataSourceDTOS.get(0).getDataKeys());
                    allDs.setActionId(dataSourceDTOS.get(0).getActionId());
                    allDs.setAction(dataSourceDTOS.get(0).getAction());
                    allDs.setMergeQuery(Boolean.valueOf(true));
                    dataSourceSetDTO.getDataSourceList().add(allDs);
                    continue;
                }
                dataSourceSetDTO.getDataSourceList().add(dataSourceDTOS.get(0));
            }
        }
    }

    private void analysisShowMetadatas(T pageDefine, PageFieldMetaData showMetadatas) {
        List newScoreWords;
        String dataSourceName = "";
        if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
            dataSourceName = pageDefine.getDataSourceSet().getFirstDataQuery().getName();
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)(newScoreWords = showMetadatas.getNewScoreWords()))) {
            ArrayList showDataProperties = new ArrayList();
            for (ScoredFieldsSummary scoreWords : newScoreWords) {
                if (org.springframework.util.CollectionUtils.isEmpty((Collection)scoreWords.getFields())) continue;
                if (StringUtils.hasLength((String)dataSourceName) && !scoreWords.getTarget().contains(dataSourceName)) {
                    if ("M".equals(scoreWords.getType())) {
                        scoreWords.setTarget(dataSourceName);
                    } else if ("D".equals(scoreWords.getType())) {
                        String target = scoreWords.getTarget().split("\\.")[scoreWords.getTarget().split("\\.").length - 1];
                        scoreWords.setTarget(dataSourceName + "." + target);
                    } else if ("SD".equals(scoreWords.getType())) {
                        String target1 = scoreWords.getTarget().split("\\.")[scoreWords.getTarget().split("\\.").length - 2];
                        String target2 = scoreWords.getTarget().split("\\.")[scoreWords.getTarget().split("\\.").length - 1];
                        scoreWords.setTarget(dataSourceName + "." + target1 + "." + target2);
                    }
                }
                showDataProperties.addAll(scoreWords.getFields().stream().map(ScoredField::getFieldName).collect(Collectors.toList()));
            }
            pageDefine.setShowDataProperties(showDataProperties);
            pageDefine.setShowMetadatas(newScoreWords);
        }
    }

    protected void analysisSubmitType(PcUiBotTmDataState dataState) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dataState.getSubmitActions())) {
            return;
        }
        boolean exists = false;
        PcUiBotSubmitType submitType = new PcUiBotSubmitType();
        submitType.setIsBatch(Boolean.valueOf(false));
        for (PcUiBotTmAction action2 : dataState.getSubmitActions()) {
            if (action2.getSubmitType() == null) continue;
            submitType.setSchema(action2.getSubmitType().getSchema());
            submitType.setSubmitAll(action2.getSubmitType().getSubmitAll());
            if (!Objects.equals(action2.getSubmitType().getIsBatch(), true) && (!Objects.nonNull(dataState.getSubmitType()) || !Objects.equals(dataState.getSubmitType().getIsBatch(), true))) continue;
            submitType.setIsBatch(Boolean.valueOf(true));
            exists = true;
            break;
        }
        if (exists) {
            dataState.setSubmitType(submitType);
            dataState.getSubmitActions().forEach(action -> {
                if (action.getSubmitType() != null) {
                    action.getSubmitType().setIsBatch(submitType.getIsBatch());
                }
            });
        }
    }

    protected void handleDataState(PcUiBotTmActivity tmActivity) {
        PcUiBotTmPage pages = tmActivity.getPages();
        if (pages == null) {
            return;
        }
        ArrayList dataStates = pages.getDataStates();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dataStates)) {
            return;
        }
        dataStates.forEach(dataState -> {
            dataState.setDefaultTabMobileCode(pages.getDefaultTabMobileCode());
            dataState.setShowSingleHeadFrom(pages.getShowSingleHeadFrom());
        });
        boolean existShowTitle = dataStates.stream().anyMatch(r -> BooleanUtils.isTrue((Boolean)r.getShowTitle()));
        dataStates = existShowTitle ? dataStates.stream().filter(r -> BooleanUtils.isTrue((Boolean)r.getShowTitle())).collect(Collectors.toList()) : Lists.newArrayList((Object[])new PcUiBotTmDataState[]{(PcUiBotTmDataState)dataStates.get(0)});
        pages.setDataStates((List)dataStates);
    }

    protected void buildDataStateSubmitAction(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getPages() == null) {
            return;
        }
        if (TaskStringUtil.isBizSmartAdjust((String)tmActivity.getActivityId())) {
            return;
        }
        List dataStates = tmActivity.getPages().getDataStates();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)dataStates)) {
            return;
        }
        dataStates.forEach(dataState -> {
            List submitAction = this.buildSubmitAction(dataState.getPageLayout());
            if (submitAction != null) {
                dataState.setSubmitActions(submitAction);
            }
        });
    }

    protected void buildPageSubmitAction(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getPages() == null) {
            return;
        }
        PcUiBotTmPage page = tmActivity.getPages();
        List layout = page.getLayout();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)layout)) {
            return;
        }
        PcUiBotTmDataState tmDataState = new PcUiBotTmDataState();
        tmDataState.setLayout(layout);
        List submitAction = this.buildSubmitAction(tmDataState.getPageLayout());
        if (submitAction != null) {
            page.setSubmitActions(submitAction);
        }
    }

    public void buildPageSubmitAction(PcUiBotTmDataState dataState) {
        List layout = dataState.getLayout();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)layout)) {
            return;
        }
        List submitAction = this.buildSubmitAction(dataState.getPageLayout());
        if (submitAction != null) {
            dataState.setSubmitActions(submitAction);
        }
    }

    private List<PcUiBotTmAction> buildSubmitAction(List<UiBotPageLayout> pageLayout) {
        if (org.springframework.util.CollectionUtils.isEmpty(pageLayout)) {
            return null;
        }
        ArrayList<PcUiBotTmAction> submitActions = new ArrayList<PcUiBotTmAction>();
        pageLayout.forEach(r -> {
            r.getBody().forEach(body -> {
                Card card;
                List cardButtons;
                if (body.getData() instanceof Button) {
                    this.handleButton(body.getSchema(), (Button)body.getData(), submitActions);
                } else if (body.getData() instanceof ZtbViewList) {
                    ZtbViewList ztbViewList = (ZtbViewList)body.getData();
                    Card card2 = ztbViewList.getCardListData();
                    List cardButtons2 = card2.getCardButtons();
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)cardButtons2)) {
                        cardButtons2.forEach(cardButton -> this.handleButtonGroup((ButtonGroup)cardButton.getData(), submitActions));
                    }
                } else if (body.getData() instanceof Card && !org.springframework.util.CollectionUtils.isEmpty((Collection)(cardButtons = (card = (Card)body.getData()).getCardButtons()))) {
                    cardButtons.forEach(cardButton -> this.handleButtonGroup((ButtonGroup)cardButton.getData(), submitActions));
                }
            });
            r.getBottom().forEach(bottom -> {
                if (bottom.getData() instanceof ButtonGroup) {
                    this.handleButtonGroup((ButtonGroup)bottom.getData(), submitActions);
                }
            });
        });
        return submitActions;
    }

    private void handleButtonGroup(ButtonGroup buttonGroup, List<PcUiBotTmAction> submitActions) {
        List contentGroup = buttonGroup.getContentGroup();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)contentGroup)) {
            return;
        }
        contentGroup.forEach(item -> this.handleButton(item.getSchema(), (Button)item.getData(), submitActions));
    }

    private void handleButton(String schema, Button<?> button, List<PcUiBotTmAction> submitActions) {
        UiBotAction action = button.getSubmitAction();
        if (action != null && ButtonTypeEnum.isNotJump((String)action.getBtnType())) {
            action.setUuid(schema);
            submitActions.add((PcUiBotTmAction)JsonUtil.objectToJavaObject((Object)action, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    public void handleMainDataSource(PcUiBotTmActivity tmActivity, PcUiBotExecuteContext executeContext) {
        if (tmActivity == null || tmActivity.getPages() == null || tmActivity.getDataSources() == null) {
            return;
        }
        if (Objects.equals("browse-page-mobile", executeContext.getPageCode()) && !ObjectUtils.isEmpty((Object)tmActivity.getPages().getDataViewQuerys())) {
            return;
        }
        Map dataSources = tmActivity.getDataSources();
        if (dataSources.size() <= 1) {
            return;
        }
        Optional<Map.Entry> optional = dataSources.entrySet().stream().filter(entry -> Objects.equals(entry.getKey(), tmActivity.getPages().getDataSourceName()) && ((PcUiBotTmQueryAction)entry.getValue()).getSequence() == 0).findFirst();
        if (optional.isPresent()) {
            return;
        }
        String dataSourceName = dataSources.entrySet().stream().filter(entry -> {
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataSourceNames())) {
                return tmActivity.getPages().getDataSourceNames().contains(entry.getKey()) && ((PcUiBotTmQueryAction)entry.getValue()).getSequence() == 0;
            }
            return ((PcUiBotTmQueryAction)entry.getValue()).getSequence() == 0;
        }).map(Map.Entry::getKey).findFirst().orElse(null);
        if (dataSourceName == null) {
            return;
        }
        tmActivity.getPages().setDataSourceName(dataSourceName);
    }

    protected void analysisDataSourceViewCode(T pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState) {
        Optional dataViewQueryList;
        PcUiBotDoubleDocumentPageDefine pcUiBotDoubleDocumentPageDefine;
        ArrayList specialPageCode = Lists.newArrayList((Object[])new String[]{"project-detail-mobile", "task-detail-mobile"});
        String viewCode = PcUiBotRuntimes.getContext().get("VIEWCODE", String.class).orElse("");
        if (!StringUtils.isEmpty((Object)viewCode)) {
            String pageCode = pageDefine.getExecuteContext().getPageCode();
            if (specialPageCode.contains(pageCode)) {
                pageCode = pageCode.concat("-").concat(dataState.getCode());
            }
            this.dataViewService.buildDslByViewCode(viewCode, tmActivity.getActivityId(), pageCode, dataState, pageDefine.getExecuteContext());
            this.buildPageSubmitAction(dataState);
        }
        if (pageDefine instanceof PcUiBotDoubleDocumentPageDefine && org.springframework.util.CollectionUtils.isEmpty((Collection)(pcUiBotDoubleDocumentPageDefine = (PcUiBotDoubleDocumentPageDefine)pageDefine).getDataViewQueryList()) && (dataViewQueryList = PcUiBotRuntimes.getContext().get("dataViewQuerys", List.class)).isPresent()) {
            pcUiBotDoubleDocumentPageDefine.setDataViewQueryList((List)dataViewQueryList.get());
        }
    }
}

