/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.AbstractPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConditionPageAnalyzer
extends AbstractPageDefineAnalyzer<PcUiBotPageDefine> {
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private TmDataSourceService tmDataSourceService;
    @Autowired
    private TmPageOperationService tmPageOperationService;
    @Autowired
    private TmPageSubmitService tmPageSubmitService;

    public PcUiBotPageDefine analysis(PcUiBotExecuteContext executeContext) {
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefine(executeContext, tmActivity);
    }

    private PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
        this.buildPageSubmitAction(tmActivity);
        PcUiBotConvertTmActivityUtils.convert((String)executeContext.getPageCode(), (String)executeContext.getLocale(), (PcUiBotTmActivity)tmActivity);
        return tmActivity;
    }

    protected PcUiBotPageDefine createNewPageDefine() {
        return new PcUiBotPageDefine();
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        pageDefine.setDefaultShow(true);
        this.tmPageSubmitService.processBaseData(executeContext, tmActivity, dataState, pageDefine);
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
    }

    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        PcUiBotDataSourceSetDTO dataSourceSet = this.tmDataSourceService.analysis(executeContext, dataSources);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = this.tmDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }
}

