/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.AbstractPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.BaseDataDoubleDocumentPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DataViewPageDefineAnalyzer
extends AbstractPageDefineAnalyzer<PcUiBotDataViewPageDefine> {
    private static final Logger log = LoggerFactory.getLogger(DataViewPageDefineAnalyzer.class);
    private static final ThreadLocal<PcUiBotDataViewPageDefine> CONTEXT_HOLDER = new TransmittableThreadLocal();
    @Lazy
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private GeneralDataSourceService generalDataSourceService;
    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer doubleDocumentPageDefineAnalyzer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PcUiBotDataViewPageDefine> analysis(PcUiBotDataViewPageDefine dataViewPageDefine) {
        String viewCode = dataViewPageDefine.getViewCode();
        PcUiBotRuntimes.getContext().put("VIEWCODE", (Object)viewCode);
        PcUiBotExecuteContext executeContext = dataViewPageDefine.getExecuteContext();
        PcUiBotTmActivity tmActivity = this.doubleDocumentPageDefineAnalyzer.getActivityWithoutTaskId(executeContext);
        executeContext.appendTmActivityInfo(tmActivity);
        try {
            CONTEXT_HOLDER.set(dataViewPageDefine);
            List list = super.createPageDefines(executeContext, tmActivity);
            return list;
        }
        finally {
            CONTEXT_HOLDER.remove();
        }
    }

    protected PcUiBotDataViewPageDefine createNewPageDefine() {
        return CONTEXT_HOLDER.get() == null ? new PcUiBotDataViewPageDefine() : (PcUiBotDataViewPageDefine)CONTEXT_HOLDER.get();
    }

    protected void analysisDataSource(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        if (CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataSourceNames())) {
            return;
        }
        String viewCode = PcUiBotRuntimes.getContext().get("VIEWCODE", String.class).orElse("");
        if (StringUtils.isNotBlank((CharSequence)viewCode)) {
            PcUiBotDataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, dataSources);
            pageDefine.setDataSourceSet(dataSourceSet);
            pageDefine.setDataStateCode(tmDataState.getCode());
        }
    }

    protected void analysisAllDataSource(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, tmActivity.getDataSources());
        pageDefine.setAllDataSourceSet(dataSourceSet);
    }

    protected void analysisDataViewQuerys(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmDataState dataState) {
        String viewCode = pageDefine.getViewCode();
        this.dataViewService.appendNecessaryData(viewCode, (PcUiBotDoubleDocumentPageDefine)pageDefine, executeContext);
        if (!CollectionUtils.isEmpty((Collection)dataState.getDataViewQuerys()) && !CollectionUtils.isEmpty((Collection)pageDefine.getPageLayout())) {
            dataState.setPageLayout(pageDefine.getPageLayout());
        }
    }

    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return this.doubleDocumentPageDefineAnalyzer.createNewContext(oldExecuteContext);
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        this.doubleDocumentPageDefineAnalyzer.analysisOperators(executeContext, (PcUiBotDoubleDocumentPageDefine)pageDefine, tmActivity, operations);
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState dataState, List<PcUiBotTmAction> submitActions) {
        this.doubleDocumentPageDefineAnalyzer.analysisSubmitActions(executeContext, (PcUiBotDoubleDocumentPageDefine)pageDefine, tmActivity, dataState, submitActions);
    }

    protected void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        this.doubleDocumentPageDefineAnalyzer.analysisBaseInfo(executeContext, (PcUiBotDoubleDocumentPageDefine)pageDefine, tmActivity, tmPage);
    }
}

