/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotModelDesignerMultipleDataSources;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTaskInfo;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocProxyUserResult;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.AbstractPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataEntryDrivenSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.NewTaskApprovalService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.NewTaskSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmApprovalService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmOtherInfoService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmTaskPageSubmitService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotAttachmentUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.digiwin.mobile.mobileuibot.test.TestV1ToV2Util;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TaskPageDefineAnalyzer
extends AbstractPageDefineAnalyzer<PcUiBotTaskPageDefine> {
    private static final Logger log = LoggerFactory.getLogger(TaskPageDefineAnalyzer.class);
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private ActivityFilterService activityFilterService;
    @Autowired
    TmPageOperationService tmPageOperationService;
    @Autowired
    private TmTaskPageSubmitService tmTaskPageSubmitService;
    @Autowired
    private NewTaskSubmitService newTaskSubmitService;
    @Autowired
    private DataEntryDrivenSubmitService dataEntryDrivenSubmitService;
    @Autowired
    private TmOtherInfoService tmOtherInfoService;
    @Autowired
    private TmApprovalService tmApprovalService;
    @Autowired
    private NewTaskApprovalService newTaskApprovalService;
    @Autowired
    private LocaleService localeService;

    public List<PcUiBotTaskPageDefine> analysis(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, DigiwinAtmcActivityData activityData) {
        PcUiBotTmActivity tmActivity = this.getActivityAction(apiRequest, executeContext);
        if (tmActivity.getDataSources() == null) {
            String message = MessageFormat.format("\u4efb\u52a1\u5b9a\u4e49\u4e0d\u5b8c\u6574\uff0c\u6ca1\u6709\u76f8\u5173\u7684\u6570\u636e\u6e90\u5b9a\u4e49,tmActivity\uff1a{0}", tmActivity.getActivityId());
            throw new ServiceException(message);
        }
        executeContext.appendTmActivityInfo(tmActivity);
        ArrayList<PcUiBotTaskPageDefine> taskPageDefineList = super.createPageDefines(executeContext, tmActivity);
        if (null == taskPageDefineList) {
            taskPageDefineList = new ArrayList<PcUiBotTaskPageDefine>();
        }
        this.appendInternalPageDefine(executeContext, tmActivity, taskPageDefineList);
        return taskPageDefineList;
    }

    public PcUiBotTmActivity getActivityAction(ApiRequest apiRequest, PcUiBotExecuteContext executeContext) {
        KnowledgeMapsActivityDefinition rawActivityDefinition = Optional.ofNullable(apiRequest).map(ApiRequest::getPatternTaskInfo).map(PatternTaskInfo::getUiBotDesignerConfig).map(UiBotDesignerConfig::getRawTaskActivityDefinition).orElse(null);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("taskId", executeContext.getTmProjectId());
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        rawActivityDefinition = rawActivityDefinition != null ? rawActivityDefinition : this.digiwinKnowledgeMapsProxyService.getActivityDefinition(athenaApiRequest);
        PcUiBotTmActivity tmActivity = (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
        if (TestV1ToV2Util.exist((String)tmActivity.getActivityId())) {
            this.replaceDsl(tmActivity, executeContext);
        }
        this.handleDataState(tmActivity);
        this.buildDataStateSubmitAction(tmActivity);
        UiBotModelDesignerMultipleDataSources.handleMultipleDataSources((PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.convert((String)executeContext.getPageCode(), (String)executeContext.getLocale(), (PcUiBotTmActivity)tmActivity);
        return tmActivity;
    }

    private void replaceDsl(PcUiBotTmActivity tmActivity, PcUiBotExecuteContext executeContext) {
        String tenantVersion = this.activityFilterService.tenantVersion(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale());
        MobileDesignerConfig config = this.activityFilterService.selectOneData(tmActivity.getApplication(), tmActivity.getActivityId(), MobileDesignerConfigTypeEnum.TASK.getValue(), executeContext.getTenantId(), tenantVersion);
        if (config == null) {
            return;
        }
        PcUiBotTmPage page = config.getPages();
        if (page == null) {
            return;
        }
        tmActivity.setPages(page);
    }

    protected PcUiBotExecuteContext createNewContext(PcUiBotExecuteContext oldExecuteContext) {
        return oldExecuteContext.clone();
    }

    protected PcUiBotTaskPageDefine createNewPageDefine() {
        return new PcUiBotTaskPageDefine();
    }

    protected void addDefaultConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        PcUiBotAttachmentUtil.addDefaultAttachmentDataSourceProcess((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity);
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity);
    }

    protected void analysisApprove(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage, PcUiBotTmDataState dataState) {
        if (tmActivity.isFlowEngine().booleanValue()) {
            this.tmApprovalService.process(executeContext, tmActivity, dataState, pageDefine);
        } else {
            this.newTaskApprovalService.process(executeContext, tmActivity, dataState, pageDefine);
        }
    }

    protected void analysisDataSource(PcUiBotExecuteContext taskExecuteContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = this.taskDataSourceAnalysisService.analysis(taskExecuteContext, tmDataState, dataSources, tmDataFilter);
        pageDefine.setDataSourceSet(dataSourceSetDTO);
        if (null != tmDataFilter) {
            pageDefine.setQueryTitle(tmDataFilter.getTitle());
            pageDefine.setRowSizeType(tmDataFilter.getRowSizeType());
        }
    }

    protected void analysisAllDataSource(PcUiBotExecuteContext taskExecuteContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = this.taskDataSourceAnalysisService.analysis(taskExecuteContext, tmDataState, tmActivity.getDataSources(), tmDataFilter);
        pageDefine.setAllDataSourceSet(dataSourceSetDTO);
    }

    protected void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, (PcUiBotPageDefine)pageDefine, tmActivity, operations);
        if (pageDefine.getFinished().booleanValue()) {
            pageDefine.setOperations(this.filterActiveOperationsWhenBacklogFinished(pageDefine.getOperations()));
        }
    }

    public void analysisBaseInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmPage tmPage) {
        if (executeContext.getTaskWithBacklogDataList() == null || executeContext.getTaskWithBacklogDataList().size() == 0) {
            return;
        }
        pageDefine.setPrePerformer(tmPage.getPrePerformer());
        pageDefine.setSubjectMatter(tmPage.getSubjectMatter());
        pageDefine.setSubjectMatterTargets(tmPage.getSubjectMatterTargets());
        pageDefine.setSubjectMatterProperties(tmPage.getSubjectMatterProperties());
        pageDefine.setRoleAttention(tmPage.getRoleAttention());
        pageDefine.setStartApproveActivityName(tmActivity.getStartApproveActivityName());
        pageDefine.setStartApproveActivity(tmActivity.getStartApproveActivity());
        pageDefine.setVersion(tmActivity.isFlowEngine() != false ? "1.0" : "2.0");
        pageDefine.setDomain(tmPage.getDomain());
        this.initFinishedInfo(executeContext, pageDefine, tmPage);
        pageDefine.setDataKeyProperties(tmPage.getDataKeyProperties());
        pageDefine.setSubjectExpect(tmPage.getSubjectExpect());
        pageDefine.setSubjectShortfall(tmPage.getSubjectShortfall());
        pageDefine.setDataStateCount(tmPage.getDataStates() == null ? 0 : tmPage.getDataStates().size());
        this.tmOtherInfoService.analysis((PcUiBotPageDefine)pageDefine, tmPage, ((DigiwinAtmcTaskWithBacklogData)executeContext.getTaskWithBacklogDataList().get(0)).getBpmData());
        pageDefine.setBindForm(tmActivity.getBindForm());
        pageDefine.setFieldConfig(tmActivity.getFieldConfig());
        pageDefine.setMerge(tmActivity.getMerge());
    }

    private void initFinishedInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmPage tmPage) {
        if (!CollectionUtils.isEmpty((Collection)executeContext.getTaskWithBacklogDataList()) && !CollectionUtils.isEmpty((Collection)((DigiwinAtmcTaskWithBacklogData)executeContext.getTaskWithBacklogDataList().get(0)).getBacklog())) {
            String finishedActionId = ((DigiwinAtmcBacklogData)((DigiwinAtmcTaskWithBacklogData)executeContext.getTaskWithBacklogDataList().get(0)).getBacklog().get(0)).getFinishedActionId();
            if (!StringUtils.isEmpty((Object)finishedActionId)) {
                for (DigiwinAtmcTaskWithBacklogData withBacklogData : executeContext.getTaskWithBacklogDataList()) {
                    if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((DigiwinAtmcBacklogData)withBacklogData.getBacklog().get(0)).getFinishedActionId())) continue;
                    finishedActionId = null;
                    break;
                }
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)finishedActionId)) {
                pageDefine.setFinished(Boolean.valueOf(true));
                pageDefine.setFinishedActionId(finishedActionId);
                List submitActions = null;
                if (!CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
                    for (PcUiBotTmDataState dataState : tmPage.getDataStates()) {
                        if (CollectionUtils.isEmpty((Collection)dataState.getSubmitActions())) continue;
                        submitActions = dataState.getSubmitActions();
                        break;
                    }
                }
                if (submitActions != null) {
                    for (PcUiBotTmAction submitAction : submitActions) {
                        if (!Objects.equals(submitAction.getId(), finishedActionId) && !Objects.equals(submitAction.getActionId(), finishedActionId)) continue;
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)submitAction.getReturnText())) {
                            pageDefine.setFinishedTitle(submitAction.getTitle());
                        } else {
                            pageDefine.setFinishedTitle(TaskPageDefineAnalyzer.getMessageWithLanguage((String)submitAction.getReturnText(), (String)executeContext.getLocale()));
                        }
                        break;
                    }
                }
            } else {
                boolean isFinished = executeContext.getTaskWithBacklogDataList().stream().filter(x -> Objects.equals(((DigiwinAtmcBacklogData)x.getBacklog().get(0)).isClosed(), false)).count() <= 0L;
                pageDefine.setFinished(Boolean.valueOf(isFinished));
            }
            String locale = executeContext.getLocale();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)locale)) {
                locale = "zh_CN";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageDefine.getFinishedTitle())) {
                if (Objects.equals(finishedActionId, "athena_bpm_reassign")) {
                    pageDefine.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u8f6c\u6d3e"));
                } else if (Objects.equals(finishedActionId, "athena_bpm_cancel")) {
                    pageDefine.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u64a4\u9500"));
                } else if (Objects.equals(finishedActionId, "uibot_retrive")) {
                    pageDefine.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u5df2\u64a4\u56de"));
                } else if (Objects.equals(finishedActionId, "uibot_action_id_finished")) {
                    pageDefine.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u5df2\u7ed3\u675f"));
                } else if (Objects.equals(finishedActionId, "athena_overdue_task_terminate")) {
                    pageDefine.setFinishedTitle(this.localeService.getLanguageValue(locale, "\u903e\u671f\u7ec8\u6b62"));
                }
            }
        }
    }

    public static String getMessageWithLanguage(String message, String language) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        try {
            Map map = (Map)JsonUtil.jsonStringToObject((String)message, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            return (String)map.get(language);
        }
        catch (Exception ex) {
            return message;
        }
    }

    protected void analysisSubmitActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, PcUiBotTmDataState tmDataState, List<PcUiBotTmAction> submitActions) {
        ArrayList<PcUiBotTmAction> actionList = new ArrayList<PcUiBotTmAction>();
        if (pageDefine.getFinished().booleanValue()) {
            for (PcUiBotTmAction tmAction : tmDataState.getSubmitActions()) {
                if (this.isRetriveAction(tmAction)) {
                    if (!this.isCanRetrieve(executeContext, Long.valueOf(10L)).booleanValue()) continue;
                    this.buildRetriveSubmitAction(executeContext, tmAction);
                    actionList.add(tmAction);
                    continue;
                }
                if (PcUiBotSubmitActionUtil.isTaskWithdrawAction((PcUiBotTmAction)tmAction)) {
                    actionList.add(tmAction);
                    continue;
                }
                if (!PcUiBotSubmitActionUtil.showWhenBacklogFinished((PcUiBotTmAction)tmAction)) continue;
                actionList.add(tmAction);
            }
        } else {
            for (PcUiBotTmAction tmAction : tmDataState.getSubmitActions()) {
                if (!PcUiBotSubmitActionUtil.isTaskWithdrawAction((PcUiBotTmAction)tmAction)) continue;
                actionList.add(tmAction);
            }
            if (!"completed".equals(tmDataState.getDataFilterCode()) && !"completed".equals(pageDefine.getDataStateCode())) {
                for (PcUiBotTmAction tmAction : tmDataState.getSubmitActions()) {
                    if (this.isRetriveAction(tmAction)) continue;
                    actionList.add(tmAction);
                }
            }
        }
        if (pageDefine.getFinished().booleanValue() && CollectionUtils.isEmpty(actionList)) {
            pageDefine.setSubmitActions(null);
            if (this.isCanRetrieve(executeContext, Long.valueOf(30L)).booleanValue()) {
                pageDefine.setFinishedTitle("\u5df2\u64a4\u56de");
            }
            return;
        }
        if (!CollectionUtils.isEmpty(actionList)) {
            tmDataState.setSubmitActions(actionList);
        }
        if (executeContext.isShared()) {
            if (executeContext.isOwnerBacklog() || this.isProxy(executeContext.getAuthoredUser(), ((DigiwinAtmcBacklogData)executeContext.getTaskWithBacklogData().getBacklog().get(0)).getPerformerId())) {
                if (tmActivity.isFlowEngine().booleanValue()) {
                    this.tmTaskPageSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, (PcUiBotPageDefine)pageDefine);
                } else {
                    this.newTaskSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, (PcUiBotPageDefine)pageDefine);
                }
            }
        } else if (tmActivity.isFlowEngine().booleanValue()) {
            this.tmTaskPageSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, (PcUiBotPageDefine)pageDefine);
        } else {
            this.newTaskSubmitService.createTaskSubmit(executeContext, tmActivity, tmDataState, (PcUiBotPageDefine)pageDefine);
        }
    }

    @JsonIgnore
    private boolean isProxy(PcUiBotAuthoredUser currentUser, String performerId) {
        List proxyTargetUsers = this.digiwinEocProxyService.getProxyTargetUsers(currentUser.getUserId(), currentUser.getToken());
        if (!CollectionUtils.isEmpty((Collection)proxyTargetUsers)) {
            for (EocProxyUserResult.EocProxyUser proxyUser : proxyTargetUsers) {
                if (!Objects.equals(performerId, proxyUser.getUserId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRetriveAction(PcUiBotTmAction tmAction) {
        if (tmAction == null) {
            return false;
        }
        if ("uibot_retrive".equals(tmAction.getActionId())) {
            return true;
        }
        if (!CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            for (PcUiBotTmAction attachAction : tmAction.getAttachActions()) {
                if (!this.isRetriveAction(attachAction)) continue;
                return true;
            }
        }
        return false;
    }

    private PcUiBotTmAction getRetriveAction(PcUiBotTmAction tmAction) {
        if (tmAction == null) {
            return null;
        }
        if ("uibot_retrive".equals(tmAction.getActionId())) {
            return tmAction;
        }
        if (!CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            for (PcUiBotTmAction attachAction : tmAction.getAttachActions()) {
                PcUiBotTmAction retriveAction = this.getRetriveAction(attachAction);
                if (retriveAction == null) continue;
                return retriveAction;
            }
        }
        return null;
    }

    private Boolean isCanRetrieve(PcUiBotExecuteContext executeContext, Long ifRetriveValue) {
        return false;
    }

    private void buildRetriveSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmAction tmAction) {
        PcUiBotTmAction submitAction = this.getRetriveAction(tmAction);
        if (submitAction == null) {
            return;
        }
        submitAction.setId("uibot_retrive");
        submitAction.setName("uibot_retrive");
        submitAction.setServiceName("uibot_retrive");
        submitAction.setUrl("api/task/card/retrieve");
        submitAction.setDefaultAction(true);
        submitAction.setTrackCode("retrieve");
        submitAction.setTitle("\u64a4\u56de");
        submitAction.setAttachActions(new ArrayList());
        submitAction.setActionId("uibot_retrive");
        submitAction.setActionType("uibot_retrive");
        PcUiBotSubmitType submitType = new PcUiBotSubmitType();
        submitType.setSchema("data");
        submitType.setIsBatch(Boolean.valueOf(false));
        submitAction.setSubmitType(submitType);
        submitAction.setType("UIBOT");
        PcUiBotSubmitExecuteContext submitExecuteContext = new PcUiBotSubmitExecuteContext();
        List backlogIds = ((List)Optional.ofNullable(executeContext.getTaskWithBacklogData()).map(DigiwinAtmcTaskWithBacklogData::getBacklog).orElse(new ArrayList())).stream().map(DigiwinAtmcBacklogData::getBacklogId).collect(Collectors.toList());
        submitExecuteContext.setBacklogId((Long)backlogIds.get(0));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)executeContext.getTmActivityId())) {
            submitExecuteContext.setTmActivityId("uibotRetriveTask");
        } else {
            submitExecuteContext.setTmActivityId(executeContext.getTmActivityId());
        }
        submitExecuteContext.setClientAgent(executeContext.getClientAgent());
        if (executeContext.getTaskWithBacklogData() != null) {
            submitExecuteContext.setBacklogId(executeContext.getFirstBacklogId());
        }
        if (executeContext.getTaskWithBacklogData() != null && !CollectionUtils.isEmpty((Map)executeContext.getTaskWithBacklogData().getBpmData())) {
            submitExecuteContext.setBpmData(executeContext.getTaskWithBacklogData().getBpmData());
        }
        submitExecuteContext.setLocale(executeContext.getLocale());
        submitExecuteContext.setPageCode(executeContext.getPageCode());
        HashMap<String, String> extendParas = submitAction.getExtendParas();
        if (null == extendParas) {
            extendParas = new HashMap<String, String>();
            submitAction.setExtendParas(extendParas);
        }
        extendParas.put("dataSource", "parentResponse");
    }
}

