/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.parser.AbstractCombineSubmitActionParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Scope(value="prototype")
public class BaseDataCombineSubmitActionParser
extends AbstractCombineSubmitActionParser {
    protected PcUiBotExecuteContext executeContext;
    protected String mainDataSourceName;

    public void init(PcUiBotExecuteContext executeContext, PcUiBotTmDataState tmDataState, String mainDataSourceName) {
        super.init(tmDataState);
        this.executeContext = executeContext;
        this.mainDataSourceName = mainDataSourceName;
    }

    public PcUiBotSubmitAction buildSubmitAction(PcUiBotTmAction tmAction) {
        if (!Objects.equals(BooleanUtils.isTrue((Boolean)this.executeContext.getIsRecycle()), this.isRecycleSubmitAction(tmAction))) {
            return null;
        }
        PcUiBotSubmitAction submitAction = this.submitActionCreateService.createSubmitAction(tmAction, this.executeContext.getTenantId(), this.executeContext.getBusinessUnit(), this.executeContext);
        submitAction.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)this.executeContext, null));
        super.setSubmitType(submitAction, this.mainDataSourceName);
        return submitAction;
    }

    public PcUiBotSubmitAction buildCombineSubmitAction(PcUiBotTmAction tmAction, List<PcUiBotSubmitAction> combineSubmitActionList) {
        if (CollectionUtils.isEmpty(combineSubmitActionList)) {
            return null;
        }
        PcUiBotSubmitAction submitAction = new PcUiBotSubmitAction();
        submitAction.setCombineActions(combineSubmitActionList);
        submitAction.setActionType(tmAction.getActionType());
        submitAction.setDefaultAction(tmAction.isDefaultAction());
        submitAction.setUuid(tmAction.getUuid());
        submitAction.setBtnId(tmAction.getBtnId());
        submitAction.setBtnType(tmAction.getBtnType());
        submitAction.setJumpAction(tmAction.getJumpAction());
        submitAction.setTitle(tmAction.getTitle());
        submitAction.setId(tmAction.getId());
        submitAction.setSubmitType(tmAction.getSubmitType());
        if (tmAction.getIgnoreRule() != null) {
            submitAction.setIgnoreRule(tmAction.getIgnoreRule());
        }
        submitAction.setCategory(tmAction.getType());
        super.setSubmitType(submitAction, this.mainDataSourceName);
        return submitAction;
    }

    private boolean isRecycleSubmitAction(PcUiBotTmAction tmAction) {
        return !CollectionUtils.isEmpty((Map)tmAction.getExtendParas()) && BooleanUtils.isTrue((Boolean)((Boolean)tmAction.getExtendParas().get("applyToRecycle")));
    }
}

