/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionCreateServiceBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DataEntryDrivenActionCreateService
extends ActionCreateServiceBase {
    public PcUiBotSubmitAction createSubmitAction(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        ArrayList attachResultActions;
        PcUiBotSubmitAction action;
        if (Objects.equals("workflow", tmAction.getType())) {
            action = this.createWorkflowSubmitAction(executeContext, tmAction, tmActivity, taskWithBacklogData);
        } else {
            action = this.initSubmitAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);
            action.setCategory(tmAction.getType());
        }
        List attachActions = tmAction.getAttachActions();
        if (CollectionUtils.isNotEmpty((Collection)attachActions)) {
            attachResultActions = Lists.newArrayListWithExpectedSize((int)attachActions.size());
            for (PcUiBotTmAction attachAction : attachActions) {
                PcUiBotSubmitAction submitAction = this.createSubmitAction(executeContext, projectData, taskWithBacklogData, attachAction, tmActivity);
                submitAction.setExecuteContext(null);
                attachResultActions.add(submitAction);
            }
        } else {
            attachResultActions = Lists.newArrayListWithExpectedSize((int)1);
        }
        if (tmAction.isDispatch()) {
            PcUiBotTmAction dispatch = new PcUiBotTmAction();
            dispatch.setActionId("athena.workflow.process.activity.work.dispatch");
            dispatch.setServiceName("workflow-act-dispatch");
            dispatch.setType("workflow");
            dispatch.setTitle("\u540c\u610f");
            attachResultActions.add(this.createWorkflowSubmitAction(executeContext, dispatch, tmActivity, taskWithBacklogData));
        }
        action.setAttachActions((List)attachResultActions);
        PcUiBotSubmitActionUtil.setCondition((PcUiBotTmAction)tmAction, (PcUiBotSubmitAction)action);
        action.setSubmitType(tmAction.getSubmitType());
        action.setTrackCode(tmAction.getTrackCode());
        action.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)executeContext, (DigiwinAtmcTaskWithBacklogData)taskWithBacklogData));
        action.setExecuteAfterCheckCompleted(tmAction.getExecuteAfterCheckCompleted());
        return action;
    }

    public PcUiBotSubmitAction createWorkflowSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity, DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        DigiwinAtmcBacklogData backlogData = (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0);
        PcUiBotSubmitAction workflowSubmitAction = this.createWorkflowSubmitAction(backlogData);
        workflowSubmitAction.setTitle(tmAction.getTitle());
        String serviceName = tmAction.getServiceName();
        Map paras = workflowSubmitAction.getParas();
        switch (serviceName) {
            case "workflow-act-submit": {
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/submit", serviceName));
                break;
            }
            case "workflow-act-agree": {
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/agree", serviceName));
                this.addAttachApprovalConfig(workflowSubmitAction, tmActivity);
                break;
            }
            case "workflow-act-disagree": {
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/disagree", serviceName));
                this.addAttachApprovalConfig(workflowSubmitAction, tmActivity);
                break;
            }
            case "workflow-act-add": {
                paras.put("dispatchData", Collections.emptyMap());
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/add", serviceName));
                ArrayList activities = new ArrayList();
                HashMap<String, String> activity = new HashMap<String, String>();
                activity.put("activityName", backlogData.getPerformerName() + " \u52a0\u7b7e");
                activity.put("signType", "single");
                activity.put("performerIds", "");
                activity.put("addType", "BackwardDispatch");
                activities.add(activity);
                paras.put("activities", activities);
                this.addAttachApprovalConfig(workflowSubmitAction, tmActivity);
                break;
            }
            case "workflow-act-return": {
                paras.put("activityId", "");
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/task/activity/return", serviceName));
                break;
            }
            case "workflow-act-reassignment": {
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/transfer", serviceName));
                paras.put("newPerformerId", "");
                break;
            }
            case "workflow-act-dispatch": {
                workflowSubmitAction.setServiceId(this.createActionServiceId("api/process/activity/work/dispatch", serviceName));
                if (workflowSubmitAction.getExtendParas() == null) {
                    workflowSubmitAction.setExtendParas(new HashMap());
                }
                if (workflowSubmitAction.getExtendParas().containsKey("dataSource")) break;
                workflowSubmitAction.getExtendParas().put("dataSource", "parent");
                break;
            }
            default: {
                String message = "exception.unsupported.action" + tmAction.getActionId() + tmAction.getType();
                throw new ServiceException(message);
            }
        }
        if (StringUtils.isEmpty((CharSequence)tmAction.getId())) {
            workflowSubmitAction.setId(tmAction.getActionId());
        } else {
            workflowSubmitAction.setId(tmAction.getId());
        }
        workflowSubmitAction.setActionId(tmAction.getActionId());
        workflowSubmitAction.setDefaultAction(tmAction.isDefaultAction());
        workflowSubmitAction.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage((Object)tmAction.getTitle()));
        workflowSubmitAction.setActionParams(tmAction.getActionParams());
        workflowSubmitAction.executeExtendParas(tmAction.getExtendParas(), executeContext);
        this.processActionParas((PcUiBotAction)workflowSubmitAction, executeContext);
        return workflowSubmitAction;
    }

    private PcUiBotActionServiceId createActionServiceId(String serviceUri, String name) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setServiceUri(serviceUri);
        actionServiceId.setName(name);
        return actionServiceId;
    }

    private PcUiBotSubmitAction createWorkflowSubmitAction(DigiwinAtmcBacklogData backlogData) {
        Map map = (Map)backlogData.getWorkitemList().get(0);
        String performerId = MapUtils.getString((Map)map, (Object)"performerId");
        String workitemId = MapUtils.getString((Map)map, (Object)"workitemId");
        Integer performerType = MapUtils.getInteger((Map)map, (Object)"performerType");
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setCategory("workflow");
        action.setTrackCode("SUBMIT");
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)workitemId)) {
            throw new ServiceException("exception.workitem.empty: " + backlogData.getBacklogId());
        }
        String userId = AppRequestContext.getContextEntity().getUserId();
        paras.put("workitemId", workitemId);
        paras.put("performerType", performerType);
        paras.put("performerId", performerId);
        if (!Objects.equals(performerId, userId)) {
            paras.put("performerType", 1);
            paras.put("agentPerformerId", userId);
        }
        paras.put("comment", "");
        paras.put("locale", AppRequestContext.getContextEntity().getLocale());
        action.setParas(paras);
        return action;
    }
}

