/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DslAllFieldsService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DslPageDataSetService {
    @Autowired
    private DslAllFieldsService dslAllFieldsService;
    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    public void getPageDataSet(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet, UiBotModel page) {
        HashMap<String, List> pageDataKeys;
        if (queryResultSet == null) {
            return;
        }
        String dataSourceName = queryResultSet.getDataSourceNameFromApiResp();
        if (StringUtils.isBlank((CharSequence)dataSourceName)) {
            dataSourceName = this.getFirstContainerSchema(pageDefine.getPageLayout());
        }
        if (Boolean.TRUE.equals(pageDefine.getMasterFromDataSourceName())) {
            dataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        }
        queryResultSet.getMainQueryResult().setDataSourceName(dataSourceName);
        PcUiBotDataSourceSetDTO dataSourceSet = pageDefine.getDataSourceSet();
        dataSourceSet.setMainDatasource(dataSourceName);
        List dataKeys = null;
        PcUiBotDataSourceDTO firstDataQuery = dataSourceSet.getFirstDataQuery();
        if (firstDataQuery != null) {
            dataKeys = firstDataQuery.getDataKeys();
            firstDataQuery.setName(dataSourceName);
        }
        if (!CollectionUtils.isEmpty(dataKeys)) {
            pageDataKeys = new HashMap<String, List>();
            pageDataKeys.put(dataSourceName, dataKeys);
        } else {
            pageDataKeys = queryResultSet.getPageDataKeys();
        }
        if (!CollectionUtils.isEmpty((Map)queryResultSet.getPageData())) {
            String finalDataSourceName = dataSourceName;
            queryResultSet.getQueryResults().forEach(qr -> qr.setDataSourceName(finalDataSourceName));
        } else {
            PcUiBotMetadataField masterField = queryResultSet.getMasterField();
            boolean single = masterField != null && !masterField.isArray();
            queryResultSet.appendData(QueryResult.empty((String)dataSourceName, (boolean)single));
        }
        List allFields = this.dslAllFieldsService.buildAllFieldsFromApiMetadata(executeContext, pageDefine, queryResultSet, dataSourceName);
        page.getPageData().putAll(queryResultSet.getPageData(allFields));
        page.setPageDataKeys((UiBotPageData)JsonUtil.objectToJavaObject(pageDataKeys, UiBotPageData.class));
        page.setPageDataIndex((UiBotPageData)JsonUtil.objectToJavaObject((Object)queryResultSet.getPageDataIndex(), UiBotPageData.class));
    }

    private String getFirstContainerSchema(List<UiBotPageLayout> pageLayout) {
        String containerComponentSchema = "";
        if (CollectionUtils.isEmpty(pageLayout)) {
            return containerComponentSchema;
        }
        UiBotPageLayout mainPageLayout = this.uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
        if (mainPageLayout == null) {
            return containerComponentSchema;
        }
        List body = mainPageLayout.getBody();
        if (CollectionUtils.isEmpty((Collection)body)) {
            return containerComponentSchema;
        }
        return ((BaseMobileComponentWrapper)body.get(0)).getSchema();
    }
}

