/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionCreateServiceBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmServiceInvokeType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataEntryDrivenActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskEngineActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class NewTaskSubmitActionCreateService
extends ActionCreateServiceBase {
    @Autowired
    private TaskEngineActionCreateService bpmService;
    @Autowired
    private DataEntryDrivenActionCreateService dataEntryDrivenActionCreateService;
    private static final String[] approvelTaskType = new String[]{"agree", "add-task", "reexecute", "disagree", "reapprove"};

    public PcUiBotSubmitAction create(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        this.taskSubmitActionCheck(taskWithBacklogData);
        PcUiBotSubmitAction action = this.createSubmitActionInternal(executeContext, projectData, taskWithBacklogData, tmAction, tmActivity);
        action.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)executeContext, (DigiwinAtmcTaskWithBacklogData)taskWithBacklogData));
        if (tmAction.getIsCustomize() != null && tmAction.getIsCustomize().booleanValue()) {
            action.setIsCustomize(Boolean.valueOf(true));
            action.setUuid(tmAction.getUuid());
            action.setBtnId(tmAction.getBtnId());
            action.setBtnType(tmAction.getBtnType());
            action.setJumpAction(tmAction.getJumpAction());
            action.setTitle(tmAction.getTitle());
            action.setType(tmAction.getType());
            if (tmAction.getSchema() != null) {
                action.setSchema(tmAction.getSchema());
            }
            action.setSubmitType(tmAction.getSubmitType());
        }
        if (tmAction.isDispatch()) {
            PcUiBotSubmitAction agreeAction = this.createTaskEngineAction(BpmServiceInvokeType.Dispatch.getName(), taskWithBacklogData, executeContext.getDataFrom());
            agreeAction.setTitle("\u540c\u610f");
            agreeAction.setActionId(BpmServiceInvokeType.Dispatch.getName());
            action.getAttachActions().add(agreeAction);
        }
        action.setExecuteAfterCheckCompleted(tmAction.getExecuteAfterCheckCompleted());
        return action;
    }

    private PcUiBotSubmitAction createSubmitActionInternal(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        PcUiBotSubmitAction action = null;
        if (Objects.equals("TaskEngine", tmAction.getType())) {
            action = this.createTaskEngineAction(tmAction.getServiceName(), taskWithBacklogData, executeContext.getDataFrom());
            if (action != null) {
                if (!StringUtils.hasLength((String)tmAction.getId())) {
                    action.setId(tmAction.getActionId());
                } else {
                    action.setId(tmAction.getId());
                }
                action.setActionId(tmAction.getActionId());
                action.setDefaultAction(tmAction.isDefaultAction());
                action.setUuid(tmAction.getUuid());
                action.setBtnId(tmAction.getBtnId());
                action.setBtnType(tmAction.getBtnType());
                action.setJumpAction(tmAction.getJumpAction());
                action.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage((Object)tmAction.getTitle()));
                action.setActionParams(tmAction.getActionParams());
                action.executeExtendParas(tmAction.getExtendParas(), executeContext);
                this.processActionParas((PcUiBotAction)action, executeContext);
            }
        } else if (Objects.equals("workflow", tmAction.getType())) {
            action = this.dataEntryDrivenActionCreateService.createWorkflowSubmitAction(executeContext, tmAction, tmActivity, taskWithBacklogData);
        } else {
            action = this.createSubmitAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);
            action.setCategory(tmAction.getType());
        }
        if (action == null) {
            String message = "\u4e0d\u652f\u6301\u7684action\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e:" + tmAction.getActionId() + tmAction.getType();
            throw new ServiceException(message);
        }
        action.setAttachActions(this.createAttachActions(executeContext, projectData, taskWithBacklogData, tmAction, tmActivity));
        action.setSubmitType(tmAction.getSubmitType());
        action.setTrackCode(tmAction.getTrackCode());
        this.generateAttachConfig(executeContext, action, tmActivity, tmAction);
        PcUiBotSubmitActionUtil.setCondition((PcUiBotTmAction)tmAction, (PcUiBotSubmitAction)action);
        return action;
    }

    private void generateAttachConfig(PcUiBotExecuteContext executeContext, PcUiBotSubmitAction action, PcUiBotTmActivity tmActivity, PcUiBotTmAction tmAction) {
        List<String> approvelTaskTypeList;
        if (("APPROVAL".equals(executeContext.getCategory()) && "BUSINESS".equals(executeContext.getPattern()) || PcUiBotPatternUtil.isModelDriven((PcUiBotExecuteContext)executeContext)) && (approvelTaskTypeList = Arrays.asList(approvelTaskType)).contains(tmAction.getServiceName())) {
            this.addAttachApprovalConfig(action, tmActivity);
        }
    }

    private PcUiBotSubmitAction createSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        return this.initSubmitAction(tmAction, tenantId, businessUnit, executeContext);
    }

    private List<PcUiBotSubmitAction> createAttachActions(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction, PcUiBotTmActivity tmActivity) {
        ArrayList<PcUiBotSubmitAction> attachActions = new ArrayList<PcUiBotSubmitAction>();
        if (CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            return attachActions;
        }
        tmAction.getAttachActions().forEach(attachTmDataSource -> {
            PcUiBotSubmitAction submitAction = this.create(executeContext, projectData, taskWithBacklogData, attachTmDataSource, tmActivity);
            submitAction.setExecuteContext(null);
            attachActions.add(submitAction);
        });
        return attachActions;
    }

    private PcUiBotSubmitAction createTaskEngineAction(String serviceName, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, String dataFrom) {
        PcUiBotSubmitAction action = this.bpmService.createAction(serviceName, taskWithBacklogData, dataFrom);
        return action;
    }
}

