/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.DataSourceAnalysisServiceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ProjectDataSourceAnalysisService
extends DataSourceAnalysisServiceBase {
    public PcUiBotDataSourceSetDTO analysis(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, Map<String, PcUiBotTmQueryAction> dataSources, PcUiBotTmDataFilter tmDataFilter) {
        PcUiBotDataSourceSetDTO dataSourceSet = new PcUiBotDataSourceSetDTO();
        if (dataSources.size() == 0) {
            return dataSourceSet;
        }
        ArrayList dataSourceList = new ArrayList();
        dataSourceSet.setDataSourceList(dataSourceList);
        dataSourceSet.setDataProcess(new ArrayList());
        boolean isUserTask = false;
        for (DigiwinAtmcTaskWithBacklogData taskWithBacklogData : executeContext.getTaskWithBacklogDataList()) {
            if (!"UserTask".equals(taskWithBacklogData.getBpmActivityType()) && !"WaitingTask".equals(taskWithBacklogData.getBpmActivityType())) continue;
            isUserTask = true;
            break;
        }
        boolean finalIsUserTask = isUserTask;
        dataSources.forEach((dataSourceName, tmQueryAction) -> {
            PcUiBotDataSourceDTO dataSourceDTO = null;
            if (finalIsUserTask) {
                boolean dataStates = tmActivity.getPages().getDataStates().stream().anyMatch(s -> s.getMergeQuery() != null && s.getMergeQuery() != false);
                if (Boolean.TRUE.equals(tmActivity.getPages().getMergeQuery()) || dataStates) {
                    dataSourceDTO = this.createBatchQueryBacklog(executeContext, dataSourceName, tmQueryAction, executeContext.getTaskWithBacklogDataList(), executeContext.getProjectData(), tmDataFilter, true);
                    if (dataSourceDTO != null) {
                        dataSourceDTO.setMetadataFields(tmQueryAction.getMetadataFields());
                    }
                } else {
                    dataSourceDTO = this.createProjectUserTaskDataSource(executeContext, tmDataFilter, dataSourceName, tmQueryAction);
                }
            } else if (tmQueryAction.getLeft() != null) {
                dataSourceDTO = this.createProjectNotUserTaskDataSource(executeContext, tmDataFilter, dataSourceName, tmQueryAction);
            } else {
                dataSourceDTO = this.createBatchQueryWithoutBacklog(executeContext, dataSourceName, tmQueryAction, tmDataFilter);
                if (dataSourceDTO != null) {
                    dataSourceDTO.setMetadataFields(tmQueryAction.getMetadataFields());
                }
            }
            if (dataSourceDTO != null) {
                dataSourceList.add(dataSourceDTO);
            }
        });
        for (PcUiBotTmQueryAction queryAction : dataSources.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)queryAction.getDataProcessors())) continue;
            for (PcUiBotTmDataProcess dataProcessor : queryAction.getDataProcessors()) {
                if (!"executeCompleted".equals(dataProcessor.getActivePoint())) continue;
                dataSourceSet.getDataProcess().add(dataProcessor);
            }
        }
        return dataSourceSet;
    }

    private PcUiBotDataSourceDTO createProjectNotUserTaskDataSource(PcUiBotExecuteContext executeContext, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, PcUiBotTmQueryAction tmAction) {
        ArrayList<PcUiBotDataSourceDTO> projectDataSourceList = new ArrayList<PcUiBotDataSourceDTO>();
        for (DigiwinAtmcTaskWithBacklogData task : executeContext.getTaskWithBacklogDataList()) {
            DigiwinAtmcActivityData newActivityData = new DigiwinAtmcActivityData();
            newActivityData.setProject(executeContext.getProjectData());
            DigiwinAtmcTaskWithBacklogData newTaskWithBacklogData = task.copy();
            ArrayList<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList = new ArrayList<DigiwinAtmcTaskWithBacklogData>();
            taskWithBacklogDataList.add(newTaskWithBacklogData);
            newActivityData.setTasks(taskWithBacklogDataList);
            PcUiBotDataSourceDTO dataSourceBase = this.create(executeContext, dataSourceName, tmAction, newTaskWithBacklogData, newActivityData.getProject(), tmDataFilter);
            if (dataSourceBase == null) continue;
            projectDataSourceList.add(dataSourceBase);
        }
        if (projectDataSourceList.size() == 1) {
            PcUiBotDataSourceDTO dataSourceBase = (PcUiBotDataSourceDTO)projectDataSourceList.get(0);
            return dataSourceBase;
        }
        if (projectDataSourceList.size() > 1) {
            PcUiBotDataSourceDTO unionDataSource = new PcUiBotDataSourceDTO();
            ArrayList<PcUiBotDataSourceDTO> unionItems = new ArrayList<PcUiBotDataSourceDTO>();
            for (PcUiBotDataSourceDTO dataSourceBase : projectDataSourceList) {
                unionItems.add(dataSourceBase);
            }
            unionDataSource.setType("MIX_UNION");
            unionDataSource.setActionId(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getActionId());
            unionDataSource.setName(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getName());
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getDataKeys());
            unionDataSource.setDataSourceProcessors(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getDataSourceProcessors());
            unionDataSource.setMetadataFields(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getMetadataFields());
            return unionDataSource;
        }
        return null;
    }

    private PcUiBotDataSourceDTO createProjectUserTaskDataSource(PcUiBotExecuteContext executeContext, PcUiBotTmDataFilter tmDataFilter, String dataSourceName, PcUiBotTmQueryAction tmAction) {
        ArrayList<PcUiBotDataSourceDTO> projectDataSourceList = new ArrayList<PcUiBotDataSourceDTO>();
        for (DigiwinAtmcTaskWithBacklogData task : executeContext.getTaskWithBacklogDataList()) {
            List backlogDatas;
            if (CollectionUtils.isEmpty((Collection)task.getBacklog()) || CollectionUtils.isEmpty((Collection)(backlogDatas = task.getBacklog()))) continue;
            for (DigiwinAtmcBacklogData backlogData : backlogDatas) {
                DigiwinAtmcActivityData newActivityData = new DigiwinAtmcActivityData();
                newActivityData.setProject(executeContext.getProjectData());
                DigiwinAtmcTaskWithBacklogData newTaskWithBacklogData = task.copy();
                ArrayList<DigiwinAtmcBacklogData> backlogDataArrayList = new ArrayList<DigiwinAtmcBacklogData>();
                backlogDataArrayList.add(backlogData);
                newTaskWithBacklogData.setBacklog(backlogDataArrayList);
                ArrayList<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList = new ArrayList<DigiwinAtmcTaskWithBacklogData>();
                taskWithBacklogDataList.add(newTaskWithBacklogData);
                newActivityData.setTasks(taskWithBacklogDataList);
                PcUiBotDataSourceDTO dataSourceBase = this.create(executeContext, dataSourceName, tmAction, newTaskWithBacklogData, newActivityData.getProject(), tmDataFilter);
                if (dataSourceBase == null) continue;
                projectDataSourceList.add(dataSourceBase);
            }
        }
        if (projectDataSourceList.size() == 1) {
            return (PcUiBotDataSourceDTO)projectDataSourceList.get(0);
        }
        if (projectDataSourceList.size() > 1) {
            PcUiBotDataSourceDTO unionDataSource = new PcUiBotDataSourceDTO();
            ArrayList<PcUiBotDataSourceDTO> unionItems = new ArrayList<PcUiBotDataSourceDTO>();
            for (PcUiBotDataSourceDTO dataSourceBase : projectDataSourceList) {
                unionItems.add(dataSourceBase);
            }
            unionDataSource.setType("MIX_UNION");
            unionDataSource.setActionId(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getActionId());
            unionDataSource.setName(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getName());
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(((PcUiBotDataSourceDTO)projectDataSourceList.get(0)).getDataKeys());
            return unionDataSource;
        }
        return null;
    }
}

