/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShowApplicationFieldsService {
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    public List<PcUiBotMetadataField> applicationFilterShowField(PcUiBotMetadataField showFields) {
        return this.applicationFilterShowField(showFields, null);
    }

    private List<PcUiBotMetadataField> applicationFilterShowField(PcUiBotMetadataField showFields, List<String> appCodes) {
        if (appCodes == null) {
            appCodes = this.digiwinIamProxyService.queryUserAppCodes(AppRequestContext.getContextEntity().getIamUserToken());
        }
        ArrayList<PcUiBotMetadataField> newShowFields = new ArrayList<PcUiBotMetadataField>();
        if (showFields.getSubFields() == null) {
            return newShowFields;
        }
        for (PcUiBotMetadataField responseField : showFields.getSubFields()) {
            List needShowSubFields = this.getShowApplicationFields(responseField, appCodes);
            if (needShowSubFields.size() <= 0) continue;
            newShowFields.addAll(needShowSubFields);
        }
        return newShowFields;
    }

    private List<PcUiBotMetadataField> getShowApplicationFields(PcUiBotMetadataField metadataField, List<String> appCodes) {
        ArrayList<PcUiBotMetadataField> newShowFields = new ArrayList<PcUiBotMetadataField>();
        if (metadataField != null) {
            if ("object".equals(metadataField.getDataType())) {
                this.applicationFilterShowField(metadataField, appCodes);
            } else {
                HashSet<String> tagCategory = new HashSet<String>();
                if (metadataField.getTagDefinitions() != null) {
                    for (PcUiBotTagDefinition tag : metadataField.getTagDefinitions()) {
                        if (!"APPLICATION".equals(tag.getCategory())) continue;
                        tagCategory.add(tag.getCategory());
                        if (!appCodes.contains(tag.getCode())) continue;
                        newShowFields.add(metadataField);
                    }
                }
                if (tagCategory.size() == 0) {
                    newShowFields.add(metadataField);
                }
            }
            if ("object".equals(metadataField.getDataType()) && newShowFields.size() == 0) {
                newShowFields.add(metadataField);
            }
        }
        return newShowFields;
    }
}

