/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmTab;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SignTagService {
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";

    public void sinTagToMetadata(PcUiBotTaggingData taggingData, PcUiBotApiMetadata masterApiMetadata) {
        if (taggingData == null || CollectionUtils.isEmpty((Collection)taggingData.getMetadataTagResult())) {
            this.signCustomizeTagToAllFields(masterApiMetadata);
        } else if (taggingData != null) {
            this.signTagMetadataToFields(masterApiMetadata, taggingData);
        }
    }

    private void signCustomizeTagToAllFields(PcUiBotApiMetadata masterApiMetadata) {
        if (masterApiMetadata == null) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)masterApiMetadata.getRequestFields())) {
            List requestMetadataFields = masterApiMetadata.getRequestFields();
            this.signCustomizeTag(requestMetadataFields);
        }
        List responseMetadataFields = masterApiMetadata.getResponseFields();
        this.signCustomizeTag(responseMetadataFields);
    }

    public void signCustomizeTagForTest(List<PcUiBotMetadataField> metadataFields) {
        this.signCustomizeTag(metadataFields);
    }

    private void signCustomizeTag(List<PcUiBotMetadataField> metadataFields) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return;
        }
        for (PcUiBotMetadataField metadataField : metadataFields) {
            if (CollectionUtils.isEmpty((Collection)metadataField.getTagDefinitions())) {
                metadataField.setTagDefinitions(PcUiBotDefaultTagUtils.createDataTypeTagDefinitions((PcUiBotMetadataField)metadataField));
            }
            if (CollectionUtils.isEmpty((Collection)metadataField.getSubFields())) continue;
            this.signCustomizeTag(metadataField.getSubFields());
        }
    }

    private void markCustomTagFromTab(List<PcUiBotMetadataField> needShowAppFields, List<PcUiBotTmTab> tabs) {
        if (CollectionUtils.isEmpty(tabs) || CollectionUtils.isEmpty(needShowAppFields)) {
            return;
        }
        Map tabTargetMap = tabs.stream().collect(Collectors.toMap(PcUiBotTmTab::getTarget, Function.identity(), (v1, v2) -> v2));
        this.markCustomTagFromConfig(needShowAppFields, tabTargetMap);
    }

    public void markCustomTagFromConfig(List<PcUiBotMetadataField> needShowAppFields, PcUiBotPageDefine pageDefine) {
        List tabs = pageDefine.getTabs();
        this.markCustomTagFromTab(needShowAppFields, tabs);
        List operations = pageDefine.getOperations();
        if (!CollectionUtils.isEmpty((Collection)operations)) {
            for (PcUiBotOperationDTO operation : operations) {
                this.markCustomTagFromTab(needShowAppFields, operation.getTabs());
            }
        }
    }

    private void markCustomTagFromConfig(List<PcUiBotMetadataField> metadataFields, Map<String, PcUiBotTmTab> tabTargetMap) {
        for (PcUiBotMetadataField metadataField : metadataFields) {
            PcUiBotTmTab tmTab;
            List subFields = metadataField.getSubFields();
            if (!CollectionUtils.isEmpty((Collection)subFields)) {
                this.markCustomTagFromConfig(subFields, tabTargetMap);
            }
            if ((tmTab = tabTargetMap.get(metadataField.getPath() + "." + metadataField.getName())) == null) continue;
            PcUiBotTagDefinition tagDefinition = PcUiBotTagUtil.buildGroupTagDefinition((String)"TAB");
            List tagDefinitions = metadataField.getTagDefinitions();
            if (tagDefinitions == null) {
                metadataField.setTagDefinitions((List)Lists.newArrayList((Object[])new PcUiBotTagDefinition[]{tagDefinition}));
                continue;
            }
            tagDefinitions.add(tagDefinition);
        }
    }

    public void signTagMetadataToFields(PcUiBotApiMetadata masterApiMetadata, PcUiBotTaggingData metadataTagsList) {
        List responseTagResult;
        if (masterApiMetadata == null) {
            return;
        }
        if (metadataTagsList == null || !masterApiMetadata.getActionId().equals(metadataTagsList.getMetadataId())) {
            return;
        }
        List metadataMetadataTagResultList = metadataTagsList.getMetadataTagResult();
        List requestTagResult = metadataMetadataTagResultList.stream().filter(metadataTagResult -> metadataTagResult.getResourceContent() != null && metadataTagResult.getResourceContent().getResponse().contains(".request.")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(requestTagResult)) {
            String prefix = masterApiMetadata.getActionId() + ".request.";
            for (PcUiBotMetadataTagResult metadataTagResult2 : requestTagResult) {
                this.signTag(prefix, masterApiMetadata.getRequestFields(), metadataTagResult2);
            }
        }
        if (!CollectionUtils.isEmpty(responseTagResult = metadataMetadataTagResultList.stream().filter(metadataTagResult -> metadataTagResult.getResourceContent() != null && metadataTagResult.getResourceContent().getResponse().contains(".response.")).collect(Collectors.toList()))) {
            String prefix = masterApiMetadata.getActionId() + ".response.";
            for (PcUiBotMetadataTagResult metadataTagResult3 : responseTagResult) {
                this.signTag(prefix, masterApiMetadata.getResponseFields(), metadataTagResult3);
            }
        }
    }

    private void signTag(String prefix, List<PcUiBotMetadataField> metadataFields, PcUiBotMetadataTagResult metadataTagResult) {
        List tagDefinitions = metadataTagResult.getTagDefinitions();
        String fullPath = metadataTagResult.getResourceContent().getResponse().replace(prefix, "");
        for (PcUiBotMetadataField metadataField : metadataFields) {
            PcUiBotMetadataField existField = metadataField.findByFullPath(fullPath);
            if (existField == null) continue;
            if (!CollectionUtils.isEmpty((Collection)existField.getTagDefinitions())) {
                existField.getTagDefinitions().addAll(tagDefinitions);
            } else {
                existField.setTagDefinitions(tagDefinitions);
            }
            PcUiBotDefaultTagUtils.createDataTypeTagDefinition((PcUiBotMetadataField)existField, (PcUiBotMetadataTagResult)metadataTagResult);
            break;
        }
    }
}

