/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotRelationTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTagRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotMetadataTagResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotThemeMapTag;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TagService {
    private static final String TEMPLATE = "TEMPLATE";
    private static final String TEMPLATE_PREFIX = "TEMPLATE_";
    private static final String MOBILEPLATFORM = "mobileplatform_";
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public PcUiBotTaggingData getThemeMapTag(String queryTagSuffix, PcUiBotRelationTag relationTag, String metadataId, String sourceType, PcUiBotExecuteContext executeContext) {
        List metadataMetadataTagResults;
        if (Objects.isNull(relationTag)) {
            return null;
        }
        String activityId = relationTag.getActivityId();
        PcUiBotTaggingData metadataTags = new PcUiBotTaggingData();
        ArrayList<String> relationIds = new ArrayList<String>();
        ArrayList<String> relationIdsDIALOG = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)relationTag.getIdentity())) {
            relationIdsDIALOG.add(relationTag.getIdentity());
            relationIds.add(relationTag.getIdentity());
        }
        if (StringUtils.isNotBlank((CharSequence)activityId)) {
            relationIdsDIALOG.add(activityId + queryTagSuffix);
            relationIds.add(activityId);
        }
        PcUiBotTagRequest tagRequest = PcUiBotTagRequest.builder().resourceId(metadataId).relationIds(relationIds).activityCode(activityId).build();
        if (CollectionUtils.isEmpty(relationIds)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)queryTagSuffix)) {
            PcUiBotTagRequest dialogTagRequest = (PcUiBotTagRequest)JsonUtil.objectToJavaObject((Object)tagRequest, PcUiBotTagRequest.class);
            dialogTagRequest.setRelationIds(relationIdsDIALOG);
            metadataMetadataTagResults = this.getMetadataTag(executeContext, dialogTagRequest);
            if (CollectionUtils.isEmpty((Collection)metadataMetadataTagResults)) {
                metadataMetadataTagResults = this.getMetadataTag(executeContext, tagRequest);
            }
        } else {
            metadataMetadataTagResults = this.getMetadataTag(executeContext, tagRequest);
        }
        if (CollectionUtils.isEmpty((Collection)metadataMetadataTagResults)) {
            return null;
        }
        metadataMetadataTagResults = this.filterTagByClientAgent(metadataMetadataTagResults, executeContext.getClientAgent());
        metadataMetadataTagResults = this.filterTagBySourceType(metadataMetadataTagResults, sourceType);
        this.orderTagHandle(metadataMetadataTagResults);
        this.positionTagHandle(metadataMetadataTagResults);
        this.groupTagHandle(metadataMetadataTagResults);
        this.applicationTagHandle(metadataMetadataTagResults);
        this.otherTagHandle(metadataMetadataTagResults);
        metadataTags.setMetadataId(metadataId);
        metadataTags.setMetadataTagResult(metadataMetadataTagResults);
        return this.orderTag(metadataTags);
    }

    private List<PcUiBotMetadataTagResult> getMetadataTag(PcUiBotExecuteContext executeContext, PcUiBotTagRequest tagRequest) {
        HashMap<String, String> features = new HashMap<String, String>(1);
        features.put("deviceType", "mobile");
        DigiwinAthenaApiRequest apiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getAuthoredUser().getTenantId())).bodyPayloadMap("resourceId", (Object)tagRequest.getResourceId()).bodyPayloadMap("relationIds", (Object)tagRequest.getRelationIds()).bodyPayloadMap("activityCode", (Object)tagRequest.getActivityCode()).bodyPayloadMap("features", features).build();
        List rawTagQueryResults = this.digiwinKnowledgeMapsProxyService.getTagQueryResult(apiRequest);
        return (List)JsonUtil.objectToJavaObject((Object)rawTagQueryResults, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void applicationTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            for (PcUiBotThemeMapTag themeMapTag : metadataTagResult.getTags()) {
                if (!"APPLICATION".equals(themeMapTag.getCategory())) continue;
                themeMapTag.setCategory("APPLICATION");
                themeMapTag.setUiBotCode(themeMapTag.getCode());
            }
        }
    }

    private PcUiBotTaggingData orderTag(PcUiBotTaggingData metadataTags) {
        PcUiBotTaggingData newTag = new PcUiBotTaggingData();
        newTag.setMetadataTagResult(new ArrayList());
        newTag.setMetadataId(metadataTags.getMetadataId());
        int[] index = new int[metadataTags.getMetadataTagResult().size()];
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTags.getMetadataTagResult()) {
            if (metadataTagResult.getTags() == null || metadataTagResult.getTags().size() <= 0) continue;
            int insertIndex = -1;
            for (PcUiBotThemeMapTag tag : metadataTagResult.getTags()) {
                int i;
                if (tag.getCategory() == null || !tag.getCategory().equals("ORDER")) continue;
                int value = Integer.valueOf(tag.getValue());
                for (i = 0; i < index.length; ++i) {
                    int existValue = index[i];
                    if (existValue != 0) {
                        if (value > existValue) continue;
                        insertIndex = i;
                        break;
                    }
                    insertIndex = i;
                    break;
                }
                if (index[insertIndex] > 0) {
                    for (i = index.length - 1; i > insertIndex; --i) {
                        index[i] = index[i - 1];
                    }
                }
                index[insertIndex] = value;
                break;
            }
            if (insertIndex > -1) {
                newTag.getMetadataTagResult().add(insertIndex, metadataTagResult);
                continue;
            }
            newTag.getMetadataTagResult().add(metadataTagResult);
        }
        return newTag;
    }

    private List<PcUiBotMetadataTagResult> filterTagBySourceType(List<PcUiBotMetadataTagResult> metadataMetadataTagResults, String sourceType) {
        ArrayList<PcUiBotMetadataTagResult> newMetadataMetadataTagResults = new ArrayList<PcUiBotMetadataTagResult>();
        if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
            return newMetadataMetadataTagResults;
        }
        for (PcUiBotMetadataTagResult metadataMetadataTagResultDTO : metadataMetadataTagResults) {
            PcUiBotMetadataTagResult metadataTagResult = new PcUiBotMetadataTagResult();
            ArrayList<PcUiBotThemeMapTag> newTags = new ArrayList<PcUiBotThemeMapTag>();
            if (CollectionUtils.isEmpty((Collection)metadataMetadataTagResultDTO.getTags()) && !sourceType.equals(TEMPLATE)) {
                metadataTagResult.setResourceContent(metadataMetadataTagResultDTO.getResourceContent());
                newMetadataMetadataTagResults.add(metadataTagResult);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)metadataMetadataTagResultDTO.getTags())) continue;
            for (PcUiBotThemeMapTag tag : metadataMetadataTagResultDTO.getTags()) {
                boolean isTemplate = false;
                if (TEMPLATE.equals(sourceType)) {
                    if (!StringUtils.startsWith((CharSequence)tag.getCode(), (CharSequence)TEMPLATE_PREFIX)) continue;
                    tag.setCode(StringUtils.substringAfterLast((String)tag.getCode(), (String)TEMPLATE_PREFIX));
                    newTags.add(tag);
                    continue;
                }
                if (StringUtils.startsWith((CharSequence)tag.getCode(), (CharSequence)TEMPLATE_PREFIX)) {
                    isTemplate = true;
                }
                if (isTemplate || StringUtils.contains((CharSequence)tag.getCode(), (CharSequence)TEMPLATE)) continue;
                newTags.add(tag);
            }
            if (CollectionUtils.isEmpty(newTags)) continue;
            metadataTagResult.setResourceContent(metadataMetadataTagResultDTO.getResourceContent());
            metadataTagResult.setTags(newTags);
            newMetadataMetadataTagResults.add(metadataTagResult);
        }
        return newMetadataMetadataTagResults;
    }

    private List<PcUiBotMetadataTagResult> filterTagByClientAgent(List<PcUiBotMetadataTagResult> metadataMetadataTagResults, String clientAgent) {
        ArrayList<PcUiBotMetadataTagResult> newMetadataTags = new ArrayList<PcUiBotMetadataTagResult>();
        if (CollectionUtils.isEmpty(metadataMetadataTagResults)) {
            return newMetadataTags;
        }
        for (PcUiBotMetadataTagResult metadataMetadataTagResultDTO : metadataMetadataTagResults) {
            ArrayList<PcUiBotThemeMapTag> newTags = new ArrayList<PcUiBotThemeMapTag>();
            for (PcUiBotThemeMapTag tag : metadataMetadataTagResultDTO.getTags()) {
                if ("mobileplatform".equals(clientAgent)) {
                    if (!tag.getCode().contains(MOBILEPLATFORM)) continue;
                    tag.setCode(StringUtils.substringAfterLast((String)tag.getCode(), (String)MOBILEPLATFORM));
                    newTags.add(tag);
                    continue;
                }
                if (tag.getCode().contains(MOBILEPLATFORM)) continue;
                newTags.add(tag);
            }
            if (CollectionUtils.isEmpty(newTags)) continue;
            PcUiBotMetadataTagResult newMetadataMetadataTagResultDTO = new PcUiBotMetadataTagResult();
            newMetadataMetadataTagResultDTO.setTags(newTags);
            newMetadataMetadataTagResultDTO.setResourceContent(metadataMetadataTagResultDTO.getResourceContent());
            newMetadataTags.add(newMetadataMetadataTagResultDTO);
        }
        return newMetadataTags;
    }

    private void orderTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            boolean orderRemoveFlag = false;
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag)themeMapTags.next();
                if (!"ORDER".equals(themeMapTag.getCategory())) continue;
                if (!orderRemoveFlag) {
                    orderRemoveFlag = true;
                    themeMapTag.setValue(StringUtils.substringAfterLast((String)themeMapTag.getCode(), (String)"ORDER_"));
                    if (themeMapTag.getValue() == null) {
                        themeMapTag.setValue("0");
                    }
                    themeMapTag.setCategory("ORDER");
                    themeMapTag.setUiBotCode("ORDER");
                    continue;
                }
                themeMapTags.remove();
            }
        }
    }

    private void groupTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            boolean orderRemoveFlag = false;
            Iterator themeMapTags = metadataTagResult.getTags().iterator();
            while (themeMapTags.hasNext()) {
                PcUiBotThemeMapTag themeMapTag = (PcUiBotThemeMapTag)themeMapTags.next();
                if (!"GROUP".equals(themeMapTag.getCategory())) continue;
                if (!orderRemoveFlag) {
                    orderRemoveFlag = true;
                    themeMapTag.setUiBotCode("GROUP");
                    themeMapTag.setCategory("GROUP");
                    themeMapTag.setTitle(themeMapTag.getName());
                    themeMapTag.setValue(themeMapTag.getCode());
                    if (themeMapTag.getCode().startsWith("GROUPTITLE_")) {
                        themeMapTag.setGroupFieldShowTitle("Y");
                        continue;
                    }
                    themeMapTag.setGroupFieldShowTitle("N");
                    continue;
                }
                themeMapTags.remove();
            }
        }
    }

    private void positionTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            for (PcUiBotThemeMapTag themeMapTag : metadataTagResult.getTags()) {
                if (!"HEAD".equals(themeMapTag.getCode())) continue;
                themeMapTag.setValue("HEAD");
                themeMapTag.setUiBotCode("HEAD");
                themeMapTag.setCategory("POSITION");
            }
        }
    }

    private void otherTagHandle(List<PcUiBotMetadataTagResult> metadataTagResults) {
        for (PcUiBotMetadataTagResult metadataTagResult : metadataTagResults) {
            for (PcUiBotThemeMapTag themeMapTag : metadataTagResult.getTags()) {
                if (!StringUtils.isBlank((CharSequence)themeMapTag.getUiBotCode())) continue;
                themeMapTag.setCategory("BUSINESS");
                themeMapTag.setUiBotCode(themeMapTag.getCode());
            }
        }
    }
}

