/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionCreateServiceBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmServiceInvokeType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TaskEngineActionCreateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class TaskEngineActionCreateService
extends ActionCreateServiceBase {
    private static HashMap<BpmServiceInvokeType, String> uriMap = new HashMap();

    TaskEngineActionCreateService() {
        uriMap.put(BpmServiceInvokeType.TerminateProcess, "api/project/terminate");
        uriMap.put(BpmServiceInvokeType.TerminateTask, "api/task/terminate");
        uriMap.put(BpmServiceInvokeType.SubmitData, "api/task/manual/submit-data");
        uriMap.put(BpmServiceInvokeType.StartNewProject, "api/task/manual/submit-data");
        uriMap.put(BpmServiceInvokeType.Dispatch, "v2/api/backlog/dispatch");
        uriMap.put(BpmServiceInvokeType.TaskEngineReAssign, "api/task/manual/reassign");
        uriMap.put(BpmServiceInvokeType.Agree, "v2/api/workitem/approve/agree");
        uriMap.put(BpmServiceInvokeType.Disagree, "v2/api/workitem/approve/disagree");
        uriMap.put(BpmServiceInvokeType.ReAssign, "api/task/approve/work/reassign");
        uriMap.put(BpmServiceInvokeType.ReExecute, "v2/api/workitem/approve/re-do");
        uriMap.put(BpmServiceInvokeType.ReApprove, "v2/api/workitem/approve/re-sign");
        uriMap.put(BpmServiceInvokeType.AddTask, "v2/api/workitem/approve/add");
        uriMap.put(BpmServiceInvokeType.Retrieve, "api/task/card/retrieve");
        uriMap.put(BpmServiceInvokeType.UpdateData, "v2/api/workitem/data/update");
        uriMap.put(BpmServiceInvokeType.TaskReturn, "api/task/card/taskReturn");
    }

    public PcUiBotSubmitAction createAction(String serviceName, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, String dataFrom) {
        BpmServiceInvokeType invokeType = BpmServiceInvokeType.nameOf((String)serviceName);
        PcUiBotSubmitAction action = this.createSubmitAction(invokeType, taskWithBacklogData, dataFrom);
        Map paras = action.getParas();
        DigiwinAtmcBacklogData backlogData = (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0);
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$proxy$uibot$pcservice$activity$service$BpmServiceInvokeType[invokeType.ordinal()]) {
            case 1: {
                if (action.getExtendParas() == null) {
                    action.setExtendParas(new HashMap());
                }
                if (action.getExtendParas().containsKey("dataSource")) break;
                action.getExtendParas().put("dataSource", "parent");
                break;
            }
            case 2: 
            case 3: {
                paras.put("newPerformerId", "");
                break;
            }
            case 4: {
                paras.put("activityId", "");
                break;
            }
            case 5: {
                paras.put("addType", "BackwardDispatch");
                ArrayList activities = new ArrayList();
                HashMap<String, String> activity = new HashMap<String, String>();
                activity.put("activityName", backlogData.getPerformerName() + " \u52a0\u7b7e");
                activity.put("signType", "single");
                activity.put("performerIds", "");
                activities.add(activity);
                paras.put("activities", activities);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (!paras.containsKey("dispatchData")) break;
                ArrayList dispatchData = new ArrayList();
                paras.put("dispatchData", dispatchData);
                break;
            }
        }
        return action;
    }

    private PcUiBotSubmitAction createSubmitAction(BpmServiceInvokeType invokeType, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, String dataFrom) {
        if (!uriMap.containsKey(invokeType)) {
            String message = "\u6682\u4e0d\u652f\u6301\u5f53\u524d\u7c7b\u578b\u7684\u63d0\u4ea4:" + invokeType.getName();
            throw new ServiceException(message);
        }
        if (invokeType == BpmServiceInvokeType.TerminateProcess) {
            return this.createTerminateProcessAction(taskWithBacklogData);
        }
        if (invokeType == BpmServiceInvokeType.TerminateTask) {
            return this.createTerminateTaskAction(taskWithBacklogData);
        }
        DigiwinAtmcBacklogData backlogData = (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0);
        Map map = (Map)backlogData.getWorkitemList().get(0);
        String performerId = MapUtil.getStr((Map)map, (Object)"performerId");
        String workitemId = MapUtil.getStr((Map)map, (Object)"workitemId");
        Integer performerType = MapUtil.getInt((Map)map, (Object)"performerType");
        if (Objects.equals(((Map)backlogData.getWorkitemList().get(0)).get("state"), 3)) {
            performerType = 0;
        }
        String serviceUri = (String)uriMap.get(invokeType);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(invokeType.getTitle());
        action.setCategory("TaskEngine");
        action.setServiceId(this.createActionServiceId(serviceUri, invokeType.getName()));
        action.setTrackCode("SUBMIT");
        HashMap<String, Object> paras = new HashMap<String, Object>();
        String workItemId = workitemId;
        if (workItemId == null) {
            String message = String.format("\u4efb\u52a1\u7684workitemId\u4e3a\u7a7a\uff0c\u4efb\u52a1%s\u6709\u5f02\u5e38", backlogData.getBacklogId());
            throw new ServiceException(message);
        }
        paras.put("workitemId", workitemId);
        paras.put("performerType", performerType);
        paras.put("performerId", performerId);
        if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
            paras.put("performerType", 1);
            paras.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
        }
        paras.put("comment", "");
        paras.put("locale", AppRequestContext.getContextEntity().getLocale());
        action.setParas(paras);
        if (Objects.equals(dataFrom, "PTM") && (invokeType == BpmServiceInvokeType.SubmitData || invokeType == BpmServiceInvokeType.TaskEngineReAssign)) {
            action.setCategory("PTM");
            paras.put("backlogId", backlogData.getPtmBacklogId());
            ArrayList dispatchDataList = new ArrayList();
            paras.put("dispatchData", dispatchDataList);
            if (invokeType == BpmServiceInvokeType.SubmitData) {
                action.getServiceId().setServiceUri("api/task/card/submit");
            } else {
                action.getServiceId().setServiceUri("api/task/card/reassign");
            }
        }
        return action;
    }

    private PcUiBotSubmitAction createTerminateProcessAction(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        BpmServiceInvokeType invokeType = BpmServiceInvokeType.TerminateProcess;
        if (!uriMap.containsKey(invokeType)) {
            String message = "\u6682\u4e0d\u652f\u6301\u5f53\u524d\u7c7b\u578b\u7684\u63d0\u4ea4:" + invokeType.getName();
            throw new ServiceException(message);
        }
        DigiwinAtmcBacklogData backlogData = (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0);
        String performerId = ((Map)backlogData.getWorkitemList().get(0)).get("performerId").toString();
        Integer performerType = Integer.parseInt(((Map)backlogData.getWorkitemList().get(0)).get("performerType").toString());
        if (Objects.equals(((Map)backlogData.getWorkitemList().get(0)).get("state"), 3)) {
            performerType = 0;
        }
        String serviceUri = (String)uriMap.get(invokeType);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(invokeType.getTitle());
        action.setCategory("TaskEngine");
        action.setServiceId(this.createActionServiceId(serviceUri, invokeType.getName()));
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("serialNumber", taskWithBacklogData.getProcessSerialNumber());
        paras.put("performerType", performerType);
        paras.put("performerId", performerId);
        if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
            paras.put("performerType", 1);
            paras.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
        }
        paras.put("comment", "");
        paras.put("locale", AppRequestContext.getContextEntity().getLocale());
        action.setParas(paras);
        return action;
    }

    public PcUiBotSubmitAction createTerminateTaskAction(DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        BpmServiceInvokeType invokeType = BpmServiceInvokeType.TerminateTask;
        if (!uriMap.containsKey(invokeType)) {
            String message = "\u6682\u4e0d\u652f\u6301\u5f53\u524d\u7c7b\u578b\u7684\u63d0\u4ea4:" + invokeType.getName();
            throw new ServiceException(message);
        }
        String taskUid = taskWithBacklogData.getTaskUid();
        String serviceUri = (String)uriMap.get(invokeType);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setTitle(invokeType.getTitle());
        action.setCategory("TaskEngine");
        action.setServiceId(this.createActionServiceId(serviceUri, invokeType.getName()));
        HashMap<String, List<String>> paras = new HashMap<String, List<String>>();
        paras.put("taskUids", Arrays.asList(taskUid));
        action.setParas(paras);
        return action;
    }

    private PcUiBotActionServiceId createActionServiceId(String serviceUri, String name) {
        PcUiBotActionServiceId actionServiceId = new PcUiBotActionServiceId();
        actionServiceId.setServiceUri(serviceUri);
        actionServiceId.setName(name);
        return actionServiceId;
    }
}

