/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActionBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ActionCreateServiceBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmServiceInvokeType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotMessageUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotSubmitActionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TaskSubmitActionCreateService
extends ActionCreateServiceBase {
    @Autowired
    private BpmActionCreateService bpmService;

    public PcUiBotSubmitAction create(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction) {
        PcUiBotSubmitAction agreeAction;
        PcUiBotSubmitAction action = this.createSubmitActionInternal(executeContext, projectData, taskWithBacklogData, tmAction);
        action.setExecuteContext(PcUiBotSubmitExecuteContext.create((PcUiBotExecuteContext)executeContext, (DigiwinAtmcTaskWithBacklogData)taskWithBacklogData));
        if (tmAction.getIsCustomize() != null && tmAction.getIsCustomize().booleanValue()) {
            action.setIsCustomize(Boolean.valueOf(true));
            action.setUuid(tmAction.getUuid());
            action.setBtnId(tmAction.getBtnId());
            action.setBtnType(tmAction.getBtnType());
            action.setJumpAction(tmAction.getJumpAction());
            action.setTitle(tmAction.getTitle());
            action.setType(tmAction.getType());
            action.setSubmitType(tmAction.getSubmitType());
            if (tmAction.getSchema() != null) {
                action.setSchema(tmAction.getSchema());
            }
        }
        if (tmAction.isDispatch()) {
            agreeAction = this.createAgreeAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            action.getAttachActions().add(agreeAction);
        }
        if (tmAction.isTerminateProcess()) {
            agreeAction = this.createTerminateProcessAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            action.getAttachActions().add(agreeAction);
        }
        action.setExecuteAfterCheckCompleted(tmAction.getExecuteAfterCheckCompleted());
        return action;
    }

    private PcUiBotSubmitAction createSubmitActionInternal(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction) {
        PcUiBotSubmitAction action = null;
        if ("BPM".equals(tmAction.getType())) {
            if (Objects.equals("dispatch", tmAction.getServiceName()) || Objects.equals("agree", tmAction.getServiceName())) {
                action = this.createAgreeAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("terminate", tmAction.getServiceName())) {
                action = this.createRejectAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reassign", tmAction.getServiceName())) {
                action = this.createReassignAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reexecute", tmAction.getServiceName())) {
                action = this.createReExecuteAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("terminate-process", tmAction.getServiceName())) {
                action = this.createTerminateProcessAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reapprove", tmAction.getServiceName())) {
                action = this.createReApproveAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("add-task", tmAction.getServiceName())) {
                action = this.createAddTaskAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            } else if (Objects.equals("reject", tmAction.getServiceName())) {
                action = this.createRejectAction(taskWithBacklogData, (DigiwinAtmcBacklogData)taskWithBacklogData.getBacklog().get(0));
            }
            if (action != null) {
                action.setUuid(tmAction.getUuid());
                action.setBtnId(tmAction.getBtnId());
                action.setBtnType(tmAction.getBtnType());
                action.setJumpAction(tmAction.getJumpAction());
                action.setActionId(tmAction.getActionId());
                action.setTitle(PcUiBotMessageUtils.getMessageByCurrentLanguage((Object)tmAction.getTitle()));
                action.setActionParams(tmAction.getActionParams());
            }
        } else if (!"COMBINE".equals(tmAction.getType())) {
            action = this.createSubmitAction(tmAction, projectData.getTenantId(), taskWithBacklogData.getBusinessUnit(), executeContext);
            action.setDefaultAction(true);
            action.setCategory(tmAction.getType());
        }
        if (action == null) {
            String message = "\u4e0d\u652f\u6301\u7684action\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e:" + tmAction.getActionId() + tmAction.getType();
            throw new ServiceException(message);
        }
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setAttachActions(this.createAttachActions(executeContext, projectData, taskWithBacklogData, tmAction));
        action.setId(tmAction.getId());
        if (StringUtils.isBlank((CharSequence)action.getTrackCode())) {
            String trackCode = StringUtils.isNotBlank((CharSequence)tmAction.getTrackCode()) ? tmAction.getTrackCode() : "SUBMIT";
            action.setTrackCode(trackCode);
        }
        action.setSubmitType(tmAction.getSubmitType());
        PcUiBotSubmitActionUtil.setCondition((PcUiBotTmAction)tmAction, (PcUiBotSubmitAction)action);
        return action;
    }

    private PcUiBotSubmitAction createSubmitAction(PcUiBotTmAction tmAction, String tenantId, Map<String, Object> businessUnit, PcUiBotExecuteContext executeContext) {
        this.appendActionInfo((PcUiBotTmActionBase)tmAction, executeContext);
        PcUiBotSubmitAction action = new PcUiBotSubmitAction();
        action.setActionId(tmAction.getActionId());
        action.setServiceId(this.createActionServiceId((PcUiBotTmActionBase)tmAction, tenantId));
        action.setCategory(tmAction.getType());
        action.setUuid(tmAction.getUuid());
        action.setBtnId(tmAction.getBtnId());
        action.setBtnType(tmAction.getBtnType());
        action.setJumpAction(tmAction.getJumpAction());
        action.setTitle(tmAction.getTitle());
        action.setReturnText((Object)tmAction.getReturnText());
        action.setBusinessUnit(businessUnit);
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setBackFills(tmAction.getBackFills());
        action.setTargetDataState(tmAction.getTargetDataState());
        action.setConfirm(tmAction.getConfirm());
        action.setActionType(tmAction.getActionType());
        if (action.getActionType() == null && tmAction.getExtendParas() != null && tmAction.getExtendParas().containsKey("actionType")) {
            action.setActionType(tmAction.getExtendParas().get("actionType").toString());
        }
        action.setId(tmAction.getId());
        action.setActionParams(tmAction.getActionParams());
        action.setCategory(tmAction.getType());
        action.setActionParams(tmAction.getActionParams());
        action.setDefaultAction(true);
        action.setId(tmAction.getId());
        action.executeExtendParas(tmAction.getExtendParas(), executeContext);
        action.setExtendParas(tmAction.getExtendParas());
        action.setAddShowFileds(tmAction.getAddShowFileds());
        action.setDefaultAction(tmAction.isDefaultAction());
        action.setActionScript(tmAction.getActionScript());
        this.processActionParas((PcUiBotAction)action, executeContext);
        return action;
    }

    private List<PcUiBotSubmitAction> createAttachActions(PcUiBotExecuteContext executeContext, DigiwinAtmcProjectData projectData, DigiwinAtmcTaskWithBacklogData taskWithBacklogData, PcUiBotTmAction tmAction) {
        ArrayList<PcUiBotSubmitAction> attachActions = new ArrayList<PcUiBotSubmitAction>();
        if (CollectionUtils.isEmpty((Collection)tmAction.getAttachActions())) {
            return attachActions;
        }
        tmAction.getAttachActions().forEach(attachAction -> {
            PcUiBotSubmitAction submitAction = this.create(executeContext, projectData, taskWithBacklogData, attachAction);
            submitAction.setExecuteContext(null);
            attachActions.add(submitAction);
        });
        return attachActions;
    }

    public PcUiBotSubmitAction createAgreeAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createAgreeAction(taskData, backlogData);
        action.setDefaultAction(true);
        action.setTitle("\u540c\u610f");
        action.setActionId(BpmServiceInvokeType.Agree.getName());
        return action;
    }

    public PcUiBotSubmitAction createRejectAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createRejectAction(taskData, backlogData);
        action.setTitle("backlog.activity.reject");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.Reject.getName());
        return action;
    }

    public PcUiBotSubmitAction createTerminateProcessAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createTerminateProcessAction(taskData, backlogData);
        action.setTitle("\u62d2\u7edd");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.TerminateProcess.getName());
        return action;
    }

    public PcUiBotSubmitAction createReassignAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.ReAssign);
        action.setTitle("\u8f6c\u6d3e");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReAssign.getName());
        return action;
    }

    public PcUiBotSubmitAction createReExecuteAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.ReExecute);
        action.setTitle("\u9000\u56de");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
        return action;
    }

    public PcUiBotSubmitAction createReApproveAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.ReApprove);
        action.setTitle("\u91cd\u7b7e");
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
        return action;
    }

    public PcUiBotSubmitAction createAddTaskAction(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData) {
        PcUiBotSubmitAction action = this.bpmService.createAction(taskData, backlogData, BpmServiceInvokeType.AddTask);
        action.setDefaultAction(false);
        action.setActionId(BpmServiceInvokeType.ReExecute.getName());
        return action;
    }
}

