/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotRelationTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.PageBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractPageBuilder<T extends PcUiBotPageDefine>
implements PageBuilder<T>,
InitializingBean {
    @Autowired
    protected DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private PcRuleService pcRuleService;

    protected void BuildRule(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        dynamicForm.setRules((List)JsonUtil.objectToJavaObject((Object)pageDefine.getRules(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        this.resetRuleFromPresetLibrary(executeContext, dynamicForm, apiRequest);
        this.removeEditRulesIfNecessary(executeContext, dynamicForm.getRules());
        pageDefine.setRules((List)JsonUtil.objectToJavaObject((Object)dynamicForm.getRules(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected void resetRuleFromPresetLibrary(PcUiBotExecuteContext executeContext, UiBotModel dynamicForm, ApiRequest apiRequest) {
        List rules;
        PcUiBotRelationTag relationTag = executeContext.getRelationTag();
        if (relationTag != null && StringUtils.isNotEmpty((CharSequence)relationTag.getActivityId()) && !CollectionUtils.isEmpty((Collection)(rules = this.getRules(apiRequest, relationTag.getActivityId())))) {
            dynamicForm.setRules(rules);
        }
    }

    protected List<UiBotRule> getRules(ApiRequest apiRequest, String activityId) {
        return this.pcRuleService.buildRuleOfKm(activityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
    }

    protected QueryResultSet queryByPagedefineWithMetaData(PcUiBotExecuteContext executeContext, T pageDefine) {
        if (pageDefine.getDataSourceSet() == null) {
            return QueryResultSet.empty();
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("dataSourceSetDTO", pageDefine.getDataSourceSet());
        body.put("executeContext", executeContext);
        body.put("parameter", pageDefine.getParameter());
        body.put("settings", pageDefine.getSettings());
        if (pageDefine.getPageInfo() != null) {
            body.put("pageInfo", pageDefine.getPageInfo());
        }
        if (pageDefine.getSortInfo() != null && !pageDefine.getSortInfo().isEmpty()) {
            body.put("sortInfo", pageDefine.getSortInfo());
        }
        if (pageDefine.getSearchInfo() != null && !pageDefine.getSearchInfo().isEmpty()) {
            body.put("searchInfo", pageDefine.getSearchInfo());
        }
        QueryResultSet queryResultSet = this.digiwinAtdmProxyService.queryWithMetaData(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), JsonUtil.javaObjectToJsonString(body), executeContext.getAuthoredUser().getTenantId());
        try {
            this.handleQueryResultSet(queryResultSet, pageDefine, executeContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryResultSet;
    }

    private void handleQueryResultSet(QueryResultSet queryResultSet, T pageDefine, PcUiBotExecuteContext executeContext) {
        if ("DataEntry_pccProjectQuestionList".equals(executeContext.getTmActivityId())) {
            if (queryResultSet == null) {
                return;
            }
            List queryResults = queryResultSet.getQueryResults();
            if (CollectionUtils.isEmpty((Collection)queryResults)) {
                return;
            }
            for (QueryResult queryResult : queryResults) {
                List data = queryResult.getData();
                if (CollectionUtils.isEmpty((Collection)data)) continue;
                data = data.stream().sorted((o1, o2) -> {
                    LocalDate o1Data = DateTimeUtil.parseLocalDateUseDefaultPattern((String)StringUtil.valueOf(o1.get("question_happen_datetime")));
                    LocalDate o2Date = DateTimeUtil.parseLocalDateUseDefaultPattern((String)StringUtil.valueOf(o2.get("question_happen_datetime")));
                    return o2Date.compareTo(o1Data);
                }).collect(Collectors.toList());
                queryResult.setData(data);
                queryResult.setTotalResults(Integer.valueOf(data.size()));
            }
        }
    }

    protected void removeEditRulesIfNecessary(PcUiBotExecuteContext executeContext, List<UiBotRule> rules) {
        if (!(executeContext.getRelationTag() == null || CollectionUtils.isEmpty(rules) || "performer".equals(executeContext.getRelationTag().getIdentity()) && !executeContext.isShared())) {
            ListIterator<UiBotRule> ruleIterator = rules.listIterator();
            while (ruleIterator.hasNext()) {
                UiBotRule rule = (UiBotRule)ruleIterator.next();
                if (!Objects.equals("EDIT", rule.getScope())) continue;
                ruleIterator.remove();
            }
        }
    }
}

