/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotModelField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageUIElement;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotRelationTag;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmFormInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUibotSupportKeyConstant;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.TmPageOperationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.DslPageBuilderBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotConvertTmActivityUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignerBusinessDataEntryDrivenTaskBuilder
extends DslPageBuilderBase<PcUiBotTaskPageDefine> {
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private TmPageOperationService tmPageOperationService;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private LocaleService localeService;

    public String supportKey() {
        return PcUibotSupportKeyConstant.Designer.BUSINESS_DATA_ENTRY_DRIVEN;
    }

    public UiBotModel createPage(PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, ApiRequest apiRequest) {
        executeContext.setIsDesigner(Boolean.valueOf(true));
        this.buildPageDefineRawlayoutAndRules(executeContext, pageDefine);
        UiBotModel uiBotModel = super.createRawPage(executeContext, queryResultSet, (PcUiBotPageDefine)pageDefine, apiRequest);
        this.handleFieldVisibleAndBottom(executeContext, pageDefine, uiBotModel, apiRequest);
        return uiBotModel;
    }

    private void buildPageDefineRawlayoutAndRules(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        List layout;
        PcUiBotTmFormInfo bindForm = pageDefine.getBindForm();
        if (bindForm == null) {
            return;
        }
        String formCode = bindForm.getFormCode();
        if (StringUtils.isEmpty((CharSequence)formCode)) {
            return;
        }
        PcUiBotExecuteContext newExecuteContext = (PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, PcUiBotExecuteContext.class);
        newExecuteContext.setPageCode("edit-page-mobile");
        newExecuteContext.setTmActivityId(formCode);
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(newExecuteContext);
        if (CollectionUtils.isEmpty((Collection)tmActivity.getPages().getLayout())) {
            PcUiBotPageUIElement pageUIElement;
            String viewCode = PcUiBotRuntimes.getContext().get("VIEWCODE", String.class).orElse("");
            PcUiBotRuntimes.getContext().remove("VIEWCODE");
            PcUiBotRuntimes.getContext().remove("dataViewQuerys");
            if (StringUtils.isNotBlank((CharSequence)viewCode) && (pageUIElement = this.dataViewService.getDslByViewCode(viewCode, "edit-page-mobile", newExecuteContext)) != null) {
                PcUiBotTmPage pages = tmActivity.getPages();
                layout = (List)JsonUtil.objectToJavaObject((Object)pageUIElement.getLayout(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                pages.setLayout(layout);
                pages.setOperations(pageUIElement.getOperations());
                pages.setHooks(pageUIElement.getHooks());
            }
        }
        PcUiBotRelationTag relationTag = new PcUiBotRelationTag();
        relationTag.setIdentity(executeContext.getIdentity());
        relationTag.setActivityId(formCode);
        executeContext.setRelationTag(relationTag);
        PcUiBotTmPage pages = tmActivity.getPages();
        pageDefine.setHooks(pages.getHooks());
        pageDefine.setRules(pages.getRules());
        List operations = pages.getOperations();
        if (CollectionUtils.isNotEmpty((Collection)operations)) {
            this.analysisOperators(executeContext, pageDefine, tmActivity, operations);
        }
        if (BooleanUtils.isTrue((Boolean)pageDefine.getFinished())) {
            pageDefine.getRules().removeIf(ruleMap -> StringUtils.equals((CharSequence)"EDIT", (CharSequence)String.valueOf(ruleMap.get("scope"))));
        }
        if (CollectionUtils.isEmpty((Collection)(layout = tmActivity.getPages().getLayout()))) {
            return;
        }
        PcUiBotTmDataState tmDataState = new PcUiBotTmDataState();
        tmDataState.setLayout(layout);
        pageDefine.setPageLayout(tmDataState.getPageLayout());
    }

    private void handleFieldVisibleAndBottom(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel uiBotModel, ApiRequest apiRequest) {
        List pageLayout = pageDefine.getPageLayout();
        if (CollectionUtils.isEmpty((Collection)pageLayout)) {
            return;
        }
        UiBotPageLayout mainPageLayout = this.uiBotDesignerRenderService.getMainPageLayout(pageLayout, null);
        Map modelFieldMap = pageDefine.getModelFieldMap();
        if (MapUtil.isNotEmpty((Map)modelFieldMap)) {
            boolean finished = BooleanUtils.isTrue((Boolean)pageDefine.getFinished());
            this.setFieldVisible(mainPageLayout.getBody(), modelFieldMap, finished);
        }
        mainPageLayout.getBottom().clear();
        mainPageLayout.setBottom(this.buildBottom(pageDefine.getSubmitActions(), pageDefine.getDataSourceSet().getMainDatasource(), uiBotModel, apiRequest));
    }

    public void setFieldVisible(List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList, Map<String, PcUiBotModelField> modelFieldMap, boolean finished) {
        if (CollectionUtils.isEmpty(cmptList)) {
            return;
        }
        ArrayList deleteCmptList = new ArrayList();
        cmptList.forEach(componentWrapper -> {
            String componentType = componentWrapper.getComponentType();
            String componentSchema = componentWrapper.getSchema();
            String componentMobilePath = componentWrapper.getMobilePath();
            if (componentWrapper.getData() instanceof CustomGroup) {
                this.setFieldVisible(((CustomGroup)componentWrapper.getData()).getContentGroup(), modelFieldMap, finished);
            } else {
                PcUiBotModelField modelField = (PcUiBotModelField)modelFieldMap.get(componentMobilePath);
                if (modelField != null) {
                    boolean enable;
                    boolean bl = enable = finished ? false : BooleanUtils.isTrue((Boolean)modelField.getEditable());
                    if (componentWrapper.getData() instanceof BaseInputMobileComponent) {
                        BaseInputMobileComponent component = (BaseInputMobileComponent)componentWrapper.getData();
                        component.applyHidden(Boolean.valueOf(BooleanUtils.isTrue((Boolean)modelField.getHidden())));
                        component.applyEditable(Boolean.valueOf(enable));
                    } else {
                        BaseMobileComponent component = componentWrapper.getData();
                        component.applyHidden(Boolean.valueOf(BooleanUtils.isTrue((Boolean)modelField.getHidden())));
                        component.applyEditable(Boolean.valueOf(enable));
                    }
                } else if (finished) {
                    if (componentWrapper.getData() instanceof BaseInputMobileComponent) {
                        BaseInputMobileComponent component = (BaseInputMobileComponent)componentWrapper.getData();
                        component.applyEditable(Boolean.valueOf(false));
                    } else {
                        BaseMobileComponent component = componentWrapper.getData();
                        component.applyEditable(Boolean.valueOf(false));
                    }
                }
            }
        });
        cmptList.removeAll(deleteCmptList);
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(List<PcUiBotSubmitAction> submitActions, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(submitActions, dataSourceName, uiBotModel, apiRequest));
        return Lists.newArrayList((Object[])new BaseMobileComponentWrapper[]{new BaseMobileComponentWrapper((BaseMobileComponent)buttonGroup, "DW_BUTTON_GROUP")});
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(List<PcUiBotSubmitAction> submitActions, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        ArrayList<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>>();
        if (CollectionUtils.isEmpty(submitActions)) {
            return contentGroup;
        }
        boolean isReverse = true;
        for (PcUiBotSubmitAction submitAction : submitActions) {
            if ("StartProject".equals(Optional.ofNullable(submitAction.getExecuteContext()).map(PcUiBotSubmitExecuteContext::getCategory).orElse(""))) {
                contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildStartProjectButton(submitAction));
                continue;
            }
            if ("basic-data-update".equals(submitAction.getActionType())) {
                isReverse = false;
                contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildBasicDataUpdataButton(submitAction));
                continue;
            }
            switch (submitAction.getId() == null ? "" : submitAction.getId()) {
                case "workflow-act-submit": {
                    contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildSubmitButton(submitAction));
                    break;
                }
                case "workflow-act-agree": {
                    contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildAgreeButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                    break;
                }
                case "workflow-act-disagree": {
                    contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildDisagreeButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                    break;
                }
                case "workflow-act-add": {
                    contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildAddButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                    break;
                }
                case "workflow-act-return": 
                case "athena.workflow.process.activity.return": {
                    contentGroup.add((BaseMobileComponentWrapper<BottomButtonDigiwinAthena>)this.buildReturnButton(submitAction, dataSourceName, uiBotModel, apiRequest));
                    break;
                }
                case "workflow-act-reassignment": {
                    break;
                }
            }
        }
        if (isReverse) {
            Collections.reverse(contentGroup);
        }
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildReturnButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(false));
        Map extendedFields = TaskDataExtractUtil.getWorkflowProgressRawData((UiBotPageData)uiBotModel.getPageData());
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest, extendedFields));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        button.setIconData(Integer.valueOf(58978));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildAddButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(false));
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        button.setIconData(Integer.valueOf(59003));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildDisagreeButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(false));
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        button.setIconData(Integer.valueOf(58982));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    public BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildAgreeButton(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_AGREE.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(false));
        uiBotJumpAction.setRawData(this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private Map<String, Object> buildRawData(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest) {
        return this.buildRawData(submitAction, dataSourceName, uiBotModel, apiRequest, null);
    }

    private Map<String, Object> buildRawData(PcUiBotSubmitAction submitAction, String dataSourceName, UiBotModel uiBotModel, ApiRequest apiRequest, Map<String, Object> extendedFields) {
        UiBotAction uiBotAction = (UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class);
        DigiwinAtmcBacklogDetail backlogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId());
        return BottomButtonDigiwinAthena.assembleRawData((UiBotAction)uiBotAction, (String)dataSourceName, (Object)uiBotModel.getPageData().get((Object)dataSourceName), extendedFields, (String)submitAction.getId(), (String)Optional.ofNullable(backlogDetail).map(DigiwinAtmcBacklogDetail::getAppCode).orElse(""));
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSubmitButton(PcUiBotSubmitAction submitAction) {
        String id = submitAction.getId();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.REFRESH.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(true));
        uiBotJumpAction.setConfirmPop(ConfirmPop.create((String)(this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "\u662f\u5426\u786e\u5b9a") + submitAction.getTitle() + "\uff1f"), (boolean)true));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildBasicDataUpdataButton(PcUiBotSubmitAction submitAction) {
        String actionType = submitAction.getActionType();
        submitAction.setUuid(actionType);
        submitAction.setBtnId(actionType);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.REFRESH.getValue());
        uiBotJumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL.name());
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(true));
        uiBotJumpAction.setConfirmPop(ConfirmPop.create((String)(this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "\u662f\u5426\u786e\u5b9a") + submitAction.getTitle() + "\uff1f"), (boolean)true));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON");
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildStartProjectButton(PcUiBotSubmitAction submitAction) {
        String id = UUIDUtil.getUuid();
        submitAction.setUuid(id);
        submitAction.setBtnId(id);
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(submitAction.isDefaultAction() ? BottomButtonStyleEnum.STRESS.getValue() : BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setType(ActionTypeEnum.BACK.getValue());
        uiBotJumpAction.setJumpPageId("");
        uiBotJumpAction.setBusinessType(BusinessTypeEnum.OTHER.getValue());
        uiBotJumpAction.setIsCheckButton(Boolean.valueOf(true));
        uiBotJumpAction.setConfirmPop(ConfirmPop.create((String)(this.localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "\u662f\u5426\u786e\u5b9a") + submitAction.getTitle() + "\uff1f"), (boolean)true));
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction((UiBotAction)JsonUtil.objectToJavaObject((Object)submitAction, UiBotAction.class));
        button.setComponentId(id);
        button.setCmptUuid(id);
        button.setSchema(id);
        return new BaseMobileComponentWrapper((BaseMobileComponent)button, "DW_BUTTON", id);
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        KnowledgeMapsActivityDefinition rawActivityDefinition = this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        PcUiBotTmActivity tmActivity = (PcUiBotTmActivity)JsonUtil.objectToJavaObject((Object)rawActivityDefinition, PcUiBotTmActivity.class);
        PcUiBotConvertTmActivityUtils.convert((String)executeContext.getPageCode(), (String)executeContext.getLocale(), (PcUiBotTmActivity)tmActivity);
        return tmActivity;
    }

    public void analysisOperators(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, PcUiBotTmActivity tmActivity, List<PcUiBotTmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, (PcUiBotPageDefine)pageDefine, tmActivity, operations);
        if (!"project-detail-mobile".equals(executeContext.getPageCode()) && BooleanUtils.isTrue((Boolean)pageDefine.getFinished())) {
            pageDefine.setOperations(this.filterActiveOperationsWhenBacklogFinished(pageDefine.getOperations()));
        }
    }

    protected List<PcUiBotOperationDTO> filterActiveOperationsWhenBacklogFinished(List<PcUiBotOperationDTO> operationList) {
        if (CollectionUtils.isEmpty(operationList)) {
            return operationList;
        }
        return operationList.stream().filter(operation -> BooleanUtils.isTrue((Boolean)operation.getApplyAlthoughFinished())).collect(Collectors.toList());
    }
}

