/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsDataViewQueryResult;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotTmPageUIElements;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewQuerySetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageUIElement;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataViewQuery;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmViewShowFields;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmViewShowFieldsMobile;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.DataViewService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.DataViewPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.GeneralDataSourceService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.DataViewPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl.DataViewRawDslRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataViewServiceImpl
implements DataViewService {
    private static final Logger log = LoggerFactory.getLogger(DataViewServiceImpl.class);
    private static final String DATA_VIEW_SERVICE_NAME = "modeldriven.commons.eai.dataview.get";
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private GeneralDataSourceService generalDataSourceService;
    @Autowired
    private DataViewRawDslRenderService dataViewRawDslRenderService;
    @Autowired
    private DataViewPageDefineAnalyzer dataViewPageDefineAnalyzer;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DataViewPageBuilder dataViewPageBuilder;

    public UiBotModel createDynamicForm(PcUiBotDataViewPageDefine dataViewPageDefine, ApiRequest apiRequest) {
        List pageDefines = this.dataViewPageDefineAnalyzer.analysis(dataViewPageDefine);
        if (CollectionUtils.isEmpty((Collection)pageDefines)) {
            return UiBotModel.emptyUiBotModel();
        }
        PcUiBotDataViewPageDefine dataViewPageDefineInner = (PcUiBotDataViewPageDefine)pageDefines.get(0);
        PcUiBotExecuteContext executeContextInner = dataViewPageDefineInner.getExecuteContext();
        QueryResultSet queryResultSet = this.queryByPagedefineWithMetaData(executeContextInner, dataViewPageDefineInner);
        dataViewPageDefineInner.resetUseHasNext(queryResultSet);
        this.buildCurrentDataViewQueryList(dataViewPageDefineInner);
        return this.dataViewPageBuilder.createPage(executeContextInner, queryResultSet, (PcUiBotPageDefine)dataViewPageDefineInner, apiRequest);
    }

    private void buildCurrentDataViewQueryList(PcUiBotDataViewPageDefine dataViewPageDefineInner) {
        PcUiBotDataViewQueryDTO dataViewQueryDTO = new PcUiBotDataViewQueryDTO();
        dataViewQueryDTO.setViewCode(dataViewPageDefineInner.getViewCode());
        dataViewQueryDTO.setViewName(dataViewPageDefineInner.getViewName());
        dataViewPageDefineInner.setDataViewQueryList((List)Lists.newArrayList((Object[])new PcUiBotDataViewQueryDTO[]{dataViewQueryDTO}));
    }

    private QueryResultSet queryByPagedefineWithMetaData(PcUiBotExecuteContext executeContext, PcUiBotDataViewPageDefine pageDefine) {
        if (pageDefine.getDataSourceSet() == null) {
            return QueryResultSet.empty();
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("dataSourceSetDTO", pageDefine.getDataSourceSet());
        body.put("executeContext", executeContext);
        body.put("parameter", pageDefine.getParameter());
        body.put("settings", pageDefine.getSettings());
        if (pageDefine.getPageInfo() != null) {
            body.put("pageInfo", pageDefine.getPageInfo());
        }
        if (pageDefine.getSortInfo() != null && !pageDefine.getSortInfo().isEmpty()) {
            body.put("sortInfo", pageDefine.getSortInfo());
        }
        if (pageDefine.getSearchInfo() != null && !pageDefine.getSearchInfo().isEmpty()) {
            body.put("searchInfo", pageDefine.getSearchInfo());
        }
        return this.digiwinAtdmProxyService.queryWithMetaData(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), JsonUtil.javaObjectToJsonString(body), executeContext.getAuthoredUser().getTenantId());
    }

    public void appendNecessaryData(String viewCode, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotExecuteContext executeContext) {
        if (StringUtils.isBlank((CharSequence)viewCode) || !this.needAppendData((PcUiBotPageDefine)pageDefine)) {
            return;
        }
        PcUiBotTmDataViewQuery tmDataViewQuery = this.queryDataView(viewCode, executeContext);
        this.checkDataViewConfig(tmDataViewQuery);
        this.appendDataSourceSet(viewCode, pageDefine, tmDataViewQuery);
        this.appendLayout(executeContext, pageDefine, tmDataViewQuery);
    }

    private boolean needAppendData(PcUiBotPageDefine pageDefine) {
        return CollectionUtils.isEmpty((Collection)pageDefine.getPageLayout()) || pageDefine.dataSourceSetEmpty();
    }

    public PcUiBotTmDataViewQuery queryDataView(String viewCode, PcUiBotExecuteContext executeContext) {
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).bodyPayloadMap("viewCodes", (Object)Lists.newArrayList((Object[])new String[]{viewCode})).build();
        KnowledgeMapsDataViewQueryResult dataViewQueryResult = this.digiwinKnowledgeMapsProxyService.queryDataViewList(athenaApiRequest);
        if (dataViewQueryResult == null || CollectionUtils.isEmpty((Collection)dataViewQueryResult.getDataViews())) {
            throw new IllegalStateException("Data view obtained from KM is empty, dataViewCode: " + viewCode);
        }
        return (PcUiBotTmDataViewQuery)dataViewQueryResult.getDataViews().get(0);
    }

    public PcUiBotTmQueryAction buildTmQueryAction(String viewCode, PcUiBotExecuteContext executeContext) {
        PcUiBotTmDataViewQuery tmDataViewQueryDefault = this.queryDataView(viewCode, executeContext);
        return this.buildTmQueryAction(tmDataViewQueryDefault);
    }

    public PcUiBotTmQueryAction buildTmQueryAction(PcUiBotTmQueryAction tmQueryAction, PcUiBotTmDataViewQuery tmDataViewQueryDefault) {
        PcUiBotTmQueryAction tmQueryActionFromDataView = this.buildTmQueryAction(tmDataViewQueryDefault);
        if (tmQueryAction != null) {
            tmQueryActionFromDataView.setActionParams(tmQueryAction.getActionParams());
            tmQueryActionFromDataView.setDataKeys(tmQueryAction.getDataKeys());
            tmQueryActionFromDataView.setNotArray(tmQueryAction.getNotArray());
            tmQueryActionFromDataView.setViewCode(tmQueryAction.getViewCode());
        }
        return tmQueryActionFromDataView;
    }

    public PcUiBotTmQueryAction buildTmQueryAction(PcUiBotTmDataViewQuery tmDataViewQueryDefault) {
        PcUiBotDataViewQuerySetDTO dataViewQuerySet = PcUiBotDataViewQuerySetDTO.builder().code(tmDataViewQueryDefault.getCode()).orderList(tmDataViewQueryDefault.getOrderList()).tables(tmDataViewQueryDefault.getTables()).returnFields(tmDataViewQueryDefault.getReturnFields()).queryConditions(tmDataViewQueryDefault.getQueryConditions()).build();
        HashMap<String, PcUiBotDataViewQuerySetDTO> paras = new HashMap<String, PcUiBotDataViewQuerySetDTO>();
        paras.put("view_info", dataViewQuerySet);
        PcUiBotTmViewShowFields viewShowFields = tmDataViewQueryDefault.getViewShowFields();
        String dataSourceName = viewShowFields.getDataName();
        PcUiBotTmQueryAction tmQueryAction = new PcUiBotTmQueryAction();
        tmQueryAction.setName(dataSourceName);
        tmQueryAction.setServiceName(DATA_VIEW_SERVICE_NAME);
        tmQueryAction.setType("ESP");
        tmQueryAction.setProductName(tmDataViewQueryDefault.getProductCode());
        tmQueryAction.setParas(paras);
        PcUiBotMetadataField metadataField = DataViewRawDslRenderService.convertToMetadataField((PcUiBotTmViewShowFields)viewShowFields);
        tmQueryAction.setMetadataFields((List)Lists.newArrayList((Object[])new PcUiBotMetadataField[]{metadataField}));
        List subFields = metadataField.getSubFields();
        tmQueryAction.setDataKeys(PcUiBotApiMetadataUtil.getDataKeys((List)subFields));
        return tmQueryAction;
    }

    private void checkDataViewConfig(PcUiBotTmDataViewQuery tmDataViewQuery) {
        PcUiBotTmViewShowFields viewShowFields = tmDataViewQuery.getViewShowFields();
        if (viewShowFields == null) {
            throw new IllegalStateException("Data view missing configuration [viewShowFields]");
        }
    }

    private void appendDataSourceSet(String viewCode, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmDataViewQuery tmDataViewQuery) {
        if (!pageDefine.dataSourceSetEmpty()) {
            return;
        }
        PcUiBotDataSourceSetDTO dataViewDataSourceSet = this.buildDataViewDataSourceSet(pageDefine.getExecuteContext(), tmDataViewQuery);
        pageDefine.setDataSourceSet(dataViewDataSourceSet);
        Optional.ofNullable(pageDefine.getDataViewQueryList()).orElse(Lists.newArrayList()).stream().filter(dataView -> viewCode.equals(dataView.getViewCode())).findFirst().ifPresent(dataView -> dataView.setDataSourceSet(dataViewDataSourceSet));
    }

    private void appendLayout(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmDataViewQuery tmDataViewQuery) {
        if (!CollectionUtils.isEmpty((Collection)pageDefine.getPageLayout())) {
            return;
        }
        pageDefine.setPageLayout(this.buildDataViewLayout(executeContext, pageDefine, tmDataViewQuery));
    }

    private List<UiBotPageLayout> buildDataViewLayout(PcUiBotExecuteContext executeContext, PcUiBotDoubleDocumentPageDefine pageDefine, PcUiBotTmDataViewQuery tmDataViewQueryDefault) {
        PcUiBotTmViewShowFieldsMobile viewShowFields = tmDataViewQueryDefault.getViewShowFieldsMobile();
        if (viewShowFields == null) {
            log.error("ViewShowFields is null, view code: {}", (Object)tmDataViewQueryDefault.getCode());
            return Lists.newArrayList((Object[])new UiBotPageLayout[]{new UiBotPageLayout()});
        }
        return this.dataViewRawDslRenderService.bulidPageLayout(executeContext, pageDefine, viewShowFields);
    }

    private PcUiBotDataSourceSetDTO buildDataViewDataSourceSet(PcUiBotExecuteContext executeContext, PcUiBotTmDataViewQuery tmDataViewQueryDefault) {
        PcUiBotTmQueryAction tmQueryAction = this.buildTmQueryAction(tmDataViewQueryDefault);
        HashMap dataSources = MapUtil.of((Object)tmQueryAction.getName(), (Object)tmQueryAction);
        return this.generalDataSourceService.analysis(executeContext, (Map)dataSources);
    }

    public void buildDslByViewCode(String viewCode, String activityId, String pageCode, PcUiBotTmDataState dataState, PcUiBotExecuteContext executeContext) {
        PcUiBotPageUIElement elements = this.getDslByViewCode(viewCode, pageCode, executeContext);
        if (elements != null) {
            List layout = (List)JsonUtil.objectToJavaObject((Object)elements.getLayout(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            dataState.setLayout(layout);
            dataState.setOperations(elements.getOperations());
            dataState.setHooks(elements.getHooks());
        }
    }

    public PcUiBotPageUIElement getDslByViewCode(String viewCode, String pageCode, PcUiBotExecuteContext executeContext) {
        if (StringUtils.isBlank((CharSequence)viewCode)) {
            log.warn("\u6839\u636eviewCode\u83b7\u53d6Dsl_\u5165\u53c2\u4e2dviewCode\u4e3a\u7a7a_\u4e0d\u7ee7\u7eed\u6267\u884c");
            return null;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("code", viewCode);
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", pageCode);
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("", executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), executeContext.getTenantId())).uriVariables(uriVariables).build();
        PcUiBotTmPageUIElements pcUiBotTmPageUIElements = this.digiwinKnowledgeMapsProxyService.getPageUIElement(athenaApiRequest);
        return Optional.ofNullable(pcUiBotTmPageUIElements).map(PcUiBotTmPageUIElements::getElements).orElse(null);
    }
}

