/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.AssistanPatternTaskBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.GeneralPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class AssistanTaskPageTemplate
extends GeneralPageTemplate<PcUiBotTaskPageDefine> {
    private static final Logger log = LoggerFactory.getLogger(AssistanTaskPageTemplate.class);
    public static final String SUPPORT_KEY = "webplatform-business_assistan-assistan-performer";
    @Autowired
    private AssistanPatternTaskBuilder assistanPatternTaskBuilder;
    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformer;
    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;
    private static final String COMPONENT_TYPE = "ACTIVITY_TITLE";
    private static final String COMPONENT_ACTIVITY_DESCRIPTION = "ACTIVITY_DESCRIPTION";

    public String supportKey() {
        return SUPPORT_KEY;
    }

    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines, UiBotModel dynamicForm) {
        ArrayList<UiBotLayout> layout = new ArrayList<UiBotLayout>();
        dynamicForm.setLayout(layout);
        this.createHeader(executeContext, pageDefine, layout);
        this.assistanPatternTaskBuilder.createDynamicForm(apiRequest, executeContext, pageDefine, dynamicForm, queryResultSet);
        if (CollectionUtils.isNotEmpty(pageDefines)) {
            UiBotLayout queryButtonComponent = this.createQueryButton(queryResultSet, pageDefines);
            layout.add(queryButtonComponent);
        }
        PcUiBotTaskData taskData = this.createTaskData(executeContext, (PcUiBotPageDefine)pageDefine, queryResultSet);
        UiBotPageData pageData = dynamicForm.getPageData();
        pageData.put("uiBot__activity", taskData);
        HashMap<String, String> templateContentData = new HashMap<String, String>();
        String contentTitle = taskData.getName();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contentTitle)) {
            templateContentData.put("title", contentTitle);
            templateContentData.put("subTitle", contentTitle);
        }
        pageData.put("uiBot__content", templateContentData);
        pageData.put("uiBot__prompt_message", "");
    }

    protected void BuildActions(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        if (!CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions())) {
            dynamicForm.setActions((List)JsonUtil.objectToJavaObject((Object)pageDefine.getSubmitActions(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    protected void BuildPageData(UiBotModel dynamicForm, QueryResultSet queryResultSet) {
    }

    protected void createHeader(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, List<UiBotLayout> layout) {
        layout.add(this.createHeadArea());
        this.createSignOffProgress(executeContext, layout);
    }

    private void createSignOffProgress(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (executeContext != null && executeContext.getTaskWithBacklogData() != null && executeContext.getTaskWithBacklogData().getRelationApproval() != null) {
            UiBotLayout signOffProgressLinkComponent = new UiBotLayout();
            signOffProgressLinkComponent.setId(UUID.randomUUID().toString());
            signOffProgressLinkComponent.setType("SIGN_OFF_PROGRESS_LINK");
            signOffProgressLinkComponent.setSchema("uiBot__activity");
            layout.add(signOffProgressLinkComponent);
        }
    }

    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        dynamicForm.setFinished(pageDefine.getFinished());
        dynamicForm.setFinishedTitle(pageDefine.getFinishedTitle());
    }

    protected UiBotLayout createHeadArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType(COMPONENT_TYPE);
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    protected UiBotLayout createDescriptionArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setType(COMPONENT_ACTIVITY_DESCRIPTION);
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    protected UiBotLayout createQueryButton(QueryResultSet queryResultSet, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotLayout queryButtonComponent = new UiBotLayout();
        queryButtonComponent.setId(UUID.randomUUID().toString());
        queryButtonComponent.setType("CONTENT_QUERY_BUTTON");
        if (queryResultSet != null && queryResultSet.getQueryResults() != null && pageDefines.size() > 0) {
            int rowSize;
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(0);
            pageDefine.setType("UI");
            if ("byDataKey".equals(pageDefine.getRowSizeType())) {
                rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryResultSet.getMainQueryResult().getDataSourceName()) || !queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName()) || CollectionUtils.isEmpty((Map)queryResult.getDataKeyIndex())) continue;
                    rowSize += queryResult.getDataKeyIndex().size();
                }
                pageDefine.setRowSize(Integer.valueOf(rowSize));
            } else {
                rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryResultSet.getMainQueryResult().getDataSourceName()) || !queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName()) || !CollectionUtils.isNotEmpty((Collection)queryResult.getData())) continue;
                    rowSize += queryResult.getData().size();
                }
                pageDefine.setRowSize(Integer.valueOf(rowSize));
            }
            if (queryResultSet.getMainQueryResult().getData() != null && queryResultSet.getMainQueryResult().getData().size() > 0) {
                queryButtonComponent.setData((Map)queryResultSet.getMainQueryResult().getData().get(0));
            }
        }
        for (int i = 1; i < pageDefines.size(); ++i) {
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(i);
            pageDefine.setType("async");
        }
        queryButtonComponent.setQueryButtons((List)JsonUtil.objectToJavaObject(pageDefines, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        return queryButtonComponent;
    }

    protected PcUiBotTaskData createTaskData(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        PcUiBotTaskData taskDetailDTO = new PcUiBotTaskData();
        String titleDefine = pageDefine.getTitle();
        if (titleDefine != null) {
            QueryResult queryResult;
            String title = titleDefine;
            if (titleDefine.contains("$(") && queryResultSet != null && (queryResult = queryResultSet.getMainQueryResult()).size() > 0) {
                Pattern p = Pattern.compile("\\$\\((?<var>.*?)\\)");
                Matcher m = p.matcher(titleDefine);
                while (m.find()) {
                    String varName = m.group("var");
                    String varValue = ((Map)queryResult.getData().get(0)).get(varName).toString();
                    title = title.replace("$(" + varName + ")", varValue.toString());
                }
            }
            taskDetailDTO.setTitle(title);
        }
        taskDetailDTO.setDescription(pageDefine.getDescription());
        DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();
        if (taskData != null && CollectionUtils.isNotEmpty((Map)taskData.getBpmData())) {
            Map bpmData = taskData.getBpmData();
            taskDetailDTO.setTitle(PcUiBotPropertyPlaceholderUtil.resolve((String)taskDetailDTO.getTitle(), (Map)bpmData));
            taskDetailDTO.setDescription(PcUiBotPropertyPlaceholderUtil.resolve((String)taskDetailDTO.getDescription(), (Map)bpmData));
        }
        taskDetailDTO.setSubDescription(pageDefine.getSubDescription());
        if (pageDefine.getDataSourceSet().isEmpty() || executeContext.getProjectData() == null || taskData == null) {
            return taskDetailDTO;
        }
        if (CollectionUtils.isNotEmpty((Collection)taskData.getEocName())) {
            taskDetailDTO.setEocName(taskData.getEocName());
        }
        if (executeContext.getApprovalInfo() != null && executeContext.getApprovalInfo().getSubState() != null) {
            taskDetailDTO.setApprovalInfo(executeContext.getApprovalInfo());
        }
        DigiwinAtmcProjectData projectData = executeContext.getProjectData();
        DigiwinAtmcBacklogData backlogData = new DigiwinAtmcBacklogData();
        List backlog = taskData.getBacklog();
        if (!CollectionUtils.isEmpty((Collection)backlog)) {
            backlogData = (DigiwinAtmcBacklogData)backlog.get(0);
        }
        taskDetailDTO.setTaskStartTime(projectData.getStartTime());
        taskDetailDTO.setRemainTime(backlogData.getRemainTime());
        taskDetailDTO.setReadCount(backlogData.getReadCount());
        taskDetailDTO.setTaskEndTime(projectData.getEndTime());
        taskDetailDTO.setTaskName(projectData.getProjectName());
        if (projectData.getProcessCreateTime() == null) {
            taskDetailDTO.setProcessCreateTime(projectData.getStartTime());
        } else {
            taskDetailDTO.setProcessCreateTime(projectData.getProcessCreateTime());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)backlogData.getBacklogName())) {
            taskDetailDTO.setName(backlogData.getBacklogName());
            taskDetailDTO.setProcessSerialNumber(taskData.getProcessSerialNumber());
            if (CollectionUtils.isNotEmpty((Collection)backlogData.getWorkitemList())) {
                taskDetailDTO.setWorkitemId(((Map)backlogData.getWorkitemList().get(0)).get("workitemId").toString());
            }
        } else {
            taskDetailDTO.setName(taskData.getTmActivityName());
        }
        taskDetailDTO.setSubName(pageDefine.getSubTitle());
        taskDetailDTO.setSteps(taskData.getSteps());
        taskDetailDTO.setApprovalState(taskData.getApprovalState());
        taskDetailDTO.setOverdueDate(backlogData.getOverdueDate());
        taskDetailDTO.setEndTime(backlogData.getPlanEndTime());
        HashMap extend = new HashMap();
        taskDetailDTO.setExtendedFields(extend);
        HashMap<String, Object> signOffData = new HashMap<String, Object>();
        signOffData.put("locale", AppRequestContext.getContextEntity().getLocale());
        extend.put("signOffProgressData", signOffData);
        ArrayList<Map> processInstances = new ArrayList<Map>();
        if (taskData.getRelationApproval() != null) {
            Map process = taskData.getRelationApproval();
            process.putAll(taskData.getRelationApproval());
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        } else {
            HashMap<String, Object> process = new HashMap<String, Object>();
            process.put("processSerialNumber", taskData.getProcessSerialNumber());
            process.put("tmActivityIds", new String[]{taskData.getTmActivityId()});
            if (backlogData != null && backlogData.getBacklogId() != null) {
                process.put("workitemId", backlogData.getBacklogId());
            }
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        }
        return taskDetailDTO;
    }

    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, (PcUiBotPageDefine)mainAction, pageDefines);
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        this.businessProcessPerformer.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, 2, null);
        uiBotModel.setRawUiBotPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class));
        this.uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength((String)uiBotModel.getPageBackgroudColor()) ? uiBotModel.getPageBackgroudColor() : BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        int type = this.businessProcessPerformer.useTabComponentRender(pageDefines) != false ? 2 : 1;
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, (PcUiBotPageDefine)mainAction, pageDefines);
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        DigiwinAtmcBacklogDetail backlogDetail = this.uiBotDesignerRenderService.buildApprovalReassign(apiRequest, uiBotModel);
        this.uiBotDesignerRenderService.buildTitleBody(apiRequest, uiBotModel, backlogDetail, Boolean.valueOf(true));
        this.businessProcessPerformer.bulidRanderData(apiRequest, mainAction, executeContext, uiBotModel, type, null);
        uiBotModel.setRawUiBotPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class));
        this.uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength((String)uiBotModel.getPageBackgroudColor()) ? uiBotModel.getPageBackgroudColor() : BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }
}

