/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.GeneralPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommonStandardPerformerGeneralPageTemplate
extends GeneralPageTemplate<PcUiBotTaskPageDefine> {
    private static final Logger log = LoggerFactory.getLogger(CommonStandardPerformerGeneralPageTemplate.class);
    private static final String COMPONENT_TYPE = "ACTIVITY_TITLE";
    private static final String COMPONENT_ACTIVITY_DESCRIPTION = "ACTIVITY_DESCRIPTION";

    public String supportKey() {
        return "webplatform-common-performer";
    }

    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        if (!CollectionUtils.isEmpty(pageDefines) && pageDefines.size() > 1) {
            if (Objects.equals(executeContext.getTmActivityId(), "apc_workShopOnline")) {
                mainAction = this.handleDefaultPageDefine(apiRequest, executeContext, mainAction, pageDefines);
            }
            if (Objects.equals(executeContext.getTmActivityId(), "apc_mergeWork")) {
                mainAction = this.handleDefaultPageDefineByFilter(apiRequest, executeContext, mainAction, pageDefines);
            }
        }
        return super.createTaskPage(apiRequest, executeContext, (PcUiBotPageDefine)mainAction, pageDefines);
    }

    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, (PcUiBotPageDefine)pageDefine, dynamicForm, apiRequest);
        UiBotPageData pageData = dynamicForm.getPageData();
        PcUiBotTaskData taskData = this.createTaskData(executeContext, (PcUiBotPageDefine)pageDefine, queryResultSet);
        pageData.put("uiBot__activity", taskData);
        HashMap<String, String> templateContentData = new HashMap<String, String>();
        String contentTitle = taskData.getName();
        if (StringUtils.isNotBlank((CharSequence)contentTitle)) {
            templateContentData.put("title", contentTitle);
            templateContentData.put("subTitle", contentTitle);
        }
        pageData.put("uiBot__content", templateContentData);
        pageData.put("uiBot__prompt_message", "");
        return queryResultSet;
    }

    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotTaskPageDefine pageDefine, List<PcUiBotTaskPageDefine> pageDefines, UiBotModel dynamicForm) {
        super.BuildLayout(apiRequest, executeContext, queryResultSet, (PcUiBotPageDefine)pageDefine, pageDefines, dynamicForm);
        ArrayList<UiBotLayout> layout = new ArrayList<UiBotLayout>();
        dynamicForm.setLayout(layout);
        this.createHeader(executeContext, pageDefine, layout);
        if (!CollectionUtils.isEmpty(pageDefines)) {
            UiBotLayout queryButtonComponent = this.createQueryButton(queryResultSet, pageDefines);
            layout.add(queryButtonComponent);
            if (executeContext != null && "task-detail-mobile".equals(executeContext.getPageCode()) && executeContext != null && !"APPROVAL".equals(executeContext.getCategory()) && queryButtonComponent != null && queryButtonComponent.getData() != null) {
                HashMap<String, Map> pageData = new HashMap<String, Map>();
                pageData.put("uiBot__APPROVAL_DESCRIPTION", queryButtonComponent.getData());
                dynamicForm.getPageData().putAll(pageData);
            }
        }
    }

    protected void createHeader(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, List<UiBotLayout> layout) {
        UiBotLayout abstractComponent;
        layout.add(this.createHeadArea());
        this.createSignOffProgress(executeContext, layout);
        this.createDataUniformityHistory(executeContext, layout);
        if (executeContext != null && "task-detail-mobile".equals(executeContext.getPageCode()) && executeContext != null && !"APPROVAL".equals(executeContext.getCategory()) && (abstractComponent = this.createActivityDescriptionComponent(executeContext, pageDefine)) != null) {
            layout.add(abstractComponent);
        }
    }

    protected void createSignOffProgress(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (executeContext != null && executeContext.getTaskWithBacklogData() != null && executeContext.getTaskWithBacklogData().getRelationApproval() != null) {
            UiBotLayout signOffProgressLinkComponent = new UiBotLayout();
            signOffProgressLinkComponent.setId(UUID.randomUUID().toString());
            signOffProgressLinkComponent.setType("SIGN_OFF_PROGRESS_LINK");
            signOffProgressLinkComponent.setSchema("uiBot__activity");
            layout.add(signOffProgressLinkComponent);
        }
    }

    private void createDataUniformityHistory(PcUiBotExecuteContext executeContext, List<UiBotLayout> layout) {
        if (!CollectionUtils.isEmpty((Collection)executeContext.getAbnormalCards())) {
            UiBotLayout dataUniformityHistoryComponent = new UiBotLayout();
            dataUniformityHistoryComponent.setId(UUID.randomUUID().toString());
            dataUniformityHistoryComponent.setType("DATA_UNIFORMITY_HISTORY");
            dataUniformityHistoryComponent.setSchema("uiBot__activity");
            layout.add(dataUniformityHistoryComponent);
        }
    }

    protected PcUiBotTaskData createTaskData(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        PcUiBotTaskData taskDetailDTO = new PcUiBotTaskData();
        String titleDefine = pageDefine.getTitle();
        if (titleDefine != null) {
            QueryResult queryResult;
            String title = titleDefine;
            if (titleDefine.contains("$(") && queryResultSet != null && (queryResult = queryResultSet.getMainQueryResult()).size() > 0) {
                Pattern p = Pattern.compile("\\$\\((?<var>.*?)\\)");
                Matcher m = p.matcher(titleDefine);
                while (m.find()) {
                    String varName = m.group("var");
                    String varValue = ((Map)queryResult.getData().get(0)).get(varName).toString();
                    title = title.replace("$(" + varName + ")", varValue.toString());
                }
            }
            taskDetailDTO.setTitle(title);
        }
        taskDetailDTO.setDescription(pageDefine.getDescription());
        DigiwinAtmcTaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();
        if (taskData != null && !CollectionUtils.isEmpty((Map)taskData.getBpmData())) {
            Map bpmData = taskData.getBpmData();
            if (bpmData.containsKey("__DERIVE_MAIN_TASK")) {
                taskDetailDTO.setDeriveMainTask(bpmData.get("__DERIVE_MAIN_TASK"));
            }
            taskDetailDTO.setTitle(PcUiBotPropertyPlaceholderUtil.resolve((String)taskDetailDTO.getTitle(), (Map)bpmData));
            taskDetailDTO.setDescription(PcUiBotPropertyPlaceholderUtil.resolve((String)taskDetailDTO.getDescription(), (Map)bpmData));
        }
        taskDetailDTO.setSubDescription(pageDefine.getSubDescription());
        if (pageDefine.getDataSourceSet().isEmpty() || executeContext.getProjectData() == null || taskData == null) {
            return taskDetailDTO;
        }
        if (!CollectionUtils.isEmpty((Collection)taskData.getEocName())) {
            taskDetailDTO.setEocName(taskData.getEocName());
        }
        if (executeContext.getApprovalInfo() != null && executeContext.getApprovalInfo().getSubState() != null) {
            taskDetailDTO.setApprovalInfo(executeContext.getApprovalInfo());
        }
        DigiwinAtmcProjectData projectData = executeContext.getProjectData();
        DigiwinAtmcBacklogData backlogData = new DigiwinAtmcBacklogData();
        List backlog = taskData.getBacklog();
        if (!CollectionUtils.isEmpty((Collection)backlog)) {
            backlogData = (DigiwinAtmcBacklogData)backlog.get(0);
        }
        taskDetailDTO.setTaskStartTime(projectData.getStartTime());
        taskDetailDTO.setRemainTime(backlogData.getRemainTime());
        taskDetailDTO.setReadCount(backlogData.getReadCount());
        taskDetailDTO.setTaskEndTime(projectData.getEndTime());
        taskDetailDTO.setTaskName(projectData.getProjectName());
        if (projectData.getProcessCreateTime() == null) {
            taskDetailDTO.setProcessCreateTime(projectData.getStartTime());
        } else {
            taskDetailDTO.setProcessCreateTime(projectData.getProcessCreateTime());
        }
        if (backlogData != null && StringUtils.isNotEmpty((CharSequence)backlogData.getBacklogName())) {
            taskDetailDTO.setName(backlogData.getBacklogName());
            taskDetailDTO.setProcessSerialNumber(taskData.getProcessSerialNumber());
            if (!CollectionUtils.isEmpty((Collection)backlogData.getWorkitemList())) {
                taskDetailDTO.setWorkitemId(((Map)backlogData.getWorkitemList().get(0)).get("workitemId").toString());
            }
        } else {
            taskDetailDTO.setName(taskData.getTmActivityName());
        }
        taskDetailDTO.setSubName(pageDefine.getSubTitle());
        taskDetailDTO.setSteps(taskData.getSteps());
        taskDetailDTO.setApprovalState(taskData.getApprovalState());
        taskDetailDTO.setOverdueDate(backlogData.getOverdueDate());
        taskDetailDTO.setEndTime(backlogData.getPlanEndTime());
        HashMap extend = new HashMap();
        taskDetailDTO.setExtendedFields(extend);
        HashMap<String, Object> signOffData = new HashMap<String, Object>();
        signOffData.put("locale", AppRequestContext.getContextEntity().getLocale());
        extend.put("signOffProgressData", signOffData);
        ArrayList<Map> processInstances = new ArrayList<Map>();
        if (taskData.getRelationApproval() != null) {
            Map process = taskData.getRelationApproval();
            process.putAll(taskData.getRelationApproval());
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        } else {
            HashMap<String, Object> process = new HashMap<String, Object>();
            process.put("processSerialNumber", taskData.getProcessSerialNumber());
            process.put("tmActivityIds", new String[]{taskData.getTmActivityId()});
            if (backlogData != null && backlogData.getBacklogId() != null) {
                process.put("workitemId", backlogData.getBacklogId());
            }
            processInstances.add(process);
            signOffData.put("processInstances", processInstances);
        }
        taskDetailDTO.setMerge(backlogData.getMerge());
        taskDetailDTO.setPlanEndTimeMin(backlogData.getPlanEndTimeMin());
        taskDetailDTO.setPlanEndTimeMax(backlogData.getPlanEndTimeMax());
        return taskDetailDTO;
    }

    protected UiBotLayout createHeadArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType(COMPONENT_TYPE);
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    protected UiBotLayout createDescriptionArea() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setType(COMPONENT_ACTIVITY_DESCRIPTION);
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    protected UiBotLayout createContentTitle() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType("CONTENT_TITLE");
        commonComponent.setSchema("uiBot__content");
        return commonComponent;
    }

    protected UiBotLayout createContentSubtitle() {
        UiBotLayout commonComponent = new UiBotLayout();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType("CONTENT_SUBTITLE");
        commonComponent.setSchema("uiBot__content");
        return commonComponent;
    }

    protected UiBotLayout createQueryButton(QueryResultSet queryResultSet, List<PcUiBotTaskPageDefine> pageDefines) {
        UiBotLayout queryButtonComponent = new UiBotLayout();
        queryButtonComponent.setId(UUID.randomUUID().toString());
        queryButtonComponent.setType("CONTENT_QUERY_BUTTON");
        if (queryResultSet != null && queryResultSet.getQueryResults() != null && pageDefines.size() > 0) {
            int rowSize;
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(0);
            pageDefine.setType("UI");
            if ("byDataKey".equals(pageDefine.getRowSizeType())) {
                rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() == null || !StringUtils.isNotEmpty((CharSequence)queryResultSet.getMainQueryResult().getDataSourceName()) || !queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) continue;
                    if (queryResult.isHasNext()) {
                        rowSize += queryResult.getTotalResults().intValue();
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Map)queryResult.getDataKeyIndex())) continue;
                    rowSize += queryResult.getDataKeyIndex().size();
                }
                pageDefine.setRowSize(Integer.valueOf(rowSize));
            } else {
                rowSize = 0;
                for (QueryResult queryResult : queryResultSet.getQueryResults()) {
                    if (queryResultSet.getMainQueryResult() == null || !StringUtils.isNotEmpty((CharSequence)queryResultSet.getMainQueryResult().getDataSourceName()) || !queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName())) continue;
                    if (queryResult.isHasNext()) {
                        rowSize += queryResult.getTotalResults().intValue();
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)queryResult.getData())) continue;
                    rowSize += queryResult.getData().size();
                }
                pageDefine.setRowSize(Integer.valueOf(rowSize));
            }
            if (queryResultSet.getMainQueryResult().getData() != null && queryResultSet.getMainQueryResult().getData().size() > 0) {
                queryButtonComponent.setData((Map)queryResultSet.getMainQueryResult().getData().get(0));
            }
        }
        for (int i = 1; i < pageDefines.size(); ++i) {
            PcUiBotTaskPageDefine pageDefine = pageDefines.get(i);
            pageDefine.setType("async");
            if (!CollectionUtils.isEmpty((Map)queryButtonComponent.getData())) continue;
            try {
                QueryResultSet resultSet = this.queryByActivityQueryDTO(pageDefine.getExecuteContext(), pageDefine.getDataSourceSet(), null, null, null, null);
                if (resultSet == null || resultSet.getQueryResults() == null) continue;
                int rowSize = 0;
                if ("byDataKey".equals(pageDefine.getRowSizeType())) {
                    for (QueryResult queryResult : resultSet.getQueryResults()) {
                        if (queryResultSet == null || queryResultSet.getMainQueryResult() == null || !StringUtils.isNotEmpty((CharSequence)queryResultSet.getMainQueryResult().getDataSourceName()) || !queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName()) || !CollUtil.isNotEmpty((Map)queryResult.getDataKeyIndex())) continue;
                        rowSize += queryResult.getDataKeyIndex().size();
                    }
                } else {
                    for (QueryResult queryResult : resultSet.getQueryResults()) {
                        if (queryResultSet == null || queryResultSet.getMainQueryResult() == null || !StringUtils.isNotEmpty((CharSequence)queryResultSet.getMainQueryResult().getDataSourceName()) || !queryResultSet.getMainQueryResult().getDataSourceName().equals(queryResult.getDataSourceName()) || !CollUtil.isNotEmpty((Collection)queryResult.getData())) continue;
                        rowSize += queryResult.getData().size();
                    }
                }
                pageDefine.setRowSize(Integer.valueOf(rowSize));
                if (resultSet.getMainQueryResult().getData().size() <= 0) continue;
                queryButtonComponent.setData((Map)resultSet.getMainQueryResult().getData().get(0));
                continue;
            }
            catch (Exception ex) {
                log.error("error:", (Throwable)ex);
                pageDefine.setRowSize(Integer.valueOf(0));
            }
        }
        queryButtonComponent.setQueryButtons((List)JsonUtil.objectToJavaObject(pageDefines, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        return queryButtonComponent;
    }

    protected boolean isCustomize(PcUiBotExecuteContext executeContext) {
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsCustomize())) {
            return true;
        }
        String pattern = executeContext.getPattern();
        return "CUSTOM".equals(pattern);
    }

    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm) {
        dynamicForm.setFinished(pageDefine.getFinished());
        dynamicForm.setFinishedTitle(pageDefine.getFinishedTitle());
    }

    public UiBotLayout createActivityDescriptionComponent(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        return null;
    }

    protected void BuildRule(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        List rules = this.pcRuleService.buildRuleOfKm(executeContext.getTmActivityId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty((Collection)rules)) {
            dynamicForm.setRules(rules);
        }
    }
}

