/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataViewQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataViewQuery;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmPage;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmSequence;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PcUiBotConvertTmActivityUtils {
    static String[] solveStates = new String[]{"waitting", "tracing", "completed"};
    static String[] states = new String[]{"waitting", "completed"};

    public static void convert(String pageCode, String locale, PcUiBotTmActivity tmActivity) {
        PcUiBotConvertTmActivityUtils.updateTmActivity((String)pageCode, (PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.processDataProcessor((String)pageCode, (PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.setDataStateCode((PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.setDataSourceDefaultValue((PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.updateSubmitAction((PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.updateShowSubmitActions((PcUiBotTmActivity)tmActivity);
        PcUiBotConvertTmActivityUtils.updateSubmitType((String)locale, (PcUiBotTmActivity)tmActivity);
    }

    private static void updateShowSubmitActions(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getPages() != null && tmActivity.getPages().getShowSubmitActions() == null) {
            tmActivity.getPages().setShowSubmitActions(Boolean.valueOf(true));
        }
    }

    private static void updateSubmitAction(PcUiBotTmActivity tmActivity) {
        if (tmActivity.getApprove() != null && tmActivity.getApprove().getSequence() != null) {
            for (PcUiBotTmSequence tmSequence : tmActivity.getApprove().getSequence()) {
                if (tmSequence.getSubmits() == null) continue;
                for (PcUiBotTmAction submit : tmSequence.getSubmits()) {
                    PcUiBotConvertTmActivityUtils.updateSubmitActionDispatch((PcUiBotTmAction)submit);
                }
            }
        }
        if (tmActivity.getPages() != null && tmActivity.getPages().getSubmitActions() != null) {
            for (PcUiBotTmAction submit : tmActivity.getPages().getSubmitActions()) {
                PcUiBotConvertTmActivityUtils.updateSubmitActionDispatch((PcUiBotTmAction)submit);
            }
        }
        if (tmActivity.getPages() != null && !CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataStates())) {
            for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                if (dataState.getSubmitActions() == null) continue;
                for (PcUiBotTmAction submit : dataState.getSubmitActions()) {
                    PcUiBotConvertTmActivityUtils.updateSubmitActionDispatch((PcUiBotTmAction)submit);
                }
            }
        }
    }

    private static void updateSubmitActionDispatch(PcUiBotTmAction action) {
        if (action.getDispatchBPM() != null) {
            action.setDispatch(action.getDispatchBPM().booleanValue());
        }
        if (!CollectionUtils.isEmpty((Collection)action.getAttachActions())) {
            for (PcUiBotTmAction attachAction : action.getAttachActions()) {
                PcUiBotConvertTmActivityUtils.updateSubmitActionDispatch((PcUiBotTmAction)attachAction);
            }
        }
    }

    private static void updateSubmitType(String locale, PcUiBotTmActivity tmActivity) {
        if (tmActivity != null && tmActivity.getPages() != null && !CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataStates()) && Objects.equals(tmActivity.getMerge(), true)) {
            tmActivity.getPages().getDataStates().forEach(tmDataState -> {
                if (Objects.equals(tmDataState.getCode(), "waitting")) {
                    if (tmDataState.getSubmitType() != null) {
                        if (!Objects.equals(tmDataState.getSubmitType().getIsBatch(), true)) {
                            tmDataState.getSubmitType().setIsBatch(Boolean.valueOf(true));
                            tmDataState.getSubmitType().setByActivity(Boolean.valueOf(true));
                        }
                    } else if (!CollectionUtils.isEmpty((Collection)tmDataState.getSubmitActions())) {
                        tmDataState.getSubmitActions().forEach(submitAction -> {
                            if (submitAction.getSubmitType() != null) {
                                if (!Objects.equals(submitAction.getSubmitType().getIsBatch(), true)) {
                                    submitAction.getSubmitType().setIsBatch(Boolean.valueOf(true));
                                    submitAction.getSubmitType().setByActivity(Boolean.valueOf(true));
                                    if (StringUtils.isBlank((CharSequence)submitAction.getSubmitType().getSchema())) {
                                        String message = MessageFormat.format("\u5408\u5e76\u4efb\u52a1 {0}({1}) \u672a\u914d\u7f6esubmitType\u7684schema", tmActivity.getActivityNameByLocale(), tmActivity.getActivityId());
                                        throw new ServiceException(message);
                                    }
                                }
                            } else {
                                PcUiBotSubmitType submitType = new PcUiBotSubmitType();
                                submitType.setIsBatch(Boolean.valueOf(true));
                                submitType.setByActivity(Boolean.valueOf(true));
                                if (CollectionUtils.isEmpty((Map)tmActivity.getDataSources()) || tmActivity.getDataSources().size() != 1) {
                                    String message = MessageFormat.format("\u5408\u5e76\u4efb\u52a1 {0}({1}) \u672a\u914d\u7f6esubmitType\u7684schema", tmActivity.getActivityNameByLocale(), tmActivity.getActivityId());
                                    throw new ServiceException(message);
                                }
                                submitType.setSchema((String)tmActivity.getDataSources().keySet().stream().findFirst().get());
                                tmDataState.setSubmitType(submitType);
                            }
                        });
                    }
                }
            });
        }
    }

    private static void setDataStateCode(PcUiBotTmActivity tmActivity) {
        block9: {
            if (CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataStates())) break block9;
            if (tmActivity.getPages().getEnableDataState() != null && tmActivity.getPages().getEnableDataState().booleanValue()) {
                String[] dataStateCodes = states;
                if ("SOLVE".equals(tmActivity.getCategory())) {
                    dataStateCodes = solveStates;
                }
                int index = 0;
                for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                    if (StringUtils.isEmpty((CharSequence)dataState.getCode())) {
                        if (index < dataStateCodes.length) {
                            dataState.setCode(dataStateCodes[index]);
                        } else {
                            dataState.setCode("unknown");
                        }
                    }
                    ++index;
                }
            } else {
                int index = 0;
                for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                    if (StringUtils.isEmpty((CharSequence)dataState.getCode())) {
                        dataState.setCode("uibot__data__state__" + String.format("%05d", index));
                    }
                    ++index;
                }
            }
        }
    }

    private static void updateTmActivity(String pageCode, PcUiBotTmActivity tmActivity) {
        Optional<PcUiBotTmDataState> dataStates;
        int index;
        if (tmActivity.getPages() == null) {
            tmActivity.setPages(new PcUiBotTmPage());
        }
        if (!CollectionUtils.isEmpty((Collection)tmActivity.getDataFilters())) {
            index = 1;
            for (PcUiBotTmDataFilter dataFilter : tmActivity.getDataFilters()) {
                if (!StringUtils.isEmpty((CharSequence)dataFilter.getCode())) continue;
                dataFilter.setCode("uibot__data__filter__" + String.format("%05d", index));
                ++index;
            }
        }
        if (CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataStates())) {
            PcUiBotTmDataFilter tmDataFilter;
            Optional<PcUiBotTmDataFilter> defaultFilter;
            ArrayList<PcUiBotTmDataState> dataStates2 = new ArrayList<PcUiBotTmDataState>();
            Object tmDataFilters = null;
            if (!CollectionUtils.isEmpty((Collection)tmActivity.getDataFilters())) {
                if (CollectionUtils.isEmpty(tmDataFilters) || !CollectionUtils.isEmpty(tmDataFilters) && tmDataFilters.size() == 0) {
                    tmDataFilters = tmActivity.getDataFilters().stream().filter(filter -> StringUtils.isEmpty((CharSequence)filter.getApplyTo()) || filter.getApplyTo().contains("task-detail")).collect(Collectors.toList());
                }
                if (!(tmDataFilters == null || tmDataFilters.isEmpty() || "project-detail-mobile".equals(pageCode) || "task-detail-mobile".equals(pageCode))) {
                    defaultFilter = tmDataFilters.stream().filter(filter -> filter.getDefaultFilter() != null && filter.getDefaultFilter() != false).findFirst();
                    if (defaultFilter.isPresent()) {
                        tmDataFilters.clear();
                        tmDataFilters.add(defaultFilter.get());
                    } else {
                        tmDataFilter = (PcUiBotTmDataFilter)tmDataFilters.get(0);
                        tmDataFilters.clear();
                        tmDataFilters.add(tmDataFilter);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(tmDataFilters)) {
                defaultFilter = tmDataFilters.iterator();
                while (defaultFilter.hasNext()) {
                    tmDataFilter = (PcUiBotTmDataFilter)defaultFilter.next();
                    PcUiBotTmDataState ds = PcUiBotConvertTmActivityUtils.createTmDataState((PcUiBotTmDataFilter)tmDataFilter, (PcUiBotTmActivity)tmActivity);
                    dataStates2.add(ds);
                }
                tmActivity.getPages().setDataStates(dataStates2);
            } else {
                PcUiBotTmDataState ds = PcUiBotConvertTmActivityUtils.createTmDataState(null, (PcUiBotTmActivity)tmActivity);
                ds = PcUiBotConvertTmActivityUtils.setDataFilterAndViewCode((PcUiBotTmActivity)tmActivity, (PcUiBotTmDataState)ds);
                dataStates2.add(ds);
            }
            tmActivity.getPages().setDataStates(dataStates2);
        } else {
            index = 1;
            for (PcUiBotTmDataState tmDataState : tmActivity.getPages().getDataStates()) {
                if (tmDataState.getDataFilter() == null || !StringUtils.isEmpty((CharSequence)tmDataState.getDataFilter().getCode())) continue;
                tmDataState.getDataFilter().setCode("uibot__data__filter__" + String.format("%05d", index));
                ++index;
            }
        }
        if (Objects.nonNull(tmActivity.getPages()) && Objects.nonNull(tmActivity.getPages().getSettings()) && !CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataStates())) {
            for (PcUiBotTmDataState dataState : tmActivity.getPages().getDataStates()) {
                if (!Objects.nonNull(dataState) || !Objects.isNull(dataState.getSettings())) continue;
                dataState.setSettings(tmActivity.getPages().getSettings());
            }
        }
        if ((dataStates = tmActivity.getPages().getDataStates().stream().filter(s -> s.getMergeQuery() != null && s.getMergeQuery() != false).findFirst()).isPresent()) {
            tmActivity.getPages().setMergeQuery(Boolean.valueOf(true));
        } else {
            tmActivity.getPages().setMergeQuery(Boolean.valueOf(false));
        }
    }

    private static void processDataProcessor(String pageCode, PcUiBotTmActivity tmActivity) {
        if (tmActivity.getDataSources() == null || tmActivity.getDataSources().size() == 0) {
            return;
        }
        int indexProcess = 0;
        for (Map.Entry entry : tmActivity.getDataSources().entrySet()) {
            String key = (String)entry.getKey();
            PcUiBotTmQueryAction tmActionDTO = (PcUiBotTmQueryAction)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)tmActionDTO.getDataProcessors())) continue;
            ArrayList<String> dataSourceNames = new ArrayList<String>();
            dataSourceNames.add(key);
            if (indexProcess == 0) {
                tmActivity.setDataProcessors(new ArrayList());
            }
            Iterator iterator = tmActionDTO.getDataProcessors().iterator();
            while (iterator.hasNext()) {
                PcUiBotTmDataProcess proce = (PcUiBotTmDataProcess)iterator.next();
                if (StringUtils.isBlank((CharSequence)proce.getApplyTo()) || proce.getApplyTo().contains("task-detail")) {
                    proce.setDataSourceNames(dataSourceNames);
                    if (tmActivity.getDataProcessors().contains(proce)) continue;
                    tmActivity.getDataProcessors().add(proce);
                    continue;
                }
                iterator.remove();
            }
            ++indexProcess;
        }
        if (CollectionUtils.isEmpty((Collection)tmActivity.getDataProcessors())) {
            return;
        }
        ArrayList<PcUiBotTmDataProcess> dataProcessors = new ArrayList<PcUiBotTmDataProcess>();
        for (PcUiBotTmDataProcess dataProcessor : tmActivity.getDataProcessors()) {
            if (StringUtils.isNotBlank((CharSequence)dataProcessor.getApplyTo())) {
                String[] applyTos = StringUtils.split((String)dataProcessor.getApplyTo(), (String)",");
                for (String applyTo : applyTos) {
                    if (!applyTo.equals(pageCode) || dataProcessors.contains(dataProcessor)) continue;
                    dataProcessors.add(dataProcessor);
                }
                continue;
            }
            if (dataProcessors.contains(dataProcessor)) continue;
            dataProcessors.add(dataProcessor);
        }
        HashMap<String, PcUiBotTmDataProcess> hashMap = new HashMap<String, PcUiBotTmDataProcess>();
        ArrayList<PcUiBotTmDataProcess> allDataProcessors = new ArrayList<PcUiBotTmDataProcess>();
        HashMap<String, PcUiBotTmDataProcess> allDataProcessMap = new HashMap<String, PcUiBotTmDataProcess>();
        for (PcUiBotTmDataProcess pcUiBotTmDataProcess : dataProcessors) {
            if ("atmcDataService".equals(pcUiBotTmDataProcess.getServiceName()) || "executeCompleted".equals(pcUiBotTmDataProcess.getActivePoint())) {
                if (pcUiBotTmDataProcess.getDataSourceNames() == null) {
                    allDataProcessors.add(pcUiBotTmDataProcess);
                    continue;
                }
                for (String dataSourceName : pcUiBotTmDataProcess.getDataSourceNames()) {
                    allDataProcessMap.put(dataSourceName, pcUiBotTmDataProcess);
                }
                continue;
            }
            if (pcUiBotTmDataProcess.getDataSourceNames() == null) {
                allDataProcessors.add(pcUiBotTmDataProcess);
                continue;
            }
            for (String dataSourceName : pcUiBotTmDataProcess.getDataSourceNames()) {
                hashMap.put(dataSourceName, pcUiBotTmDataProcess);
            }
        }
        for (Map.Entry entry : tmActivity.getDataSources().entrySet()) {
            String key = (String)entry.getKey();
            PcUiBotTmQueryAction value = (PcUiBotTmQueryAction)entry.getValue();
            if (!CollectionUtils.isEmpty((Collection)value.getDataProcessors())) continue;
            value.setName(key);
            PcUiBotConvertTmActivityUtils.addDataProcessor((PcUiBotTmQueryAction)value, hashMap);
            value.getDataProcessors().addAll(allDataProcessors);
            if (!allDataProcessMap.containsKey(key)) continue;
            value.getDataProcessors().add(allDataProcessMap.get(key));
        }
    }

    private static void addDataProcessor(PcUiBotTmQueryAction tmQueryAction, Map<String, PcUiBotTmDataProcess> dataProcessMap) {
        if (tmQueryAction.getDataProcessors() == null) {
            tmQueryAction.setDataProcessors(new ArrayList());
        }
        if (dataProcessMap.containsKey(tmQueryAction.getName())) {
            tmQueryAction.getDataProcessors().add(dataProcessMap.get(tmQueryAction.getName()));
        }
        if (tmQueryAction.getLeft() != null) {
            PcUiBotConvertTmActivityUtils.addDataProcessor((PcUiBotTmQueryAction)tmQueryAction.getLeft(), dataProcessMap);
        }
        if (tmQueryAction.getRightList() != null) {
            for (PcUiBotTmQueryAction queryAction : tmQueryAction.getRightList()) {
                PcUiBotConvertTmActivityUtils.addDataProcessor((PcUiBotTmQueryAction)queryAction, dataProcessMap);
            }
        }
    }

    private static PcUiBotTmDataState createTmDataState(PcUiBotTmDataFilter tmDataFilter, PcUiBotTmActivity tmActivity) {
        PcUiBotTmDataState ds = PcUiBotTmDataState.builder().dataFilterCode(tmDataFilter == null ? null : tmDataFilter.getCode()).operations(null).submitActions(null).extendedFields(tmActivity.getPages().getExtendedFields()).submitType(tmActivity.getPages().getSubmitType()).multipleSelectMerge(tmActivity.getPages().getMultipleSelectMerge()).taskStates(tmActivity.getPages().getTaskStates()).settings(tmActivity.getPages().getSettings()).abortTaskAction(tmActivity.getPages().getAbortTaskAction()).enablePaging(tmActivity.getPages().getEnablePaging()).tabs(tmActivity.getPages().getTabs()).enableBackEndPaging(tmActivity.getPages().getEnableBackEndPaging()).enableBackEndPagingLimit(tmActivity.getPages().getEnableBackEndPagingLimit()).mergeQuery(tmActivity.getPages().getMergeQuery()).layout(tmActivity.getPages().getLayout()).hooks(tmActivity.getPages().getHooks()).dataViewQuerys(tmActivity.getPages().getDataViewQuerys()).masterFromDataSourceName(tmActivity.getPages().getMasterFromDataSourceName()).build();
        if (tmDataFilter == null || tmDataFilter.getDefaultFilter().booleanValue()) {
            ds.setOperations(tmActivity.getPages().getOperations());
            ds.setSubmitActions(tmActivity.getPages().getSubmitActions());
        }
        return ds;
    }

    private static void setDataSourceDefaultValue(PcUiBotTmActivity tmActivity) {
        if (CollectionUtils.isEmpty((Map)tmActivity.getDataSources())) {
            return;
        }
        tmActivity.getDataSources().forEach((k, v) -> {
            if (StringUtils.isBlank((CharSequence)v.getName())) {
                v.setName(k);
            }
        });
    }

    private static PcUiBotTmDataState setDataFilterAndViewCode(PcUiBotTmActivity tmActivity, PcUiBotTmDataState ds) {
        if (!CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataSourceNames())) {
            List dataSourceNames = tmActivity.getPages().getDataSourceNames();
            if (tmActivity.getDataSources().get(dataSourceNames.get(0)) != null && ((PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceNames.get(0))).getDataViewQuery() != null) {
                PcUiBotTmDataFilter tempTmDataFilter = new PcUiBotTmDataFilter();
                tempTmDataFilter.setDataSourceNames(dataSourceNames);
                ds.setDataFilter(tempTmDataFilter);
                String viewCode = PcUiBotRuntimes.getContext().get("VIEWCODE", String.class).orElse("");
                ArrayList<PcUiBotTmQueryAction> tmQueryActionList = new ArrayList<PcUiBotTmQueryAction>();
                for (String dataSourceName : dataSourceNames) {
                    PcUiBotTmQueryAction queryAction = (PcUiBotTmQueryAction)tmActivity.getDataSources().get(dataSourceName);
                    if (queryAction == null) continue;
                    tmQueryActionList.add(queryAction);
                }
                if (!CollectionUtils.isEmpty(tmQueryActionList)) {
                    List tmDataViewQueries = tmQueryActionList.stream().map(PcUiBotTmQueryAction::getDataViewQuery).filter(Objects::nonNull).collect(Collectors.toList());
                    String defaultViewCode = ((PcUiBotTmDataViewQuery)tmDataViewQueries.get(0)).getCode();
                    boolean isViewCodeMode = ((PcUiBotTmQueryAction)tmQueryActionList.get(0)).getType().equals("VIEWCODE");
                    PcUiBotTmDataViewQuery tmDataViewQuery = tmDataViewQueries.stream().filter(s -> s.getIsDefault() != null && s.getIsDefault() != false).findFirst().orElse(null);
                    if (tmDataViewQuery != null) {
                        defaultViewCode = tmDataViewQuery.getCode();
                    }
                    if (StringUtils.isBlank((CharSequence)viewCode)) {
                        PcUiBotRuntimes.getContext().put("VIEWCODE", (Object)defaultViewCode);
                    }
                    List dataViewQuerys = tmQueryActionList.stream().map(tmQueryAction -> {
                        PcUiBotDataViewQueryDTO dataViewQueryDTO = new PcUiBotDataViewQueryDTO();
                        if (tmQueryAction.getType().equals("VIEWCODE")) {
                            PcUiBotTmDataViewQuery dataViewQuery = tmQueryAction.getDataViewQuery();
                            dataViewQueryDTO.setViewName(tmQueryAction.getTitle());
                            dataViewQueryDTO.setViewCode(dataViewQuery.getCode());
                            dataViewQueryDTO.setSort(dataViewQuery.getSort());
                            dataViewQueryDTO.setIsDefault(dataViewQuery.getIsDefault());
                        } else {
                            PcUiBotTmDataViewQuery dataViewQuery = tmQueryAction.getDataViewQuery();
                            dataViewQueryDTO.setViewName(tmQueryAction.getTitle());
                            dataViewQueryDTO.setViewCode(tmQueryAction.getViewCode());
                            dataViewQueryDTO.setSort((long)tmQueryAction.getSequence());
                            dataViewQueryDTO.setIsDefault(dataViewQuery.getIsDefault());
                        }
                        return dataViewQueryDTO;
                    }).collect(Collectors.toList());
                    if (isViewCodeMode && dataViewQuerys.size() > 1) {
                        PcUiBotRuntimes.getContext().put("dataViewQuerys", dataViewQuerys);
                    }
                }
                tmActivity.getPages().setDataViewQuerys(null);
                ds.setDataViewQuerys(null);
                ds.setLayout(null);
                ds.setOperations(null);
                ds.setSubmitActions(null);
            }
        }
        return ds;
    }
}

