/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTagDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotTagUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PcUiBotHeadTagUtils {
    private PcUiBotHeadTagUtils() {
    }

    public static PcUiBotMetadataField analysisTag(List<PcUiBotMetadataField> originalMetadata) {
        return PcUiBotHeadTagUtils.positionHeadTag(originalMetadata);
    }

    private static PcUiBotMetadataField positionHeadTag(List<PcUiBotMetadataField> originalMetadata) {
        ArrayList headShowFiles = new ArrayList();
        PcUiBotHeadTagUtils.handleHeadTag(headShowFiles, originalMetadata);
        if (!CollectionUtils.isEmpty(headShowFiles)) {
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            metadataField.setHead(Boolean.TRUE.booleanValue());
            metadataField.setName(originalMetadata.get(0).getName() + "_HEAD");
            metadataField.setArray(Boolean.FALSE.booleanValue());
            metadataField.setSubFields(headShowFiles);
            metadataField.setDataType("object");
            List groupInlineFields = PcUiBotHeadTagUtils.extractGroupInlineFields(headShowFiles);
            PcUiBotHeadTagUtils.markGroupInlineTag((List)groupInlineFields);
            PcUiBotHeadTagUtils.markGroupTag(headShowFiles);
            metadataField.getSubFields().addAll(groupInlineFields);
            return metadataField;
        }
        return null;
    }

    private static void markGroupTag(List<PcUiBotMetadataField> headShowFiles) {
        for (PcUiBotMetadataField headField : headShowFiles) {
            if (CollectionUtils.isEmpty((Collection)headField.getTagDefinitions())) continue;
            PcUiBotTagDefinition tag = PcUiBotTagUtil.buildGroupTagDefinition((String)headField.getName());
            headField.getTagDefinitions().add(tag);
        }
    }

    private static void markGroupInlineTag(List<PcUiBotMetadataField> groupInlineFields) {
        for (PcUiBotMetadataField headField : groupInlineFields) {
            if (CollectionUtils.isEmpty((Collection)headField.getTagDefinitions())) continue;
            PcUiBotTagDefinition tag = PcUiBotTagUtil.buildTagDefinition((String)"GROUP_INLINE", (String)headField.getName());
            headField.getTagDefinitions().add(tag);
        }
    }

    private static List<PcUiBotMetadataField> extractGroupInlineFields(List<PcUiBotMetadataField> headShowFiles) {
        ArrayList combineField = Lists.newArrayList();
        for (PcUiBotMetadataField headShowFile : headShowFiles) {
            List tagDefinitions = headShowFile.getTagDefinitions();
            if (!PcUiBotTagUtil.existBusinessTag((List)tagDefinitions, (String)"CONTACT") && !PcUiBotTagUtil.existBusinessTag((List)tagDefinitions, (String)"ADDRESS")) continue;
            combineField.add(headShowFile);
        }
        if (combineField.size() == 2) {
            headShowFiles.removeAll(combineField);
            return combineField;
        }
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleHeadTag(List<PcUiBotMetadataField> headShowFiles, List<PcUiBotMetadataField> metadataFields) {
        if (!CollectionUtils.isEmpty(metadataFields)) {
            Iterator<PcUiBotMetadataField> metadataFieldIterator = metadataFields.iterator();
            while (metadataFieldIterator.hasNext()) {
                PcUiBotMetadataField metadataField = metadataFieldIterator.next();
                if ("object".equals(metadataField.getDataType())) {
                    PcUiBotHeadTagUtils.handleHeadTag(headShowFiles, (List)metadataField.getSubFields());
                }
                if (CollectionUtils.isEmpty((Collection)metadataField.getTagDefinitions())) continue;
                for (PcUiBotTagDefinition tagDefinition : metadataField.getTagDefinitions()) {
                    if (tagDefinition.getThemeMapTag() == null || !"POSITION".equals(tagDefinition.getCategory()) || !"HEAD".equals(tagDefinition.getThemeMapTag().getCode())) continue;
                    try {
                        metadataFieldIterator.remove();
                    }
                    catch (Exception newMetadataField) {}
                    continue;
                    finally {
                        PcUiBotMetadataField newMetadataField = (PcUiBotMetadataField)JsonUtil.objectToJavaObject((Object)metadataField, PcUiBotMetadataField.class);
                        PcUiBotTagUtil.removeTag((PcUiBotMetadataField)newMetadataField, (String)"POSITION", (String)"HEAD");
                        if (headShowFiles.contains(newMetadataField)) continue;
                        headShowFiles.add(newMetadataField);
                    }
                }
            }
        }
    }
}

