/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.custom.ApiRequestZhilinkPrintData;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.CustomCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanCheckRequestData;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeDataResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/zhilink"})
public class ZhilinkController {
    private static final Logger logger = LoggerFactory.getLogger(ZhilinkController.class);
    private static final String QR_CODE_RESULT = "qrCodeResult";
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private ZhilinkService zhilinkService;

    @PostMapping(value={"/printdata"})
    public ApiResponse<ZhilinkBarcodeDataResponse> getZhilinkPrintData(@RequestBody ApiRequestZhilinkPrintData apiRequest) {
        ZhilinkBarcodeDataResponse responseData = apiRequest.getActionDone() == false ? this.zhilinkService.generateBarcodeFirstTime(apiRequest) : this.zhilinkService.generateBarcodeNotFirstTime(apiRequest);
        if (null != responseData) {
            List testProcessData = responseData.getBarcodeData().size() > 0 ? responseData.getBarcodeData().subList(0, 1) : responseData.getBarcodeData();
            responseData.setBarcodeData(testProcessData);
            return ApiResponse.buildOK().setData((Object)responseData);
        }
        return ApiResponse.buildError((String)("Get Zhilink PrintData failed...current request from app is : " + JsonUtil.javaObjectToJsonString((Object)apiRequest)));
    }

    @PostMapping(value={"/check/wo_no"})
    public ApiResponse checkWoNo(@RequestBody InputScanCheckRequestData requestData) {
        Map rawData = requestData.getRawData();
        String locale = requestData.getLocale();
        List woDataList = (List)rawData.get("data");
        String checkWoNo = requestData.getQrCode();
        if (null == woDataList || woDataList.isEmpty()) {
            return ApiResponse.buildError((String)(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5de5\u5355\u6570\u636e\u96c6\u9519\u8bef") + ", " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6821\u9a8c\u5931\u8d25")));
        }
        if (!StringUtils.hasLength((String)checkWoNo)) {
            return ApiResponse.buildError((String)(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u626b\u63cf\u503c\u4e3a\u7a7a") + ", " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6821\u9a8c\u5931\u8d25")));
        }
        boolean match = woDataList.stream().anyMatch(map -> Objects.equals(checkWoNo, map.get("wo_no")));
        if (!match) {
            return ApiResponse.buildError((String)(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5de5\u5355\u4e0d\u5c5e\u4e8e\u8be5\u7269\u6599") + ", " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6821\u9a8c\u5931\u8d25")));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put(QR_CODE_RESULT, checkWoNo);
        return ApiResponse.buildOK().setData(resultMap);
    }

    @PostMapping(value={"/check/barcode_no"})
    public ApiResponse<Map> checkBarcodeNo(@RequestParam(value="type") String type, @RequestBody InputScanCheckRequestData requestData) {
        List scannedBarcodeDataList = this.haveBarcodeMsg(type, requestData);
        String locale = requestData.getLocale();
        if (CustomCodeEnum.PASTE.getValue().equals(type)) {
            if (null == scannedBarcodeDataList || scannedBarcodeDataList.isEmpty()) {
                return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u7b7e\u8d34\u9519\uff0c\u5e76\u975e\u8be5\u5de5\u5355\u4e0b\u6761\u7801"));
            }
            ZhilinkBarcodeData barcodeData = (ZhilinkBarcodeData)scannedBarcodeDataList.get(0);
            boolean scanBarcodeMsg = this.scanBarcodeMsg(type, requestData, barcodeData.getBarcodeNo(), "", "");
            if (scanBarcodeMsg) {
                return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u7b7e\u5df2\u626b\u63cf\u8fc7"));
            }
            boolean insertSuccess = this.insertBarcode(type, requestData, barcodeData);
            if (insertSuccess) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(QR_CODE_RESULT, barcodeData.getBarcodeNo());
                logger.debug("checkBarcodeNo type is {}, barcode_no returned {}", (Object)type, (Object)barcodeData.getBarcodeNo());
                return ApiResponse.buildOK().setData(map);
            }
            return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u7b7e\u626b\u63cf\u8bb0\u5f55\u65b0\u589e\u5931\u8d25"));
        }
        if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
            String taskSoNo;
            if (null == scannedBarcodeDataList || scannedBarcodeDataList.isEmpty()) {
                return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u626b\u63cf\u7684\u4ea7\u54c1\u4e0e\u5f85\u51fa\u5382\u7684\u4ea7\u54c1\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u4ed4\u7ec6\u6838\u5bf9"));
            }
            ZhilinkBarcodeData scannedBarcodeData = (ZhilinkBarcodeData)scannedBarcodeDataList.get(0);
            String scannedBarcodeDataSoNo = scannedBarcodeData.getSoNo();
            if (!Objects.equals(scannedBarcodeDataSoNo, taskSoNo = (String)((Map)((List)requestData.getRawData().get("barcode_data")).get(0)).get("so_no"))) {
                return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)("\u626b\u63cf\u7684\u6761\u7801 " + scannedBarcodeData.getBarcodeNo() + " \u8ba2\u5355\u53f7" + scannedBarcodeDataSoNo + " \u4e0d\u5b58\u5728\u672c\u6b21\u5f85\u51fa\u5e93\u8ba2\u5355\u4e2d\uff0c\u8bf7\u6838\u5b9e")));
            }
            boolean scanBarcodeMsg = this.scanBarcodeMsg(type, requestData, requestData.getQrCode(), scannedBarcodeData.getSoNo(), scannedBarcodeData.getSourceNo());
            if (scanBarcodeMsg) {
                return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u7b7e\u5df2\u626b\u63cf\u8fc7"));
            }
            boolean insertSuccess = this.insertBarcode(type, requestData, scannedBarcodeData);
            if (insertSuccess) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(QR_CODE_RESULT, scannedBarcodeData.getBarcodeNo());
                logger.debug("checkBarcodeNo type is {}, barcode_no returned {}", (Object)type, (Object)scannedBarcodeData.getBarcodeNo());
                return ApiResponse.buildOK().setData(map);
            }
            return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6807\u7b7e\u626b\u63cf\u8bb0\u5f55\u65b0\u589e\u5931\u8d25"));
        }
        logger.error("type NOT found in CustomCodeEnum... nothing done...");
        return ApiResponse.buildError((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"type NOT found in CustomCodeEnum... nothing done..."));
    }

    private boolean insertBarcode(String type, InputScanCheckRequestData requestData, ZhilinkBarcodeData barcodeData) {
        Map rawData = requestData.getRawData();
        HashMap<String, Object> bodyData = new HashMap<String, Object>();
        bodyData.put("actionId", "zhilink.barcode.temp.info.create");
        bodyData.put("businessUnit", rawData.get("businessUnit"));
        bodyData.put("executeContext", rawData.get("executeContext"));
        HashMap parameter = new HashMap();
        ArrayList barcodeDataList = new ArrayList();
        List rawDataBarcodeDataList = (List)rawData.get("barcode_data");
        for (Map rawDataBarcodeDataMap : rawDataBarcodeDataList) {
            HashMap tempDataMap = new HashMap();
            if (CustomCodeEnum.PASTE.getValue().equals(type)) {
                tempDataMap.put("wo_no", rawDataBarcodeDataMap.get("wo_no"));
                tempDataMap.put("source_no", rawDataBarcodeDataMap.get("source_no"));
                tempDataMap.put("seq_no", "1");
                tempDataMap.put("operation_type", "2");
                tempDataMap.put("barcode", barcodeData.getBarcodeNo());
                tempDataMap.put("item_no", barcodeData.getItemNo());
                tempDataMap.put("item_name", barcodeData.getItemName());
                tempDataMap.put("item_spec", barcodeData.getItemSpec());
                tempDataMap.put("qty", barcodeData.getQty());
                tempDataMap.put("eoc_company_id", barcodeData.getEocCompanyId());
                tempDataMap.put("eoc_site_id", barcodeData.getEocSiteId());
                tempDataMap.put("eoc_region_id", barcodeData.getEocRegionId());
            } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
                tempDataMap.put("wo_no", barcodeData.getSourceNo());
                tempDataMap.put("source_no", barcodeData.getSoNo());
                tempDataMap.put("seq_no", "1");
                tempDataMap.put("operation_type", "3");
                tempDataMap.put("barcode", barcodeData.getBarcodeNo());
                tempDataMap.put("item_no", barcodeData.getItemNo());
                tempDataMap.put("item_name", barcodeData.getItemName());
                tempDataMap.put("item_spec", barcodeData.getItemSpec());
                tempDataMap.put("qty", barcodeData.getQty());
                tempDataMap.put("eoc_company_id", barcodeData.getEocCompanyId());
                tempDataMap.put("eoc_site_id", barcodeData.getEocSiteId());
                tempDataMap.put("eoc_region_id", barcodeData.getEocRegionId());
            } else {
                logger.error("type NOT found in CustomCodeEnum... NO parameters added...");
            }
            barcodeDataList.add(tempDataMap);
        }
        parameter.put("barcode_data", barcodeDataList);
        bodyData.put("parameter", parameter);
        DigiwinAthenaApiResponse response = this.digiwinAtdmProxyService.dataQueryByActionId(requestData.getLocale(), requestData.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodyData), requestData.getTenantId());
        if (response == null || response.getResponse() == null) {
            return false;
        }
        Map map = (Map)response.getResponse();
        List barcodeDataResult = (List)map.get("barcode_data");
        return barcodeDataResult != null && !barcodeDataResult.isEmpty();
    }

    private boolean scanBarcodeMsg(String type, InputScanCheckRequestData requestData, String barcode, String sourceNo, String woNo) {
        Map rawData = requestData.getRawData();
        HashMap<String, Object> bodyData = new HashMap<String, Object>();
        bodyData.put("actionId", "zhilink.barcode.temp.info.get");
        bodyData.put("businessUnit", rawData.get("businessUnit"));
        bodyData.put("executeContext", rawData.get("executeContext"));
        HashMap parameter = new HashMap();
        ArrayList barcodeDataList = new ArrayList();
        List rawDataBarcodeDataList = (List)rawData.get("barcode_data");
        for (Map rawDataBarcodeDataMap : rawDataBarcodeDataList) {
            HashMap<String, String> tempDataMap = new HashMap<String, String>();
            if (CustomCodeEnum.PASTE.getValue().equals(type)) {
                tempDataMap.put("barcode", barcode);
                tempDataMap.put("wo_no", (String)rawDataBarcodeDataMap.get("wo_no"));
                tempDataMap.put("operation_type", "2");
            } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
                tempDataMap.put("barcode", barcode);
                tempDataMap.put("source_no", sourceNo);
                tempDataMap.put("wo_no", woNo);
                tempDataMap.put("operation_type", "3");
            } else {
                logger.error("type NOT found in CustomCodeEnum... NO parameters added...");
            }
            barcodeDataList.add(tempDataMap);
        }
        parameter.put("barcode_data", barcodeDataList);
        bodyData.put("parameter", parameter);
        DigiwinAthenaApiResponse response = this.digiwinAtdmProxyService.dataQueryByActionId(requestData.getLocale(), requestData.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodyData), requestData.getTenantId());
        if (response == null || response.getResponse() == null) {
            return true;
        }
        Map map = (Map)response.getResponse();
        List barcodeDataResult = (List)map.get("barcode_data");
        return barcodeDataResult != null && !barcodeDataResult.isEmpty();
    }

    private List<ZhilinkBarcodeData> haveBarcodeMsg(String type, InputScanCheckRequestData requestData) {
        Map rawData = requestData.getRawData();
        HashMap<String, Object> bodyData = new HashMap<String, Object>();
        bodyData.put("actionId", "bm.bcsc.barcode.get");
        bodyData.put("businessUnit", rawData.get("businessUnit"));
        bodyData.put("executeContext", rawData.get("executeContext"));
        HashMap<String, Serializable> parameter = new HashMap<String, Serializable>();
        parameter.put("use_has_next", Boolean.valueOf(false));
        List rawDataBarcodeDataList = (List)rawData.get("barcode_data");
        ArrayList barcodeDataMapList = new ArrayList();
        for (Map rawDataBarcodeDataMap : rawDataBarcodeDataList) {
            HashMap tempDataMap = new HashMap();
            if (CustomCodeEnum.PASTE.getValue().equals(type)) {
                tempDataMap.put("barcode_url", rawDataBarcodeDataMap.get("barcode_url"));
                tempDataMap.put("source_no", rawDataBarcodeDataMap.get("wo_no"));
                tempDataMap.put("barcode_no", requestData.getQrCode());
                tempDataMap.put("item_no", rawDataBarcodeDataMap.get("item_no"));
                tempDataMap.put("sn_barcode_status", rawDataBarcodeDataMap.get("sn_barcode_status"));
                tempDataMap.put("eoc_company_id", rawDataBarcodeDataMap.get("eoc_company_id"));
                tempDataMap.put("eoc_site_id", rawDataBarcodeDataMap.get("eoc_site_id"));
            } else if (CustomCodeEnum.CHECKOUT.getValue().equals(type)) {
                tempDataMap.put("barcode_url", rawDataBarcodeDataMap.get("barcode_url"));
                tempDataMap.put("barcode_no", requestData.getQrCode());
                tempDataMap.put("item_no", rawDataBarcodeDataMap.get("item_no"));
                tempDataMap.put("sn_barcode_status", rawDataBarcodeDataMap.get("sn_barcode_status"));
                tempDataMap.put("eoc_company_id", rawDataBarcodeDataMap.get("eoc_company_id"));
                tempDataMap.put("eoc_site_id", rawDataBarcodeDataMap.get("eoc_site_id"));
            } else {
                logger.error("type NOT found in CustomCodeEnum... NO parameters added...");
            }
            barcodeDataMapList.add(tempDataMap);
        }
        parameter.put("barcode_data", barcodeDataMapList);
        bodyData.put("parameter", parameter);
        List barcodeDataList = this.digiwinAtdmProxyService.getBarcodeData(requestData.getLocale(), requestData.getIamUserToken(), JsonUtil.javaObjectToJsonString(bodyData), requestData.getTenantId());
        return barcodeDataList;
    }
}

