/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomGoodsArrivalContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildZTBArrivalScanConfirmStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBArrivalScanConfirmStrategy.class);

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "GOODS_ARRIVAL": {
                    CustomGoodsArrivalContent customGoodsArrivalContent = CustomGoodsArrivalContent.create();
                    newPageData.put((Object)schema, (Object)customGoodsArrivalContent);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                        if (ActionTypeEnum.CALL_API_BACK_TWO.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("transport_no", rawData.get((Object)"transport_no"));
                            buttonRawData.put("biz_id", (Object)"ZTB");
                            buttonRawData.put("page_id", (Object)PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT);
                            buttonRawData.put("action", rawData.get((Object)"action"));
                            buttonRawData.put("data", rawData.get((Object)"data"));
                            buttonRawData.put("action_id", (Object)"arrive_scan");
                            action.setRawData((Object)buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    newPageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }
}

