/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseSizeRatioMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContentDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.image.Image;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBElectronicFenceDetailStrategy")
public class UiBotModelBuildZTBElectronicFenceDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBElectronicFenceDetailStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ArrayList<UiBotLayout> mobileUiBotLayouts = new ArrayList<UiBotLayout>(2);
        UiBotModel mobileUibotModel = new UiBotModel(mobileUiBotLayouts);
        UiBotLayout mobileUibitLayout = new UiBotLayout();
        String customGroupSchema = UUIDUtil.getUuid();
        mobileUibitLayout.setSchema(customGroupSchema);
        mobileUibitLayout.setType("CUSTOM_GROUP");
        mobileUiBotLayouts.add(mobileUibitLayout);
        UiBotPageData mobilePageData = new UiBotPageData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        HashMap<String, String> electronicFence = new HashMap<String, String>(4);
        String factoryId = String.valueOf(apiRequest.getRawData().get((Object)"factory_id"));
        String factoryName = String.valueOf(apiRequest.getRawData().get((Object)"factory_name"));
        String radius = String.valueOf(apiRequest.getRawData().get((Object)"radius"));
        String startFlag = String.valueOf(apiRequest.getRawData().get((Object)"start_flag"));
        electronicFence.put("factory_id", factoryId);
        electronicFence.put("factory_name", factoryName);
        electronicFence.put("radius", radius);
        electronicFence.put("start_flag", startFlag);
        boolean isIndexEnter = "true".equals(StringUtil.valueOf((Object)apiRequest.getRawData().get((Object)"isIndexEnter")));
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String value = electronicFence.get(layout.getSchema()) == null ? "" : String.valueOf(electronicFence.get(layout.getSchema()));
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "FIELD": {
                    if (!StringUtils.hasLength((String)value)) break;
                    Field field = Field.createLabelValueLeftField((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)value);
                    field.setHidden(Boolean.valueOf(StrUtil.equals((CharSequence)schema, (CharSequence)"factory_id")));
                    field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue());
                    pageData.put((Object)schema, (Object)field);
                    break;
                }
                case "INPUT_NUMERIC": {
                    InputNumeric inputNumeric = InputNumeric.create((Integer)6, (Integer)0, (String)value, (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setPlaceholder("\u8bf7\u8f93\u5165...");
                    inputNumeric.setHidden(Boolean.valueOf(!StrUtil.equals((CharSequence)startFlag, (CharSequence)"Y")));
                    inputNumeric.setRequired(Boolean.valueOf(StrUtil.equals((CharSequence)startFlag, (CharSequence)"Y")));
                    ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>();
                    ValidateRule validateRule = new ValidateRule();
                    validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                    validateRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                    validateRule.setParameter("20");
                    validateRule.setOperatorType(Integer.valueOf(6));
                    validateRule.setErrorMessage(this.localeService.getLanguageValue(locale, "\u8f93\u5165\u534a\u5f84\u4e0d\u80fd\u5c0f\u4e8e20"));
                    validateRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                    validateRuleList.add(validateRule);
                    inputNumeric.setValidateRuleList(validateRuleList);
                    pageData.put((Object)schema, (Object)inputNumeric);
                    break;
                }
                case "IMAGE": {
                    Image image = new Image();
                    BaseSizeRatioMobileComponent.BaseSize baseSize = new BaseSizeRatioMobileComponent.BaseSize();
                    baseSize.setWidth(Integer.valueOf(654));
                    baseSize.setHeight(Integer.valueOf(470));
                    image.setBaseSize(baseSize);
                    BaseImageContent imageContent = new BaseImageContent();
                    imageContent.setDataType(BaseImageContentDataTypeEnum.NETWORK_HTTP_URL.getValue());
                    imageContent.setData("http://180.167.0.43:18086/staticDemo/athena/resources/ztb/drive_electronic_fence_example.png");
                    image.setContent(imageContent);
                    pageData.put((Object)layout.getSchema(), (Object)image);
                    break;
                }
                case "INPUT_SWITCH": {
                    pageData.put((Object)schema, (Object)InputSwitch.createByZtbCondition((Boolean)StrUtil.equals((CharSequence)value, (CharSequence)"Y"), (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)"radius", (String)"\u8bbe\u5b9a\u7535\u5b50\u56f4\u680f\uff0c\u53ef\u5728\u8f66\u8f86\u5373\u5c06\u5230\u8fbe\u65f6\uff0c\u7ed9\u53f8\u673a\u53d1\u9001\u5165\u5382\u51ed\u8bc1\uff0c\u5feb\u901f\u5165\u5382"));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    mobileUiBotLayouts.add(layout);
                    List bottomButtons = (List)uiBotModel.getPageData().get((Object)"bottomButtons");
                    ArrayList<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<BottomButtonDigiwinAthena>(1);
                    for (Map button : bottomButtons) {
                        if (!"submit".equals(button.get("id"))) continue;
                        BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4fdd\u5b58"));
                        Action action = new Action();
                        if (isIndexEnter) {
                            action = (Action)JsonUtil.objectToJavaObject(button.get("action"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                            if (action.getJumpPageTitle() != null) {
                                action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                            if (StringUtils.hasLength((String)action.getRequestUrl())) {
                                action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
                            }
                        } else {
                            Map rawData = (Map)((Map)button.get("action")).get("rawData");
                            action.setType(ActionTypeEnum.CALL_API.getValue());
                            action.setRawData((Object)rawData);
                        }
                        ((Map)action.getRawData()).put("electronicFenceType", "update");
                        ((Map)action.getRawData()).put("data", electronicFence);
                        bottomButtonDigiwinAthena.setAction(action);
                        bottomButtonDigiwinAthena.setId((String)button.get("id"));
                        buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                    }
                    mobilePageData.put((Object)schema, buttonDigiwinAthenas);
                }
            }
        }
        uiBotModel.setPageData(pageData);
        CustomGroup customGroup = CustomGroup.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)""), (UiBotModel)uiBotModel);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        mobilePageData.put((Object)customGroupSchema, (Object)customGroup);
        mobileUibotModel.setPageData(mobilePageData);
        mobileUibotModel.setPageBackgroudColor(uiBotModel.getPageBackgroudColor());
        return mobileUibotModel;
    }
}

