/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.pageable.PageableList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBGoodsDepartureStrategy")
public class UiBotModelBuildZTBGoodsDepartureStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBGoodsDepartureStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private ZhilinkService zhilinkService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBGoodsDeparture");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        String taskNo = "";
        String transportNo = "";
        List deliveryDetailList = (List)pcUiBotModel.getPageData().get((Object)"cargo_information");
        if (!CollectionUtils.isEmpty((Collection)deliveryDetailList)) {
            taskNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("task_no"));
            transportNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("transport_no"));
        }
        DigiwinTransportResponse transportMainInfo = this.digiwinEspProxyService.getTransportMainInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        Map vehicleInfo = this.digiwinEspProxyService.getTransportVehicleInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        stopWatch.start("Build ZTBGoodsDeparture Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    newPageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_ONE".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, transportMainInfo, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class), Boolean.valueOf(false));
                    } else if ("CUSTOM_GROUP_TWO".equalsIgnoreCase(schema)) {
                        customGroup = this.buildDriverMessageGroup(locale, vehicleInfo, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class));
                    } else {
                        if ("CUSTOM_GROUP_THREE".equalsIgnoreCase(schema)) break;
                        if ("CUSTOM_GROUP_FOUR".equalsIgnoreCase(schema)) {
                            customGroup = this.buildPlatFormMessageGroup(locale, transportMainInfo, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class), (String)((Map)uiBotModel.getPageData().get((Object)schema)).get("name"));
                        } else if ("car_pic".equalsIgnoreCase(schema)) {
                            customGroup = customGroup.buildZtbPictrue("\u9644\u4ef6", locale, this.localeService, schema, Boolean.valueOf(false), "\u8bf7\u4e0a\u4f20\u7eb8\u8d28\u88c5\u8f66\u6e05\u5355");
                        }
                    }
                    newPageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "ZTB_VIEW_LIST": {
                    Map cargoInformation = this.digiwinEspProxyService.getTransportCargoInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo, Integer.valueOf(1), Integer.valueOf(9999), Boolean.valueOf(false));
                    ZtbViewList ztbViewList = (ZtbViewList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), ZtbViewList.class);
                    ztbViewList.setSchema(schema);
                    newPageData.put((Object)schema, (Object)ZtbViewList.create((ZtbViewList)ztbViewList, (Map)cargoInformation, (LocaleService)this.localeService, (String)locale));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List bottomButtonList = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButton -> {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                        Action action = bottomButton.getAction();
                        if (action.getConfirmPop() != null) {
                            ConfirmPop confirmPop = action.getConfirmPop();
                            confirmPop.setContent(this.localeService.getLanguageValue(locale, confirmPop.getContent()));
                        }
                        action.setType(ActionTypeEnum.CALL_API.getValue());
                        action.setRefreshPageId(pageSetting.getPageId());
                        action.setNeedPosition(Integer.valueOf(1));
                        HashMap<String, Object> buttonRawData = new HashMap<String, Object>();
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_DEPARTURE.toString());
                        UiBotAction uiBotAction = this.getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);
                        bottomButton.setAction(action);
                    });
                    newPageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    private CustomGroup buildPlatFormMessageGroup(String locale, DigiwinTransportResponse transportMainInfo, UiBotModel uiBotModel, String name) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(this.localeService.getLanguageValue(locale, name));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map dataMap = (Map)JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString((Object)transportMainInfo), Map.class);
        block6: for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "FIELD": {
                    if ("appoint_time".equalsIgnoreCase(schema)) {
                        String date = StringUtils.hasLength((String)transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                        String[] values = date.split(" ");
                        String value = "";
                        value = values.length > 1 ? values[0] : date;
                        pageData.put((Object)schema, (Object)Field.createLabelValueLeftFieldNoNewLine((String)((String)layout.getmLabelText().get(locale)), (String)value));
                        break;
                    }
                    if ("time_slot".equalsIgnoreCase(schema)) {
                        List timeSlots = transportMainInfo.getTimeSlot();
                        if (timeSlots == null || timeSlots.size() <= 0) continue block6;
                        String value = transportMainInfo.getTimeSlots(timeSlots);
                        pageData.put((Object)schema, (Object)Field.createLabelValueLeftFieldNoNewLine((String)((String)layout.getmLabelText().get(locale)), (String)value));
                        break;
                    }
                    pageData.put((Object)schema, (Object)Field.createLabelValueLeftFieldNoNewLine((String)((String)layout.getmLabelText().get(locale)), (String)((String)dataMap.get(schema))));
                    break;
                }
            }
        }
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(Boolean.valueOf(false));
        customGroup.setHasDetail(Boolean.valueOf(false));
        return customGroup;
    }

    private CustomGroup buildDriverMessageGroup(String locale, Map<String, Object> vehicleInfo, UiBotModel driverMessageUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List driverMessageLayouts = driverMessageUiBotModel.getLayout();
        UiBotPageData pageData = driverMessageUiBotModel.getPageData();
        UiBotPageData driverMessagePageData = new UiBotPageData();
        for (UiBotLayout driverMessageLayout : driverMessageLayouts) {
            String driverMessageSchema = driverMessageLayout.getSchema();
            Map schemaPageData = (Map)pageData.get((Object)driverMessageSchema);
            switch (driverMessageLayout.getType()) {
                case "FIELD": {
                    Field driverMessageField = new Field();
                    String value = "-";
                    if (!CollectionUtils.isEmpty(vehicleInfo)) {
                        value = String.valueOf(vehicleInfo.get(driverMessageSchema));
                    }
                    driverMessageField = Field.create((String)((String)driverMessageLayout.getmLabelText().get(locale)), (String)"LABEL", (String)value, (String)driverMessageSchema, (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                    driverMessagePageData.put((Object)driverMessageSchema, (Object)driverMessageField);
                    break;
                }
            }
        }
        CustomGroupContent driverMessageContent = new CustomGroupContent();
        driverMessageContent.setLayout(driverMessageLayouts);
        driverMessageContent.setPageData(driverMessagePageData);
        customGroup.setContent(driverMessageContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8f66\u8f86\u4fe1\u606f"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    private CustomGroup buildFreightGroup(String locale, String taskNo, UiBotModel freightUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List freightLayouts = freightUiBotModel.getLayout();
        UiBotPageData pageData = freightUiBotModel.getPageData();
        UiBotPageData freightPageData = new UiBotPageData();
        for (UiBotLayout freightLayout : freightLayouts) {
            String freightSchema = freightLayout.getSchema();
            Map schemaPageData = (Map)pageData.get((Object)freightSchema);
            switch (freightLayout.getType()) {
                case "PAGEABLE_LIST": {
                    PageableList freightPageableList = new PageableList();
                    HashMap<String, Object> rawData = new HashMap<String, Object>();
                    rawData.put("task_no", taskNo);
                    rawData.put("use_has_next", true);
                    freightPageableList = PageableList.create(rawData, (String)"/mobile/v1/uibot/component/pageablelist/data", (String)"");
                    freightPageData.put((Object)freightSchema, (Object)freightPageableList);
                    break;
                }
            }
        }
        CustomGroupContent freightContent = new CustomGroupContent();
        freightContent.setLayout(freightLayouts);
        freightContent.setPageData(freightPageData);
        customGroup.setContent(freightContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8d27\u8fd0\u4fe1\u606f"));
        return customGroup;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<UiBotAction>();
        block0: for (UiBotLayout layout : layoutList) {
            List actions = layout.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) continue;
            for (UiBotAction action : actions) {
                if (!actionId.equalsIgnoreCase(action.getActionId())) continue;
                uiBotAction.set(action);
                break block0;
            }
        }
        return (UiBotAction)uiBotAction.get();
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

