/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBGoodsLoadingVehicleInfoStrategy")
public class UiBotModelBuildZTBGoodsLoadingVehicleInfoStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        String taskNo = (String)apiRawData.get((Object)"task_no");
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String layoutType = layout.getType();
            String schema = layout.getSchema();
            switch (layoutType) {
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MultiFunctionList.class);
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.SINGLE_CHOICE.toString());
                    multiFunctionList.setPageable(Boolean.valueOf(false));
                    multiFunctionList.setSearch(Boolean.valueOf(true));
                    multiFunctionList.setDataUrl("/mobile/v1/ztb/vehicle/information");
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.SPLIT_LINE.toString());
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("task_no", (Object)taskNo);
                    rawData.put("is_load_car", (Object)true);
                    multiFunctionList.setRawData(rawData);
                    newPageData.put((Object)schema, (Object)multiFunctionList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                        if (bottomButton.getAction() == null || !ActionTypeEnum.CALL_API_ONLY.getValue().equals(bottomButton.getAction().getType())) continue;
                        Action action = bottomButton.getAction();
                        apiRawData.put("page_id", (Object)PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO.toString());
                        action.setRawData((Object)apiRawData);
                        ConfirmPop confirmPop = action.getConfirmPop();
                        if (confirmPop == null || confirmPop.getNeedConfirm() == null || !confirmPop.getNeedConfirm().booleanValue()) continue;
                        if (StringUtils.hasLength((String)confirmPop.getContent())) {
                            confirmPop.setContent(this.localeService.getLanguageValue(locale, confirmPop.getContent()));
                        }
                        if (!StringUtils.hasLength((String)confirmPop.getTitle())) continue;
                        confirmPop.setTitle(this.localeService.getLanguageValue(locale, confirmPop.getTitle()));
                    }
                    newPageData.put((Object)schema, (Object)buttons);
                    break;
                }
            }
        }
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }
}

