/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrict;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrictTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildZTBModifiyAddressStrategy")
public class UiBotModelBuildZTBModifiyAddressStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBModifiyAddressStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService espProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildAddressMessage");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)uiBotLayout.getSchema()), CustomGroup.class);
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)this.buildAddressCustomGroup(customGroup, (Map)rawData, apiRequest, Boolean.valueOf(CollectionUtils.isEmpty((Map)rawData))));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)uiBotLayout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(arg_0 -> UiBotModelBuildZTBModifiyAddressStrategy.lambda$doActually$0(apiRequest, (Map)rawData, arg_0));
                    pageData.put((Object)uiBotLayout.getSchema(), (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private CustomGroup buildAddressCustomGroup(CustomGroup customGroup, Map<String, Object> rawData, ApiRequest apiRequest, Boolean isAdd) {
        customGroup.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), customGroup.getName()));
        CustomGroupContent content = customGroup.getContent();
        List uiBotLayouts = content.getLayout();
        UiBotPageData pageData = content.getPageData();
        Map userAddress = new HashMap(16);
        if (!isAdd.booleanValue()) {
            String addressId = (String)rawData.get("address_id");
            userAddress = this.espProxyService.getUserAddress(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), addressId);
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "INPUT_SINGLE": {
                    pageData.put((Object)layout.getSchema(), (Object)InputSingleText.create((String)layout.getSchema(), (String)this.localeService.getLanguageValue(apiRequest.getLocale(), layout.getLabel()), (Boolean)true, (Boolean)true, (String)apiRequest.getLocale(), (String)(isAdd != false ? "" : (String)userAddress.get(layout.getSchema())), (Boolean)false));
                    break;
                }
                case "INPUT_CASCADE_DISTRICT": {
                    pageData.put((Object)layout.getSchema(), (Object)InputCascadeDistrict.create((String)layout.getSchema(), (String)this.localeService.getLanguageValue(apiRequest.getLocale(), layout.getLabel()), (String)apiRequest.getLocale(), isAdd != false ? Collections.emptyMap() : userAddress, (boolean)true, (Integer)InputCascadeDistrictTypeEnum.ALL_PCA.getValue()));
                    break;
                }
                case "INPUT_MULTI": {
                    pageData.put((Object)layout.getSchema(), (Object)InputMultiText.create((String)layout.getSchema(), (String)this.localeService.getLanguageValue(apiRequest.getLocale(), layout.getLabel()), (String)(isAdd != false ? "" : (String)userAddress.get(layout.getSchema())), (Boolean)true, (Boolean)true, (Boolean)false, (String)apiRequest.getLocale()));
                    break;
                }
            }
        }
        return customGroup;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/addressMessage.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }

    private static /* synthetic */ void lambda$doActually$0(ApiRequest apiRequest, Map rawData, BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null) {
            action = new Action();
            action.setType(ActionTypeEnum.CALL_API.getValue());
        }
        HashMap<String, Object> actionRawData = new HashMap<String, Object>(2);
        actionRawData.put("page_id", apiRequest.getPageId());
        actionRawData.put("biz_id", "ZTB");
        actionRawData.put("isAdd", CollectionUtils.isEmpty((Map)rawData));
        action.setRawData(actionRawData);
    }
}

