/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Message;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageNode;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UiBotModelBuildZTBProjectLogisticsStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        List logisticsDetailList = (List)apiRawData.get((Object)"data");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "MESSAGE_NODE": {
                    MessageNode messageNode = (MessageNode)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MessageNode.class);
                    List messageList = messageNode.getMessageList();
                    if (!CollectionUtils.isEmpty((Collection)logisticsDetailList)) {
                        logisticsDetailList.stream().forEach(logisticsDetail -> {
                            Message message = new Message();
                            String logisticsTime = (String)logisticsDetail.get("logistics_time");
                            if (logisticsTime != null && logisticsTime.contains("-")) {
                                if (StringUtils.hasLength((String)logisticsTime)) {
                                    String[] datas = logisticsTime.split(" ");
                                    message.setDate(DateTimeUtil.getFullMonth((Integer)Integer.valueOf(datas[0].split("-")[1])) + "-" + DateTimeUtil.getFullDate((Integer)Integer.valueOf(datas[0].split("-")[2])));
                                    message.setTime(datas[1]);
                                }
                            } else {
                                message.setDate(DateTimeUtil.getFullMonth((Integer)Integer.valueOf(((String)logisticsDetail.get("logistics_date")).split("-")[1])) + "-" + DateTimeUtil.getFullDate((Integer)Integer.valueOf(((String)logisticsDetail.get("logistics_date")).split("-")[2])));
                                message.setTime(logisticsTime);
                            }
                            message.setMessage((String)logisticsDetail.get("logistics_desc"));
                            messageList.add(message);
                        });
                    }
                    Collections.reverse(messageList);
                    pageData.put((Object)schema, (Object)messageNode);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String name = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)name)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), name));
                        }
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

