/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UiBotModelBuildZTBShippingTaskQrCodeStrategy
implements UiBotModelBuildStrategy {
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        ApiRawData apiRawData = apiRequest.getRawData();
        String taskNo = (String)apiRawData.get((Object)"task_no");
        String transportNo = (String)apiRawData.get((Object)"transport_no");
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "QR_CODE": {
                    QrCode qrCode;
                    QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg("ZHILINK_ITM");
                    if (StringUtils.hasLength((String)transportNo)) {
                        qrCodeContentMsg.put("transport_no", transportNo);
                        qrCodeContentMsg.put("task_no", taskNo);
                        qrCode = QrCode.create((QrCodeContentMsg)qrCodeContentMsg, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u626b\u7801\u8fd0\u5355\u4e8c\u7ef4\u7801"));
                    } else {
                        qrCodeContentMsg.put("task_no", taskNo);
                        qrCode = QrCode.create((QrCodeContentMsg)qrCodeContentMsg, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u626b\u7801\u8d27\u8fd0\u4e8c\u7ef4\u7801"));
                    }
                    pageData.put((Object)schema, (Object)qrCode);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

