/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildZTBTransportAbnormalAlarmStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "SINGLE_SELECT_LIST": {
                    pageData.put((Object)schema, (Object)SingleSelectList.createByZtbEnum((List)this.digiwinEspProxyService.getEnumerateInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "abnormal_alarm"), (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)"", (String)""));
                    break;
                }
                case "INPUT_MULTI": {
                    pageData.put((Object)schema, (Object)InputMultiText.create((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)"", (Boolean)true, (Boolean)true, (String)locale, (String)this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165\u5185\u5bb9")));
                    break;
                }
                case "PICTURE": {
                    pageData.put((Object)schema, (Object)Picture.createEmptyPic((String)schema, (String)"", (Integer)AttachmentTypeEnum.READ_AND_WRITE.getValue(), (boolean)false, (String)"abnormal_alarm_pic"));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                        if (ActionTypeEnum.CALL_API.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("transport_no", rawData.get((Object)"transport_no"));
                            buttonRawData.put("biz_id", (Object)"ZTB");
                            buttonRawData.put("page_id", (Object)pageSetting.getPageId());
                            buttonRawData.put("action", rawData.get((Object)"action"));
                            buttonRawData.put("data", rawData.get((Object)"data"));
                            action.setRawData((Object)buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

